//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridkubernetes_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridkubernetes/armhybridkubernetes"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/CreateClusterExample.json
func ExampleConnectedClusterClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewConnectedClusterClient().BeginCreate(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ConnectedCluster{
		Location: to.Ptr("East US"),
		Tags:     map[string]*string{},
		Identity: &armhybridkubernetes.ConnectedClusterIdentity{
			Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
		},
		Properties: &armhybridkubernetes.ConnectedClusterProperties{
			AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectedCluster = armhybridkubernetes.ConnectedCluster{
	// 	Name: to.Ptr("connectedCluster1"),
	// 	Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
	// 	ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armhybridkubernetes.ConnectedClusterIdentity{
	// 		Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
	// 	},
	// 	Properties: &armhybridkubernetes.ConnectedClusterProperties{
	// 		AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
	// 		AgentVersion: to.Ptr("0.1.0"),
	// 		KubernetesVersion: to.Ptr("1.17.0"),
	// 		ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
	// 		TotalNodeCount: to.Ptr[int32](2),
	// 	},
	// 	SystemData: &armhybridkubernetes.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
	// 		CreatedBy: to.Ptr("sikasire@microsoft.com"),
	// 		CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("sikasire@microsoft.com"),
	// 		LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/UpdateClusterExample.json
func ExampleConnectedClusterClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().Update(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ConnectedClusterPatch{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectedCluster = armhybridkubernetes.ConnectedCluster{
	// 	Name: to.Ptr("connectedCluster1"),
	// 	Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
	// 	ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armhybridkubernetes.ConnectedClusterIdentity{
	// 		Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
	// 	},
	// 	Properties: &armhybridkubernetes.ConnectedClusterProperties{
	// 		AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
	// 		AgentVersion: to.Ptr("0.1.0"),
	// 		KubernetesVersion: to.Ptr("1.17.0"),
	// 		ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
	// 		TotalNodeCount: to.Ptr[int32](2),
	// 	},
	// 	SystemData: &armhybridkubernetes.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
	// 		CreatedBy: to.Ptr("sikasire@microsoft.com"),
	// 		CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:14:58.865Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("2d2a754c-cade-4935-83d4-ce413c5a3910"),
	// 		LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/GetClusterExample.json
func ExampleConnectedClusterClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().Get(ctx, "k8sc-rg", "testCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectedCluster = armhybridkubernetes.ConnectedCluster{
	// 	Name: to.Ptr("connectedCluster1"),
	// 	Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
	// 	ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
	// 	Location: to.Ptr("East US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Identity: &armhybridkubernetes.ConnectedClusterIdentity{
	// 		Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("d8cd1fd9-154f-4da7-b348-595f283c13a3"),
	// 		TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
	// 	},
	// 	Properties: &armhybridkubernetes.ConnectedClusterProperties{
	// 		AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
	// 		AgentVersion: to.Ptr("0.1.0"),
	// 		KubernetesVersion: to.Ptr("1.17.0"),
	// 		ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
	// 		TotalNodeCount: to.Ptr[int32](2),
	// 	},
	// 	SystemData: &armhybridkubernetes.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
	// 		CreatedBy: to.Ptr("sikasire@microsoft.com"),
	// 		CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:14:58.865Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("2d2a754c-cade-4935-83d4-ce413c5a3910"),
	// 		LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/DeleteClusterExample.json
func ExampleConnectedClusterClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewConnectedClusterClient().BeginDelete(ctx, "k8sc-rg", "testCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/ConnectedClustersListClusterCredentialResultHPAAD.json
func ExampleConnectedClusterClient_ListClusterUserCredential_listClusterUserCredentialCspExample() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().ListClusterUserCredential(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ListClusterUserCredentialProperties{
		AuthenticationMethod: to.Ptr(armhybridkubernetes.AuthenticationMethodAAD),
		ClientProxy:          to.Ptr(false),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CredentialResults = armhybridkubernetes.CredentialResults{
	// 	Kubeconfigs: []*armhybridkubernetes.CredentialResult{
	// 		{
	// 			Name: to.Ptr("credentialName1"),
	// 			Value: []byte("YXBpVmVyc2lvbjogdjENCmNsdXN0ZXJzOg0KLSBjbHVzdGVyOg0KICAgIGNlcnRpZmljYXRlLWF1dGhvcml0eS1kYXRhOiBMUzB0TFMxQ1JVZEpUaUJEUlZKVVNVWkpRMEZVUlMwdExTMHRDazFKU1VWNGVrTkRRWEVyWjBGM1NVSkJaMGxSVTJ0dVdsWnZaekp1VmpKVmNYZEtjblZYTTFCSGVrRk9RbWRyY1docmFVYzVkekJDUVZGelJrRkVRVTRLVFZGemQwTlJXVVJXVVZGRVJYZEthbGVsSlEwbHFRVTVDWjJ0eGFHdHBSemwzTUVKQlVVVkdRVUZQUTBGbk9FRk5TVWxEUTJkTFEwRm5SVUUwV1hCNUNsUmtUMVJSU1dNdmVsaERlR3hTZWtVMF"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/ConnectedClustersListClusterCredentialResultCSPAAD.json
func ExampleConnectedClusterClient_ListClusterUserCredential_listClusterUserCredentialExample() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().ListClusterUserCredential(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ListClusterUserCredentialProperties{
		AuthenticationMethod: to.Ptr(armhybridkubernetes.AuthenticationMethodAAD),
		ClientProxy:          to.Ptr(true),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CredentialResults = armhybridkubernetes.CredentialResults{
	// 	HybridConnectionConfig: &armhybridkubernetes.HybridConnectionConfig{
	// 		ExpirationTime: to.Ptr[int64](1631196183),
	// 		HybridConnectionName: to.Ptr("microsoft.kubernetes/connectedclusters/229dc73f7b07196c79a93d4362d9c7fc4ed34df3e95290d27c56cec2dbb82865/1631185383340987904"),
	// 		Relay: to.Ptr("azgnrelay-ph0-l1"),
	// 		Token: to.Ptr("SharedAccessSignature 123456789034675890pbduwegiavifkuw647o02423bbhfouseb"),
	// 	},
	// 	Kubeconfigs: []*armhybridkubernetes.CredentialResult{
	// 		{
	// 			Name: to.Ptr("credentialName1"),
	// 			Value: []byte("YXBpVmVyc2lvbjogdjENCmNsdXN0ZXJzOg0KLSBjbHVzdGVyOg0KICAgIGNlcnRpZmljYXRlLWF1dGhvcml0eS1kYXRhOiBMUzB0TFMxQ1JVZEpUaUJEUlZKVVNVWkpRMEZVUlMwdExTMHRDazFKU1VWNGVrTkRRWEVyWjBGM1NVSkJaMGxSVTJ0dVdsWnZaekp1VmpKVmNYZEtjblZYTTFCSGVrRk9RbWRyY1docmFVYzVkekJDUVZGelJrRkVRVTRLVFZGemQwTlJXVVJXVVZGRVJYZEthbGVsSlEwbHFRVTVDWjJ0eGFHdHBSemwzTUVKQlVVVkdRVUZQUTBGbk9FRk5TVWxEUTJkTFEwRm5SVUUwV1hCNUNsUmtUMVJSU1dNdmVsaERlR3hTZWtVMF"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/ConnectedClustersListClusterCredentialResultHPToken.json
func ExampleConnectedClusterClient_ListClusterUserCredential_listClusterUserCredentialNonAadCspExample() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().ListClusterUserCredential(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ListClusterUserCredentialProperties{
		AuthenticationMethod: to.Ptr(armhybridkubernetes.AuthenticationMethodToken),
		ClientProxy:          to.Ptr(false),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CredentialResults = armhybridkubernetes.CredentialResults{
	// 	Kubeconfigs: []*armhybridkubernetes.CredentialResult{
	// 		{
	// 			Name: to.Ptr("credentialName1"),
	// 			Value: []byte("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"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/ConnectedClustersListClusterCredentialResultCSPToken.json
func ExampleConnectedClusterClient_ListClusterUserCredential_listClusterUserCredentialNonAadExample() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectedClusterClient().ListClusterUserCredential(ctx, "k8sc-rg", "testCluster", armhybridkubernetes.ListClusterUserCredentialProperties{
		AuthenticationMethod: to.Ptr(armhybridkubernetes.AuthenticationMethodToken),
		ClientProxy:          to.Ptr(true),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CredentialResults = armhybridkubernetes.CredentialResults{
	// 	HybridConnectionConfig: &armhybridkubernetes.HybridConnectionConfig{
	// 		ExpirationTime: to.Ptr[int64](1631196183),
	// 		HybridConnectionName: to.Ptr("microsoft.kubernetes/connectedclusters/229dc73f7b07196c79a93d4362d9c7fc4ed34df3e95290d27c56cec2dbb82865/1631185383340987904"),
	// 		Relay: to.Ptr("azgnrelay-ph0-l1"),
	// 		Token: to.Ptr("SharedAccessSignature 123456789034675890pbduwegiavifkuw647o02423bbhfouseb"),
	// 	},
	// 	Kubeconfigs: []*armhybridkubernetes.CredentialResult{
	// 		{
	// 			Name: to.Ptr("credentialName1"),
	// 			Value: []byte("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"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/GetClustersByResourceGroupExample.json
func ExampleConnectedClusterClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectedClusterClient().NewListByResourceGroupPager("k8sc-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectedClusterList = armhybridkubernetes.ConnectedClusterList{
		// 	Value: []*armhybridkubernetes.ConnectedCluster{
		// 		{
		// 			Name: to.Ptr("connectedCluster1"),
		// 			Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
		// 			ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armhybridkubernetes.ConnectedClusterIdentity{
		// 				Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("d8cd1fd9-154f-4da7-b348-595f283c13a3"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Properties: &armhybridkubernetes.ConnectedClusterProperties{
		// 				AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
		// 				AgentVersion: to.Ptr("0.1.0"),
		// 				KubernetesVersion: to.Ptr("1.17.0"),
		// 				ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
		// 				TotalNodeCount: to.Ptr[int32](2),
		// 			},
		// 			SystemData: &armhybridkubernetes.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				CreatedBy: to.Ptr("sikasire@microsoft.com"),
		// 				CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sikasire@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("connectedCluster1"),
		// 			Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
		// 			ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armhybridkubernetes.ConnectedClusterIdentity{
		// 				Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("d8cd1fd9-154f-4da7-b348-595f283c13a3"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Properties: &armhybridkubernetes.ConnectedClusterProperties{
		// 				AgentPublicKeyCertificate: to.Ptr("XIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
		// 				AgentVersion: to.Ptr("0.1.0"),
		// 				KubernetesVersion: to.Ptr("1.1"),
		// 				ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
		// 				TotalNodeCount: to.Ptr[int32](2),
		// 			},
		// 			SystemData: &armhybridkubernetes.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				CreatedBy: to.Ptr("sikasire@microsoft.com"),
		// 				CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sikasire@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/hybridkubernetes/resource-manager/Microsoft.Kubernetes/stable/2021-10-01/examples/GetClustersBySubscriptionExample.json
func ExampleConnectedClusterClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridkubernetes.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectedClusterClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectedClusterList = armhybridkubernetes.ConnectedClusterList{
		// 	Value: []*armhybridkubernetes.ConnectedCluster{
		// 		{
		// 			Name: to.Ptr("connectedCluster1"),
		// 			Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
		// 			ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armhybridkubernetes.ConnectedClusterIdentity{
		// 				Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("d8cd1fd9-154f-4da7-b348-595f283c13a3"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Properties: &armhybridkubernetes.ConnectedClusterProperties{
		// 				AgentPublicKeyCertificate: to.Ptr("MIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
		// 				AgentVersion: to.Ptr("0.1.0"),
		// 				KubernetesVersion: to.Ptr("1.17.0"),
		// 				ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
		// 				TotalNodeCount: to.Ptr[int32](2),
		// 			},
		// 			SystemData: &armhybridkubernetes.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				CreatedBy: to.Ptr("sikasire@microsoft.com"),
		// 				CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sikasire@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("connectedCluster2"),
		// 			Type: to.Ptr("Microsoft.Kubernetes/connectedClusters"),
		// 			ID: to.Ptr("/subscriptions/1bfbb5d0-917e-4346-9026-1d3b344417f5/resourceGroups/akkeshar/providers/Microsoft.Kubernetes/connectedClusters/connectedCluster1"),
		// 			Location: to.Ptr("East US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Identity: &armhybridkubernetes.ConnectedClusterIdentity{
		// 				Type: to.Ptr(armhybridkubernetes.ResourceIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("d8cd1fd9-154f-4da7-b348-595f283c13a3"),
		// 				TenantID: to.Ptr("72f988bf-86f1-41af-91ab-2d7cd011db47"),
		// 			},
		// 			Properties: &armhybridkubernetes.ConnectedClusterProperties{
		// 				AgentPublicKeyCertificate: to.Ptr("XIICYzCCAcygAwIBAgIBADANBgkqhkiG9w0BAQUFADAuMQswCQYDVQQGEwJVUzEMMAoGA1UEChMDSUJNMREwDwYDVQQLEwhMb2NhbCBDQTAeFw05OTEyMjIwNTAwMDBaFw0wMDEyMjMwNDU5NTlaMC4xCzAJBgNVBAYTAlVTMQwwCgYDVQQKEwNJQk0xETAPBgNVBAsTCExvY2FsIENBMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQD2bZEo7xGaX2/0GHkrNFZvlxBou9v1Jmt/PDiTMPve8r9FeJAQ0QdvFST/0JPQYD20rH0bimdDLgNdNynmyRoS2S/IInfpmf69iyc2G0TPyRvmHIiOZbdCd+YBHQi1adkj17NDcWj6S14tVurFX73zx0sNoMS79q3tuXKrDsxeuwIDAQABo4GQMIGNMEsGCVUdDwGG+EIBDQQ+EzxHZW5lcmF0ZWQgYnkgdGhlIFNlY3VyZVdheSBTZWN1cml0eSBTZXJ2ZXIgZm9yIE9TLzM5MCAoUkFDRikwDgYDVR0PAQH/BAQDAgAGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFJ3+ocRyCTJw067dLSwr/nalx6YMMA0GCSqGSIb3DQEBBQUAA4GBAMaQzt+zaj1GU77yzlr8iiMBXgdQrwsZZWJo5exnAucJAEYQZmOfyLiM D6oYq+ZnfvM0n8G/Y79q8nhwvuxpYOnRSAXFp6xSkrIOeZtJMY1h00LKp/JX3Ng1svZ2agE126JHsQ0bhzN5TKsYfbwfTwfjdWAGy6Vf1nYi/rO+ryMO"),
		// 				AgentVersion: to.Ptr("0.1.0"),
		// 				KubernetesVersion: to.Ptr("1.16.3"),
		// 				ProvisioningState: to.Ptr(armhybridkubernetes.ProvisioningStateSucceeded),
		// 				TotalNodeCount: to.Ptr[int32](4),
		// 			},
		// 			SystemData: &armhybridkubernetes.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				CreatedBy: to.Ptr("sikasire@microsoft.com"),
		// 				CreatedByType: to.Ptr(armhybridkubernetes.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-12-17T07:06:33.917Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("sikasire@microsoft.com"),
		// 				LastModifiedByType: to.Ptr(armhybridkubernetes.LastModifiedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}
