//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// BinaryHardeningClient contains the methods for the BinaryHardening group.
// Don't use this type directly, use NewBinaryHardeningClient() instead.
type BinaryHardeningClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewBinaryHardeningClient creates a new instance of BinaryHardeningClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewBinaryHardeningClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*BinaryHardeningClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &BinaryHardeningClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListByFirmwarePager - Lists binary hardening analysis results of a firmware.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - BinaryHardeningClientListByFirmwareOptions contains the optional parameters for the BinaryHardeningClient.NewListByFirmwarePager
//     method.
func (client *BinaryHardeningClient) NewListByFirmwarePager(resourceGroupName string, workspaceName string, firmwareID string, options *BinaryHardeningClientListByFirmwareOptions) *runtime.Pager[BinaryHardeningClientListByFirmwareResponse] {
	return runtime.NewPager(runtime.PagingHandler[BinaryHardeningClientListByFirmwareResponse]{
		More: func(page BinaryHardeningClientListByFirmwareResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *BinaryHardeningClientListByFirmwareResponse) (BinaryHardeningClientListByFirmwareResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "BinaryHardeningClient.NewListByFirmwarePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByFirmwareCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
			}, nil)
			if err != nil {
				return BinaryHardeningClientListByFirmwareResponse{}, err
			}
			return client.listByFirmwareHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByFirmwareCreateRequest creates the ListByFirmware request.
func (client *BinaryHardeningClient) listByFirmwareCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *BinaryHardeningClientListByFirmwareOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/binaryHardeningResults"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFirmwareHandleResponse handles the ListByFirmware response.
func (client *BinaryHardeningClient) listByFirmwareHandleResponse(resp *http.Response) (BinaryHardeningClientListByFirmwareResponse, error) {
	result := BinaryHardeningClientListByFirmwareResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BinaryHardeningListResult); err != nil {
		return BinaryHardeningClientListByFirmwareResponse{}, err
	}
	return result, nil
}
