//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/maintenance/armmaintenance"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigurationsForResourceGroupServer is a fake server for instances of the armmaintenance.ConfigurationsForResourceGroupClient type.
type ConfigurationsForResourceGroupServer struct {
	// NewListPager is the fake for method ConfigurationsForResourceGroupClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armmaintenance.ConfigurationsForResourceGroupClientListOptions) (resp azfake.PagerResponder[armmaintenance.ConfigurationsForResourceGroupClientListResponse])
}

// NewConfigurationsForResourceGroupServerTransport creates a new instance of ConfigurationsForResourceGroupServerTransport with the provided implementation.
// The returned ConfigurationsForResourceGroupServerTransport instance is connected to an instance of armmaintenance.ConfigurationsForResourceGroupClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationsForResourceGroupServerTransport(srv *ConfigurationsForResourceGroupServer) *ConfigurationsForResourceGroupServerTransport {
	return &ConfigurationsForResourceGroupServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmaintenance.ConfigurationsForResourceGroupClientListResponse]](),
	}
}

// ConfigurationsForResourceGroupServerTransport connects instances of armmaintenance.ConfigurationsForResourceGroupClient to instances of ConfigurationsForResourceGroupServer.
// Don't use this type directly, use NewConfigurationsForResourceGroupServerTransport instead.
type ConfigurationsForResourceGroupServerTransport struct {
	srv          *ConfigurationsForResourceGroupServer
	newListPager *tracker[azfake.PagerResponder[armmaintenance.ConfigurationsForResourceGroupClientListResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationsForResourceGroupServerTransport.
func (c *ConfigurationsForResourceGroupServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationsForResourceGroupClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationsForResourceGroupServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/maintenanceConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
