//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	moduleVersion = "v1.1.0"
)

// ACLActionType - Type of actions that can be performed.
type ACLActionType string

const (
	ACLActionTypeCount ACLActionType = "Count"
	ACLActionTypeDrop  ACLActionType = "Drop"
	ACLActionTypeLog   ACLActionType = "Log"
)

// PossibleACLActionTypeValues returns the possible values for the ACLActionType const type.
func PossibleACLActionTypeValues() []ACLActionType {
	return []ACLActionType{
		ACLActionTypeCount,
		ACLActionTypeDrop,
		ACLActionTypeLog,
	}
}

// Action - Specify action.
type Action string

const (
	ActionAllow Action = "Allow"
	ActionDeny  Action = "Deny"
)

// PossibleActionValues returns the possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{
		ActionAllow,
		ActionDeny,
	}
}

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AddressFamilyType - AddressFamilyType. This parameter decides whether the given ipv4 or ipv6 route policy.
type AddressFamilyType string

const (
	AddressFamilyTypeIPv4 AddressFamilyType = "IPv4"
	AddressFamilyTypeIPv6 AddressFamilyType = "IPv6"
)

// PossibleAddressFamilyTypeValues returns the possible values for the AddressFamilyType const type.
func PossibleAddressFamilyTypeValues() []AddressFamilyType {
	return []AddressFamilyType{
		AddressFamilyTypeIPv4,
		AddressFamilyTypeIPv6,
	}
}

// AdministrativeState - State defined to represent administrative actions or post actions on a particular resource.
type AdministrativeState string

const (
	AdministrativeStateDisabled AdministrativeState = "Disabled"
	AdministrativeStateEnabled  AdministrativeState = "Enabled"
	AdministrativeStateMAT      AdministrativeState = "MAT"
	AdministrativeStateRMA      AdministrativeState = "RMA"
)

// PossibleAdministrativeStateValues returns the possible values for the AdministrativeState const type.
func PossibleAdministrativeStateValues() []AdministrativeState {
	return []AdministrativeState{
		AdministrativeStateDisabled,
		AdministrativeStateEnabled,
		AdministrativeStateMAT,
		AdministrativeStateRMA,
	}
}

// AllowASOverride - Enable Or Disable state.
type AllowASOverride string

const (
	AllowASOverrideDisable AllowASOverride = "Disable"
	AllowASOverrideEnable  AllowASOverride = "Enable"
)

// PossibleAllowASOverrideValues returns the possible values for the AllowASOverride const type.
func PossibleAllowASOverrideValues() []AllowASOverride {
	return []AllowASOverride{
		AllowASOverrideDisable,
		AllowASOverrideEnable,
	}
}

// BfdAdministrativeState - Administrative state of the BfdConfiguration. Example: Enabled | Disabled.
type BfdAdministrativeState string

const (
	BfdAdministrativeStateDisabled BfdAdministrativeState = "Disabled"
	BfdAdministrativeStateEnabled  BfdAdministrativeState = "Enabled"
	BfdAdministrativeStateMAT      BfdAdministrativeState = "MAT"
	BfdAdministrativeStateRMA      BfdAdministrativeState = "RMA"
)

// PossibleBfdAdministrativeStateValues returns the possible values for the BfdAdministrativeState const type.
func PossibleBfdAdministrativeStateValues() []BfdAdministrativeState {
	return []BfdAdministrativeState{
		BfdAdministrativeStateDisabled,
		BfdAdministrativeStateEnabled,
		BfdAdministrativeStateMAT,
		BfdAdministrativeStateRMA,
	}
}

// BooleanEnumProperty - Boolean Enum. Example- True/False
type BooleanEnumProperty string

const (
	BooleanEnumPropertyFalse BooleanEnumProperty = "False"
	BooleanEnumPropertyTrue  BooleanEnumProperty = "True"
)

// PossibleBooleanEnumPropertyValues returns the possible values for the BooleanEnumProperty const type.
func PossibleBooleanEnumPropertyValues() []BooleanEnumProperty {
	return []BooleanEnumProperty{
		BooleanEnumPropertyFalse,
		BooleanEnumPropertyTrue,
	}
}

// CommunityActionTypes - community action types. Example: Permit | Deny.
type CommunityActionTypes string

const (
	CommunityActionTypesDeny   CommunityActionTypes = "Deny"
	CommunityActionTypesPermit CommunityActionTypes = "Permit"
)

// PossibleCommunityActionTypesValues returns the possible values for the CommunityActionTypes const type.
func PossibleCommunityActionTypesValues() []CommunityActionTypes {
	return []CommunityActionTypes{
		CommunityActionTypesDeny,
		CommunityActionTypesPermit,
	}
}

// Condition - Specify prefix-list bounds.
type Condition string

const (
	ConditionEqualTo              Condition = "EqualTo"
	ConditionGreaterThanOrEqualTo Condition = "GreaterThanOrEqualTo"
	ConditionLesserThanOrEqualTo  Condition = "LesserThanOrEqualTo"
	ConditionRange                Condition = "Range"
)

// PossibleConditionValues returns the possible values for the Condition const type.
func PossibleConditionValues() []Condition {
	return []Condition{
		ConditionEqualTo,
		ConditionGreaterThanOrEqualTo,
		ConditionLesserThanOrEqualTo,
		ConditionRange,
	}
}

// ConfigurationState - Configuration state for the resource.
type ConfigurationState string

const (
	ConfigurationStateAccepted            ConfigurationState = "Accepted"
	ConfigurationStateDeferredControl     ConfigurationState = "DeferredControl"
	ConfigurationStateDeprovisioned       ConfigurationState = "Deprovisioned"
	ConfigurationStateDeprovisioning      ConfigurationState = "Deprovisioning"
	ConfigurationStateErrorDeprovisioning ConfigurationState = "ErrorDeprovisioning"
	ConfigurationStateErrorProvisioning   ConfigurationState = "ErrorProvisioning"
	ConfigurationStateFailed              ConfigurationState = "Failed"
	ConfigurationStateProvisioned         ConfigurationState = "Provisioned"
	ConfigurationStateRejected            ConfigurationState = "Rejected"
	ConfigurationStateSucceeded           ConfigurationState = "Succeeded"
)

// PossibleConfigurationStateValues returns the possible values for the ConfigurationState const type.
func PossibleConfigurationStateValues() []ConfigurationState {
	return []ConfigurationState{
		ConfigurationStateAccepted,
		ConfigurationStateDeferredControl,
		ConfigurationStateDeprovisioned,
		ConfigurationStateDeprovisioning,
		ConfigurationStateErrorDeprovisioning,
		ConfigurationStateErrorProvisioning,
		ConfigurationStateFailed,
		ConfigurationStateProvisioned,
		ConfigurationStateRejected,
		ConfigurationStateSucceeded,
	}
}

// ConfigurationType - Input method to configure Access Control List.
type ConfigurationType string

const (
	ConfigurationTypeFile   ConfigurationType = "File"
	ConfigurationTypeInline ConfigurationType = "Inline"
)

// PossibleConfigurationTypeValues returns the possible values for the ConfigurationType const type.
func PossibleConfigurationTypeValues() []ConfigurationType {
	return []ConfigurationType{
		ConfigurationTypeFile,
		ConfigurationTypeInline,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DestinationType - Type of destination. Input can be IsolationDomain or Direct.
type DestinationType string

const (
	DestinationTypeDirect          DestinationType = "Direct"
	DestinationTypeIsolationDomain DestinationType = "IsolationDomain"
)

// PossibleDestinationTypeValues returns the possible values for the DestinationType const type.
func PossibleDestinationTypeValues() []DestinationType {
	return []DestinationType{
		DestinationTypeDirect,
		DestinationTypeIsolationDomain,
	}
}

// DeviceAdministrativeState - Administrative state.
type DeviceAdministrativeState string

const (
	DeviceAdministrativeStateGracefulQuarantine DeviceAdministrativeState = "GracefulQuarantine"
	DeviceAdministrativeStateQuarantine         DeviceAdministrativeState = "Quarantine"
	DeviceAdministrativeStateRMA                DeviceAdministrativeState = "RMA"
	DeviceAdministrativeStateResync             DeviceAdministrativeState = "Resync"
)

// PossibleDeviceAdministrativeStateValues returns the possible values for the DeviceAdministrativeState const type.
func PossibleDeviceAdministrativeStateValues() []DeviceAdministrativeState {
	return []DeviceAdministrativeState{
		DeviceAdministrativeStateGracefulQuarantine,
		DeviceAdministrativeStateQuarantine,
		DeviceAdministrativeStateRMA,
		DeviceAdministrativeStateResync,
	}
}

// EnableDisableState - Administrative state.
type EnableDisableState string

const (
	EnableDisableStateDisable EnableDisableState = "Disable"
	EnableDisableStateEnable  EnableDisableState = "Enable"
)

// PossibleEnableDisableStateValues returns the possible values for the EnableDisableState const type.
func PossibleEnableDisableStateValues() []EnableDisableState {
	return []EnableDisableState{
		EnableDisableStateDisable,
		EnableDisableStateEnable,
	}
}

// Encapsulation - Type of encapsulation.
type Encapsulation string

const (
	EncapsulationGRE  Encapsulation = "GRE"
	EncapsulationNone Encapsulation = "None"
)

// PossibleEncapsulationValues returns the possible values for the Encapsulation const type.
func PossibleEncapsulationValues() []Encapsulation {
	return []Encapsulation{
		EncapsulationGRE,
		EncapsulationNone,
	}
}

// EncapsulationType - Encapsulation Type.
type EncapsulationType string

const (
	EncapsulationTypeGTPv1 EncapsulationType = "GTPv1"
	EncapsulationTypeNone  EncapsulationType = "None"
)

// PossibleEncapsulationTypeValues returns the possible values for the EncapsulationType const type.
func PossibleEncapsulationTypeValues() []EncapsulationType {
	return []EncapsulationType{
		EncapsulationTypeGTPv1,
		EncapsulationTypeNone,
	}
}

// Extension - Extension. Example: NoExtension | NPB.
type Extension string

const (
	ExtensionNPB         Extension = "NPB"
	ExtensionNoExtension Extension = "NoExtension"
)

// PossibleExtensionValues returns the possible values for the Extension const type.
func PossibleExtensionValues() []Extension {
	return []Extension{
		ExtensionNPB,
		ExtensionNoExtension,
	}
}

// FabricSKUType - Type of Network Fabric SKU.
type FabricSKUType string

const (
	FabricSKUTypeMultiRack  FabricSKUType = "MultiRack"
	FabricSKUTypeSingleRack FabricSKUType = "SingleRack"
)

// PossibleFabricSKUTypeValues returns the possible values for the FabricSKUType const type.
func PossibleFabricSKUTypeValues() []FabricSKUType {
	return []FabricSKUType{
		FabricSKUTypeMultiRack,
		FabricSKUTypeSingleRack,
	}
}

// GatewayType - Gateway Type of the resource.
type GatewayType string

const (
	GatewayTypeInfrastructure GatewayType = "Infrastructure"
	GatewayTypeWorkload       GatewayType = "Workload"
)

// PossibleGatewayTypeValues returns the possible values for the GatewayType const type.
func PossibleGatewayTypeValues() []GatewayType {
	return []GatewayType{
		GatewayTypeInfrastructure,
		GatewayTypeWorkload,
	}
}

// IPAddressType - IP Address type.
type IPAddressType string

const (
	IPAddressTypeIPv4 IPAddressType = "IPv4"
	IPAddressTypeIPv6 IPAddressType = "IPv6"
)

// PossibleIPAddressTypeValues returns the possible values for the IPAddressType const type.
func PossibleIPAddressTypeValues() []IPAddressType {
	return []IPAddressType{
		IPAddressTypeIPv4,
		IPAddressTypeIPv6,
	}
}

// InterfaceType - The Interface Type. Example: Management/Data
type InterfaceType string

const (
	InterfaceTypeData       InterfaceType = "Data"
	InterfaceTypeManagement InterfaceType = "Management"
)

// PossibleInterfaceTypeValues returns the possible values for the InterfaceType const type.
func PossibleInterfaceTypeValues() []InterfaceType {
	return []InterfaceType{
		InterfaceTypeData,
		InterfaceTypeManagement,
	}
}

// IsManagementType - Configuration to use NNI for Infrastructure Management. Example: True/False.
type IsManagementType string

const (
	IsManagementTypeFalse IsManagementType = "False"
	IsManagementTypeTrue  IsManagementType = "True"
)

// PossibleIsManagementTypeValues returns the possible values for the IsManagementType const type.
func PossibleIsManagementTypeValues() []IsManagementType {
	return []IsManagementType{
		IsManagementTypeFalse,
		IsManagementTypeTrue,
	}
}

// IsMonitoringEnabled - To check whether monitoring of internal network is enabled or not.
type IsMonitoringEnabled string

const (
	IsMonitoringEnabledFalse IsMonitoringEnabled = "False"
	IsMonitoringEnabledTrue  IsMonitoringEnabled = "True"
)

// PossibleIsMonitoringEnabledValues returns the possible values for the IsMonitoringEnabled const type.
func PossibleIsMonitoringEnabledValues() []IsMonitoringEnabled {
	return []IsMonitoringEnabled{
		IsMonitoringEnabledFalse,
		IsMonitoringEnabledTrue,
	}
}

// IsWorkloadManagementNetworkEnabled - A workload management network is required for all the tenant (workload) traffic. This
// traffic is only dedicated for Tenant workloads which are required to access internet or any other MSFT/Public
// endpoints.
type IsWorkloadManagementNetworkEnabled string

const (
	IsWorkloadManagementNetworkEnabledFalse IsWorkloadManagementNetworkEnabled = "False"
	IsWorkloadManagementNetworkEnabledTrue  IsWorkloadManagementNetworkEnabled = "True"
)

// PossibleIsWorkloadManagementNetworkEnabledValues returns the possible values for the IsWorkloadManagementNetworkEnabled const type.
func PossibleIsWorkloadManagementNetworkEnabledValues() []IsWorkloadManagementNetworkEnabled {
	return []IsWorkloadManagementNetworkEnabled{
		IsWorkloadManagementNetworkEnabledFalse,
		IsWorkloadManagementNetworkEnabledTrue,
	}
}

// Layer4Protocol - Layer4 protocol type that needs to be matched.
type Layer4Protocol string

const (
	Layer4ProtocolTCP Layer4Protocol = "TCP"
	Layer4ProtocolUDP Layer4Protocol = "UDP"
)

// PossibleLayer4ProtocolValues returns the possible values for the Layer4Protocol const type.
func PossibleLayer4ProtocolValues() []Layer4Protocol {
	return []Layer4Protocol{
		Layer4ProtocolTCP,
		Layer4ProtocolUDP,
	}
}

// NetworkDeviceRole - NetworkDeviceRole is the device role: Example: CE | ToR.
type NetworkDeviceRole string

const (
	NetworkDeviceRoleCE         NetworkDeviceRole = "CE"
	NetworkDeviceRoleManagement NetworkDeviceRole = "Management"
	NetworkDeviceRoleNPB        NetworkDeviceRole = "NPB"
	NetworkDeviceRoleTS         NetworkDeviceRole = "TS"
	NetworkDeviceRoleToR        NetworkDeviceRole = "ToR"
)

// PossibleNetworkDeviceRoleValues returns the possible values for the NetworkDeviceRole const type.
func PossibleNetworkDeviceRoleValues() []NetworkDeviceRole {
	return []NetworkDeviceRole{
		NetworkDeviceRoleCE,
		NetworkDeviceRoleManagement,
		NetworkDeviceRoleNPB,
		NetworkDeviceRoleTS,
		NetworkDeviceRoleToR,
	}
}

// NetworkDeviceRoleName - Available roles for the network device.
type NetworkDeviceRoleName string

const (
	NetworkDeviceRoleNameCE         NetworkDeviceRoleName = "CE"
	NetworkDeviceRoleNameManagement NetworkDeviceRoleName = "Management"
	NetworkDeviceRoleNameNPB        NetworkDeviceRoleName = "NPB"
	NetworkDeviceRoleNameTS         NetworkDeviceRoleName = "TS"
	NetworkDeviceRoleNameToR        NetworkDeviceRoleName = "ToR"
)

// PossibleNetworkDeviceRoleNameValues returns the possible values for the NetworkDeviceRoleName const type.
func PossibleNetworkDeviceRoleNameValues() []NetworkDeviceRoleName {
	return []NetworkDeviceRoleName{
		NetworkDeviceRoleNameCE,
		NetworkDeviceRoleNameManagement,
		NetworkDeviceRoleNameNPB,
		NetworkDeviceRoleNameTS,
		NetworkDeviceRoleNameToR,
	}
}

// NetworkRackType - Network Rack SKU name.
type NetworkRackType string

const (
	NetworkRackTypeAggregate NetworkRackType = "Aggregate"
	NetworkRackTypeCombined  NetworkRackType = "Combined"
	NetworkRackTypeCompute   NetworkRackType = "Compute"
)

// PossibleNetworkRackTypeValues returns the possible values for the NetworkRackType const type.
func PossibleNetworkRackTypeValues() []NetworkRackType {
	return []NetworkRackType{
		NetworkRackTypeAggregate,
		NetworkRackTypeCombined,
		NetworkRackTypeCompute,
	}
}

// NfcSKU - Network Fabric Controller SKU.
type NfcSKU string

const (
	NfcSKUBasic           NfcSKU = "Basic"
	NfcSKUHighPerformance NfcSKU = "HighPerformance"
	NfcSKUStandard        NfcSKU = "Standard"
)

// PossibleNfcSKUValues returns the possible values for the NfcSKU const type.
func PossibleNfcSKUValues() []NfcSKU {
	return []NfcSKU{
		NfcSKUBasic,
		NfcSKUHighPerformance,
		NfcSKUStandard,
	}
}

// NniType - Type of NNI used. Example: CE | NPB
type NniType string

const (
	NniTypeCE  NniType = "CE"
	NniTypeNPB NniType = "NPB"
)

// PossibleNniTypeValues returns the possible values for the NniType const type.
func PossibleNniTypeValues() []NniType {
	return []NniType{
		NniTypeCE,
		NniTypeNPB,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// PeeringOption - Peering option list.
type PeeringOption string

const (
	PeeringOptionOptionA PeeringOption = "OptionA"
	PeeringOptionOptionB PeeringOption = "OptionB"
)

// PossiblePeeringOptionValues returns the possible values for the PeeringOption const type.
func PossiblePeeringOptionValues() []PeeringOption {
	return []PeeringOption{
		PeeringOptionOptionA,
		PeeringOptionOptionB,
	}
}

// PollingIntervalInSeconds - Polling interval in seconds.
type PollingIntervalInSeconds int32

const (
	PollingIntervalInSecondsNinety           PollingIntervalInSeconds = 90
	PollingIntervalInSecondsOneHundredTwenty PollingIntervalInSeconds = 120
	PollingIntervalInSecondsSixty            PollingIntervalInSeconds = 60
	PollingIntervalInSecondsThirty           PollingIntervalInSeconds = 30
)

// PossiblePollingIntervalInSecondsValues returns the possible values for the PollingIntervalInSeconds const type.
func PossiblePollingIntervalInSecondsValues() []PollingIntervalInSeconds {
	return []PollingIntervalInSeconds{
		PollingIntervalInSecondsNinety,
		PollingIntervalInSecondsOneHundredTwenty,
		PollingIntervalInSecondsSixty,
		PollingIntervalInSecondsThirty,
	}
}

// PollingType - Polling type.
type PollingType string

const (
	PollingTypePull PollingType = "Pull"
	PollingTypePush PollingType = "Push"
)

// PossiblePollingTypeValues returns the possible values for the PollingType const type.
func PossiblePollingTypeValues() []PollingType {
	return []PollingType{
		PollingTypePull,
		PollingTypePush,
	}
}

// PortType - Port type that needs to be matched.
type PortType string

const (
	PortTypeDestinationPort PortType = "DestinationPort"
	PortTypeSourcePort      PortType = "SourcePort"
)

// PossiblePortTypeValues returns the possible values for the PortType const type.
func PossiblePortTypeValues() []PortType {
	return []PortType{
		PortTypeDestinationPort,
		PortTypeSourcePort,
	}
}

// PrefixType - IP Prefix Type.
type PrefixType string

const (
	PrefixTypeLongestPrefix PrefixType = "LongestPrefix"
	PrefixTypePrefix        PrefixType = "Prefix"
)

// PossiblePrefixTypeValues returns the possible values for the PrefixType const type.
func PossiblePrefixTypeValues() []PrefixType {
	return []PrefixType{
		PrefixTypeLongestPrefix,
		PrefixTypePrefix,
	}
}

// ProvisioningState - The current provisioning state.
type ProvisioningState string

const (
	ProvisioningStateAccepted  ProvisioningState = "Accepted"
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// RebootType - Type of reboot to be performed. Example: GracefulRebootWithZTP
type RebootType string

const (
	RebootTypeGracefulRebootWithZTP      RebootType = "GracefulRebootWithZTP"
	RebootTypeGracefulRebootWithoutZTP   RebootType = "GracefulRebootWithoutZTP"
	RebootTypeUngracefulRebootWithZTP    RebootType = "UngracefulRebootWithZTP"
	RebootTypeUngracefulRebootWithoutZTP RebootType = "UngracefulRebootWithoutZTP"
)

// PossibleRebootTypeValues returns the possible values for the RebootType const type.
func PossibleRebootTypeValues() []RebootType {
	return []RebootType{
		RebootTypeGracefulRebootWithZTP,
		RebootTypeGracefulRebootWithoutZTP,
		RebootTypeUngracefulRebootWithZTP,
		RebootTypeUngracefulRebootWithoutZTP,
	}
}

// RedistributeConnectedSubnets - Advertise Connected Subnets. Ex: "True" | "False".
type RedistributeConnectedSubnets string

const (
	RedistributeConnectedSubnetsFalse RedistributeConnectedSubnets = "False"
	RedistributeConnectedSubnetsTrue  RedistributeConnectedSubnets = "True"
)

// PossibleRedistributeConnectedSubnetsValues returns the possible values for the RedistributeConnectedSubnets const type.
func PossibleRedistributeConnectedSubnetsValues() []RedistributeConnectedSubnets {
	return []RedistributeConnectedSubnets{
		RedistributeConnectedSubnetsFalse,
		RedistributeConnectedSubnetsTrue,
	}
}

// RedistributeStaticRoutes - Advertise Static Routes. Ex: "True" | "False".
type RedistributeStaticRoutes string

const (
	RedistributeStaticRoutesFalse RedistributeStaticRoutes = "False"
	RedistributeStaticRoutesTrue  RedistributeStaticRoutes = "True"
)

// PossibleRedistributeStaticRoutesValues returns the possible values for the RedistributeStaticRoutes const type.
func PossibleRedistributeStaticRoutesValues() []RedistributeStaticRoutes {
	return []RedistributeStaticRoutes{
		RedistributeStaticRoutesFalse,
		RedistributeStaticRoutesTrue,
	}
}

// RoutePolicyActionType - Action type. Example: Permit | Deny | Continue.
type RoutePolicyActionType string

const (
	RoutePolicyActionTypeContinue RoutePolicyActionType = "Continue"
	RoutePolicyActionTypeDeny     RoutePolicyActionType = "Deny"
	RoutePolicyActionTypePermit   RoutePolicyActionType = "Permit"
)

// PossibleRoutePolicyActionTypeValues returns the possible values for the RoutePolicyActionType const type.
func PossibleRoutePolicyActionTypeValues() []RoutePolicyActionType {
	return []RoutePolicyActionType{
		RoutePolicyActionTypeContinue,
		RoutePolicyActionTypeDeny,
		RoutePolicyActionTypePermit,
	}
}

// RoutePolicyConditionType - Type of the condition used.
type RoutePolicyConditionType string

const (
	RoutePolicyConditionTypeAnd RoutePolicyConditionType = "And"
	RoutePolicyConditionTypeOr  RoutePolicyConditionType = "Or"
)

// PossibleRoutePolicyConditionTypeValues returns the possible values for the RoutePolicyConditionType const type.
func PossibleRoutePolicyConditionTypeValues() []RoutePolicyConditionType {
	return []RoutePolicyConditionType{
		RoutePolicyConditionTypeAnd,
		RoutePolicyConditionTypeOr,
	}
}

// SourceDestinationType - IP Address type.
type SourceDestinationType string

const (
	SourceDestinationTypeDestinationIP SourceDestinationType = "DestinationIP"
	SourceDestinationTypeSourceIP      SourceDestinationType = "SourceIP"
)

// PossibleSourceDestinationTypeValues returns the possible values for the SourceDestinationType const type.
func PossibleSourceDestinationTypeValues() []SourceDestinationType {
	return []SourceDestinationType{
		SourceDestinationTypeDestinationIP,
		SourceDestinationTypeSourceIP,
	}
}

// TapRuleActionType - Type of actions that can be performed.
type TapRuleActionType string

const (
	TapRuleActionTypeCount     TapRuleActionType = "Count"
	TapRuleActionTypeDrop      TapRuleActionType = "Drop"
	TapRuleActionTypeGoto      TapRuleActionType = "Goto"
	TapRuleActionTypeLog       TapRuleActionType = "Log"
	TapRuleActionTypeMirror    TapRuleActionType = "Mirror"
	TapRuleActionTypeRedirect  TapRuleActionType = "Redirect"
	TapRuleActionTypeReplicate TapRuleActionType = "Replicate"
)

// PossibleTapRuleActionTypeValues returns the possible values for the TapRuleActionType const type.
func PossibleTapRuleActionTypeValues() []TapRuleActionType {
	return []TapRuleActionType{
		TapRuleActionTypeCount,
		TapRuleActionTypeDrop,
		TapRuleActionTypeGoto,
		TapRuleActionTypeLog,
		TapRuleActionTypeMirror,
		TapRuleActionTypeRedirect,
		TapRuleActionTypeReplicate,
	}
}

// ValidateAction - Validate action that to be performed
type ValidateAction string

const (
	ValidateActionCabling       ValidateAction = "Cabling"
	ValidateActionConfiguration ValidateAction = "Configuration"
	ValidateActionConnectivity  ValidateAction = "Connectivity"
)

// PossibleValidateActionValues returns the possible values for the ValidateAction const type.
func PossibleValidateActionValues() []ValidateAction {
	return []ValidateAction{
		ValidateActionCabling,
		ValidateActionConfiguration,
		ValidateActionConnectivity,
	}
}

// WellKnownCommunities - Internet - Advertise routes to internet community. LocalAS - Advertise routes to only localAS peers.
// NoAdvertise - Don't advertise routes to any peer.NoExport - Don't export to next AS.GShut -
// Graceful Shutdown (GSHUT) withdraw routes before terminating BGP connection.
type WellKnownCommunities string

const (
	WellKnownCommunitiesGShut       WellKnownCommunities = "GShut"
	WellKnownCommunitiesInternet    WellKnownCommunities = "Internet"
	WellKnownCommunitiesLocalAS     WellKnownCommunities = "LocalAS"
	WellKnownCommunitiesNoAdvertise WellKnownCommunities = "NoAdvertise"
	WellKnownCommunitiesNoExport    WellKnownCommunities = "NoExport"
)

// PossibleWellKnownCommunitiesValues returns the possible values for the WellKnownCommunities const type.
func PossibleWellKnownCommunitiesValues() []WellKnownCommunities {
	return []WellKnownCommunities{
		WellKnownCommunitiesGShut,
		WellKnownCommunitiesInternet,
		WellKnownCommunitiesLocalAS,
		WellKnownCommunitiesNoAdvertise,
		WellKnownCommunitiesNoExport,
	}
}
