//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmanagednetworkfabric_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Create_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPCommunitiesClient().BeginCreate(ctx, "example-rg", "example-ipcommunity", armmanagednetworkfabric.IPCommunity{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"keyId": to.Ptr("KeyValue"),
		},
		Properties: &armmanagednetworkfabric.IPCommunityProperties{
			Annotation: to.Ptr("annotation"),
			IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
				{
					Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
					CommunityMembers: []*string{
						to.Ptr("1:1")},
					SequenceNumber: to.Ptr[int64](4155123341),
					WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
						to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPCommunity = armmanagednetworkfabric.IPCommunity{
	// 	Name: to.Ptr("example-ipcommunity"),
	// 	Type: to.Ptr("microsoft.managednetworkfabric/ipcommunities"),
	// 	ID: to.Ptr("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/ipCommunities/example-ipcommunity"),
	// 	SystemData: &armmanagednetworkfabric.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@mail.com"),
	// 		CreatedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@mail.com"),
	// 		LastModifiedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"keyId": to.Ptr("KeyValue"),
	// 	},
	// 	Properties: &armmanagednetworkfabric.IPCommunityProperties{
	// 		Annotation: to.Ptr("annotation"),
	// 		IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
	// 			{
	// 				Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
	// 				CommunityMembers: []*string{
	// 					to.Ptr("1:1")},
	// 					SequenceNumber: to.Ptr[int64](4155123341),
	// 					WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
	// 						to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
	// 				}},
	// 				AdministrativeState: to.Ptr(armmanagednetworkfabric.AdministrativeStateEnabled),
	// 				ConfigurationState: to.Ptr(armmanagednetworkfabric.ConfigurationStateSucceeded),
	// 				ProvisioningState: to.Ptr(armmanagednetworkfabric.ProvisioningStateSucceeded),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Get_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIPCommunitiesClient().Get(ctx, "example-rg", "example-ipcommunity", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPCommunity = armmanagednetworkfabric.IPCommunity{
	// 	Name: to.Ptr("example-ipcommunity"),
	// 	Type: to.Ptr("microsoft.managednetworkfabric/ipcommunities"),
	// 	ID: to.Ptr("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/ipCommunities/example-ipcommunity"),
	// 	SystemData: &armmanagednetworkfabric.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@mail.com"),
	// 		CreatedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@mail.com"),
	// 		LastModifiedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"keyId": to.Ptr("KeyValue"),
	// 	},
	// 	Properties: &armmanagednetworkfabric.IPCommunityProperties{
	// 		Annotation: to.Ptr("annotation"),
	// 		IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
	// 			{
	// 				Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
	// 				CommunityMembers: []*string{
	// 					to.Ptr("1:1")},
	// 					SequenceNumber: to.Ptr[int64](4155123341),
	// 					WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
	// 						to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
	// 				}},
	// 				AdministrativeState: to.Ptr(armmanagednetworkfabric.AdministrativeStateEnabled),
	// 				ConfigurationState: to.Ptr(armmanagednetworkfabric.ConfigurationStateSucceeded),
	// 				ProvisioningState: to.Ptr(armmanagednetworkfabric.ProvisioningStateSucceeded),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Update_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPCommunitiesClient().BeginUpdate(ctx, "example-rg", "example-ipcommunity", armmanagednetworkfabric.IPCommunityPatch{
		Properties: &armmanagednetworkfabric.IPCommunityPatchableProperties{
			IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
				{
					Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
					CommunityMembers: []*string{
						to.Ptr("1:1")},
					SequenceNumber: to.Ptr[int64](4155123341),
					WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
						to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPCommunity = armmanagednetworkfabric.IPCommunity{
	// 	Name: to.Ptr("example-ipcommunity"),
	// 	Type: to.Ptr("microsoft.managednetworkfabric/ipcommunities"),
	// 	ID: to.Ptr("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/ipCommunities/example-ipcommunity"),
	// 	SystemData: &armmanagednetworkfabric.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@mail.com"),
	// 		CreatedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@mail.com"),
	// 		LastModifiedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"keyID": to.Ptr("KeyValue"),
	// 	},
	// 	Properties: &armmanagednetworkfabric.IPCommunityProperties{
	// 		Annotation: to.Ptr("annotation"),
	// 		IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
	// 			{
	// 				Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
	// 				CommunityMembers: []*string{
	// 					to.Ptr("1:1")},
	// 					SequenceNumber: to.Ptr[int64](4155123341),
	// 					WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
	// 						to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
	// 				}},
	// 				AdministrativeState: to.Ptr(armmanagednetworkfabric.AdministrativeStateEnabled),
	// 				ConfigurationState: to.Ptr(armmanagednetworkfabric.ConfigurationStateSucceeded),
	// 				ProvisioningState: to.Ptr(armmanagednetworkfabric.ProvisioningStateSucceeded),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_Delete_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewIPCommunitiesClient().BeginDelete(ctx, "example-rg", "example-ipcommunity", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_ListByResourceGroup_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIPCommunitiesClient().NewListByResourceGroupPager("example-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IPCommunitiesListResult = armmanagednetworkfabric.IPCommunitiesListResult{
		// 	Value: []*armmanagednetworkfabric.IPCommunity{
		// 		{
		// 			Name: to.Ptr("example-ipcommunity"),
		// 			Type: to.Ptr("microsoft.managednetworkfabric/ipcommunities"),
		// 			ID: to.Ptr("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/ipCommunities/example-ipcommunity"),
		// 			SystemData: &armmanagednetworkfabric.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@mail.com"),
		// 				CreatedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@mail.com"),
		// 				LastModifiedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"keyId": to.Ptr("KeyValue"),
		// 			},
		// 			Properties: &armmanagednetworkfabric.IPCommunityProperties{
		// 				Annotation: to.Ptr("annotation"),
		// 				IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
		// 					{
		// 						Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
		// 						CommunityMembers: []*string{
		// 							to.Ptr("1:1")},
		// 							SequenceNumber: to.Ptr[int64](4155123341),
		// 							WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
		// 								to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
		// 						}},
		// 						AdministrativeState: to.Ptr(armmanagednetworkfabric.AdministrativeStateEnabled),
		// 						ConfigurationState: to.Ptr(armmanagednetworkfabric.ConfigurationStateSucceeded),
		// 						ProvisioningState: to.Ptr(armmanagednetworkfabric.ProvisioningStateSucceeded),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/925ba149e17454ce91ecd3f9f4134effb2f97844/specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/stable/2023-06-15/examples/IpCommunities_ListBySubscription_MaximumSet_Gen.json
func ExampleIPCommunitiesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagednetworkfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIPCommunitiesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IPCommunitiesListResult = armmanagednetworkfabric.IPCommunitiesListResult{
		// 	Value: []*armmanagednetworkfabric.IPCommunity{
		// 		{
		// 			Name: to.Ptr("example-ipcommunity"),
		// 			Type: to.Ptr("microsoft.managednetworkfabric/ipcommunities"),
		// 			ID: to.Ptr("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/ipCommunities/example-ipcommunity"),
		// 			SystemData: &armmanagednetworkfabric.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@mail.com"),
		// 				CreatedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-11T18:26:17.611Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@mail.com"),
		// 				LastModifiedByType: to.Ptr(armmanagednetworkfabric.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"keyId": to.Ptr("KeyValue"),
		// 			},
		// 			Properties: &armmanagednetworkfabric.IPCommunityProperties{
		// 				Annotation: to.Ptr("annotation"),
		// 				IPCommunityRules: []*armmanagednetworkfabric.IPCommunityRule{
		// 					{
		// 						Action: to.Ptr(armmanagednetworkfabric.CommunityActionTypesPermit),
		// 						CommunityMembers: []*string{
		// 							to.Ptr("1:1")},
		// 							SequenceNumber: to.Ptr[int64](4155123341),
		// 							WellKnownCommunities: []*armmanagednetworkfabric.WellKnownCommunities{
		// 								to.Ptr(armmanagednetworkfabric.WellKnownCommunitiesInternet)},
		// 						}},
		// 						AdministrativeState: to.Ptr(armmanagednetworkfabric.AdministrativeStateEnabled),
		// 						ConfigurationState: to.Ptr(armmanagednetworkfabric.ConfigurationStateSucceeded),
		// 						ProvisioningState: to.Ptr(armmanagednetworkfabric.ProvisioningStateSucceeded),
		// 					},
		// 			}},
		// 		}
	}
}
