//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmanagedservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managedservices/armmanagedservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationAssignment.json
func ExampleRegistrationAssignmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewRegistrationAssignmentsClient().Get(ctx, "subscription/0afefe50-734e-4610-8a82-a144ahf49dea", "26c128c2-fefa-4340-9bb1-6e081c90ada2", &armmanagedservices.RegistrationAssignmentsClientGetOptions{ExpandRegistrationDefinition: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistrationAssignment = armmanagedservices.RegistrationAssignment{
	// 	Name: to.Ptr("484a7d5f-9729-4b87-bc9b-26610985a013"),
	// 	Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
	// 	ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/484a7d5f-9729-4b87-bc9b-26610985a013"),
	// 	Properties: &armmanagedservices.RegistrationAssignmentProperties{
	// 		ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
	// 		RegistrationDefinition: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinition{
	// 			Name: to.Ptr("26c128c2-fefa-4340-9bb1-8e081c90ada2"),
	// 			Type: to.Ptr("Microsoft.ManagedServices/registrationDefinitions"),
	// 			ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
	// 			Plan: &armmanagedservices.Plan{
	// 				Name: to.Ptr("addesai-plan"),
	// 				Product: to.Ptr("test"),
	// 				Publisher: to.Ptr("marketplace-test"),
	// 				Version: to.Ptr("1.0.0"),
	// 			},
	// 			Properties: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinitionProperties{
	// 				Description: to.Ptr("Test"),
	// 				Authorizations: []*armmanagedservices.Authorization{
	// 					{
	// 						PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
	// 						PrincipalIDDisplayName: to.Ptr("Support User"),
	// 						RoleDefinitionID: to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
	// 					},
	// 					{
	// 						DelegatedRoleDefinitionIDs: []*string{
	// 							to.Ptr("b24988ac-6180-42a0-ab88-20f7382dd24c")},
	// 							PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
	// 							PrincipalIDDisplayName: to.Ptr("User Access Administrator"),
	// 							RoleDefinitionID: to.Ptr("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
	// 					}},
	// 					EligibleAuthorizations: []*armmanagedservices.EligibleAuthorization{
	// 						{
	// 							JustInTimeAccessPolicy: &armmanagedservices.JustInTimeAccessPolicy{
	// 								MaximumActivationDuration: to.Ptr("PT8H"),
	// 								MultiFactorAuthProvider: to.Ptr(armmanagedservices.MultiFactorAuthProviderAzure),
	// 							},
	// 							PrincipalID: to.Ptr("3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2"),
	// 							PrincipalIDDisplayName: to.Ptr("Support User"),
	// 							RoleDefinitionID: to.Ptr("ae349356-3a1b-4a5e-921d-050484c6347e"),
	// 					}},
	// 					ManagedByTenantID: to.Ptr("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
	// 					ManagedByTenantName: to.Ptr("Contoso Corp."),
	// 					ManageeTenantID: to.Ptr("01c0bcd5-4f47-4e4b-b492-418b7e2a8854"),
	// 					ManageeTenantName: to.Ptr("test_test_aad_SbtFhyGiLHPFm"),
	// 					ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
	// 					RegistrationDefinitionName: to.Ptr("DefinitionName"),
	// 				},
	// 			},
	// 			RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/DeleteRegistrationAssignment.json
func ExampleRegistrationAssignmentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistrationAssignmentsClient().BeginDelete(ctx, "subscription/0afefe50-734e-4610-8a82-a144ahf49dea", "26c128c2-fefa-4340-9bb1-6e081c90ada2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/PutRegistrationAssignment.json
func ExampleRegistrationAssignmentsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewRegistrationAssignmentsClient().BeginCreateOrUpdate(ctx, "subscription/0afefe50-734e-4610-8a82-a144ahf49dea", "26c128c2-fefa-4340-9bb1-6e081c90ada2", armmanagedservices.RegistrationAssignment{
		Properties: &armmanagedservices.RegistrationAssignmentProperties{
			RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RegistrationAssignment = armmanagedservices.RegistrationAssignment{
	// 	Name: to.Ptr("484a7d5f-9729-4b87-bc9b-26610985a013"),
	// 	Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
	// 	ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/484a7d5f-9729-4b87-bc9b-26610985a013"),
	// 	Properties: &armmanagedservices.RegistrationAssignmentProperties{
	// 		ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
	// 		RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationAssignments.json
func ExampleRegistrationAssignmentsClient_NewListPager_getRegistrationAssignments() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistrationAssignmentsClient().NewListPager("subscription/0afefe50-734e-4610-8a82-a144ahf49dea", &armmanagedservices.RegistrationAssignmentsClientListOptions{ExpandRegistrationDefinition: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RegistrationAssignmentList = armmanagedservices.RegistrationAssignmentList{
		// 	Value: []*armmanagedservices.RegistrationAssignment{
		// 		{
		// 			Name: to.Ptr("484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
		// 			ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Properties: &armmanagedservices.RegistrationAssignmentProperties{
		// 				ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 				RegistrationDefinition: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinition{
		// 					Name: to.Ptr("26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Type: to.Ptr("Microsoft.ManagedServices/registrationDefinitions"),
		// 					ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Plan: &armmanagedservices.Plan{
		// 						Name: to.Ptr("addesai-plan"),
		// 						Product: to.Ptr("test"),
		// 						Publisher: to.Ptr("marketplace-test"),
		// 						Version: to.Ptr("1.0.0"),
		// 					},
		// 					Properties: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinitionProperties{
		// 						Description: to.Ptr("Test"),
		// 						Authorizations: []*armmanagedservices.Authorization{
		// 							{
		// 								PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 								PrincipalIDDisplayName: to.Ptr("Support User"),
		// 								RoleDefinitionID: to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
		// 							},
		// 							{
		// 								DelegatedRoleDefinitionIDs: []*string{
		// 									to.Ptr("b24988ac-6180-42a0-ab88-20f7382dd24c")},
		// 									PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 									PrincipalIDDisplayName: to.Ptr("User Access Administrator"),
		// 									RoleDefinitionID: to.Ptr("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
		// 							}},
		// 							EligibleAuthorizations: []*armmanagedservices.EligibleAuthorization{
		// 								{
		// 									JustInTimeAccessPolicy: &armmanagedservices.JustInTimeAccessPolicy{
		// 										MaximumActivationDuration: to.Ptr("PT8H"),
		// 										MultiFactorAuthProvider: to.Ptr(armmanagedservices.MultiFactorAuthProviderAzure),
		// 									},
		// 									PrincipalID: to.Ptr("700bddf4-2c3b-4cd1-bb02-6a2c622524f4"),
		// 									RoleDefinitionID: to.Ptr("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
		// 							}},
		// 							ManagedByTenantID: to.Ptr("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
		// 							ManagedByTenantName: to.Ptr("Contoso Corp."),
		// 							ManageeTenantID: to.Ptr("01c0bcd5-4f47-4e4b-b492-418b7e2a8854"),
		// 							ManageeTenantName: to.Ptr("test_test_aad_SbtFhyGiLHPFm"),
		// 							ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 							RegistrationDefinitionName: to.Ptr("DefinitionName"),
		// 						},
		// 					},
		// 					RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationAssignmentsWithManagedByTenantIdEqFilter.json
func ExampleRegistrationAssignmentsClient_NewListPager_getRegistrationAssignmentsWithManagedByTenantIdEqFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistrationAssignmentsClient().NewListPager("subscription/0afefe50-734e-4610-8a82-a144ahf49dea", &armmanagedservices.RegistrationAssignmentsClientListOptions{ExpandRegistrationDefinition: nil,
		Filter: to.Ptr("$filter=managedByTenantId eq '83abe5cd-bcc3-441a-bd86-e6a75360cecc'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RegistrationAssignmentList = armmanagedservices.RegistrationAssignmentList{
		// 	Value: []*armmanagedservices.RegistrationAssignment{
		// 		{
		// 			Name: to.Ptr("484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
		// 			ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Properties: &armmanagedservices.RegistrationAssignmentProperties{
		// 				ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 				RegistrationDefinition: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinition{
		// 					Name: to.Ptr("26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Type: to.Ptr("Microsoft.ManagedServices/registrationDefinitions"),
		// 					ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Plan: &armmanagedservices.Plan{
		// 						Name: to.Ptr("addesai-plan"),
		// 						Product: to.Ptr("test"),
		// 						Publisher: to.Ptr("marketplace-test"),
		// 						Version: to.Ptr("1.0.0"),
		// 					},
		// 					Properties: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinitionProperties{
		// 						Description: to.Ptr("Test"),
		// 						Authorizations: []*armmanagedservices.Authorization{
		// 							{
		// 								PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 								PrincipalIDDisplayName: to.Ptr("Support User"),
		// 								RoleDefinitionID: to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
		// 							},
		// 							{
		// 								DelegatedRoleDefinitionIDs: []*string{
		// 									to.Ptr("b24988ac-6180-42a0-ab88-20f7382dd24c")},
		// 									PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 									PrincipalIDDisplayName: to.Ptr("User Access Administrator"),
		// 									RoleDefinitionID: to.Ptr("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
		// 							}},
		// 							EligibleAuthorizations: []*armmanagedservices.EligibleAuthorization{
		// 								{
		// 									JustInTimeAccessPolicy: &armmanagedservices.JustInTimeAccessPolicy{
		// 										MaximumActivationDuration: to.Ptr("PT8H"),
		// 										MultiFactorAuthProvider: to.Ptr(armmanagedservices.MultiFactorAuthProviderAzure),
		// 									},
		// 									PrincipalID: to.Ptr("700bddf4-2c3b-4cd1-bb02-6a2c622524f4"),
		// 									RoleDefinitionID: to.Ptr("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
		// 							}},
		// 							ManagedByTenantID: to.Ptr("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
		// 							ManagedByTenantName: to.Ptr("Contoso Corp."),
		// 							ManageeTenantID: to.Ptr("01c0bcd5-4f47-4e4b-b492-418b7e2a8854"),
		// 							ManageeTenantName: to.Ptr("test_test_aad_SbtFhyGiLHPFm"),
		// 							ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 							RegistrationDefinitionName: to.Ptr("DefinitionName"),
		// 						},
		// 						SystemData: &armmanagedservices.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser@outlook.com"),
		// 							CreatedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser@outlook.com"),
		// 							LastModifiedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 						},
		// 					},
		// 					RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationAssignmentsWithManagedByTenantIdInFilter.json
func ExampleRegistrationAssignmentsClient_NewListPager_getRegistrationAssignmentsWithManagedByTenantIdInFilter() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmanagedservices.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewRegistrationAssignmentsClient().NewListPager("subscription/0afefe50-734e-4610-8a82-a144ahf49dea", &armmanagedservices.RegistrationAssignmentsClientListOptions{ExpandRegistrationDefinition: nil,
		Filter: to.Ptr("$filter=managedByTenantId in (83abe5cd-bcc3-441a-bd86-e6a75360cec, de83f4a9-a76a-4025-a91a-91171923eac7)"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RegistrationAssignmentList = armmanagedservices.RegistrationAssignmentList{
		// 	Value: []*armmanagedservices.RegistrationAssignment{
		// 		{
		// 			Name: to.Ptr("484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
		// 			ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/484a7d5f-9729-4b87-bc9b-26610985a013"),
		// 			Properties: &armmanagedservices.RegistrationAssignmentProperties{
		// 				ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 				RegistrationDefinition: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinition{
		// 					Name: to.Ptr("26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Type: to.Ptr("Microsoft.ManagedServices/registrationDefinitions"),
		// 					ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 					Plan: &armmanagedservices.Plan{
		// 						Name: to.Ptr("addesai-plan"),
		// 						Product: to.Ptr("test"),
		// 						Publisher: to.Ptr("marketplace-test"),
		// 						Version: to.Ptr("1.0.0"),
		// 					},
		// 					Properties: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinitionProperties{
		// 						Description: to.Ptr("Test"),
		// 						Authorizations: []*armmanagedservices.Authorization{
		// 							{
		// 								PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 								PrincipalIDDisplayName: to.Ptr("Support User"),
		// 								RoleDefinitionID: to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
		// 							},
		// 							{
		// 								DelegatedRoleDefinitionIDs: []*string{
		// 									to.Ptr("b24988ac-6180-42a0-ab88-20f7382dd24c")},
		// 									PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 									PrincipalIDDisplayName: to.Ptr("User Access Administrator"),
		// 									RoleDefinitionID: to.Ptr("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
		// 							}},
		// 							EligibleAuthorizations: []*armmanagedservices.EligibleAuthorization{
		// 								{
		// 									JustInTimeAccessPolicy: &armmanagedservices.JustInTimeAccessPolicy{
		// 										MaximumActivationDuration: to.Ptr("PT8H"),
		// 										MultiFactorAuthProvider: to.Ptr(armmanagedservices.MultiFactorAuthProviderAzure),
		// 									},
		// 									PrincipalID: to.Ptr("700bddf4-2c3b-4cd1-bb02-6a2c622524f4"),
		// 									RoleDefinitionID: to.Ptr("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
		// 							}},
		// 							ManagedByTenantID: to.Ptr("83abe5cd-bcc3-441a-bd86-e6a75360cec"),
		// 							ManagedByTenantName: to.Ptr("Contoso Corp."),
		// 							ManageeTenantID: to.Ptr("01c0bcd5-4f47-4e4b-b492-418b7e2a8854"),
		// 							ManageeTenantName: to.Ptr("test_test_aad_SbtFhyGiLHPFm"),
		// 							ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 							RegistrationDefinitionName: to.Ptr("DefinitionName"),
		// 						},
		// 						SystemData: &armmanagedservices.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser@outlook.com"),
		// 							CreatedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser@outlook.com"),
		// 							LastModifiedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 						},
		// 					},
		// 					RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-8e081c90ada2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("f6e721b2-7576-44d3-9182-03143fce94c0"),
		// 				Type: to.Ptr("Microsoft.ManagedServices/registrationAssignments"),
		// 				ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationAssignments/f6e721b2-7576-44d3-9182-03143fce94c0"),
		// 				Properties: &armmanagedservices.RegistrationAssignmentProperties{
		// 					ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 					RegistrationDefinition: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinition{
		// 						Name: to.Ptr("67aa1d7b-30ac-4ec2-be0b-ce30751468f2"),
		// 						Type: to.Ptr("Microsoft.ManagedServices/registrationDefinitions"),
		// 						ID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/67aa1d7b-30ac-4ec2-be0b-ce30751468f2"),
		// 						Properties: &armmanagedservices.RegistrationAssignmentPropertiesRegistrationDefinitionProperties{
		// 							Description: to.Ptr("Test"),
		// 							Authorizations: []*armmanagedservices.Authorization{
		// 								{
		// 									PrincipalID: to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
		// 									PrincipalIDDisplayName: to.Ptr("Support User"),
		// 									RoleDefinitionID: to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
		// 							}},
		// 							ManagedByTenantID: to.Ptr("de83f4a9-a76a-4025-a91a-91171923eac7"),
		// 							ManagedByTenantName: to.Ptr("Test Corp."),
		// 							ManageeTenantID: to.Ptr("01c0bcd5-4f47-4e4b-b492-418b7e2a8854"),
		// 							ManageeTenantName: to.Ptr("test_test_aad_SbtFhyGiLHPFm"),
		// 							ProvisioningState: to.Ptr(armmanagedservices.ProvisioningStateSucceeded),
		// 							RegistrationDefinitionName: to.Ptr("DefinitionName"),
		// 						},
		// 						SystemData: &armmanagedservices.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser@outlook.com"),
		// 							CreatedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-11-22T19:56:05.070Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser@outlook.com"),
		// 							LastModifiedByType: to.Ptr(armmanagedservices.CreatedByTypeUser),
		// 						},
		// 					},
		// 					RegistrationDefinitionID: to.Ptr("/subscriptions/0afefe50-734e-4610-8c82-a144aff49dea/providers/Microsoft.ManagedServices/registrationDefinitions/67aa1d7b-30ac-4ec2-be0b-ce30751468f2"),
		// 				},
		// 		}},
		// 	}
	}
}
