//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armplaywrighttesting_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/playwrighttesting/armplaywrighttesting"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/3eb9ec8e9c8f717c6b461c4c0f49a4662fb948fd/specification/playwrighttesting/resource-manager/Microsoft.AzurePlaywrightService/preview/2023-10-01-preview/examples/Operations_List.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armplaywrighttesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armplaywrighttesting.OperationListResult{
		// 	Value: []*armplaywrighttesting.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.AzurePlaywrightService/accounts/Write"),
		// 			Display: &armplaywrighttesting.OperationDisplay{
		// 				Description: to.Ptr("Set PlaywrightAccounts"),
		// 				Operation: to.Ptr("Creates or updates the PlaywrightAccounts"),
		// 				Provider: to.Ptr("Microsoft.AzurePlaywrightService"),
		// 				Resource: to.Ptr("accounts"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AzurePlaywrightService/accounts/Delete"),
		// 			Display: &armplaywrighttesting.OperationDisplay{
		// 				Description: to.Ptr("Delete PlaywrightAccounts"),
		// 				Operation: to.Ptr("Deletes the PlaywrightAccounts"),
		// 				Provider: to.Ptr("Microsoft.AzurePlaywrightService"),
		// 				Resource: to.Ptr("accounts"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.AzurePlaywrightService/accounts/Read"),
		// 			Display: &armplaywrighttesting.OperationDisplay{
		// 				Description: to.Ptr("Read PlaywrightAccounts"),
		// 				Operation: to.Ptr("Reads the PlaywrightAccounts"),
		// 				Provider: to.Ptr("Microsoft.AzurePlaywrightService"),
		// 				Resource: to.Ptr("accounts"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 	}},
		// }
	}
}
