//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpowerbidedicated_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbidedicated/armpowerbidedicated"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/getCapacity.json
func ExampleCapacitiesClient_GetDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCapacitiesClient().GetDetails(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DedicatedCapacity = armpowerbidedicated.DedicatedCapacity{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SystemData: &armpowerbidedicated.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armpowerbidedicated.DedicatedCapacityProperties{
	// 		Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
	// 			State: to.Ptr(armpowerbidedicated.StateProvisioning),
	// 		},
	// 		SKU: &armpowerbidedicated.CapacitySKU{
	// 			Name: to.Ptr("A1"),
	// 			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/createCapacity.json
func ExampleCapacitiesClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginCreate(ctx, "TestRG", "azsdktest", armpowerbidedicated.DedicatedCapacity{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"testKey": to.Ptr("testValue"),
		},
		Properties: &armpowerbidedicated.DedicatedCapacityProperties{
			Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
				Members: []*string{
					to.Ptr("azsdktest@microsoft.com"),
					to.Ptr("azsdktest2@microsoft.com")},
			},
		},
		SKU: &armpowerbidedicated.CapacitySKU{
			Name: to.Ptr("A1"),
			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DedicatedCapacity = armpowerbidedicated.DedicatedCapacity{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SystemData: &armpowerbidedicated.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armpowerbidedicated.DedicatedCapacityProperties{
	// 		Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com"),
	// 				to.Ptr("azsdktest2@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
	// 			State: to.Ptr(armpowerbidedicated.StateProvisioning),
	// 		},
	// 		SKU: &armpowerbidedicated.CapacitySKU{
	// 			Name: to.Ptr("A1"),
	// 			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/deleteCapacity.json
func ExampleCapacitiesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginDelete(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/updateCapacity.json
func ExampleCapacitiesClient_BeginUpdate_updateCapacityParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginUpdate(ctx, "TestRG", "azsdktest", armpowerbidedicated.DedicatedCapacityUpdateParameters{
		Properties: &armpowerbidedicated.DedicatedCapacityMutableProperties{
			Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
				Members: []*string{
					to.Ptr("azsdktest@microsoft.com"),
					to.Ptr("azsdktest2@microsoft.com")},
			},
		},
		SKU: &armpowerbidedicated.CapacitySKU{
			Name: to.Ptr("A1"),
			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		},
		Tags: map[string]*string{
			"testKey": to.Ptr("testValue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DedicatedCapacity = armpowerbidedicated.DedicatedCapacity{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SystemData: &armpowerbidedicated.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armpowerbidedicated.DedicatedCapacityProperties{
	// 		Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com"),
	// 				to.Ptr("azsdktest2@microsoft.com")},
	// 			},
	// 			ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
	// 			State: to.Ptr(armpowerbidedicated.StateProvisioning),
	// 		},
	// 		SKU: &armpowerbidedicated.CapacitySKU{
	// 			Name: to.Ptr("A1"),
	// 			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/updateToGen2.json
func ExampleCapacitiesClient_BeginUpdate_updateCapacityToGeneration2() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginUpdate(ctx, "TestRG", "azsdktest", armpowerbidedicated.DedicatedCapacityUpdateParameters{
		Properties: &armpowerbidedicated.DedicatedCapacityMutableProperties{
			Mode: to.Ptr(armpowerbidedicated.ModeGen2),
		},
		SKU: &armpowerbidedicated.CapacitySKU{
			Name: to.Ptr("A1"),
			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		},
		Tags: map[string]*string{
			"testKey": to.Ptr("testValue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DedicatedCapacity = armpowerbidedicated.DedicatedCapacity{
	// 	Name: to.Ptr("azsdktest"),
	// 	ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
	// 	Location: to.Ptr("West US"),
	// 	SystemData: &armpowerbidedicated.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-01-01T00:00:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpowerbidedicated.IdentityTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 		"testKey": to.Ptr("testValue"),
	// 	},
	// 	Properties: &armpowerbidedicated.DedicatedCapacityProperties{
	// 		Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
	// 			Members: []*string{
	// 				to.Ptr("azsdktest@microsoft.com"),
	// 				to.Ptr("azsdktest2@microsoft.com")},
	// 			},
	// 			Mode: to.Ptr(armpowerbidedicated.ModeGen2),
	// 			ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
	// 			State: to.Ptr(armpowerbidedicated.StateProvisioning),
	// 		},
	// 		SKU: &armpowerbidedicated.CapacitySKU{
	// 			Name: to.Ptr("A1"),
	// 			Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/suspendCapacity.json
func ExampleCapacitiesClient_BeginSuspend() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginSuspend(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/resumeCapacity.json
func ExampleCapacitiesClient_BeginResume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCapacitiesClient().BeginResume(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/listCapacitiesInResourceGroup.json
func ExampleCapacitiesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCapacitiesClient().NewListByResourceGroupPager("TestRG", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DedicatedCapacities = armpowerbidedicated.DedicatedCapacities{
		// 	Value: []*armpowerbidedicated.DedicatedCapacity{
		// 		{
		// 			Name: to.Ptr("azsdktest"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"testKey": to.Ptr("testValue"),
		// 			},
		// 			Properties: &armpowerbidedicated.DedicatedCapacityProperties{
		// 				Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
		// 					Members: []*string{
		// 						to.Ptr("azsdktest@microsoft.com")},
		// 					},
		// 					ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
		// 					State: to.Ptr(armpowerbidedicated.StateProvisioning),
		// 				},
		// 				SKU: &armpowerbidedicated.CapacitySKU{
		// 					Name: to.Ptr("A1"),
		// 					Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("azsdktest2"),
		// 				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
		// 				Location: to.Ptr("West US"),
		// 				Tags: map[string]*string{
		// 					"testKey": to.Ptr("testValue"),
		// 				},
		// 				Properties: &armpowerbidedicated.DedicatedCapacityProperties{
		// 					Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
		// 						Members: []*string{
		// 							to.Ptr("azsdktest@microsoft.com")},
		// 						},
		// 						ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
		// 						State: to.Ptr(armpowerbidedicated.StateProvisioning),
		// 					},
		// 					SKU: &armpowerbidedicated.CapacitySKU{
		// 						Name: to.Ptr("A2"),
		// 						Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/listCapacitiesInSubscription.json
func ExampleCapacitiesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCapacitiesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DedicatedCapacities = armpowerbidedicated.DedicatedCapacities{
		// 	Value: []*armpowerbidedicated.DedicatedCapacity{
		// 		{
		// 			Name: to.Ptr("azsdktest"),
		// 			ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"testKey": to.Ptr("testValue"),
		// 			},
		// 			Properties: &armpowerbidedicated.DedicatedCapacityProperties{
		// 				Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
		// 					Members: []*string{
		// 						to.Ptr("azsdktest@microsoft.com")},
		// 					},
		// 					ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
		// 					State: to.Ptr(armpowerbidedicated.StateProvisioning),
		// 				},
		// 				SKU: &armpowerbidedicated.CapacitySKU{
		// 					Name: to.Ptr("A1"),
		// 					Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("azsdktest2"),
		// 				ID: to.Ptr("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/providers/Microsoft.PowerBIDedicated/capacities/azsdktest"),
		// 				Location: to.Ptr("West US"),
		// 				Tags: map[string]*string{
		// 					"testKey": to.Ptr("testValue"),
		// 				},
		// 				Properties: &armpowerbidedicated.DedicatedCapacityProperties{
		// 					Administration: &armpowerbidedicated.DedicatedCapacityAdministrators{
		// 						Members: []*string{
		// 							to.Ptr("azsdktest@microsoft.com")},
		// 						},
		// 						ProvisioningState: to.Ptr(armpowerbidedicated.CapacityProvisioningStateSucceeded),
		// 						State: to.Ptr(armpowerbidedicated.StateProvisioning),
		// 					},
		// 					SKU: &armpowerbidedicated.CapacitySKU{
		// 						Name: to.Ptr("A2"),
		// 						Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/listSKUsForNew.json
func ExampleCapacitiesClient_ListSKUs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCapacitiesClient().ListSKUs(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SKUEnumerationForNewResourceResult = armpowerbidedicated.SKUEnumerationForNewResourceResult{
	// 	Value: []*armpowerbidedicated.CapacitySKU{
	// 		{
	// 			Name: to.Ptr("A1"),
	// 		},
	// 		{
	// 			Name: to.Ptr("A2"),
	// 		},
	// 		{
	// 			Name: to.Ptr("A3"),
	// 		},
	// 		{
	// 			Name: to.Ptr("A4"),
	// 		},
	// 		{
	// 			Name: to.Ptr("A5"),
	// 		},
	// 		{
	// 			Name: to.Ptr("A6"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/listSKUsForExisting.json
func ExampleCapacitiesClient_ListSKUsForCapacity() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCapacitiesClient().ListSKUsForCapacity(ctx, "TestRG", "azsdktest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SKUEnumerationForExistingResourceResult = armpowerbidedicated.SKUEnumerationForExistingResourceResult{
	// 	Value: []*armpowerbidedicated.SKUDetailsForExistingResource{
	// 		{
	// 			SKU: &armpowerbidedicated.CapacitySKU{
	// 				Name: to.Ptr("A2"),
	// 				Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armpowerbidedicated.CapacitySKU{
	// 				Name: to.Ptr("A3"),
	// 				Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armpowerbidedicated.CapacitySKU{
	// 				Name: to.Ptr("A4"),
	// 				Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armpowerbidedicated.CapacitySKU{
	// 				Name: to.Ptr("A5"),
	// 				Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 			},
	// 		},
	// 		{
	// 			SKU: &armpowerbidedicated.CapacitySKU{
	// 				Name: to.Ptr("A6"),
	// 				Tier: to.Ptr(armpowerbidedicated.CapacitySKUTierPBIEAzure),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/powerbidedicated/resource-manager/Microsoft.PowerBIdedicated/stable/2021-01-01/examples/checkNameAvailability.json
func ExampleCapacitiesClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpowerbidedicated.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCapacitiesClient().CheckNameAvailability(ctx, "West US", armpowerbidedicated.CheckCapacityNameAvailabilityParameters{
		Name: to.Ptr("azsdktest"),
		Type: to.Ptr("Microsoft.PowerBIDedicated/capacities"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckCapacityNameAvailabilityResult = armpowerbidedicated.CheckCapacityNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}
