//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armproviderhub

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AuthorizationActionMapping.
func (a AuthorizationActionMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "desired", a.Desired)
	populate(objectMap, "original", a.Original)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationActionMapping.
func (a *AuthorizationActionMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "desired":
			err = unpopulate(val, "Desired", &a.Desired)
			delete(rawMsg, key)
		case "original":
			err = unpopulate(val, "Original", &a.Original)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CanaryTrafficRegionRolloutConfiguration.
func (c CanaryTrafficRegionRolloutConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", c.Regions)
	populate(objectMap, "skipRegions", c.SkipRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CanaryTrafficRegionRolloutConfiguration.
func (c *CanaryTrafficRegionRolloutConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &c.Regions)
			delete(rawMsg, key)
		case "skipRegions":
			err = unpopulate(val, "SkipRegions", &c.SkipRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilitySpecifications.
func (c CheckNameAvailabilitySpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableDefaultValidation", c.EnableDefaultValidation)
	populate(objectMap, "resourceTypesWithCustomValidation", c.ResourceTypesWithCustomValidation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilitySpecifications.
func (c *CheckNameAvailabilitySpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableDefaultValidation":
			err = unpopulate(val, "EnableDefaultValidation", &c.EnableDefaultValidation)
			delete(rawMsg, key)
		case "resourceTypesWithCustomValidation":
			err = unpopulate(val, "ResourceTypesWithCustomValidation", &c.ResourceTypesWithCustomValidation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckinManifestInfo.
func (c CheckinManifestInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commitId", c.CommitID)
	populate(objectMap, "isCheckedIn", c.IsCheckedIn)
	populate(objectMap, "pullRequest", c.PullRequest)
	populate(objectMap, "statusMessage", c.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckinManifestInfo.
func (c *CheckinManifestInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commitId":
			err = unpopulate(val, "CommitID", &c.CommitID)
			delete(rawMsg, key)
		case "isCheckedIn":
			err = unpopulate(val, "IsCheckedIn", &c.IsCheckedIn)
			delete(rawMsg, key)
		case "pullRequest":
			err = unpopulate(val, "PullRequest", &c.PullRequest)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &c.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckinManifestParams.
func (c CheckinManifestParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baselineArmManifestLocation", c.BaselineArmManifestLocation)
	populate(objectMap, "environment", c.Environment)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckinManifestParams.
func (c *CheckinManifestParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baselineArmManifestLocation":
			err = unpopulate(val, "BaselineArmManifestLocation", &c.BaselineArmManifestLocation)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &c.Environment)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRollout.
func (c CustomRollout) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRollout.
func (c *CustomRollout) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutArrayResponseWithContinuation.
func (c CustomRolloutArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutArrayResponseWithContinuation.
func (c *CustomRolloutArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutProperties.
func (c CustomRolloutProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "specification", c.Specification)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutProperties.
func (c *CustomRolloutProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &c.Specification)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutPropertiesAutoGenerated.
func (c CustomRolloutPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "specification", c.Specification)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutPropertiesAutoGenerated.
func (c *CustomRolloutPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &c.Specification)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutPropertiesSpecification.
func (c CustomRolloutPropertiesSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", c.Canary)
	populate(objectMap, "providerRegistration", c.ProviderRegistration)
	populate(objectMap, "resourceTypeRegistrations", c.ResourceTypeRegistrations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutPropertiesSpecification.
func (c *CustomRolloutPropertiesSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &c.Canary)
			delete(rawMsg, key)
		case "providerRegistration":
			err = unpopulate(val, "ProviderRegistration", &c.ProviderRegistration)
			delete(rawMsg, key)
		case "resourceTypeRegistrations":
			err = unpopulate(val, "ResourceTypeRegistrations", &c.ResourceTypeRegistrations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutPropertiesStatus.
func (c CustomRolloutPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completedRegions", c.CompletedRegions)
	populate(objectMap, "failedOrSkippedRegions", c.FailedOrSkippedRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutPropertiesStatus.
func (c *CustomRolloutPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedRegions":
			err = unpopulate(val, "CompletedRegions", &c.CompletedRegions)
			delete(rawMsg, key)
		case "failedOrSkippedRegions":
			err = unpopulate(val, "FailedOrSkippedRegions", &c.FailedOrSkippedRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutSpecification.
func (c CustomRolloutSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", c.Canary)
	populate(objectMap, "providerRegistration", c.ProviderRegistration)
	populate(objectMap, "resourceTypeRegistrations", c.ResourceTypeRegistrations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutSpecification.
func (c *CustomRolloutSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &c.Canary)
			delete(rawMsg, key)
		case "providerRegistration":
			err = unpopulate(val, "ProviderRegistration", &c.ProviderRegistration)
			delete(rawMsg, key)
		case "resourceTypeRegistrations":
			err = unpopulate(val, "ResourceTypeRegistrations", &c.ResourceTypeRegistrations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutSpecificationCanary.
func (c CustomRolloutSpecificationCanary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", c.Regions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutSpecificationCanary.
func (c *CustomRolloutSpecificationCanary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &c.Regions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutSpecificationProviderRegistration.
func (c CustomRolloutSpecificationProviderRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutSpecificationProviderRegistration.
func (c *CustomRolloutSpecificationProviderRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomRolloutStatus.
func (c CustomRolloutStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completedRegions", c.CompletedRegions)
	populate(objectMap, "failedOrSkippedRegions", c.FailedOrSkippedRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomRolloutStatus.
func (c *CustomRolloutStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedRegions":
			err = unpopulate(val, "CompletedRegions", &c.CompletedRegions)
			delete(rawMsg, key)
		case "failedOrSkippedRegions":
			err = unpopulate(val, "FailedOrSkippedRegions", &c.FailedOrSkippedRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRollout.
func (d DefaultRollout) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRollout.
func (d *DefaultRollout) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutArrayResponseWithContinuation.
func (d DefaultRolloutArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutArrayResponseWithContinuation.
func (d *DefaultRolloutArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutProperties.
func (d DefaultRolloutProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "specification", d.Specification)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutProperties.
func (d *DefaultRolloutProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &d.Specification)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutPropertiesAutoGenerated.
func (d DefaultRolloutPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "specification", d.Specification)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutPropertiesAutoGenerated.
func (d *DefaultRolloutPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &d.Specification)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutPropertiesSpecification.
func (d DefaultRolloutPropertiesSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", d.Canary)
	populate(objectMap, "highTraffic", d.HighTraffic)
	populate(objectMap, "lowTraffic", d.LowTraffic)
	populate(objectMap, "mediumTraffic", d.MediumTraffic)
	populate(objectMap, "providerRegistration", d.ProviderRegistration)
	populate(objectMap, "resourceTypeRegistrations", d.ResourceTypeRegistrations)
	populate(objectMap, "restOfTheWorldGroupOne", d.RestOfTheWorldGroupOne)
	populate(objectMap, "restOfTheWorldGroupTwo", d.RestOfTheWorldGroupTwo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutPropertiesSpecification.
func (d *DefaultRolloutPropertiesSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &d.Canary)
			delete(rawMsg, key)
		case "highTraffic":
			err = unpopulate(val, "HighTraffic", &d.HighTraffic)
			delete(rawMsg, key)
		case "lowTraffic":
			err = unpopulate(val, "LowTraffic", &d.LowTraffic)
			delete(rawMsg, key)
		case "mediumTraffic":
			err = unpopulate(val, "MediumTraffic", &d.MediumTraffic)
			delete(rawMsg, key)
		case "providerRegistration":
			err = unpopulate(val, "ProviderRegistration", &d.ProviderRegistration)
			delete(rawMsg, key)
		case "resourceTypeRegistrations":
			err = unpopulate(val, "ResourceTypeRegistrations", &d.ResourceTypeRegistrations)
			delete(rawMsg, key)
		case "restOfTheWorldGroupOne":
			err = unpopulate(val, "RestOfTheWorldGroupOne", &d.RestOfTheWorldGroupOne)
			delete(rawMsg, key)
		case "restOfTheWorldGroupTwo":
			err = unpopulate(val, "RestOfTheWorldGroupTwo", &d.RestOfTheWorldGroupTwo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutPropertiesStatus.
func (d DefaultRolloutPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completedRegions", d.CompletedRegions)
	populate(objectMap, "failedOrSkippedRegions", d.FailedOrSkippedRegions)
	populate(objectMap, "nextTrafficRegion", d.NextTrafficRegion)
	populateDateTimeRFC3339(objectMap, "nextTrafficRegionScheduledTime", d.NextTrafficRegionScheduledTime)
	populate(objectMap, "subscriptionReregistrationResult", d.SubscriptionReregistrationResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutPropertiesStatus.
func (d *DefaultRolloutPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedRegions":
			err = unpopulate(val, "CompletedRegions", &d.CompletedRegions)
			delete(rawMsg, key)
		case "failedOrSkippedRegions":
			err = unpopulate(val, "FailedOrSkippedRegions", &d.FailedOrSkippedRegions)
			delete(rawMsg, key)
		case "nextTrafficRegion":
			err = unpopulate(val, "NextTrafficRegion", &d.NextTrafficRegion)
			delete(rawMsg, key)
		case "nextTrafficRegionScheduledTime":
			err = unpopulateDateTimeRFC3339(val, "NextTrafficRegionScheduledTime", &d.NextTrafficRegionScheduledTime)
			delete(rawMsg, key)
		case "subscriptionReregistrationResult":
			err = unpopulate(val, "SubscriptionReregistrationResult", &d.SubscriptionReregistrationResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecification.
func (d DefaultRolloutSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "canary", d.Canary)
	populate(objectMap, "highTraffic", d.HighTraffic)
	populate(objectMap, "lowTraffic", d.LowTraffic)
	populate(objectMap, "mediumTraffic", d.MediumTraffic)
	populate(objectMap, "providerRegistration", d.ProviderRegistration)
	populate(objectMap, "resourceTypeRegistrations", d.ResourceTypeRegistrations)
	populate(objectMap, "restOfTheWorldGroupOne", d.RestOfTheWorldGroupOne)
	populate(objectMap, "restOfTheWorldGroupTwo", d.RestOfTheWorldGroupTwo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecification.
func (d *DefaultRolloutSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "canary":
			err = unpopulate(val, "Canary", &d.Canary)
			delete(rawMsg, key)
		case "highTraffic":
			err = unpopulate(val, "HighTraffic", &d.HighTraffic)
			delete(rawMsg, key)
		case "lowTraffic":
			err = unpopulate(val, "LowTraffic", &d.LowTraffic)
			delete(rawMsg, key)
		case "mediumTraffic":
			err = unpopulate(val, "MediumTraffic", &d.MediumTraffic)
			delete(rawMsg, key)
		case "providerRegistration":
			err = unpopulate(val, "ProviderRegistration", &d.ProviderRegistration)
			delete(rawMsg, key)
		case "resourceTypeRegistrations":
			err = unpopulate(val, "ResourceTypeRegistrations", &d.ResourceTypeRegistrations)
			delete(rawMsg, key)
		case "restOfTheWorldGroupOne":
			err = unpopulate(val, "RestOfTheWorldGroupOne", &d.RestOfTheWorldGroupOne)
			delete(rawMsg, key)
		case "restOfTheWorldGroupTwo":
			err = unpopulate(val, "RestOfTheWorldGroupTwo", &d.RestOfTheWorldGroupTwo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationCanary.
func (d DefaultRolloutSpecificationCanary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "skipRegions", d.SkipRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationCanary.
func (d *DefaultRolloutSpecificationCanary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "skipRegions":
			err = unpopulate(val, "SkipRegions", &d.SkipRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationHighTraffic.
func (d DefaultRolloutSpecificationHighTraffic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "waitDuration", d.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationHighTraffic.
func (d *DefaultRolloutSpecificationHighTraffic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &d.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationLowTraffic.
func (d DefaultRolloutSpecificationLowTraffic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "waitDuration", d.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationLowTraffic.
func (d *DefaultRolloutSpecificationLowTraffic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &d.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationMediumTraffic.
func (d DefaultRolloutSpecificationMediumTraffic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "waitDuration", d.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationMediumTraffic.
func (d *DefaultRolloutSpecificationMediumTraffic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &d.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationProviderRegistration.
func (d DefaultRolloutSpecificationProviderRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationProviderRegistration.
func (d *DefaultRolloutSpecificationProviderRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationRestOfTheWorldGroupOne.
func (d DefaultRolloutSpecificationRestOfTheWorldGroupOne) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "waitDuration", d.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationRestOfTheWorldGroupOne.
func (d *DefaultRolloutSpecificationRestOfTheWorldGroupOne) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &d.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutSpecificationRestOfTheWorldGroupTwo.
func (d DefaultRolloutSpecificationRestOfTheWorldGroupTwo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", d.Regions)
	populate(objectMap, "waitDuration", d.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutSpecificationRestOfTheWorldGroupTwo.
func (d *DefaultRolloutSpecificationRestOfTheWorldGroupTwo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &d.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &d.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultRolloutStatus.
func (d DefaultRolloutStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completedRegions", d.CompletedRegions)
	populate(objectMap, "failedOrSkippedRegions", d.FailedOrSkippedRegions)
	populate(objectMap, "nextTrafficRegion", d.NextTrafficRegion)
	populateDateTimeRFC3339(objectMap, "nextTrafficRegionScheduledTime", d.NextTrafficRegionScheduledTime)
	populate(objectMap, "subscriptionReregistrationResult", d.SubscriptionReregistrationResult)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultRolloutStatus.
func (d *DefaultRolloutStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedRegions":
			err = unpopulate(val, "CompletedRegions", &d.CompletedRegions)
			delete(rawMsg, key)
		case "failedOrSkippedRegions":
			err = unpopulate(val, "FailedOrSkippedRegions", &d.FailedOrSkippedRegions)
			delete(rawMsg, key)
		case "nextTrafficRegion":
			err = unpopulate(val, "NextTrafficRegion", &d.NextTrafficRegion)
			delete(rawMsg, key)
		case "nextTrafficRegionScheduledTime":
			err = unpopulateDateTimeRFC3339(val, "NextTrafficRegionScheduledTime", &d.NextTrafficRegionScheduledTime)
			delete(rawMsg, key)
		case "subscriptionReregistrationResult":
			err = unpopulate(val, "SubscriptionReregistrationResult", &d.SubscriptionReregistrationResult)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorInnerError.
func (e ErrorInnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populateAny(objectMap, "innerError", e.InnerError)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorInnerError.
func (e *ErrorInnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseError.
func (e ErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseError.
func (e *ErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedErrorInfo.
func (e ExtendedErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedErrorInfo.
func (e *ExtendedErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocationOptions.
func (e ExtendedLocationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedPolicy", e.SupportedPolicy)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocationOptions.
func (e *ExtendedLocationOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedPolicy":
			err = unpopulate(val, "SupportedPolicy", &e.SupportedPolicy)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionOptions.
func (e ExtensionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "request", e.Request)
	populate(objectMap, "response", e.Response)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtensionOptions.
func (e *ExtensionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "request":
			err = unpopulate(val, "Request", &e.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &e.Response)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeaturesRule.
func (f FeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", f.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeaturesRule.
func (f *FeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &f.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityManagement.
func (i IdentityManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityManagement.
func (i *IdentityManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityManagementProperties.
func (i IdentityManagementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", i.ApplicationID)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityManagementProperties.
func (i *IdentityManagementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &i.ApplicationID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerError.
func (i InnerError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", i.Code)
	populateAny(objectMap, "innerError", i.InnerError)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerError.
func (i *InnerError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &i.InnerError)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LightHouseAuthorization.
func (l LightHouseAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", l.PrincipalID)
	populate(objectMap, "roleDefinitionId", l.RoleDefinitionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LightHouseAuthorization.
func (l *LightHouseAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &l.PrincipalID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &l.RoleDefinitionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedAccessCheck.
func (l LinkedAccessCheck) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionName", l.ActionName)
	populate(objectMap, "linkedAction", l.LinkedAction)
	populate(objectMap, "linkedActionVerb", l.LinkedActionVerb)
	populate(objectMap, "linkedProperty", l.LinkedProperty)
	populate(objectMap, "linkedType", l.LinkedType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedAccessCheck.
func (l *LinkedAccessCheck) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &l.ActionName)
			delete(rawMsg, key)
		case "linkedAction":
			err = unpopulate(val, "LinkedAction", &l.LinkedAction)
			delete(rawMsg, key)
		case "linkedActionVerb":
			err = unpopulate(val, "LinkedActionVerb", &l.LinkedActionVerb)
			delete(rawMsg, key)
		case "linkedProperty":
			err = unpopulate(val, "LinkedProperty", &l.LinkedProperty)
			delete(rawMsg, key)
		case "linkedType":
			err = unpopulate(val, "LinkedType", &l.LinkedType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedOperationRule.
func (l LinkedOperationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkedAction", l.LinkedAction)
	populate(objectMap, "linkedOperation", l.LinkedOperation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedOperationRule.
func (l *LinkedOperationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkedAction":
			err = unpopulate(val, "LinkedAction", &l.LinkedAction)
			delete(rawMsg, key)
		case "linkedOperation":
			err = unpopulate(val, "LinkedOperation", &l.LinkedOperation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggingHiddenPropertyPath.
func (l LoggingHiddenPropertyPath) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hiddenPathsOnRequest", l.HiddenPathsOnRequest)
	populate(objectMap, "hiddenPathsOnResponse", l.HiddenPathsOnResponse)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggingHiddenPropertyPath.
func (l *LoggingHiddenPropertyPath) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hiddenPathsOnRequest":
			err = unpopulate(val, "HiddenPathsOnRequest", &l.HiddenPathsOnRequest)
			delete(rawMsg, key)
		case "hiddenPathsOnResponse":
			err = unpopulate(val, "HiddenPathsOnResponse", &l.HiddenPathsOnResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggingRule.
func (l LoggingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", l.Action)
	populate(objectMap, "detailLevel", l.DetailLevel)
	populate(objectMap, "direction", l.Direction)
	populate(objectMap, "hiddenPropertyPaths", l.HiddenPropertyPaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggingRule.
func (l *LoggingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &l.Action)
			delete(rawMsg, key)
		case "detailLevel":
			err = unpopulate(val, "DetailLevel", &l.DetailLevel)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &l.Direction)
			delete(rawMsg, key)
		case "hiddenPropertyPaths":
			err = unpopulate(val, "HiddenPropertyPaths", &l.HiddenPropertyPaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoggingRuleHiddenPropertyPaths.
func (l LoggingRuleHiddenPropertyPaths) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hiddenPathsOnRequest", l.HiddenPathsOnRequest)
	populate(objectMap, "hiddenPathsOnResponse", l.HiddenPathsOnResponse)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoggingRuleHiddenPropertyPaths.
func (l *LoggingRuleHiddenPropertyPaths) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hiddenPathsOnRequest":
			err = unpopulate(val, "HiddenPathsOnRequest", &l.HiddenPathsOnRequest)
			delete(rawMsg, key)
		case "hiddenPathsOnResponse":
			err = unpopulate(val, "HiddenPathsOnResponse", &l.HiddenPathsOnResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Metadata.
func (m Metadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerAuthentication", m.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", m.ProviderAuthorizations)
	populate(objectMap, "thirdPartyProviderAuthorization", m.ThirdPartyProviderAuthorization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Metadata.
func (m *Metadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &m.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &m.ProviderAuthorizations)
			delete(rawMsg, key)
		case "thirdPartyProviderAuthorization":
			err = unpopulate(val, "ThirdPartyProviderAuthorization", &m.ThirdPartyProviderAuthorization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataProviderAuthentication.
func (m MetadataProviderAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", m.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataProviderAuthentication.
func (m *MetadataProviderAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &m.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetadataThirdPartyProviderAuthorization.
func (m MetadataThirdPartyProviderAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizations", m.Authorizations)
	populate(objectMap, "managedByTenantId", m.ManagedByTenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetadataThirdPartyProviderAuthorization.
func (m *MetadataThirdPartyProviderAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizations":
			err = unpopulate(val, "Authorizations", &m.Authorizations)
			delete(rawMsg, key)
		case "managedByTenantId":
			err = unpopulate(val, "ManagedByTenantID", &m.ManagedByTenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationEndpoint.
func (n NotificationEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", n.Locations)
	populate(objectMap, "notificationDestination", n.NotificationDestination)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationEndpoint.
func (n *NotificationEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &n.Locations)
			delete(rawMsg, key)
		case "notificationDestination":
			err = unpopulate(val, "NotificationDestination", &n.NotificationDestination)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationRegistration.
func (n NotificationRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationRegistration.
func (n *NotificationRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationRegistrationArrayResponseWithContinuation.
func (n NotificationRegistrationArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationRegistrationArrayResponseWithContinuation.
func (n *NotificationRegistrationArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationRegistrationProperties.
func (n NotificationRegistrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "includedEvents", n.IncludedEvents)
	populate(objectMap, "messageScope", n.MessageScope)
	populate(objectMap, "notificationEndpoints", n.NotificationEndpoints)
	populate(objectMap, "notificationMode", n.NotificationMode)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationRegistrationProperties.
func (n *NotificationRegistrationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includedEvents":
			err = unpopulate(val, "IncludedEvents", &n.IncludedEvents)
			delete(rawMsg, key)
		case "messageScope":
			err = unpopulate(val, "MessageScope", &n.MessageScope)
			delete(rawMsg, key)
		case "notificationEndpoints":
			err = unpopulate(val, "NotificationEndpoints", &n.NotificationEndpoints)
			delete(rawMsg, key)
		case "notificationMode":
			err = unpopulate(val, "NotificationMode", &n.NotificationMode)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationRegistrationPropertiesAutoGenerated.
func (n NotificationRegistrationPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "includedEvents", n.IncludedEvents)
	populate(objectMap, "messageScope", n.MessageScope)
	populate(objectMap, "notificationEndpoints", n.NotificationEndpoints)
	populate(objectMap, "notificationMode", n.NotificationMode)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationRegistrationPropertiesAutoGenerated.
func (n *NotificationRegistrationPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "includedEvents":
			err = unpopulate(val, "IncludedEvents", &n.IncludedEvents)
			delete(rawMsg, key)
		case "messageScope":
			err = unpopulate(val, "MessageScope", &n.MessageScope)
			delete(rawMsg, key)
		case "notificationEndpoints":
			err = unpopulate(val, "NotificationEndpoints", &n.NotificationEndpoints)
			delete(rawMsg, key)
		case "notificationMode":
			err = unpopulate(val, "NotificationMode", &n.NotificationMode)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsContent.
func (o OperationsContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsContent.
func (o *OperationsContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinition.
func (o OperationsDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinition.
func (o *OperationsDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinitionArrayResponseWithContinuation.
func (o OperationsDefinitionArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinitionArrayResponseWithContinuation.
func (o *OperationsDefinitionArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDefinitionDisplay.
func (o OperationsDefinitionDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDefinitionDisplay.
func (o *OperationsDefinitionDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsDisplayDefinition.
func (o OperationsDisplayDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsDisplayDefinition.
func (o *OperationsDisplayDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsPutContent.
func (o OperationsPutContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contents", o.Contents)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsPutContent.
func (o *OperationsPutContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &o.Contents)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistration.
func (p ProviderRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistration.
func (p *ProviderRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistrationArrayResponseWithContinuation.
func (p ProviderRegistrationArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistrationArrayResponseWithContinuation.
func (p *ProviderRegistrationArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistrationProperties.
func (p ProviderRegistrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", p.Capabilities)
	populate(objectMap, "featuresRule", p.FeaturesRule)
	populate(objectMap, "management", p.Management)
	populateAny(objectMap, "metadata", p.Metadata)
	populate(objectMap, "namespace", p.Namespace)
	populate(objectMap, "providerAuthentication", p.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", p.ProviderAuthorizations)
	populate(objectMap, "providerHubMetadata", p.ProviderHubMetadata)
	populate(objectMap, "providerType", p.ProviderType)
	populate(objectMap, "providerVersion", p.ProviderVersion)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requestHeaderOptions", p.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", p.RequiredFeatures)
	populate(objectMap, "subscriptionLifecycleNotificationSpecifications", p.SubscriptionLifecycleNotificationSpecifications)
	populate(objectMap, "templateDeploymentOptions", p.TemplateDeploymentOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistrationProperties.
func (p *ProviderRegistrationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &p.Capabilities)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &p.FeaturesRule)
			delete(rawMsg, key)
		case "management":
			err = unpopulate(val, "Management", &p.Management)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &p.Namespace)
			delete(rawMsg, key)
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &p.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &p.ProviderAuthorizations)
			delete(rawMsg, key)
		case "providerHubMetadata":
			err = unpopulate(val, "ProviderHubMetadata", &p.ProviderHubMetadata)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &p.ProviderType)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &p.ProviderVersion)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &p.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &p.RequiredFeatures)
			delete(rawMsg, key)
		case "subscriptionLifecycleNotificationSpecifications":
			err = unpopulate(val, "SubscriptionLifecycleNotificationSpecifications", &p.SubscriptionLifecycleNotificationSpecifications)
			delete(rawMsg, key)
		case "templateDeploymentOptions":
			err = unpopulate(val, "TemplateDeploymentOptions", &p.TemplateDeploymentOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistrationPropertiesAutoGenerated.
func (p ProviderRegistrationPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", p.Capabilities)
	populate(objectMap, "featuresRule", p.FeaturesRule)
	populate(objectMap, "management", p.Management)
	populateAny(objectMap, "metadata", p.Metadata)
	populate(objectMap, "namespace", p.Namespace)
	populate(objectMap, "providerAuthentication", p.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", p.ProviderAuthorizations)
	populate(objectMap, "providerHubMetadata", p.ProviderHubMetadata)
	populate(objectMap, "providerType", p.ProviderType)
	populate(objectMap, "providerVersion", p.ProviderVersion)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requestHeaderOptions", p.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", p.RequiredFeatures)
	populate(objectMap, "subscriptionLifecycleNotificationSpecifications", p.SubscriptionLifecycleNotificationSpecifications)
	populate(objectMap, "templateDeploymentOptions", p.TemplateDeploymentOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistrationPropertiesAutoGenerated.
func (p *ProviderRegistrationPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &p.Capabilities)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &p.FeaturesRule)
			delete(rawMsg, key)
		case "management":
			err = unpopulate(val, "Management", &p.Management)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &p.Metadata)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &p.Namespace)
			delete(rawMsg, key)
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &p.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &p.ProviderAuthorizations)
			delete(rawMsg, key)
		case "providerHubMetadata":
			err = unpopulate(val, "ProviderHubMetadata", &p.ProviderHubMetadata)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &p.ProviderType)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &p.ProviderVersion)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &p.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &p.RequiredFeatures)
			delete(rawMsg, key)
		case "subscriptionLifecycleNotificationSpecifications":
			err = unpopulate(val, "SubscriptionLifecycleNotificationSpecifications", &p.SubscriptionLifecycleNotificationSpecifications)
			delete(rawMsg, key)
		case "templateDeploymentOptions":
			err = unpopulate(val, "TemplateDeploymentOptions", &p.TemplateDeploymentOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistrationPropertiesProviderHubMetadata.
func (p ProviderRegistrationPropertiesProviderHubMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "providerAuthentication", p.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", p.ProviderAuthorizations)
	populate(objectMap, "thirdPartyProviderAuthorization", p.ThirdPartyProviderAuthorization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistrationPropertiesProviderHubMetadata.
func (p *ProviderRegistrationPropertiesProviderHubMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &p.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &p.ProviderAuthorizations)
			delete(rawMsg, key)
		case "thirdPartyProviderAuthorization":
			err = unpopulate(val, "ThirdPartyProviderAuthorization", &p.ThirdPartyProviderAuthorization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.
func (p ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "softDeleteTTL", p.SoftDeleteTTL)
	populate(objectMap, "subscriptionStateOverrideActions", p.SubscriptionStateOverrideActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.
func (p *ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "softDeleteTTL":
			err = unpopulate(val, "SoftDeleteTTL", &p.SoftDeleteTTL)
			delete(rawMsg, key)
		case "subscriptionStateOverrideActions":
			err = unpopulate(val, "SubscriptionStateOverrideActions", &p.SubscriptionStateOverrideActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReRegisterSubscriptionMetadata.
func (r ReRegisterSubscriptionMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "concurrencyLimit", r.ConcurrencyLimit)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReRegisterSubscriptionMetadata.
func (r *ReRegisterSubscriptionMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "concurrencyLimit":
			err = unpopulate(val, "ConcurrencyLimit", &r.ConcurrencyLimit)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestHeaderOptions.
func (r RequestHeaderOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "optInHeaders", r.OptInHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestHeaderOptions.
func (r *RequestHeaderOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "optInHeaders":
			err = unpopulate(val, "OptInHeaders", &r.OptInHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceMovePolicy.
func (r ResourceMovePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossResourceGroupMoveEnabled", r.CrossResourceGroupMoveEnabled)
	populate(objectMap, "crossSubscriptionMoveEnabled", r.CrossSubscriptionMoveEnabled)
	populate(objectMap, "validationRequired", r.ValidationRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceMovePolicy.
func (r *ResourceMovePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossResourceGroupMoveEnabled":
			err = unpopulate(val, "CrossResourceGroupMoveEnabled", &r.CrossResourceGroupMoveEnabled)
			delete(rawMsg, key)
		case "crossSubscriptionMoveEnabled":
			err = unpopulate(val, "CrossSubscriptionMoveEnabled", &r.CrossSubscriptionMoveEnabled)
			delete(rawMsg, key)
		case "validationRequired":
			err = unpopulate(val, "ValidationRequired", &r.ValidationRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderAuthentication.
func (r ResourceProviderAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", r.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderAuthentication.
func (r *ResourceProviderAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &r.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderAuthorization.
func (r ResourceProviderAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", r.ApplicationID)
	populate(objectMap, "managedByRoleDefinitionId", r.ManagedByRoleDefinitionID)
	populate(objectMap, "roleDefinitionId", r.RoleDefinitionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderAuthorization.
func (r *ResourceProviderAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &r.ApplicationID)
			delete(rawMsg, key)
		case "managedByRoleDefinitionId":
			err = unpopulate(val, "ManagedByRoleDefinitionID", &r.ManagedByRoleDefinitionID)
			delete(rawMsg, key)
		case "roleDefinitionId":
			err = unpopulate(val, "RoleDefinitionID", &r.RoleDefinitionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderCapabilities.
func (r ResourceProviderCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "effect", r.Effect)
	populate(objectMap, "quotaId", r.QuotaID)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderCapabilities.
func (r *ResourceProviderCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "effect":
			err = unpopulate(val, "Effect", &r.Effect)
			delete(rawMsg, key)
		case "quotaId":
			err = unpopulate(val, "QuotaID", &r.QuotaID)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderEndpoint.
func (r ResourceProviderEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", r.APIVersions)
	populate(objectMap, "enabled", r.Enabled)
	populate(objectMap, "endpointUri", r.EndpointURI)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderEndpoint.
func (r *ResourceProviderEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &r.APIVersions)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		case "endpointUri":
			err = unpopulate(val, "EndpointURI", &r.EndpointURI)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderEndpointFeaturesRule.
func (r ResourceProviderEndpointFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderEndpointFeaturesRule.
func (r *ResourceProviderEndpointFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManagement.
func (r ResourceProviderManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incidentContactEmail", r.IncidentContactEmail)
	populate(objectMap, "incidentRoutingService", r.IncidentRoutingService)
	populate(objectMap, "incidentRoutingTeam", r.IncidentRoutingTeam)
	populate(objectMap, "manifestOwners", r.ManifestOwners)
	populate(objectMap, "resourceAccessPolicy", r.ResourceAccessPolicy)
	populate(objectMap, "resourceAccessRoles", r.ResourceAccessRoles)
	populate(objectMap, "schemaOwners", r.SchemaOwners)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManagement.
func (r *ResourceProviderManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incidentContactEmail":
			err = unpopulate(val, "IncidentContactEmail", &r.IncidentContactEmail)
			delete(rawMsg, key)
		case "incidentRoutingService":
			err = unpopulate(val, "IncidentRoutingService", &r.IncidentRoutingService)
			delete(rawMsg, key)
		case "incidentRoutingTeam":
			err = unpopulate(val, "IncidentRoutingTeam", &r.IncidentRoutingTeam)
			delete(rawMsg, key)
		case "manifestOwners":
			err = unpopulate(val, "ManifestOwners", &r.ManifestOwners)
			delete(rawMsg, key)
		case "resourceAccessPolicy":
			err = unpopulate(val, "ResourceAccessPolicy", &r.ResourceAccessPolicy)
			delete(rawMsg, key)
		case "resourceAccessRoles":
			err = unpopulate(val, "ResourceAccessRoles", &r.ResourceAccessRoles)
			delete(rawMsg, key)
		case "schemaOwners":
			err = unpopulate(val, "SchemaOwners", &r.SchemaOwners)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifest.
func (r ResourceProviderManifest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "globalNotificationEndpoints", r.GlobalNotificationEndpoints)
	populate(objectMap, "management", r.Management)
	populateAny(objectMap, "metadata", r.Metadata)
	populate(objectMap, "namespace", r.Namespace)
	populate(objectMap, "providerAuthentication", r.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", r.ProviderAuthorizations)
	populate(objectMap, "providerType", r.ProviderType)
	populate(objectMap, "providerVersion", r.ProviderVersion)
	populate(objectMap, "reRegisterSubscriptionMetadata", r.ReRegisterSubscriptionMetadata)
	populate(objectMap, "requestHeaderOptions", r.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "resourceTypes", r.ResourceTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifest.
func (r *ResourceProviderManifest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "globalNotificationEndpoints":
			err = unpopulate(val, "GlobalNotificationEndpoints", &r.GlobalNotificationEndpoints)
			delete(rawMsg, key)
		case "management":
			err = unpopulate(val, "Management", &r.Management)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &r.Metadata)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &r.Namespace)
			delete(rawMsg, key)
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &r.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &r.ProviderAuthorizations)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &r.ProviderType)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &r.ProviderVersion)
			delete(rawMsg, key)
		case "reRegisterSubscriptionMetadata":
			err = unpopulate(val, "ReRegisterSubscriptionMetadata", &r.ReRegisterSubscriptionMetadata)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &r.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "resourceTypes":
			err = unpopulate(val, "ResourceTypes", &r.ResourceTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestFeaturesRule.
func (r ResourceProviderManifestFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestFeaturesRule.
func (r *ResourceProviderManifestFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestManagement.
func (r ResourceProviderManifestManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incidentContactEmail", r.IncidentContactEmail)
	populate(objectMap, "incidentRoutingService", r.IncidentRoutingService)
	populate(objectMap, "incidentRoutingTeam", r.IncidentRoutingTeam)
	populate(objectMap, "manifestOwners", r.ManifestOwners)
	populate(objectMap, "resourceAccessPolicy", r.ResourceAccessPolicy)
	populate(objectMap, "resourceAccessRoles", r.ResourceAccessRoles)
	populate(objectMap, "schemaOwners", r.SchemaOwners)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestManagement.
func (r *ResourceProviderManifestManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incidentContactEmail":
			err = unpopulate(val, "IncidentContactEmail", &r.IncidentContactEmail)
			delete(rawMsg, key)
		case "incidentRoutingService":
			err = unpopulate(val, "IncidentRoutingService", &r.IncidentRoutingService)
			delete(rawMsg, key)
		case "incidentRoutingTeam":
			err = unpopulate(val, "IncidentRoutingTeam", &r.IncidentRoutingTeam)
			delete(rawMsg, key)
		case "manifestOwners":
			err = unpopulate(val, "ManifestOwners", &r.ManifestOwners)
			delete(rawMsg, key)
		case "resourceAccessPolicy":
			err = unpopulate(val, "ResourceAccessPolicy", &r.ResourceAccessPolicy)
			delete(rawMsg, key)
		case "resourceAccessRoles":
			err = unpopulate(val, "ResourceAccessRoles", &r.ResourceAccessRoles)
			delete(rawMsg, key)
		case "schemaOwners":
			err = unpopulate(val, "SchemaOwners", &r.SchemaOwners)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestProperties.
func (r ResourceProviderManifestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "management", r.Management)
	populateAny(objectMap, "metadata", r.Metadata)
	populate(objectMap, "namespace", r.Namespace)
	populate(objectMap, "providerAuthentication", r.ProviderAuthentication)
	populate(objectMap, "providerAuthorizations", r.ProviderAuthorizations)
	populate(objectMap, "providerType", r.ProviderType)
	populate(objectMap, "providerVersion", r.ProviderVersion)
	populate(objectMap, "requestHeaderOptions", r.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "templateDeploymentOptions", r.TemplateDeploymentOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestProperties.
func (r *ResourceProviderManifestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "management":
			err = unpopulate(val, "Management", &r.Management)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &r.Metadata)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &r.Namespace)
			delete(rawMsg, key)
		case "providerAuthentication":
			err = unpopulate(val, "ProviderAuthentication", &r.ProviderAuthentication)
			delete(rawMsg, key)
		case "providerAuthorizations":
			err = unpopulate(val, "ProviderAuthorizations", &r.ProviderAuthorizations)
			delete(rawMsg, key)
		case "providerType":
			err = unpopulate(val, "ProviderType", &r.ProviderType)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &r.ProviderVersion)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &r.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "templateDeploymentOptions":
			err = unpopulate(val, "TemplateDeploymentOptions", &r.TemplateDeploymentOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestPropertiesFeaturesRule.
func (r ResourceProviderManifestPropertiesFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestPropertiesFeaturesRule.
func (r *ResourceProviderManifestPropertiesFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestPropertiesManagement.
func (r ResourceProviderManifestPropertiesManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incidentContactEmail", r.IncidentContactEmail)
	populate(objectMap, "incidentRoutingService", r.IncidentRoutingService)
	populate(objectMap, "incidentRoutingTeam", r.IncidentRoutingTeam)
	populate(objectMap, "manifestOwners", r.ManifestOwners)
	populate(objectMap, "resourceAccessPolicy", r.ResourceAccessPolicy)
	populate(objectMap, "resourceAccessRoles", r.ResourceAccessRoles)
	populate(objectMap, "schemaOwners", r.SchemaOwners)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestPropertiesManagement.
func (r *ResourceProviderManifestPropertiesManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incidentContactEmail":
			err = unpopulate(val, "IncidentContactEmail", &r.IncidentContactEmail)
			delete(rawMsg, key)
		case "incidentRoutingService":
			err = unpopulate(val, "IncidentRoutingService", &r.IncidentRoutingService)
			delete(rawMsg, key)
		case "incidentRoutingTeam":
			err = unpopulate(val, "IncidentRoutingTeam", &r.IncidentRoutingTeam)
			delete(rawMsg, key)
		case "manifestOwners":
			err = unpopulate(val, "ManifestOwners", &r.ManifestOwners)
			delete(rawMsg, key)
		case "resourceAccessPolicy":
			err = unpopulate(val, "ResourceAccessPolicy", &r.ResourceAccessPolicy)
			delete(rawMsg, key)
		case "resourceAccessRoles":
			err = unpopulate(val, "ResourceAccessRoles", &r.ResourceAccessRoles)
			delete(rawMsg, key)
		case "schemaOwners":
			err = unpopulate(val, "SchemaOwners", &r.SchemaOwners)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestPropertiesProviderAuthentication.
func (r ResourceProviderManifestPropertiesProviderAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", r.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestPropertiesProviderAuthentication.
func (r *ResourceProviderManifestPropertiesProviderAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &r.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestPropertiesRequestHeaderOptions.
func (r ResourceProviderManifestPropertiesRequestHeaderOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "optInHeaders", r.OptInHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestPropertiesRequestHeaderOptions.
func (r *ResourceProviderManifestPropertiesRequestHeaderOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "optInHeaders":
			err = unpopulate(val, "OptInHeaders", &r.OptInHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestPropertiesTemplateDeploymentOptions.
func (r ResourceProviderManifestPropertiesTemplateDeploymentOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preflightOptions", r.PreflightOptions)
	populate(objectMap, "preflightSupported", r.PreflightSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestPropertiesTemplateDeploymentOptions.
func (r *ResourceProviderManifestPropertiesTemplateDeploymentOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preflightOptions":
			err = unpopulate(val, "PreflightOptions", &r.PreflightOptions)
			delete(rawMsg, key)
		case "preflightSupported":
			err = unpopulate(val, "PreflightSupported", &r.PreflightSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestProviderAuthentication.
func (r ResourceProviderManifestProviderAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedAudiences", r.AllowedAudiences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestProviderAuthentication.
func (r *ResourceProviderManifestProviderAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAudiences":
			err = unpopulate(val, "AllowedAudiences", &r.AllowedAudiences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestReRegisterSubscriptionMetadata.
func (r ResourceProviderManifestReRegisterSubscriptionMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "concurrencyLimit", r.ConcurrencyLimit)
	populate(objectMap, "enabled", r.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestReRegisterSubscriptionMetadata.
func (r *ResourceProviderManifestReRegisterSubscriptionMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "concurrencyLimit":
			err = unpopulate(val, "ConcurrencyLimit", &r.ConcurrencyLimit)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderManifestRequestHeaderOptions.
func (r ResourceProviderManifestRequestHeaderOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "optInHeaders", r.OptInHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderManifestRequestHeaderOptions.
func (r *ResourceProviderManifestRequestHeaderOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "optInHeaders":
			err = unpopulate(val, "OptInHeaders", &r.OptInHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceType.
func (r ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedUnauthorizedActions", r.AllowedUnauthorizedActions)
	populate(objectMap, "authorizationActionMappings", r.AuthorizationActionMappings)
	populate(objectMap, "defaultApiVersion", r.DefaultAPIVersion)
	populate(objectMap, "disallowedActionVerbs", r.DisallowedActionVerbs)
	populate(objectMap, "endpoints", r.Endpoints)
	populate(objectMap, "extendedLocations", r.ExtendedLocations)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "identityManagement", r.IdentityManagement)
	populate(objectMap, "linkedAccessChecks", r.LinkedAccessChecks)
	populate(objectMap, "linkedOperationRules", r.LinkedOperationRules)
	populate(objectMap, "loggingRules", r.LoggingRules)
	populate(objectMap, "marketplaceType", r.MarketplaceType)
	populateAny(objectMap, "metadata", r.Metadata)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "requestHeaderOptions", r.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "resourceDeletionPolicy", r.ResourceDeletionPolicy)
	populate(objectMap, "resourceValidation", r.ResourceValidation)
	populate(objectMap, "routingType", r.RoutingType)
	populate(objectMap, "skuLink", r.SKULink)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	populate(objectMap, "subscriptionStateRules", r.SubscriptionStateRules)
	populate(objectMap, "templateDeploymentPolicy", r.TemplateDeploymentPolicy)
	populate(objectMap, "throttlingRules", r.ThrottlingRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceType.
func (r *ResourceType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedUnauthorizedActions":
			err = unpopulate(val, "AllowedUnauthorizedActions", &r.AllowedUnauthorizedActions)
			delete(rawMsg, key)
		case "authorizationActionMappings":
			err = unpopulate(val, "AuthorizationActionMappings", &r.AuthorizationActionMappings)
			delete(rawMsg, key)
		case "defaultApiVersion":
			err = unpopulate(val, "DefaultAPIVersion", &r.DefaultAPIVersion)
			delete(rawMsg, key)
		case "disallowedActionVerbs":
			err = unpopulate(val, "DisallowedActionVerbs", &r.DisallowedActionVerbs)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &r.Endpoints)
			delete(rawMsg, key)
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &r.ExtendedLocations)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "identityManagement":
			err = unpopulate(val, "IdentityManagement", &r.IdentityManagement)
			delete(rawMsg, key)
		case "linkedAccessChecks":
			err = unpopulate(val, "LinkedAccessChecks", &r.LinkedAccessChecks)
			delete(rawMsg, key)
		case "linkedOperationRules":
			err = unpopulate(val, "LinkedOperationRules", &r.LinkedOperationRules)
			delete(rawMsg, key)
		case "loggingRules":
			err = unpopulate(val, "LoggingRules", &r.LoggingRules)
			delete(rawMsg, key)
		case "marketplaceType":
			err = unpopulate(val, "MarketplaceType", &r.MarketplaceType)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &r.Metadata)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &r.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "resourceDeletionPolicy":
			err = unpopulate(val, "ResourceDeletionPolicy", &r.ResourceDeletionPolicy)
			delete(rawMsg, key)
		case "resourceValidation":
			err = unpopulate(val, "ResourceValidation", &r.ResourceValidation)
			delete(rawMsg, key)
		case "routingType":
			err = unpopulate(val, "RoutingType", &r.RoutingType)
			delete(rawMsg, key)
		case "skuLink":
			err = unpopulate(val, "SKULink", &r.SKULink)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		case "subscriptionStateRules":
			err = unpopulate(val, "SubscriptionStateRules", &r.SubscriptionStateRules)
			delete(rawMsg, key)
		case "templateDeploymentPolicy":
			err = unpopulate(val, "TemplateDeploymentPolicy", &r.TemplateDeploymentPolicy)
			delete(rawMsg, key)
		case "throttlingRules":
			err = unpopulate(val, "ThrottlingRules", &r.ThrottlingRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeEndpoint.
func (r ResourceTypeEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", r.APIVersions)
	populate(objectMap, "enabled", r.Enabled)
	populate(objectMap, "extensions", r.Extensions)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "locations", r.Locations)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeEndpoint.
func (r *ResourceTypeEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &r.APIVersions)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &r.Enabled)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &r.Extensions)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &r.Locations)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeEndpointFeaturesRule.
func (r ResourceTypeEndpointFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeEndpointFeaturesRule.
func (r *ResourceTypeEndpointFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeExtension.
func (r ResourceTypeExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointUri", r.EndpointURI)
	populate(objectMap, "extensionCategories", r.ExtensionCategories)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeExtension.
func (r *ResourceTypeExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointUri":
			err = unpopulate(val, "EndpointURI", &r.EndpointURI)
			delete(rawMsg, key)
		case "extensionCategories":
			err = unpopulate(val, "ExtensionCategories", &r.ExtensionCategories)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeExtensionOptions.
func (r ResourceTypeExtensionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceCreationBegin", r.ResourceCreationBegin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeExtensionOptions.
func (r *ResourceTypeExtensionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceCreationBegin":
			err = unpopulate(val, "ResourceCreationBegin", &r.ResourceCreationBegin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeExtensionOptionsResourceCreationBegin.
func (r ResourceTypeExtensionOptionsResourceCreationBegin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "request", r.Request)
	populate(objectMap, "response", r.Response)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeExtensionOptionsResourceCreationBegin.
func (r *ResourceTypeExtensionOptionsResourceCreationBegin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "request":
			err = unpopulate(val, "Request", &r.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, "Response", &r.Response)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeFeaturesRule.
func (r ResourceTypeFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeFeaturesRule.
func (r *ResourceTypeFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeIdentityManagement.
func (r ResourceTypeIdentityManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeIdentityManagement.
func (r *ResourceTypeIdentityManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistration.
func (r ResourceTypeRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistration.
func (r *ResourceTypeRegistration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationArrayResponseWithContinuation.
func (r ResourceTypeRegistrationArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationArrayResponseWithContinuation.
func (r *ResourceTypeRegistrationArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationProperties.
func (r ResourceTypeRegistrationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedUnauthorizedActions", r.AllowedUnauthorizedActions)
	populate(objectMap, "authorizationActionMappings", r.AuthorizationActionMappings)
	populate(objectMap, "checkNameAvailabilitySpecifications", r.CheckNameAvailabilitySpecifications)
	populate(objectMap, "defaultApiVersion", r.DefaultAPIVersion)
	populate(objectMap, "disallowedActionVerbs", r.DisallowedActionVerbs)
	populate(objectMap, "enableAsyncOperation", r.EnableAsyncOperation)
	populate(objectMap, "enableThirdPartyS2S", r.EnableThirdPartyS2S)
	populate(objectMap, "endpoints", r.Endpoints)
	populate(objectMap, "extendedLocations", r.ExtendedLocations)
	populate(objectMap, "extensionOptions", r.ExtensionOptions)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "identityManagement", r.IdentityManagement)
	populate(objectMap, "isPureProxy", r.IsPureProxy)
	populate(objectMap, "linkedAccessChecks", r.LinkedAccessChecks)
	populate(objectMap, "loggingRules", r.LoggingRules)
	populate(objectMap, "marketplaceType", r.MarketplaceType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "regionality", r.Regionality)
	populate(objectMap, "requestHeaderOptions", r.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "resourceDeletionPolicy", r.ResourceDeletionPolicy)
	populate(objectMap, "resourceMovePolicy", r.ResourceMovePolicy)
	populate(objectMap, "routingType", r.RoutingType)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	populate(objectMap, "subscriptionLifecycleNotificationSpecifications", r.SubscriptionLifecycleNotificationSpecifications)
	populate(objectMap, "subscriptionStateRules", r.SubscriptionStateRules)
	populate(objectMap, "swaggerSpecifications", r.SwaggerSpecifications)
	populate(objectMap, "templateDeploymentOptions", r.TemplateDeploymentOptions)
	populate(objectMap, "throttlingRules", r.ThrottlingRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationProperties.
func (r *ResourceTypeRegistrationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedUnauthorizedActions":
			err = unpopulate(val, "AllowedUnauthorizedActions", &r.AllowedUnauthorizedActions)
			delete(rawMsg, key)
		case "authorizationActionMappings":
			err = unpopulate(val, "AuthorizationActionMappings", &r.AuthorizationActionMappings)
			delete(rawMsg, key)
		case "checkNameAvailabilitySpecifications":
			err = unpopulate(val, "CheckNameAvailabilitySpecifications", &r.CheckNameAvailabilitySpecifications)
			delete(rawMsg, key)
		case "defaultApiVersion":
			err = unpopulate(val, "DefaultAPIVersion", &r.DefaultAPIVersion)
			delete(rawMsg, key)
		case "disallowedActionVerbs":
			err = unpopulate(val, "DisallowedActionVerbs", &r.DisallowedActionVerbs)
			delete(rawMsg, key)
		case "enableAsyncOperation":
			err = unpopulate(val, "EnableAsyncOperation", &r.EnableAsyncOperation)
			delete(rawMsg, key)
		case "enableThirdPartyS2S":
			err = unpopulate(val, "EnableThirdPartyS2S", &r.EnableThirdPartyS2S)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &r.Endpoints)
			delete(rawMsg, key)
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &r.ExtendedLocations)
			delete(rawMsg, key)
		case "extensionOptions":
			err = unpopulate(val, "ExtensionOptions", &r.ExtensionOptions)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "identityManagement":
			err = unpopulate(val, "IdentityManagement", &r.IdentityManagement)
			delete(rawMsg, key)
		case "isPureProxy":
			err = unpopulate(val, "IsPureProxy", &r.IsPureProxy)
			delete(rawMsg, key)
		case "linkedAccessChecks":
			err = unpopulate(val, "LinkedAccessChecks", &r.LinkedAccessChecks)
			delete(rawMsg, key)
		case "loggingRules":
			err = unpopulate(val, "LoggingRules", &r.LoggingRules)
			delete(rawMsg, key)
		case "marketplaceType":
			err = unpopulate(val, "MarketplaceType", &r.MarketplaceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "regionality":
			err = unpopulate(val, "Regionality", &r.Regionality)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &r.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "resourceDeletionPolicy":
			err = unpopulate(val, "ResourceDeletionPolicy", &r.ResourceDeletionPolicy)
			delete(rawMsg, key)
		case "resourceMovePolicy":
			err = unpopulate(val, "ResourceMovePolicy", &r.ResourceMovePolicy)
			delete(rawMsg, key)
		case "routingType":
			err = unpopulate(val, "RoutingType", &r.RoutingType)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		case "subscriptionLifecycleNotificationSpecifications":
			err = unpopulate(val, "SubscriptionLifecycleNotificationSpecifications", &r.SubscriptionLifecycleNotificationSpecifications)
			delete(rawMsg, key)
		case "subscriptionStateRules":
			err = unpopulate(val, "SubscriptionStateRules", &r.SubscriptionStateRules)
			delete(rawMsg, key)
		case "swaggerSpecifications":
			err = unpopulate(val, "SwaggerSpecifications", &r.SwaggerSpecifications)
			delete(rawMsg, key)
		case "templateDeploymentOptions":
			err = unpopulate(val, "TemplateDeploymentOptions", &r.TemplateDeploymentOptions)
			delete(rawMsg, key)
		case "throttlingRules":
			err = unpopulate(val, "ThrottlingRules", &r.ThrottlingRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesAutoGenerated.
func (r ResourceTypeRegistrationPropertiesAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedUnauthorizedActions", r.AllowedUnauthorizedActions)
	populate(objectMap, "authorizationActionMappings", r.AuthorizationActionMappings)
	populate(objectMap, "checkNameAvailabilitySpecifications", r.CheckNameAvailabilitySpecifications)
	populate(objectMap, "defaultApiVersion", r.DefaultAPIVersion)
	populate(objectMap, "disallowedActionVerbs", r.DisallowedActionVerbs)
	populate(objectMap, "enableAsyncOperation", r.EnableAsyncOperation)
	populate(objectMap, "enableThirdPartyS2S", r.EnableThirdPartyS2S)
	populate(objectMap, "endpoints", r.Endpoints)
	populate(objectMap, "extendedLocations", r.ExtendedLocations)
	populate(objectMap, "extensionOptions", r.ExtensionOptions)
	populate(objectMap, "featuresRule", r.FeaturesRule)
	populate(objectMap, "identityManagement", r.IdentityManagement)
	populate(objectMap, "isPureProxy", r.IsPureProxy)
	populate(objectMap, "linkedAccessChecks", r.LinkedAccessChecks)
	populate(objectMap, "loggingRules", r.LoggingRules)
	populate(objectMap, "marketplaceType", r.MarketplaceType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "regionality", r.Regionality)
	populate(objectMap, "requestHeaderOptions", r.RequestHeaderOptions)
	populate(objectMap, "requiredFeatures", r.RequiredFeatures)
	populate(objectMap, "resourceDeletionPolicy", r.ResourceDeletionPolicy)
	populate(objectMap, "resourceMovePolicy", r.ResourceMovePolicy)
	populate(objectMap, "routingType", r.RoutingType)
	populate(objectMap, "serviceTreeInfos", r.ServiceTreeInfos)
	populate(objectMap, "subscriptionLifecycleNotificationSpecifications", r.SubscriptionLifecycleNotificationSpecifications)
	populate(objectMap, "subscriptionStateRules", r.SubscriptionStateRules)
	populate(objectMap, "swaggerSpecifications", r.SwaggerSpecifications)
	populate(objectMap, "templateDeploymentOptions", r.TemplateDeploymentOptions)
	populate(objectMap, "throttlingRules", r.ThrottlingRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesAutoGenerated.
func (r *ResourceTypeRegistrationPropertiesAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedUnauthorizedActions":
			err = unpopulate(val, "AllowedUnauthorizedActions", &r.AllowedUnauthorizedActions)
			delete(rawMsg, key)
		case "authorizationActionMappings":
			err = unpopulate(val, "AuthorizationActionMappings", &r.AuthorizationActionMappings)
			delete(rawMsg, key)
		case "checkNameAvailabilitySpecifications":
			err = unpopulate(val, "CheckNameAvailabilitySpecifications", &r.CheckNameAvailabilitySpecifications)
			delete(rawMsg, key)
		case "defaultApiVersion":
			err = unpopulate(val, "DefaultAPIVersion", &r.DefaultAPIVersion)
			delete(rawMsg, key)
		case "disallowedActionVerbs":
			err = unpopulate(val, "DisallowedActionVerbs", &r.DisallowedActionVerbs)
			delete(rawMsg, key)
		case "enableAsyncOperation":
			err = unpopulate(val, "EnableAsyncOperation", &r.EnableAsyncOperation)
			delete(rawMsg, key)
		case "enableThirdPartyS2S":
			err = unpopulate(val, "EnableThirdPartyS2S", &r.EnableThirdPartyS2S)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &r.Endpoints)
			delete(rawMsg, key)
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &r.ExtendedLocations)
			delete(rawMsg, key)
		case "extensionOptions":
			err = unpopulate(val, "ExtensionOptions", &r.ExtensionOptions)
			delete(rawMsg, key)
		case "featuresRule":
			err = unpopulate(val, "FeaturesRule", &r.FeaturesRule)
			delete(rawMsg, key)
		case "identityManagement":
			err = unpopulate(val, "IdentityManagement", &r.IdentityManagement)
			delete(rawMsg, key)
		case "isPureProxy":
			err = unpopulate(val, "IsPureProxy", &r.IsPureProxy)
			delete(rawMsg, key)
		case "linkedAccessChecks":
			err = unpopulate(val, "LinkedAccessChecks", &r.LinkedAccessChecks)
			delete(rawMsg, key)
		case "loggingRules":
			err = unpopulate(val, "LoggingRules", &r.LoggingRules)
			delete(rawMsg, key)
		case "marketplaceType":
			err = unpopulate(val, "MarketplaceType", &r.MarketplaceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "regionality":
			err = unpopulate(val, "Regionality", &r.Regionality)
			delete(rawMsg, key)
		case "requestHeaderOptions":
			err = unpopulate(val, "RequestHeaderOptions", &r.RequestHeaderOptions)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &r.RequiredFeatures)
			delete(rawMsg, key)
		case "resourceDeletionPolicy":
			err = unpopulate(val, "ResourceDeletionPolicy", &r.ResourceDeletionPolicy)
			delete(rawMsg, key)
		case "resourceMovePolicy":
			err = unpopulate(val, "ResourceMovePolicy", &r.ResourceMovePolicy)
			delete(rawMsg, key)
		case "routingType":
			err = unpopulate(val, "RoutingType", &r.RoutingType)
			delete(rawMsg, key)
		case "serviceTreeInfos":
			err = unpopulate(val, "ServiceTreeInfos", &r.ServiceTreeInfos)
			delete(rawMsg, key)
		case "subscriptionLifecycleNotificationSpecifications":
			err = unpopulate(val, "SubscriptionLifecycleNotificationSpecifications", &r.SubscriptionLifecycleNotificationSpecifications)
			delete(rawMsg, key)
		case "subscriptionStateRules":
			err = unpopulate(val, "SubscriptionStateRules", &r.SubscriptionStateRules)
			delete(rawMsg, key)
		case "swaggerSpecifications":
			err = unpopulate(val, "SwaggerSpecifications", &r.SwaggerSpecifications)
			delete(rawMsg, key)
		case "templateDeploymentOptions":
			err = unpopulate(val, "TemplateDeploymentOptions", &r.TemplateDeploymentOptions)
			delete(rawMsg, key)
		case "throttlingRules":
			err = unpopulate(val, "ThrottlingRules", &r.ThrottlingRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications.
func (r ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableDefaultValidation", r.EnableDefaultValidation)
	populate(objectMap, "resourceTypesWithCustomValidation", r.ResourceTypesWithCustomValidation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications.
func (r *ResourceTypeRegistrationPropertiesCheckNameAvailabilitySpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableDefaultValidation":
			err = unpopulate(val, "EnableDefaultValidation", &r.EnableDefaultValidation)
			delete(rawMsg, key)
		case "resourceTypesWithCustomValidation":
			err = unpopulate(val, "ResourceTypesWithCustomValidation", &r.ResourceTypesWithCustomValidation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesExtensionOptions.
func (r ResourceTypeRegistrationPropertiesExtensionOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceCreationBegin", r.ResourceCreationBegin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesExtensionOptions.
func (r *ResourceTypeRegistrationPropertiesExtensionOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceCreationBegin":
			err = unpopulate(val, "ResourceCreationBegin", &r.ResourceCreationBegin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesFeaturesRule.
func (r ResourceTypeRegistrationPropertiesFeaturesRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requiredFeaturesPolicy", r.RequiredFeaturesPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesFeaturesRule.
func (r *ResourceTypeRegistrationPropertiesFeaturesRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requiredFeaturesPolicy":
			err = unpopulate(val, "RequiredFeaturesPolicy", &r.RequiredFeaturesPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesIdentityManagement.
func (r ResourceTypeRegistrationPropertiesIdentityManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", r.ApplicationID)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesIdentityManagement.
func (r *ResourceTypeRegistrationPropertiesIdentityManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &r.ApplicationID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesRequestHeaderOptions.
func (r ResourceTypeRegistrationPropertiesRequestHeaderOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "optInHeaders", r.OptInHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesRequestHeaderOptions.
func (r *ResourceTypeRegistrationPropertiesRequestHeaderOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "optInHeaders":
			err = unpopulate(val, "OptInHeaders", &r.OptInHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesResourceMovePolicy.
func (r ResourceTypeRegistrationPropertiesResourceMovePolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "crossResourceGroupMoveEnabled", r.CrossResourceGroupMoveEnabled)
	populate(objectMap, "crossSubscriptionMoveEnabled", r.CrossSubscriptionMoveEnabled)
	populate(objectMap, "validationRequired", r.ValidationRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesResourceMovePolicy.
func (r *ResourceTypeRegistrationPropertiesResourceMovePolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "crossResourceGroupMoveEnabled":
			err = unpopulate(val, "CrossResourceGroupMoveEnabled", &r.CrossResourceGroupMoveEnabled)
			delete(rawMsg, key)
		case "crossSubscriptionMoveEnabled":
			err = unpopulate(val, "CrossSubscriptionMoveEnabled", &r.CrossSubscriptionMoveEnabled)
			delete(rawMsg, key)
		case "validationRequired":
			err = unpopulate(val, "ValidationRequired", &r.ValidationRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.
func (r ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "softDeleteTTL", r.SoftDeleteTTL)
	populate(objectMap, "subscriptionStateOverrideActions", r.SubscriptionStateOverrideActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications.
func (r *ResourceTypeRegistrationPropertiesSubscriptionLifecycleNotificationSpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "softDeleteTTL":
			err = unpopulate(val, "SoftDeleteTTL", &r.SoftDeleteTTL)
			delete(rawMsg, key)
		case "subscriptionStateOverrideActions":
			err = unpopulate(val, "SubscriptionStateOverrideActions", &r.SubscriptionStateOverrideActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRegistrationPropertiesTemplateDeploymentOptions.
func (r ResourceTypeRegistrationPropertiesTemplateDeploymentOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preflightOptions", r.PreflightOptions)
	populate(objectMap, "preflightSupported", r.PreflightSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRegistrationPropertiesTemplateDeploymentOptions.
func (r *ResourceTypeRegistrationPropertiesTemplateDeploymentOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preflightOptions":
			err = unpopulate(val, "PreflightOptions", &r.PreflightOptions)
			delete(rawMsg, key)
		case "preflightSupported":
			err = unpopulate(val, "PreflightSupported", &r.PreflightSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeRequestHeaderOptions.
func (r ResourceTypeRequestHeaderOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "optInHeaders", r.OptInHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeRequestHeaderOptions.
func (r *ResourceTypeRequestHeaderOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "optInHeaders":
			err = unpopulate(val, "OptInHeaders", &r.OptInHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeSKU.
func (r ResourceTypeSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "skuSettings", r.SKUSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeSKU.
func (r *ResourceTypeSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "skuSettings":
			err = unpopulate(val, "SKUSettings", &r.SKUSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceTypeTemplateDeploymentPolicy.
func (r ResourceTypeTemplateDeploymentPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", r.Capabilities)
	populate(objectMap, "preflightOptions", r.PreflightOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceTypeTemplateDeploymentPolicy.
func (r *ResourceTypeTemplateDeploymentPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &r.Capabilities)
			delete(rawMsg, key)
		case "preflightOptions":
			err = unpopulate(val, "PreflightOptions", &r.PreflightOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RolloutStatusBase.
func (r RolloutStatusBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "completedRegions", r.CompletedRegions)
	populate(objectMap, "failedOrSkippedRegions", r.FailedOrSkippedRegions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RolloutStatusBase.
func (r *RolloutStatusBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedRegions":
			err = unpopulate(val, "CompletedRegions", &r.CompletedRegions)
			delete(rawMsg, key)
		case "failedOrSkippedRegions":
			err = unpopulate(val, "FailedOrSkippedRegions", &r.FailedOrSkippedRegions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapability.
func (s SKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapability.
func (s *SKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCost.
func (s SKUCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedUnit", s.ExtendedUnit)
	populate(objectMap, "meterId", s.MeterID)
	populate(objectMap, "quantity", s.Quantity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCost.
func (s *SKUCost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedUnit":
			err = unpopulate(val, "ExtendedUnit", &s.ExtendedUnit)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &s.MeterID)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &s.Quantity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKULocationInfo.
func (s SKULocationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocations", s.ExtendedLocations)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "zoneDetails", s.ZoneDetails)
	populate(objectMap, "zones", s.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKULocationInfo.
func (s *SKULocationInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocations":
			err = unpopulate(val, "ExtendedLocations", &s.ExtendedLocations)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "zoneDetails":
			err = unpopulate(val, "ZoneDetails", &s.ZoneDetails)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &s.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUResource.
func (s SKUResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUResource.
func (s *SKUResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUResourceArrayResponseWithContinuation.
func (s SKUResourceArrayResponseWithContinuation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUResourceArrayResponseWithContinuation.
func (s *SKUResourceArrayResponseWithContinuation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUResourceProperties.
func (s SKUResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "skuSettings", s.SKUSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUResourceProperties.
func (s *SKUResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "skuSettings":
			err = unpopulate(val, "SKUSettings", &s.SKUSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUSetting.
func (s SKUSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "costs", s.Costs)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "locationInfo", s.LocationInfo)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "requiredFeatures", s.RequiredFeatures)
	populate(objectMap, "requiredQuotaIds", s.RequiredQuotaIDs)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUSetting.
func (s *SKUSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "costs":
			err = unpopulate(val, "Costs", &s.Costs)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "locationInfo":
			err = unpopulate(val, "LocationInfo", &s.LocationInfo)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &s.RequiredFeatures)
			delete(rawMsg, key)
		case "requiredQuotaIds":
			err = unpopulate(val, "RequiredQuotaIDs", &s.RequiredQuotaIDs)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUSettingCapacity.
func (s SKUSettingCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUSettingCapacity.
func (s *SKUSettingCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUZoneDetail.
func (s SKUZoneDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", s.Capabilities)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUZoneDetail.
func (s *SKUZoneDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &s.Capabilities)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceTreeInfo.
func (s ServiceTreeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", s.ComponentID)
	populate(objectMap, "serviceId", s.ServiceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceTreeInfo.
func (s *ServiceTreeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &s.ComponentID)
			delete(rawMsg, key)
		case "serviceId":
			err = unpopulate(val, "ServiceID", &s.ServiceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionLifecycleNotificationSpecifications.
func (s SubscriptionLifecycleNotificationSpecifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "softDeleteTTL", s.SoftDeleteTTL)
	populate(objectMap, "subscriptionStateOverrideActions", s.SubscriptionStateOverrideActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionLifecycleNotificationSpecifications.
func (s *SubscriptionLifecycleNotificationSpecifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "softDeleteTTL":
			err = unpopulate(val, "SoftDeleteTTL", &s.SoftDeleteTTL)
			delete(rawMsg, key)
		case "subscriptionStateOverrideActions":
			err = unpopulate(val, "SubscriptionStateOverrideActions", &s.SubscriptionStateOverrideActions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionStateOverrideAction.
func (s SubscriptionStateOverrideAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", s.Action)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionStateOverrideAction.
func (s *SubscriptionStateOverrideAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &s.Action)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionStateRule.
func (s SubscriptionStateRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedActions", s.AllowedActions)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionStateRule.
func (s *SubscriptionStateRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &s.AllowedActions)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwaggerSpecification.
func (s SwaggerSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersions", s.APIVersions)
	populate(objectMap, "swaggerSpecFolderUri", s.SwaggerSpecFolderURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwaggerSpecification.
func (s *SwaggerSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersions":
			err = unpopulate(val, "APIVersions", &s.APIVersions)
			delete(rawMsg, key)
		case "swaggerSpecFolderUri":
			err = unpopulate(val, "SwaggerSpecFolderURI", &s.SwaggerSpecFolderURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TemplateDeploymentOptions.
func (t TemplateDeploymentOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preflightOptions", t.PreflightOptions)
	populate(objectMap, "preflightSupported", t.PreflightSupported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TemplateDeploymentOptions.
func (t *TemplateDeploymentOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preflightOptions":
			err = unpopulate(val, "PreflightOptions", &t.PreflightOptions)
			delete(rawMsg, key)
		case "preflightSupported":
			err = unpopulate(val, "PreflightSupported", &t.PreflightSupported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TemplateDeploymentPolicy.
func (t TemplateDeploymentPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", t.Capabilities)
	populate(objectMap, "preflightOptions", t.PreflightOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TemplateDeploymentPolicy.
func (t *TemplateDeploymentPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &t.Capabilities)
			delete(rawMsg, key)
		case "preflightOptions":
			err = unpopulate(val, "PreflightOptions", &t.PreflightOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThirdPartyProviderAuthorization.
func (t ThirdPartyProviderAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizations", t.Authorizations)
	populate(objectMap, "managedByTenantId", t.ManagedByTenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThirdPartyProviderAuthorization.
func (t *ThirdPartyProviderAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizations":
			err = unpopulate(val, "Authorizations", &t.Authorizations)
			delete(rawMsg, key)
		case "managedByTenantId":
			err = unpopulate(val, "ManagedByTenantID", &t.ManagedByTenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThrottlingMetric.
func (t ThrottlingMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interval", t.Interval)
	populate(objectMap, "limit", t.Limit)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThrottlingMetric.
func (t *ThrottlingMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interval":
			err = unpopulate(val, "Interval", &t.Interval)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &t.Limit)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThrottlingRule.
func (t ThrottlingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", t.Action)
	populate(objectMap, "metrics", t.Metrics)
	populate(objectMap, "requiredFeatures", t.RequiredFeatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThrottlingRule.
func (t *ThrottlingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &t.Action)
			delete(rawMsg, key)
		case "metrics":
			err = unpopulate(val, "Metrics", &t.Metrics)
			delete(rawMsg, key)
		case "requiredFeatures":
			err = unpopulate(val, "RequiredFeatures", &t.RequiredFeatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficRegionRolloutConfiguration.
func (t TrafficRegionRolloutConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", t.Regions)
	populate(objectMap, "waitDuration", t.WaitDuration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficRegionRolloutConfiguration.
func (t *TrafficRegionRolloutConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &t.Regions)
			delete(rawMsg, key)
		case "waitDuration":
			err = unpopulate(val, "WaitDuration", &t.WaitDuration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrafficRegions.
func (t TrafficRegions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "regions", t.Regions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrafficRegions.
func (t *TrafficRegions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "regions":
			err = unpopulate(val, "Regions", &t.Regions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TypedErrorInfo.
func (t TypedErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", t.Info)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TypedErrorInfo.
func (t *TypedErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &t.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
