//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/recoveryservices/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/CheckNameAvailability_Available.json
func ExampleClient_CheckNameAvailability_availabilityStatusOfResourceNameWhenNoResourceWithSameNameTypeAndSubscriptionExistsNorHasBeenDeletedWithinLast24Hours() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().CheckNameAvailability(ctx, "resGroupFoo", "westus", armrecoveryservices.CheckNameAvailabilityParameters{
		Name: to.Ptr("swaggerExample"),
		Type: to.Ptr("Microsoft.RecoveryServices/Vaults"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armrecoveryservices.CheckNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/recoveryservices/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/CheckNameAvailability_NotAvailable.json
func ExampleClient_CheckNameAvailability_availabilityStatusOfResourceNameWhenResourceWithSameNameTypeAndSubscriptionExists() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().CheckNameAvailability(ctx, "resGroupBar", "westus", armrecoveryservices.CheckNameAvailabilityParameters{
		Name: to.Ptr("swaggerExample2"),
		Type: to.Ptr("Microsoft.RecoveryServices/Vaults"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armrecoveryservices.CheckNameAvailabilityResult{
	// 	Message: to.Ptr("Resource already exists with the same name."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/recoveryservices/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/Capabilities.json
func ExampleClient_Capabilities() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservices.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Capabilities(ctx, "westus", armrecoveryservices.ResourceCapabilities{
		Type: to.Ptr("Microsoft.RecoveryServices/Vaults"),
		Properties: &armrecoveryservices.CapabilitiesProperties{
			DNSZones: []*armrecoveryservices.DNSZone{
				{
					SubResource: to.Ptr(armrecoveryservices.VaultSubResourceTypeAzureBackup),
				},
				{
					SubResource: to.Ptr(armrecoveryservices.VaultSubResourceTypeAzureSiteRecovery),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CapabilitiesResponse = armrecoveryservices.CapabilitiesResponse{
	// 	Type: to.Ptr("Microsoft.RecoveryServices/Vaults"),
	// 	Properties: &armrecoveryservices.CapabilitiesResponseProperties{
	// 		DNSZones: []*armrecoveryservices.DNSZoneResponse{
	// 			{
	// 				SubResource: to.Ptr(armrecoveryservices.VaultSubResourceTypeAzureBackup),
	// 				RequiredZoneNames: []*string{
	// 					to.Ptr("privatelink.wus.backup.windowsazure.com"),
	// 					to.Ptr("privatelink.queue.core.windows.net"),
	// 					to.Ptr("privatelink.blob.core.windows.net")},
	// 				},
	// 				{
	// 					SubResource: to.Ptr(armrecoveryservices.VaultSubResourceTypeAzureSiteRecovery),
	// 					RequiredZoneNames: []*string{
	// 						to.Ptr("privatelink.siterecovery.windowsazure.com")},
	// 				}},
	// 			},
	// 		}
}
