//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getComputeOneSkuUsages.json
func ExampleQuotaClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewQuotaClient().Get(ctx, "00000000-0000-0000-0000-000000000000", "Microsoft.Compute", "eastus", "standardNDSFamily", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armreservations.CurrentQuotaLimitBase{
	// 	Properties: &armreservations.QuotaProperties{
	// 		Name: &armreservations.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard NDS Family vCPUs"),
	// 			Value: to.Ptr("standardNDSFamily"),
	// 		},
	// 		CurrentValue: to.Ptr[int32](0),
	// 		Limit: to.Ptr[int32](10),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/putComputeOneSkuQuotaRequest.json
func ExampleQuotaClient_BeginCreateOrUpdate_quotasRequestPutForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewQuotaClient().BeginCreateOrUpdate(ctx, "D7EC67B3-7657-4966-BFFC-41EFD36BAAB3", "Microsoft.Compute", "eastus", "standardFSv2Family", armreservations.CurrentQuotaLimitBase{
		Properties: &armreservations.QuotaProperties{
			Name: &armreservations.ResourceName{
				Value: to.Ptr("standardFSv2Family"),
			},
			Limit: to.Ptr[int32](200),
			Unit:  to.Ptr("Count"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armreservations.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Capacity/serviceLimits"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Capacity/resourceProviders/Microsoft.Compute/locations/eastus/serviceLimitsRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armreservations.QuotaProperties{
	// 		Name: &armreservations.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard FSv2 Family vCPUs"),
	// 			Value: to.Ptr("standardFSv2Family"),
	// 		},
	// 		CurrentValue: to.Ptr[int32](160),
	// 		Limit: to.Ptr[int32](200),
	// 		Properties: map[string]any{
	// 		},
	// 		QuotaPeriod: to.Ptr(""),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/putMachineLearningServicesQuotaRequestDedicated.json
func ExampleQuotaClient_BeginCreateOrUpdate_quotasRequestPutForMachineLearningServicesDedicatedResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewQuotaClient().BeginCreateOrUpdate(ctx, "D7EC67B3-7657-4966-BFFC-41EFD36BAAB3", "Microsoft.MachineLearningServices", "eastus", "StandardDv2Family", armreservations.CurrentQuotaLimitBase{
		Properties: &armreservations.QuotaProperties{
			Name: &armreservations.ResourceName{
				Value: to.Ptr("StandardDv2Family"),
			},
			Limit:        to.Ptr[int32](200),
			ResourceType: to.Ptr(armreservations.ResourceTypeDedicated),
			Unit:         to.Ptr("Count"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armreservations.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Capacity/serviceLimits"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Capacity/resourceProviders/Microsoft.MachineLearningServices/locations/eastus/serviceLimitsRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armreservations.QuotaProperties{
	// 		Name: &armreservations.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard Dv2 Family Cluster Dedicated vCPUs"),
	// 			Value: to.Ptr("StandardDv2Family"),
	// 		},
	// 		CurrentValue: to.Ptr[int32](160),
	// 		Limit: to.Ptr[int32](200),
	// 		Properties: map[string]any{
	// 		},
	// 		QuotaPeriod: to.Ptr(""),
	// 		ResourceType: to.Ptr(armreservations.ResourceTypeDedicated),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/putMachineLearningServicesQuotaRequestLowPriority.json
func ExampleQuotaClient_BeginCreateOrUpdate_quotasRequestPutForMachineLearningServicesLowPriorityResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewQuotaClient().BeginCreateOrUpdate(ctx, "D7EC67B3-7657-4966-BFFC-41EFD36BAAB3", "Microsoft.MachineLearningServices", "eastus", "TotalLowPriorityCores", armreservations.CurrentQuotaLimitBase{
		Properties: &armreservations.QuotaProperties{
			Name: &armreservations.ResourceName{
				Value: to.Ptr("TotalLowPriorityCores"),
			},
			Limit:        to.Ptr[int32](200),
			ResourceType: to.Ptr(armreservations.ResourceTypeLowPriority),
			Unit:         to.Ptr("Count"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armreservations.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Capacity/serviceLimits"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Capacity/resourceProviders/Microsoft.MachineLearningServices/locations/eastus/serviceLimitsRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armreservations.QuotaProperties{
	// 		Name: &armreservations.ResourceName{
	// 			LocalizedValue: to.Ptr("Total Cluster Low Priority Regional vCPUs"),
	// 			Value: to.Ptr("TotalLowPriorityCores"),
	// 		},
	// 		CurrentValue: to.Ptr[int32](160),
	// 		Limit: to.Ptr[int32](200),
	// 		Properties: map[string]any{
	// 		},
	// 		QuotaPeriod: to.Ptr(""),
	// 		ResourceType: to.Ptr(armreservations.ResourceTypeLowPriority),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/patchComputeQuotaRequest.json
func ExampleQuotaClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewQuotaClient().BeginUpdate(ctx, "D7EC67B3-7657-4966-BFFC-41EFD36BAAB3", "Microsoft.Compute", "eastus", "standardFSv2Family", armreservations.CurrentQuotaLimitBase{
		Properties: &armreservations.QuotaProperties{
			Name: &armreservations.ResourceName{
				Value: to.Ptr("standardFSv2Family"),
			},
			Limit: to.Ptr[int32](200),
			Unit:  to.Ptr("Count"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armreservations.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Capacity/serviceLimits"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Capacity/resourceProviders/Microsoft.Compute/locations/eastus/serviceLimitsRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armreservations.QuotaProperties{
	// 		Name: &armreservations.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard FSv2 Family vCPUs"),
	// 			Value: to.Ptr("standardFSv2Family"),
	// 		},
	// 		CurrentValue: to.Ptr[int32](160),
	// 		Limit: to.Ptr[int32](200),
	// 		Properties: map[string]any{
	// 		},
	// 		QuotaPeriod: to.Ptr(""),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getComputeUsages.json
func ExampleQuotaClient_NewListPager_quotasListUsagesForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewQuotaClient().NewListPager("00000000-0000-0000-0000-000000000000", "Microsoft.Compute", "eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.QuotaLimits = armreservations.QuotaLimits{
		// 	Value: []*armreservations.CurrentQuotaLimitBase{
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard FSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardFSv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](100),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NDS Family vCPUs"),
		// 					Value: to.Ptr("standardNDSFamily"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](0),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NCSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardNCSv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](0),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NCSv3 Family vCPUs"),
		// 					Value: to.Ptr("standardNCSv3Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](0),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard LSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardLSv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](100),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard PBS Family vCPUs"),
		// 					Value: to.Ptr("standardPBSFamily"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](6),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard EIv3 Family vCPUs"),
		// 					Value: to.Ptr("standardEIv3Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](100),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard EISv3 Family vCPUs"),
		// 					Value: to.Ptr("standardEISv3Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](100),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard DCS Family vCPUs"),
		// 					Value: to.Ptr("standardDCSFamily"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](8),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NVSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardNVSv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](0),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard MSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardMSv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](0),
		// 				Limit: to.Ptr[int32](0),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getMachineLearningServicesUsages.json
func ExampleQuotaClient_NewListPager_quotasListUsagesMachineLearningServices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewQuotaClient().NewListPager("00000000-0000-0000-0000-000000000000", "Microsoft.MachineLearningServices", "eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.QuotaLimits = armreservations.QuotaLimits{
		// 	Value: []*armreservations.CurrentQuotaLimitBase{
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard Dv2 Family vCPUs"),
		// 					Value: to.Ptr("standardDv2Family"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](15),
		// 				Limit: to.Ptr[int32](20),
		// 				ResourceType: to.Ptr(armreservations.ResourceTypeDedicated),
		// 			},
		// 		},
		// 		{
		// 			Properties: &armreservations.QuotaProperties{
		// 				Name: &armreservations.ResourceName{
		// 					LocalizedValue: to.Ptr("Total Regional Low-priority vCPUs"),
		// 					Value: to.Ptr("totalLowPriorityCores"),
		// 				},
		// 				CurrentValue: to.Ptr[int32](49),
		// 				Limit: to.Ptr[int32](600),
		// 				ResourceType: to.Ptr(armreservations.ResourceTypeLowPriority),
		// 			},
		// 	}},
		// }
	}
}
