//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// SensitivitySettingsClient contains the methods for the SensitivitySettings group.
// Don't use this type directly, use NewSensitivitySettingsClient() instead.
type SensitivitySettingsClient struct {
	internal *arm.Client
}

// NewSensitivitySettingsClient creates a new instance of SensitivitySettingsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSensitivitySettingsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SensitivitySettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SensitivitySettingsClient{
		internal: cl,
	}
	return client, nil
}

// List - Gets a list with a single sensitivity settings resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-15-preview
//   - options - SensitivitySettingsClientListOptions contains the optional parameters for the SensitivitySettingsClient.List
//     method.
func (client *SensitivitySettingsClient) List(ctx context.Context, options *SensitivitySettingsClientListOptions) (SensitivitySettingsClientListResponse, error) {
	var err error
	const operationName = "SensitivitySettingsClient.List"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCreateRequest(ctx, options)
	if err != nil {
		return SensitivitySettingsClientListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SensitivitySettingsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SensitivitySettingsClientListResponse{}, err
	}
	resp, err := client.listHandleResponse(httpResp)
	return resp, err
}

// listCreateRequest creates the List request.
func (client *SensitivitySettingsClient) listCreateRequest(ctx context.Context, options *SensitivitySettingsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Security/sensitivitySettings"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-02-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SensitivitySettingsClient) listHandleResponse(resp *http.Response) (SensitivitySettingsClientListResponse, error) {
	result := SensitivitySettingsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GetSensitivitySettingsListResponse); err != nil {
		return SensitivitySettingsClientListResponse{}, err
	}
	return result, nil
}
