//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurityinsights

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AADDataConnector.
func (a AADDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = DataConnectorKindAzureActiveDirectory
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADDataConnector.
func (a *AADDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AADDataConnectorProperties.
func (a AADDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", a.DataTypes)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AADDataConnectorProperties.
func (a *AADDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AATPDataConnector.
func (a AATPDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = DataConnectorKindAzureAdvancedThreatProtection
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AATPDataConnector.
func (a *AATPDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AATPDataConnectorProperties.
func (a AATPDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", a.DataTypes)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AATPDataConnectorProperties.
func (a *AATPDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ASCDataConnector.
func (a ASCDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = DataConnectorKindAzureSecurityCenter
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ASCDataConnector.
func (a *ASCDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ASCDataConnectorProperties.
func (a ASCDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", a.DataTypes)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ASCDataConnectorProperties.
func (a *ASCDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountEntity.
func (a AccountEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = EntityKindEnumAccount
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountEntity.
func (a *AccountEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountEntityProperties.
func (a AccountEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadTenantId", a.AADTenantID)
	populate(objectMap, "aadUserId", a.AADUserID)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "additionalData", a.AdditionalData)
	populate(objectMap, "dnsDomain", a.DNSDomain)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "hostEntityId", a.HostEntityID)
	populate(objectMap, "isDomainJoined", a.IsDomainJoined)
	populate(objectMap, "ntDomain", a.NtDomain)
	populate(objectMap, "objectGuid", a.ObjectGUID)
	populate(objectMap, "puid", a.Puid)
	populate(objectMap, "sid", a.Sid)
	populate(objectMap, "upnSuffix", a.UpnSuffix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountEntityProperties.
func (a *AccountEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadTenantId":
			err = unpopulate(val, "AADTenantID", &a.AADTenantID)
			delete(rawMsg, key)
		case "aadUserId":
			err = unpopulate(val, "AADUserID", &a.AADUserID)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &a.AdditionalData)
			delete(rawMsg, key)
		case "dnsDomain":
			err = unpopulate(val, "DNSDomain", &a.DNSDomain)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "hostEntityId":
			err = unpopulate(val, "HostEntityID", &a.HostEntityID)
			delete(rawMsg, key)
		case "isDomainJoined":
			err = unpopulate(val, "IsDomainJoined", &a.IsDomainJoined)
			delete(rawMsg, key)
		case "ntDomain":
			err = unpopulate(val, "NtDomain", &a.NtDomain)
			delete(rawMsg, key)
		case "objectGuid":
			err = unpopulate(val, "ObjectGUID", &a.ObjectGUID)
			delete(rawMsg, key)
		case "puid":
			err = unpopulate(val, "Puid", &a.Puid)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "Sid", &a.Sid)
			delete(rawMsg, key)
		case "upnSuffix":
			err = unpopulate(val, "UpnSuffix", &a.UpnSuffix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionRequest.
func (a ActionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionRequest.
func (a *ActionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionRequestProperties.
func (a ActionRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logicAppResourceId", a.LogicAppResourceID)
	populate(objectMap, "triggerUri", a.TriggerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionRequestProperties.
func (a *ActionRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logicAppResourceId":
			err = unpopulate(val, "LogicAppResourceID", &a.LogicAppResourceID)
			delete(rawMsg, key)
		case "triggerUri":
			err = unpopulate(val, "TriggerURI", &a.TriggerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionResponse.
func (a ActionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionResponse.
func (a *ActionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionResponseProperties.
func (a ActionResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logicAppResourceId", a.LogicAppResourceID)
	populate(objectMap, "workflowId", a.WorkflowID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionResponseProperties.
func (a *ActionResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logicAppResourceId":
			err = unpopulate(val, "LogicAppResourceID", &a.LogicAppResourceID)
			delete(rawMsg, key)
		case "workflowId":
			err = unpopulate(val, "WorkflowID", &a.WorkflowID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActionsList.
func (a ActionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActionsList.
func (a *ActionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertDetailsOverride.
func (a AlertDetailsOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertDescriptionFormat", a.AlertDescriptionFormat)
	populate(objectMap, "alertDisplayNameFormat", a.AlertDisplayNameFormat)
	populate(objectMap, "alertSeverityColumnName", a.AlertSeverityColumnName)
	populate(objectMap, "alertTacticsColumnName", a.AlertTacticsColumnName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertDetailsOverride.
func (a *AlertDetailsOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertDescriptionFormat":
			err = unpopulate(val, "AlertDescriptionFormat", &a.AlertDescriptionFormat)
			delete(rawMsg, key)
		case "alertDisplayNameFormat":
			err = unpopulate(val, "AlertDisplayNameFormat", &a.AlertDisplayNameFormat)
			delete(rawMsg, key)
		case "alertSeverityColumnName":
			err = unpopulate(val, "AlertSeverityColumnName", &a.AlertSeverityColumnName)
			delete(rawMsg, key)
		case "alertTacticsColumnName":
			err = unpopulate(val, "AlertTacticsColumnName", &a.AlertTacticsColumnName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertRule.
func (a AlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = a.Kind
	populate(objectMap, "name", a.Name)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRule.
func (a *AlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleTemplate.
func (a AlertRuleTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = a.Kind
	populate(objectMap, "name", a.Name)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRuleTemplate.
func (a *AlertRuleTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleTemplateDataSource.
func (a AlertRuleTemplateDataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectorId", a.ConnectorID)
	populate(objectMap, "dataTypes", a.DataTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRuleTemplateDataSource.
func (a *AlertRuleTemplateDataSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectorId":
			err = unpopulate(val, "ConnectorID", &a.ConnectorID)
			delete(rawMsg, key)
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertRuleTemplatesList.
func (a AlertRuleTemplatesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRuleTemplatesList.
func (a *AlertRuleTemplatesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalAlertRuleTemplateClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertRulesList.
func (a AlertRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertRulesList.
func (a *AlertRulesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			a.Value, err = unmarshalAlertRuleClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertsDataTypeOfDataConnector.
func (a AlertsDataTypeOfDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alerts", a.Alerts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertsDataTypeOfDataConnector.
func (a *AlertsDataTypeOfDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alerts":
			err = unpopulate(val, "Alerts", &a.Alerts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRule.
func (a AutomationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRule.
func (a *AutomationRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleAction.
func (a AutomationRuleAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["actionType"] = a.ActionType
	populate(objectMap, "order", a.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleAction.
func (a *AutomationRuleAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &a.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleCondition.
func (a AutomationRuleCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["conditionType"] = a.ConditionType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleCondition.
func (a *AutomationRuleCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditionType":
			err = unpopulate(val, "ConditionType", &a.ConditionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleModifyPropertiesAction.
func (a AutomationRuleModifyPropertiesAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionConfiguration", a.ActionConfiguration)
	objectMap["actionType"] = ActionTypeModifyProperties
	populate(objectMap, "order", a.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleModifyPropertiesAction.
func (a *AutomationRuleModifyPropertiesAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionConfiguration":
			err = unpopulate(val, "ActionConfiguration", &a.ActionConfiguration)
			delete(rawMsg, key)
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &a.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleProperties.
func (a AutomationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", a.Actions)
	populate(objectMap, "createdBy", a.CreatedBy)
	populateDateTimeRFC3339(objectMap, "createdTimeUtc", a.CreatedTimeUTC)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "lastModifiedBy", a.LastModifiedBy)
	populateDateTimeRFC3339(objectMap, "lastModifiedTimeUtc", a.LastModifiedTimeUTC)
	populate(objectMap, "order", a.Order)
	populate(objectMap, "triggeringLogic", a.TriggeringLogic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleProperties.
func (a *AutomationRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			a.Actions, err = unmarshalAutomationRuleActionClassificationArray(val)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &a.CreatedBy)
			delete(rawMsg, key)
		case "createdTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimeUTC", &a.CreatedTimeUTC)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &a.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTimeUTC", &a.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &a.Order)
			delete(rawMsg, key)
		case "triggeringLogic":
			err = unpopulate(val, "TriggeringLogic", &a.TriggeringLogic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRulePropertyValuesCondition.
func (a AutomationRulePropertyValuesCondition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operator", a.Operator)
	populate(objectMap, "propertyName", a.PropertyName)
	populate(objectMap, "propertyValues", a.PropertyValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRulePropertyValuesCondition.
func (a *AutomationRulePropertyValuesCondition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operator":
			err = unpopulate(val, "Operator", &a.Operator)
			delete(rawMsg, key)
		case "propertyName":
			err = unpopulate(val, "PropertyName", &a.PropertyName)
			delete(rawMsg, key)
		case "propertyValues":
			err = unpopulate(val, "PropertyValues", &a.PropertyValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleRunPlaybookAction.
func (a AutomationRuleRunPlaybookAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionConfiguration", a.ActionConfiguration)
	objectMap["actionType"] = ActionTypeRunPlaybook
	populate(objectMap, "order", a.Order)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleRunPlaybookAction.
func (a *AutomationRuleRunPlaybookAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionConfiguration":
			err = unpopulate(val, "ActionConfiguration", &a.ActionConfiguration)
			delete(rawMsg, key)
		case "actionType":
			err = unpopulate(val, "ActionType", &a.ActionType)
			delete(rawMsg, key)
		case "order":
			err = unpopulate(val, "Order", &a.Order)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRuleTriggeringLogic.
func (a AutomationRuleTriggeringLogic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conditions", a.Conditions)
	populateDateTimeRFC3339(objectMap, "expirationTimeUtc", a.ExpirationTimeUTC)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "triggersOn", a.TriggersOn)
	populate(objectMap, "triggersWhen", a.TriggersWhen)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRuleTriggeringLogic.
func (a *AutomationRuleTriggeringLogic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditions":
			a.Conditions, err = unmarshalAutomationRuleConditionClassificationArray(val)
			delete(rawMsg, key)
		case "expirationTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTimeUTC", &a.ExpirationTimeUTC)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &a.IsEnabled)
			delete(rawMsg, key)
		case "triggersOn":
			err = unpopulate(val, "TriggersOn", &a.TriggersOn)
			delete(rawMsg, key)
		case "triggersWhen":
			err = unpopulate(val, "TriggersWhen", &a.TriggersWhen)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutomationRulesList.
func (a AutomationRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRulesList.
func (a *AutomationRulesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsCloudTrailDataConnector.
func (a AwsCloudTrailDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = DataConnectorKindAmazonWebServicesCloudTrail
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsCloudTrailDataConnector.
func (a *AwsCloudTrailDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsCloudTrailDataConnectorDataTypes.
func (a AwsCloudTrailDataConnectorDataTypes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logs", a.Logs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsCloudTrailDataConnectorDataTypes.
func (a *AwsCloudTrailDataConnectorDataTypes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logs":
			err = unpopulate(val, "Logs", &a.Logs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsCloudTrailDataConnectorDataTypesLogs.
func (a AwsCloudTrailDataConnectorDataTypesLogs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", a.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsCloudTrailDataConnectorDataTypesLogs.
func (a *AwsCloudTrailDataConnectorDataTypesLogs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AwsCloudTrailDataConnectorProperties.
func (a AwsCloudTrailDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "awsRoleArn", a.AwsRoleArn)
	populate(objectMap, "dataTypes", a.DataTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AwsCloudTrailDataConnectorProperties.
func (a *AwsCloudTrailDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "awsRoleArn":
			err = unpopulate(val, "AwsRoleArn", &a.AwsRoleArn)
			delete(rawMsg, key)
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &a.DataTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceEntity.
func (a AzureResourceEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = EntityKindEnumAzureResource
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceEntity.
func (a *AzureResourceEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResourceEntityProperties.
func (a AzureResourceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", a.AdditionalData)
	populate(objectMap, "friendlyName", a.FriendlyName)
	populate(objectMap, "resourceId", a.ResourceID)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResourceEntityProperties.
func (a *AzureResourceEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &a.AdditionalData)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Bookmark.
func (b Bookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Bookmark.
func (b *Bookmark) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BookmarkList.
func (b BookmarkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BookmarkList.
func (b *BookmarkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BookmarkProperties.
func (b BookmarkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "created", b.Created)
	populate(objectMap, "createdBy", b.CreatedBy)
	populate(objectMap, "displayName", b.DisplayName)
	populateDateTimeRFC3339(objectMap, "eventTime", b.EventTime)
	populate(objectMap, "incidentInfo", b.IncidentInfo)
	populate(objectMap, "labels", b.Labels)
	populate(objectMap, "notes", b.Notes)
	populate(objectMap, "query", b.Query)
	populateDateTimeRFC3339(objectMap, "queryEndTime", b.QueryEndTime)
	populate(objectMap, "queryResult", b.QueryResult)
	populateDateTimeRFC3339(objectMap, "queryStartTime", b.QueryStartTime)
	populateDateTimeRFC3339(objectMap, "updated", b.Updated)
	populate(objectMap, "updatedBy", b.UpdatedBy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BookmarkProperties.
func (b *BookmarkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &b.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &b.CreatedBy)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &b.DisplayName)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateDateTimeRFC3339(val, "EventTime", &b.EventTime)
			delete(rawMsg, key)
		case "incidentInfo":
			err = unpopulate(val, "IncidentInfo", &b.IncidentInfo)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &b.Labels)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &b.Notes)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &b.Query)
			delete(rawMsg, key)
		case "queryEndTime":
			err = unpopulateDateTimeRFC3339(val, "QueryEndTime", &b.QueryEndTime)
			delete(rawMsg, key)
		case "queryResult":
			err = unpopulate(val, "QueryResult", &b.QueryResult)
			delete(rawMsg, key)
		case "queryStartTime":
			err = unpopulateDateTimeRFC3339(val, "QueryStartTime", &b.QueryStartTime)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &b.Updated)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &b.UpdatedBy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClientInfo.
func (c ClientInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", c.Email)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "objectId", c.ObjectID)
	populate(objectMap, "userPrincipalName", c.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientInfo.
func (c *ClientInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &c.Email)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &c.ObjectID)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &c.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplicationEntity.
func (c CloudApplicationEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = EntityKindEnumCloudApplication
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplicationEntity.
func (c *CloudApplicationEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplicationEntityProperties.
func (c CloudApplicationEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", c.AdditionalData)
	populate(objectMap, "appId", c.AppID)
	populate(objectMap, "appName", c.AppName)
	populate(objectMap, "friendlyName", c.FriendlyName)
	populate(objectMap, "instanceName", c.InstanceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplicationEntityProperties.
func (c *CloudApplicationEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &c.AdditionalData)
			delete(rawMsg, key)
		case "appId":
			err = unpopulate(val, "AppID", &c.AppID)
			delete(rawMsg, key)
		case "appName":
			err = unpopulate(val, "AppName", &c.AppName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &c.FriendlyName)
			delete(rawMsg, key)
		case "instanceName":
			err = unpopulate(val, "InstanceName", &c.InstanceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSEntity.
func (d DNSEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = EntityKindEnumDNSResolution
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSEntity.
func (d *DNSEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSEntityProperties.
func (d DNSEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", d.AdditionalData)
	populate(objectMap, "dnsServerIpEntityId", d.DNSServerIPEntityID)
	populate(objectMap, "domainName", d.DomainName)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "hostIpAddressEntityId", d.HostIPAddressEntityID)
	populate(objectMap, "ipAddressEntityIds", d.IPAddressEntityIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSEntityProperties.
func (d *DNSEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &d.AdditionalData)
			delete(rawMsg, key)
		case "dnsServerIpEntityId":
			err = unpopulate(val, "DNSServerIPEntityID", &d.DNSServerIPEntityID)
			delete(rawMsg, key)
		case "domainName":
			err = unpopulate(val, "DomainName", &d.DomainName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "hostIpAddressEntityId":
			err = unpopulate(val, "HostIPAddressEntityID", &d.HostIPAddressEntityID)
			delete(rawMsg, key)
		case "ipAddressEntityIds":
			err = unpopulate(val, "IPAddressEntityIDs", &d.IPAddressEntityIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnector.
func (d DataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = d.Kind
	populate(objectMap, "name", d.Name)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnector.
func (d *DataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectorDataTypeCommon.
func (d DataConnectorDataTypeCommon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", d.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectorDataTypeCommon.
func (d *DataConnectorDataTypeCommon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataConnectorList.
func (d DataConnectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataConnectorList.
func (d *DataConnectorList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			d.Value, err = unmarshalDataConnectorClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Entity.
func (e Entity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = e.Kind
	populate(objectMap, "name", e.Name)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Entity.
func (e *Entity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EntityMapping.
func (e EntityMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", e.EntityType)
	populate(objectMap, "fieldMappings", e.FieldMappings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EntityMapping.
func (e *EntityMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &e.EntityType)
			delete(rawMsg, key)
		case "fieldMappings":
			err = unpopulate(val, "FieldMappings", &e.FieldMappings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGroupingSettings.
func (e EventGroupingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationKind", e.AggregationKind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGroupingSettings.
func (e *EventGroupingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationKind":
			err = unpopulate(val, "AggregationKind", &e.AggregationKind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FieldMapping.
func (f FieldMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columnName", f.ColumnName)
	populate(objectMap, "identifier", f.Identifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FieldMapping.
func (f *FieldMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &f.ColumnName)
			delete(rawMsg, key)
		case "identifier":
			err = unpopulate(val, "Identifier", &f.Identifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileEntity.
func (f FileEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	objectMap["kind"] = EntityKindEnumFile
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileEntity.
func (f *FileEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileEntityProperties.
func (f FileEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", f.AdditionalData)
	populate(objectMap, "directory", f.Directory)
	populate(objectMap, "fileHashEntityIds", f.FileHashEntityIDs)
	populate(objectMap, "fileName", f.FileName)
	populate(objectMap, "friendlyName", f.FriendlyName)
	populate(objectMap, "hostEntityId", f.HostEntityID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileEntityProperties.
func (f *FileEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &f.AdditionalData)
			delete(rawMsg, key)
		case "directory":
			err = unpopulate(val, "Directory", &f.Directory)
			delete(rawMsg, key)
		case "fileHashEntityIds":
			err = unpopulate(val, "FileHashEntityIDs", &f.FileHashEntityIDs)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "hostEntityId":
			err = unpopulate(val, "HostEntityID", &f.HostEntityID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileHashEntity.
func (f FileHashEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	objectMap["kind"] = EntityKindEnumFileHash
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileHashEntity.
func (f *FileHashEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileHashEntityProperties.
func (f FileHashEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", f.AdditionalData)
	populate(objectMap, "algorithm", f.Algorithm)
	populate(objectMap, "friendlyName", f.FriendlyName)
	populate(objectMap, "hashValue", f.HashValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileHashEntityProperties.
func (f *FileHashEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &f.AdditionalData)
			delete(rawMsg, key)
		case "algorithm":
			err = unpopulate(val, "Algorithm", &f.Algorithm)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "hashValue":
			err = unpopulate(val, "HashValue", &f.HashValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FusionAlertRule.
func (f FusionAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	objectMap["kind"] = AlertRuleKindFusion
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FusionAlertRule.
func (f *FusionAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FusionAlertRuleProperties.
func (f FusionAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertRuleTemplateName", f.AlertRuleTemplateName)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "displayName", f.DisplayName)
	populate(objectMap, "enabled", f.Enabled)
	populateDateTimeRFC3339(objectMap, "lastModifiedUtc", f.LastModifiedUTC)
	populate(objectMap, "severity", f.Severity)
	populate(objectMap, "tactics", f.Tactics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FusionAlertRuleProperties.
func (f *FusionAlertRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertRuleTemplateName":
			err = unpopulate(val, "AlertRuleTemplateName", &f.AlertRuleTemplateName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &f.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &f.Enabled)
			delete(rawMsg, key)
		case "lastModifiedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedUTC", &f.LastModifiedUTC)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &f.Severity)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &f.Tactics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FusionAlertRuleTemplate.
func (f FusionAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	objectMap["kind"] = AlertRuleKindFusion
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FusionAlertRuleTemplate.
func (f *FusionAlertRuleTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &f.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FusionAlertRuleTemplateProperties.
func (f FusionAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertRulesCreatedByTemplateCount", f.AlertRulesCreatedByTemplateCount)
	populateDateTimeRFC3339(objectMap, "createdDateUTC", f.CreatedDateUTC)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "displayName", f.DisplayName)
	populateDateTimeRFC3339(objectMap, "lastUpdatedDateUTC", f.LastUpdatedDateUTC)
	populate(objectMap, "requiredDataConnectors", f.RequiredDataConnectors)
	populate(objectMap, "severity", f.Severity)
	populate(objectMap, "status", f.Status)
	populate(objectMap, "tactics", f.Tactics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FusionAlertRuleTemplateProperties.
func (f *FusionAlertRuleTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertRulesCreatedByTemplateCount":
			err = unpopulate(val, "AlertRulesCreatedByTemplateCount", &f.AlertRulesCreatedByTemplateCount)
			delete(rawMsg, key)
		case "createdDateUTC":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateUTC", &f.CreatedDateUTC)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &f.DisplayName)
			delete(rawMsg, key)
		case "lastUpdatedDateUTC":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedDateUTC", &f.LastUpdatedDateUTC)
			delete(rawMsg, key)
		case "requiredDataConnectors":
			err = unpopulate(val, "RequiredDataConnectors", &f.RequiredDataConnectors)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &f.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &f.Tactics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GeoLocation.
func (g GeoLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", g.Asn)
	populate(objectMap, "city", g.City)
	populate(objectMap, "countryCode", g.CountryCode)
	populate(objectMap, "countryName", g.CountryName)
	populate(objectMap, "latitude", g.Latitude)
	populate(objectMap, "longitude", g.Longitude)
	populate(objectMap, "state", g.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GeoLocation.
func (g *GeoLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &g.Asn)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &g.City)
			delete(rawMsg, key)
		case "countryCode":
			err = unpopulate(val, "CountryCode", &g.CountryCode)
			delete(rawMsg, key)
		case "countryName":
			err = unpopulate(val, "CountryName", &g.CountryName)
			delete(rawMsg, key)
		case "latitude":
			err = unpopulate(val, "Latitude", &g.Latitude)
			delete(rawMsg, key)
		case "longitude":
			err = unpopulate(val, "Longitude", &g.Longitude)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupingConfiguration.
func (g GroupingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "groupByAlertDetails", g.GroupByAlertDetails)
	populate(objectMap, "groupByCustomDetails", g.GroupByCustomDetails)
	populate(objectMap, "groupByEntities", g.GroupByEntities)
	populate(objectMap, "lookbackDuration", g.LookbackDuration)
	populate(objectMap, "matchingMethod", g.MatchingMethod)
	populate(objectMap, "reopenClosedIncident", g.ReopenClosedIncident)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupingConfiguration.
func (g *GroupingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "groupByAlertDetails":
			err = unpopulate(val, "GroupByAlertDetails", &g.GroupByAlertDetails)
			delete(rawMsg, key)
		case "groupByCustomDetails":
			err = unpopulate(val, "GroupByCustomDetails", &g.GroupByCustomDetails)
			delete(rawMsg, key)
		case "groupByEntities":
			err = unpopulate(val, "GroupByEntities", &g.GroupByEntities)
			delete(rawMsg, key)
		case "lookbackDuration":
			err = unpopulate(val, "LookbackDuration", &g.LookbackDuration)
			delete(rawMsg, key)
		case "matchingMethod":
			err = unpopulate(val, "MatchingMethod", &g.MatchingMethod)
			delete(rawMsg, key)
		case "reopenClosedIncident":
			err = unpopulate(val, "ReopenClosedIncident", &g.ReopenClosedIncident)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostEntity.
func (h HostEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	objectMap["kind"] = EntityKindEnumHost
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostEntity.
func (h *HostEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostEntityProperties.
func (h HostEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", h.AdditionalData)
	populate(objectMap, "azureID", h.AzureID)
	populate(objectMap, "dnsDomain", h.DNSDomain)
	populate(objectMap, "friendlyName", h.FriendlyName)
	populate(objectMap, "hostName", h.HostName)
	populate(objectMap, "isDomainJoined", h.IsDomainJoined)
	populate(objectMap, "netBiosName", h.NetBiosName)
	populate(objectMap, "ntDomain", h.NtDomain)
	populate(objectMap, "osFamily", h.OSFamily)
	populate(objectMap, "osVersion", h.OSVersion)
	populate(objectMap, "omsAgentID", h.OmsAgentID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostEntityProperties.
func (h *HostEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &h.AdditionalData)
			delete(rawMsg, key)
		case "azureID":
			err = unpopulate(val, "AzureID", &h.AzureID)
			delete(rawMsg, key)
		case "dnsDomain":
			err = unpopulate(val, "DNSDomain", &h.DNSDomain)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &h.FriendlyName)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &h.HostName)
			delete(rawMsg, key)
		case "isDomainJoined":
			err = unpopulate(val, "IsDomainJoined", &h.IsDomainJoined)
			delete(rawMsg, key)
		case "netBiosName":
			err = unpopulate(val, "NetBiosName", &h.NetBiosName)
			delete(rawMsg, key)
		case "ntDomain":
			err = unpopulate(val, "NtDomain", &h.NtDomain)
			delete(rawMsg, key)
		case "osFamily":
			err = unpopulate(val, "OSFamily", &h.OSFamily)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &h.OSVersion)
			delete(rawMsg, key)
		case "omsAgentID":
			err = unpopulate(val, "OmsAgentID", &h.OmsAgentID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HuntingBookmark.
func (h HuntingBookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	objectMap["kind"] = EntityKindEnumBookmark
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HuntingBookmark.
func (h *HuntingBookmark) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HuntingBookmarkProperties.
func (h HuntingBookmarkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", h.AdditionalData)
	populateDateTimeRFC3339(objectMap, "created", h.Created)
	populate(objectMap, "createdBy", h.CreatedBy)
	populate(objectMap, "displayName", h.DisplayName)
	populateDateTimeRFC3339(objectMap, "eventTime", h.EventTime)
	populate(objectMap, "friendlyName", h.FriendlyName)
	populate(objectMap, "incidentInfo", h.IncidentInfo)
	populate(objectMap, "labels", h.Labels)
	populate(objectMap, "notes", h.Notes)
	populate(objectMap, "query", h.Query)
	populate(objectMap, "queryResult", h.QueryResult)
	populateDateTimeRFC3339(objectMap, "updated", h.Updated)
	populate(objectMap, "updatedBy", h.UpdatedBy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HuntingBookmarkProperties.
func (h *HuntingBookmarkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &h.AdditionalData)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &h.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &h.CreatedBy)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateDateTimeRFC3339(val, "EventTime", &h.EventTime)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &h.FriendlyName)
			delete(rawMsg, key)
		case "incidentInfo":
			err = unpopulate(val, "IncidentInfo", &h.IncidentInfo)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &h.Labels)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &h.Notes)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &h.Query)
			delete(rawMsg, key)
		case "queryResult":
			err = unpopulate(val, "QueryResult", &h.QueryResult)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &h.Updated)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &h.UpdatedBy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPEntity.
func (i IPEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = EntityKindEnumIP
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPEntity.
func (i *IPEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPEntityProperties.
func (i IPEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", i.AdditionalData)
	populate(objectMap, "address", i.Address)
	populate(objectMap, "friendlyName", i.FriendlyName)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "threatIntelligence", i.ThreatIntelligence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPEntityProperties.
func (i *IPEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &i.AdditionalData)
			delete(rawMsg, key)
		case "address":
			err = unpopulate(val, "Address", &i.Address)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &i.FriendlyName)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "threatIntelligence":
			err = unpopulate(val, "ThreatIntelligence", &i.ThreatIntelligence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Incident.
func (i *Incident) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentAdditionalData.
func (i IncidentAdditionalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertProductNames", i.AlertProductNames)
	populate(objectMap, "alertsCount", i.AlertsCount)
	populate(objectMap, "bookmarksCount", i.BookmarksCount)
	populate(objectMap, "commentsCount", i.CommentsCount)
	populate(objectMap, "tactics", i.Tactics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentAdditionalData.
func (i *IncidentAdditionalData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertProductNames":
			err = unpopulate(val, "AlertProductNames", &i.AlertProductNames)
			delete(rawMsg, key)
		case "alertsCount":
			err = unpopulate(val, "AlertsCount", &i.AlertsCount)
			delete(rawMsg, key)
		case "bookmarksCount":
			err = unpopulate(val, "BookmarksCount", &i.BookmarksCount)
			delete(rawMsg, key)
		case "commentsCount":
			err = unpopulate(val, "CommentsCount", &i.CommentsCount)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &i.Tactics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentAlertList.
func (i IncidentAlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentAlertList.
func (i *IncidentAlertList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentBookmarkList.
func (i IncidentBookmarkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentBookmarkList.
func (i *IncidentBookmarkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentComment.
func (i IncidentComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentComment.
func (i *IncidentComment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentCommentList.
func (i IncidentCommentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentCommentList.
func (i *IncidentCommentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentCommentProperties.
func (i IncidentCommentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "author", i.Author)
	populateDateTimeRFC3339(objectMap, "createdTimeUtc", i.CreatedTimeUTC)
	populateDateTimeRFC3339(objectMap, "lastModifiedTimeUtc", i.LastModifiedTimeUTC)
	populate(objectMap, "message", i.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentCommentProperties.
func (i *IncidentCommentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &i.Author)
			delete(rawMsg, key)
		case "createdTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimeUTC", &i.CreatedTimeUTC)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTimeUTC", &i.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentConfiguration.
func (i IncidentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createIncident", i.CreateIncident)
	populate(objectMap, "groupingConfiguration", i.GroupingConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentConfiguration.
func (i *IncidentConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createIncident":
			err = unpopulate(val, "CreateIncident", &i.CreateIncident)
			delete(rawMsg, key)
		case "groupingConfiguration":
			err = unpopulate(val, "GroupingConfiguration", &i.GroupingConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentEntitiesResponse.
func (i IncidentEntitiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entities", i.Entities)
	populate(objectMap, "metaData", i.MetaData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentEntitiesResponse.
func (i *IncidentEntitiesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entities":
			i.Entities, err = unmarshalEntityClassificationArray(val)
			delete(rawMsg, key)
		case "metaData":
			err = unpopulate(val, "MetaData", &i.MetaData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentEntitiesResultsMetadata.
func (i IncidentEntitiesResultsMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", i.Count)
	populate(objectMap, "entityKind", i.EntityKind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentEntitiesResultsMetadata.
func (i *IncidentEntitiesResultsMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &i.Count)
			delete(rawMsg, key)
		case "entityKind":
			err = unpopulate(val, "EntityKind", &i.EntityKind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentInfo.
func (i IncidentInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incidentId", i.IncidentID)
	populate(objectMap, "relationName", i.RelationName)
	populate(objectMap, "severity", i.Severity)
	populate(objectMap, "title", i.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentInfo.
func (i *IncidentInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incidentId":
			err = unpopulate(val, "IncidentID", &i.IncidentID)
			delete(rawMsg, key)
		case "relationName":
			err = unpopulate(val, "RelationName", &i.RelationName)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &i.Severity)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentLabel.
func (i IncidentLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "labelName", i.LabelName)
	populate(objectMap, "labelType", i.LabelType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentLabel.
func (i *IncidentLabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "labelName":
			err = unpopulate(val, "LabelName", &i.LabelName)
			delete(rawMsg, key)
		case "labelType":
			err = unpopulate(val, "LabelType", &i.LabelType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentList.
func (i IncidentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentList.
func (i *IncidentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentOwnerInfo.
func (i IncidentOwnerInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedTo", i.AssignedTo)
	populate(objectMap, "email", i.Email)
	populate(objectMap, "objectId", i.ObjectID)
	populate(objectMap, "userPrincipalName", i.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentOwnerInfo.
func (i *IncidentOwnerInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedTo":
			err = unpopulate(val, "AssignedTo", &i.AssignedTo)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &i.Email)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &i.ObjectID)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &i.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentOwnerInfoAutoGenerated.
func (i IncidentOwnerInfoAutoGenerated) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedTo", i.AssignedTo)
	populate(objectMap, "email", i.Email)
	populate(objectMap, "objectId", i.ObjectID)
	populate(objectMap, "ownerType", i.OwnerType)
	populate(objectMap, "userPrincipalName", i.UserPrincipalName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentOwnerInfoAutoGenerated.
func (i *IncidentOwnerInfoAutoGenerated) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedTo":
			err = unpopulate(val, "AssignedTo", &i.AssignedTo)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &i.Email)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &i.ObjectID)
			delete(rawMsg, key)
		case "ownerType":
			err = unpopulate(val, "OwnerType", &i.OwnerType)
			delete(rawMsg, key)
		case "userPrincipalName":
			err = unpopulate(val, "UserPrincipalName", &i.UserPrincipalName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentProperties.
func (i IncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", i.AdditionalData)
	populate(objectMap, "classification", i.Classification)
	populate(objectMap, "classificationComment", i.ClassificationComment)
	populate(objectMap, "classificationReason", i.ClassificationReason)
	populateDateTimeRFC3339(objectMap, "createdTimeUtc", i.CreatedTimeUTC)
	populate(objectMap, "description", i.Description)
	populateDateTimeRFC3339(objectMap, "firstActivityTimeUtc", i.FirstActivityTimeUTC)
	populate(objectMap, "incidentNumber", i.IncidentNumber)
	populate(objectMap, "incidentUrl", i.IncidentURL)
	populate(objectMap, "labels", i.Labels)
	populateDateTimeRFC3339(objectMap, "lastActivityTimeUtc", i.LastActivityTimeUTC)
	populateDateTimeRFC3339(objectMap, "lastModifiedTimeUtc", i.LastModifiedTimeUTC)
	populate(objectMap, "owner", i.Owner)
	populate(objectMap, "relatedAnalyticRuleIds", i.RelatedAnalyticRuleIDs)
	populate(objectMap, "severity", i.Severity)
	populate(objectMap, "status", i.Status)
	populate(objectMap, "title", i.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentProperties.
func (i *IncidentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &i.AdditionalData)
			delete(rawMsg, key)
		case "classification":
			err = unpopulate(val, "Classification", &i.Classification)
			delete(rawMsg, key)
		case "classificationComment":
			err = unpopulate(val, "ClassificationComment", &i.ClassificationComment)
			delete(rawMsg, key)
		case "classificationReason":
			err = unpopulate(val, "ClassificationReason", &i.ClassificationReason)
			delete(rawMsg, key)
		case "createdTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimeUTC", &i.CreatedTimeUTC)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "firstActivityTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "FirstActivityTimeUTC", &i.FirstActivityTimeUTC)
			delete(rawMsg, key)
		case "incidentNumber":
			err = unpopulate(val, "IncidentNumber", &i.IncidentNumber)
			delete(rawMsg, key)
		case "incidentUrl":
			err = unpopulate(val, "IncidentURL", &i.IncidentURL)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &i.Labels)
			delete(rawMsg, key)
		case "lastActivityTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastActivityTimeUTC", &i.LastActivityTimeUTC)
			delete(rawMsg, key)
		case "lastModifiedTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedTimeUTC", &i.LastModifiedTimeUTC)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &i.Owner)
			delete(rawMsg, key)
		case "relatedAnalyticRuleIds":
			err = unpopulate(val, "RelatedAnalyticRuleIDs", &i.RelatedAnalyticRuleIDs)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &i.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncidentPropertiesAction.
func (i IncidentPropertiesAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "classification", i.Classification)
	populate(objectMap, "classificationComment", i.ClassificationComment)
	populate(objectMap, "classificationReason", i.ClassificationReason)
	populate(objectMap, "labels", i.Labels)
	populate(objectMap, "owner", i.Owner)
	populate(objectMap, "severity", i.Severity)
	populate(objectMap, "status", i.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncidentPropertiesAction.
func (i *IncidentPropertiesAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classification":
			err = unpopulate(val, "Classification", &i.Classification)
			delete(rawMsg, key)
		case "classificationComment":
			err = unpopulate(val, "ClassificationComment", &i.ClassificationComment)
			delete(rawMsg, key)
		case "classificationReason":
			err = unpopulate(val, "ClassificationReason", &i.ClassificationReason)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &i.Labels)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &i.Owner)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &i.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &i.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTDeviceEntity.
func (i IoTDeviceEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = EntityKindEnumIoTDevice
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTDeviceEntity.
func (i *IoTDeviceEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IoTDeviceEntityProperties.
func (i IoTDeviceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", i.AdditionalData)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "deviceName", i.DeviceName)
	populate(objectMap, "deviceType", i.DeviceType)
	populate(objectMap, "edgeId", i.EdgeID)
	populate(objectMap, "firmwareVersion", i.FirmwareVersion)
	populate(objectMap, "friendlyName", i.FriendlyName)
	populate(objectMap, "hostEntityId", i.HostEntityID)
	populate(objectMap, "ipAddressEntityId", i.IPAddressEntityID)
	populate(objectMap, "iotHubEntityId", i.IotHubEntityID)
	populate(objectMap, "iotSecurityAgentId", i.IotSecurityAgentID)
	populate(objectMap, "macAddress", i.MacAddress)
	populate(objectMap, "model", i.Model)
	populate(objectMap, "operatingSystem", i.OperatingSystem)
	populate(objectMap, "protocols", i.Protocols)
	populate(objectMap, "serialNumber", i.SerialNumber)
	populate(objectMap, "source", i.Source)
	populate(objectMap, "threatIntelligence", i.ThreatIntelligence)
	populate(objectMap, "vendor", i.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IoTDeviceEntityProperties.
func (i *IoTDeviceEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &i.AdditionalData)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "deviceName":
			err = unpopulate(val, "DeviceName", &i.DeviceName)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &i.DeviceType)
			delete(rawMsg, key)
		case "edgeId":
			err = unpopulate(val, "EdgeID", &i.EdgeID)
			delete(rawMsg, key)
		case "firmwareVersion":
			err = unpopulate(val, "FirmwareVersion", &i.FirmwareVersion)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &i.FriendlyName)
			delete(rawMsg, key)
		case "hostEntityId":
			err = unpopulate(val, "HostEntityID", &i.HostEntityID)
			delete(rawMsg, key)
		case "ipAddressEntityId":
			err = unpopulate(val, "IPAddressEntityID", &i.IPAddressEntityID)
			delete(rawMsg, key)
		case "iotHubEntityId":
			err = unpopulate(val, "IotHubEntityID", &i.IotHubEntityID)
			delete(rawMsg, key)
		case "iotSecurityAgentId":
			err = unpopulate(val, "IotSecurityAgentID", &i.IotSecurityAgentID)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &i.MacAddress)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &i.Model)
			delete(rawMsg, key)
		case "operatingSystem":
			err = unpopulate(val, "OperatingSystem", &i.OperatingSystem)
			delete(rawMsg, key)
		case "protocols":
			err = unpopulate(val, "Protocols", &i.Protocols)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &i.SerialNumber)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &i.Source)
			delete(rawMsg, key)
		case "threatIntelligence":
			err = unpopulate(val, "ThreatIntelligence", &i.ThreatIntelligence)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &i.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MCASDataConnector.
func (m MCASDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = DataConnectorKindMicrosoftCloudAppSecurity
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MCASDataConnector.
func (m *MCASDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MCASDataConnectorDataTypes.
func (m MCASDataConnectorDataTypes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alerts", m.Alerts)
	populate(objectMap, "discoveryLogs", m.DiscoveryLogs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MCASDataConnectorDataTypes.
func (m *MCASDataConnectorDataTypes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alerts":
			err = unpopulate(val, "Alerts", &m.Alerts)
			delete(rawMsg, key)
		case "discoveryLogs":
			err = unpopulate(val, "DiscoveryLogs", &m.DiscoveryLogs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MCASDataConnectorProperties.
func (m MCASDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", m.DataTypes)
	populate(objectMap, "tenantId", m.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MCASDataConnectorProperties.
func (m *MCASDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &m.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MDATPDataConnector.
func (m MDATPDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = DataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MDATPDataConnector.
func (m *MDATPDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MDATPDataConnectorProperties.
func (m MDATPDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", m.DataTypes)
	populate(objectMap, "tenantId", m.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MDATPDataConnectorProperties.
func (m *MDATPDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &m.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailClusterEntity.
func (m MailClusterEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = EntityKindEnumMailCluster
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailClusterEntity.
func (m *MailClusterEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailClusterEntityProperties.
func (m MailClusterEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", m.AdditionalData)
	populate(objectMap, "clusterGroup", m.ClusterGroup)
	populateDateTimeRFC3339(objectMap, "clusterQueryEndTime", m.ClusterQueryEndTime)
	populateDateTimeRFC3339(objectMap, "clusterQueryStartTime", m.ClusterQueryStartTime)
	populate(objectMap, "clusterSourceIdentifier", m.ClusterSourceIdentifier)
	populate(objectMap, "clusterSourceType", m.ClusterSourceType)
	populateAny(objectMap, "countByDeliveryStatus", m.CountByDeliveryStatus)
	populateAny(objectMap, "countByProtectionStatus", m.CountByProtectionStatus)
	populateAny(objectMap, "countByThreatType", m.CountByThreatType)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "isVolumeAnomaly", m.IsVolumeAnomaly)
	populate(objectMap, "mailCount", m.MailCount)
	populate(objectMap, "networkMessageIds", m.NetworkMessageIDs)
	populate(objectMap, "query", m.Query)
	populateDateTimeRFC3339(objectMap, "queryTime", m.QueryTime)
	populate(objectMap, "source", m.Source)
	populate(objectMap, "threats", m.Threats)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailClusterEntityProperties.
func (m *MailClusterEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &m.AdditionalData)
			delete(rawMsg, key)
		case "clusterGroup":
			err = unpopulate(val, "ClusterGroup", &m.ClusterGroup)
			delete(rawMsg, key)
		case "clusterQueryEndTime":
			err = unpopulateDateTimeRFC3339(val, "ClusterQueryEndTime", &m.ClusterQueryEndTime)
			delete(rawMsg, key)
		case "clusterQueryStartTime":
			err = unpopulateDateTimeRFC3339(val, "ClusterQueryStartTime", &m.ClusterQueryStartTime)
			delete(rawMsg, key)
		case "clusterSourceIdentifier":
			err = unpopulate(val, "ClusterSourceIdentifier", &m.ClusterSourceIdentifier)
			delete(rawMsg, key)
		case "clusterSourceType":
			err = unpopulate(val, "ClusterSourceType", &m.ClusterSourceType)
			delete(rawMsg, key)
		case "countByDeliveryStatus":
			err = unpopulate(val, "CountByDeliveryStatus", &m.CountByDeliveryStatus)
			delete(rawMsg, key)
		case "countByProtectionStatus":
			err = unpopulate(val, "CountByProtectionStatus", &m.CountByProtectionStatus)
			delete(rawMsg, key)
		case "countByThreatType":
			err = unpopulate(val, "CountByThreatType", &m.CountByThreatType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "isVolumeAnomaly":
			err = unpopulate(val, "IsVolumeAnomaly", &m.IsVolumeAnomaly)
			delete(rawMsg, key)
		case "mailCount":
			err = unpopulate(val, "MailCount", &m.MailCount)
			delete(rawMsg, key)
		case "networkMessageIds":
			err = unpopulate(val, "NetworkMessageIDs", &m.NetworkMessageIDs)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &m.Query)
			delete(rawMsg, key)
		case "queryTime":
			err = unpopulateDateTimeRFC3339(val, "QueryTime", &m.QueryTime)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &m.Source)
			delete(rawMsg, key)
		case "threats":
			err = unpopulate(val, "Threats", &m.Threats)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailMessageEntity.
func (m MailMessageEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = EntityKindEnumMailMessage
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailMessageEntity.
func (m *MailMessageEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailMessageEntityProperties.
func (m MailMessageEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", m.AdditionalData)
	populate(objectMap, "antispamDirection", m.AntispamDirection)
	populate(objectMap, "bodyFingerprintBin1", m.BodyFingerprintBin1)
	populate(objectMap, "bodyFingerprintBin2", m.BodyFingerprintBin2)
	populate(objectMap, "bodyFingerprintBin3", m.BodyFingerprintBin3)
	populate(objectMap, "bodyFingerprintBin4", m.BodyFingerprintBin4)
	populate(objectMap, "bodyFingerprintBin5", m.BodyFingerprintBin5)
	populate(objectMap, "deliveryAction", m.DeliveryAction)
	populate(objectMap, "deliveryLocation", m.DeliveryLocation)
	populate(objectMap, "fileEntityIds", m.FileEntityIDs)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "internetMessageId", m.InternetMessageID)
	populate(objectMap, "language", m.Language)
	populate(objectMap, "networkMessageId", m.NetworkMessageID)
	populate(objectMap, "p1Sender", m.P1Sender)
	populate(objectMap, "p1SenderDisplayName", m.P1SenderDisplayName)
	populate(objectMap, "p1SenderDomain", m.P1SenderDomain)
	populate(objectMap, "p2Sender", m.P2Sender)
	populate(objectMap, "p2SenderDisplayName", m.P2SenderDisplayName)
	populate(objectMap, "p2SenderDomain", m.P2SenderDomain)
	populateDateTimeRFC3339(objectMap, "receiveDate", m.ReceiveDate)
	populate(objectMap, "recipient", m.Recipient)
	populate(objectMap, "senderIP", m.SenderIP)
	populate(objectMap, "subject", m.Subject)
	populate(objectMap, "threatDetectionMethods", m.ThreatDetectionMethods)
	populate(objectMap, "threats", m.Threats)
	populate(objectMap, "urls", m.Urls)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailMessageEntityProperties.
func (m *MailMessageEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &m.AdditionalData)
			delete(rawMsg, key)
		case "antispamDirection":
			err = unpopulate(val, "AntispamDirection", &m.AntispamDirection)
			delete(rawMsg, key)
		case "bodyFingerprintBin1":
			err = unpopulate(val, "BodyFingerprintBin1", &m.BodyFingerprintBin1)
			delete(rawMsg, key)
		case "bodyFingerprintBin2":
			err = unpopulate(val, "BodyFingerprintBin2", &m.BodyFingerprintBin2)
			delete(rawMsg, key)
		case "bodyFingerprintBin3":
			err = unpopulate(val, "BodyFingerprintBin3", &m.BodyFingerprintBin3)
			delete(rawMsg, key)
		case "bodyFingerprintBin4":
			err = unpopulate(val, "BodyFingerprintBin4", &m.BodyFingerprintBin4)
			delete(rawMsg, key)
		case "bodyFingerprintBin5":
			err = unpopulate(val, "BodyFingerprintBin5", &m.BodyFingerprintBin5)
			delete(rawMsg, key)
		case "deliveryAction":
			err = unpopulate(val, "DeliveryAction", &m.DeliveryAction)
			delete(rawMsg, key)
		case "deliveryLocation":
			err = unpopulate(val, "DeliveryLocation", &m.DeliveryLocation)
			delete(rawMsg, key)
		case "fileEntityIds":
			err = unpopulate(val, "FileEntityIDs", &m.FileEntityIDs)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "internetMessageId":
			err = unpopulate(val, "InternetMessageID", &m.InternetMessageID)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &m.Language)
			delete(rawMsg, key)
		case "networkMessageId":
			err = unpopulate(val, "NetworkMessageID", &m.NetworkMessageID)
			delete(rawMsg, key)
		case "p1Sender":
			err = unpopulate(val, "P1Sender", &m.P1Sender)
			delete(rawMsg, key)
		case "p1SenderDisplayName":
			err = unpopulate(val, "P1SenderDisplayName", &m.P1SenderDisplayName)
			delete(rawMsg, key)
		case "p1SenderDomain":
			err = unpopulate(val, "P1SenderDomain", &m.P1SenderDomain)
			delete(rawMsg, key)
		case "p2Sender":
			err = unpopulate(val, "P2Sender", &m.P2Sender)
			delete(rawMsg, key)
		case "p2SenderDisplayName":
			err = unpopulate(val, "P2SenderDisplayName", &m.P2SenderDisplayName)
			delete(rawMsg, key)
		case "p2SenderDomain":
			err = unpopulate(val, "P2SenderDomain", &m.P2SenderDomain)
			delete(rawMsg, key)
		case "receiveDate":
			err = unpopulateDateTimeRFC3339(val, "ReceiveDate", &m.ReceiveDate)
			delete(rawMsg, key)
		case "recipient":
			err = unpopulate(val, "Recipient", &m.Recipient)
			delete(rawMsg, key)
		case "senderIP":
			err = unpopulate(val, "SenderIP", &m.SenderIP)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &m.Subject)
			delete(rawMsg, key)
		case "threatDetectionMethods":
			err = unpopulate(val, "ThreatDetectionMethods", &m.ThreatDetectionMethods)
			delete(rawMsg, key)
		case "threats":
			err = unpopulate(val, "Threats", &m.Threats)
			delete(rawMsg, key)
		case "urls":
			err = unpopulate(val, "Urls", &m.Urls)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailboxEntity.
func (m MailboxEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = EntityKindEnumMailbox
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailboxEntity.
func (m *MailboxEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MailboxEntityProperties.
func (m MailboxEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", m.AdditionalData)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "externalDirectoryObjectId", m.ExternalDirectoryObjectID)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "mailboxPrimaryAddress", m.MailboxPrimaryAddress)
	populate(objectMap, "upn", m.Upn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MailboxEntityProperties.
func (m *MailboxEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &m.AdditionalData)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "externalDirectoryObjectId":
			err = unpopulate(val, "ExternalDirectoryObjectID", &m.ExternalDirectoryObjectID)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "mailboxPrimaryAddress":
			err = unpopulate(val, "MailboxPrimaryAddress", &m.MailboxPrimaryAddress)
			delete(rawMsg, key)
		case "upn":
			err = unpopulate(val, "Upn", &m.Upn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MalwareEntity.
func (m MalwareEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = EntityKindEnumMalware
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MalwareEntity.
func (m *MalwareEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MalwareEntityProperties.
func (m MalwareEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", m.AdditionalData)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "fileEntityIds", m.FileEntityIDs)
	populate(objectMap, "friendlyName", m.FriendlyName)
	populate(objectMap, "malwareName", m.MalwareName)
	populate(objectMap, "processEntityIds", m.ProcessEntityIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MalwareEntityProperties.
func (m *MalwareEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &m.AdditionalData)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "fileEntityIds":
			err = unpopulate(val, "FileEntityIDs", &m.FileEntityIDs)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &m.FriendlyName)
			delete(rawMsg, key)
		case "malwareName":
			err = unpopulate(val, "MalwareName", &m.MalwareName)
			delete(rawMsg, key)
		case "processEntityIds":
			err = unpopulate(val, "ProcessEntityIDs", &m.ProcessEntityIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftSecurityIncidentCreationAlertRule.
func (m MicrosoftSecurityIncidentCreationAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = AlertRuleKindMicrosoftSecurityIncidentCreation
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftSecurityIncidentCreationAlertRule.
func (m *MicrosoftSecurityIncidentCreationAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleProperties.
func (m MicrosoftSecurityIncidentCreationAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertRuleTemplateName", m.AlertRuleTemplateName)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "displayNamesExcludeFilter", m.DisplayNamesExcludeFilter)
	populate(objectMap, "displayNamesFilter", m.DisplayNamesFilter)
	populate(objectMap, "enabled", m.Enabled)
	populateDateTimeRFC3339(objectMap, "lastModifiedUtc", m.LastModifiedUTC)
	populate(objectMap, "productFilter", m.ProductFilter)
	populate(objectMap, "severitiesFilter", m.SeveritiesFilter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleProperties.
func (m *MicrosoftSecurityIncidentCreationAlertRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertRuleTemplateName":
			err = unpopulate(val, "AlertRuleTemplateName", &m.AlertRuleTemplateName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "displayNamesExcludeFilter":
			err = unpopulate(val, "DisplayNamesExcludeFilter", &m.DisplayNamesExcludeFilter)
			delete(rawMsg, key)
		case "displayNamesFilter":
			err = unpopulate(val, "DisplayNamesFilter", &m.DisplayNamesFilter)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "lastModifiedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedUTC", &m.LastModifiedUTC)
			delete(rawMsg, key)
		case "productFilter":
			err = unpopulate(val, "ProductFilter", &m.ProductFilter)
			delete(rawMsg, key)
		case "severitiesFilter":
			err = unpopulate(val, "SeveritiesFilter", &m.SeveritiesFilter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (m MicrosoftSecurityIncidentCreationAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = AlertRuleKindMicrosoftSecurityIncidentCreation
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (m *MicrosoftSecurityIncidentCreationAlertRuleTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties.
func (m MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertRulesCreatedByTemplateCount", m.AlertRulesCreatedByTemplateCount)
	populateDateTimeRFC3339(objectMap, "createdDateUTC", m.CreatedDateUTC)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "displayNamesExcludeFilter", m.DisplayNamesExcludeFilter)
	populate(objectMap, "displayNamesFilter", m.DisplayNamesFilter)
	populateDateTimeRFC3339(objectMap, "lastUpdatedDateUTC", m.LastUpdatedDateUTC)
	populate(objectMap, "productFilter", m.ProductFilter)
	populate(objectMap, "requiredDataConnectors", m.RequiredDataConnectors)
	populate(objectMap, "severitiesFilter", m.SeveritiesFilter)
	populate(objectMap, "status", m.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties.
func (m *MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertRulesCreatedByTemplateCount":
			err = unpopulate(val, "AlertRulesCreatedByTemplateCount", &m.AlertRulesCreatedByTemplateCount)
			delete(rawMsg, key)
		case "createdDateUTC":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateUTC", &m.CreatedDateUTC)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "displayNamesExcludeFilter":
			err = unpopulate(val, "DisplayNamesExcludeFilter", &m.DisplayNamesExcludeFilter)
			delete(rawMsg, key)
		case "displayNamesFilter":
			err = unpopulate(val, "DisplayNamesFilter", &m.DisplayNamesFilter)
			delete(rawMsg, key)
		case "lastUpdatedDateUTC":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedDateUTC", &m.LastUpdatedDateUTC)
			delete(rawMsg, key)
		case "productFilter":
			err = unpopulate(val, "ProductFilter", &m.ProductFilter)
			delete(rawMsg, key)
		case "requiredDataConnectors":
			err = unpopulate(val, "RequiredDataConnectors", &m.RequiredDataConnectors)
			delete(rawMsg, key)
		case "severitiesFilter":
			err = unpopulate(val, "SeveritiesFilter", &m.SeveritiesFilter)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnector.
func (o OfficeDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "id", o.ID)
	objectMap["kind"] = DataConnectorKindOffice365
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnector.
func (o *OfficeDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &o.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnectorDataTypes.
func (o OfficeDataConnectorDataTypes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exchange", o.Exchange)
	populate(objectMap, "sharePoint", o.SharePoint)
	populate(objectMap, "teams", o.Teams)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnectorDataTypes.
func (o *OfficeDataConnectorDataTypes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exchange":
			err = unpopulate(val, "Exchange", &o.Exchange)
			delete(rawMsg, key)
		case "sharePoint":
			err = unpopulate(val, "SharePoint", &o.SharePoint)
			delete(rawMsg, key)
		case "teams":
			err = unpopulate(val, "Teams", &o.Teams)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnectorDataTypesExchange.
func (o OfficeDataConnectorDataTypesExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", o.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnectorDataTypesExchange.
func (o *OfficeDataConnectorDataTypesExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &o.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnectorDataTypesSharePoint.
func (o OfficeDataConnectorDataTypesSharePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", o.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnectorDataTypesSharePoint.
func (o *OfficeDataConnectorDataTypesSharePoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &o.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnectorDataTypesTeams.
func (o OfficeDataConnectorDataTypesTeams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", o.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnectorDataTypesTeams.
func (o *OfficeDataConnectorDataTypesTeams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &o.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfficeDataConnectorProperties.
func (o OfficeDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", o.DataTypes)
	populate(objectMap, "tenantId", o.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfficeDataConnectorProperties.
func (o *OfficeDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &o.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &o.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsList.
func (o OperationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsList.
func (o *OperationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlaybookActionProperties.
func (p PlaybookActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logicAppResourceId", p.LogicAppResourceID)
	populate(objectMap, "tenantId", p.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlaybookActionProperties.
func (p *PlaybookActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logicAppResourceId":
			err = unpopulate(val, "LogicAppResourceID", &p.LogicAppResourceID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessEntity.
func (p ProcessEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	objectMap["kind"] = EntityKindEnumProcess
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessEntity.
func (p *ProcessEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &p.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProcessEntityProperties.
func (p ProcessEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountEntityId", p.AccountEntityID)
	populate(objectMap, "additionalData", p.AdditionalData)
	populate(objectMap, "commandLine", p.CommandLine)
	populateDateTimeRFC3339(objectMap, "creationTimeUtc", p.CreationTimeUTC)
	populate(objectMap, "elevationToken", p.ElevationToken)
	populate(objectMap, "friendlyName", p.FriendlyName)
	populate(objectMap, "hostEntityId", p.HostEntityID)
	populate(objectMap, "hostLogonSessionEntityId", p.HostLogonSessionEntityID)
	populate(objectMap, "imageFileEntityId", p.ImageFileEntityID)
	populate(objectMap, "parentProcessEntityId", p.ParentProcessEntityID)
	populate(objectMap, "processId", p.ProcessID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessEntityProperties.
func (p *ProcessEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountEntityId":
			err = unpopulate(val, "AccountEntityID", &p.AccountEntityID)
			delete(rawMsg, key)
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &p.AdditionalData)
			delete(rawMsg, key)
		case "commandLine":
			err = unpopulate(val, "CommandLine", &p.CommandLine)
			delete(rawMsg, key)
		case "creationTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "CreationTimeUTC", &p.CreationTimeUTC)
			delete(rawMsg, key)
		case "elevationToken":
			err = unpopulate(val, "ElevationToken", &p.ElevationToken)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "hostEntityId":
			err = unpopulate(val, "HostEntityID", &p.HostEntityID)
			delete(rawMsg, key)
		case "hostLogonSessionEntityId":
			err = unpopulate(val, "HostLogonSessionEntityID", &p.HostLogonSessionEntityID)
			delete(rawMsg, key)
		case "imageFileEntityId":
			err = unpopulate(val, "ImageFileEntityID", &p.ImageFileEntityID)
			delete(rawMsg, key)
		case "parentProcessEntityId":
			err = unpopulate(val, "ParentProcessEntityID", &p.ParentProcessEntityID)
			delete(rawMsg, key)
		case "processId":
			err = unpopulate(val, "ProcessID", &p.ProcessID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertyConditionProperties.
func (p PropertyConditionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "conditionProperties", p.ConditionProperties)
	objectMap["conditionType"] = ConditionTypeProperty
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertyConditionProperties.
func (p *PropertyConditionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "conditionProperties":
			err = unpopulate(val, "ConditionProperties", &p.ConditionProperties)
			delete(rawMsg, key)
		case "conditionType":
			err = unpopulate(val, "ConditionType", &p.ConditionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryKeyEntity.
func (r RegistryKeyEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = EntityKindEnumRegistryKey
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryKeyEntity.
func (r *RegistryKeyEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryKeyEntityProperties.
func (r RegistryKeyEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", r.AdditionalData)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "hive", r.Hive)
	populate(objectMap, "key", r.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryKeyEntityProperties.
func (r *RegistryKeyEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &r.AdditionalData)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "hive":
			err = unpopulate(val, "Hive", &r.Hive)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &r.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryValueEntity.
func (r RegistryValueEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = EntityKindEnumRegistryValue
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryValueEntity.
func (r *RegistryValueEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryValueEntityProperties.
func (r RegistryValueEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", r.AdditionalData)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "keyEntityId", r.KeyEntityID)
	populate(objectMap, "valueData", r.ValueData)
	populate(objectMap, "valueName", r.ValueName)
	populate(objectMap, "valueType", r.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryValueEntityProperties.
func (r *RegistryValueEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &r.AdditionalData)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "keyEntityId":
			err = unpopulate(val, "KeyEntityID", &r.KeyEntityID)
			delete(rawMsg, key)
		case "valueData":
			err = unpopulate(val, "ValueData", &r.ValueData)
			delete(rawMsg, key)
		case "valueName":
			err = unpopulate(val, "ValueName", &r.ValueName)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &r.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Relation.
func (r Relation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Relation.
func (r *Relation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationList.
func (r RelationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationList.
func (r *RelationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelationProperties.
func (r RelationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "relatedResourceId", r.RelatedResourceID)
	populate(objectMap, "relatedResourceKind", r.RelatedResourceKind)
	populate(objectMap, "relatedResourceName", r.RelatedResourceName)
	populate(objectMap, "relatedResourceType", r.RelatedResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelationProperties.
func (r *RelationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "relatedResourceId":
			err = unpopulate(val, "RelatedResourceID", &r.RelatedResourceID)
			delete(rawMsg, key)
		case "relatedResourceKind":
			err = unpopulate(val, "RelatedResourceKind", &r.RelatedResourceKind)
			delete(rawMsg, key)
		case "relatedResourceName":
			err = unpopulate(val, "RelatedResourceName", &r.RelatedResourceName)
			delete(rawMsg, key)
		case "relatedResourceType":
			err = unpopulate(val, "RelatedResourceType", &r.RelatedResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledAlertRule.
func (s ScheduledAlertRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = AlertRuleKindScheduled
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledAlertRule.
func (s *ScheduledAlertRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledAlertRuleProperties.
func (s ScheduledAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertDetailsOverride", s.AlertDetailsOverride)
	populate(objectMap, "alertRuleTemplateName", s.AlertRuleTemplateName)
	populate(objectMap, "customDetails", s.CustomDetails)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "entityMappings", s.EntityMappings)
	populate(objectMap, "eventGroupingSettings", s.EventGroupingSettings)
	populate(objectMap, "incidentConfiguration", s.IncidentConfiguration)
	populateDateTimeRFC3339(objectMap, "lastModifiedUtc", s.LastModifiedUTC)
	populate(objectMap, "query", s.Query)
	populate(objectMap, "queryFrequency", s.QueryFrequency)
	populate(objectMap, "queryPeriod", s.QueryPeriod)
	populate(objectMap, "severity", s.Severity)
	populate(objectMap, "suppressionDuration", s.SuppressionDuration)
	populate(objectMap, "suppressionEnabled", s.SuppressionEnabled)
	populate(objectMap, "tactics", s.Tactics)
	populate(objectMap, "templateVersion", s.TemplateVersion)
	populate(objectMap, "triggerOperator", s.TriggerOperator)
	populate(objectMap, "triggerThreshold", s.TriggerThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledAlertRuleProperties.
func (s *ScheduledAlertRuleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertDetailsOverride":
			err = unpopulate(val, "AlertDetailsOverride", &s.AlertDetailsOverride)
			delete(rawMsg, key)
		case "alertRuleTemplateName":
			err = unpopulate(val, "AlertRuleTemplateName", &s.AlertRuleTemplateName)
			delete(rawMsg, key)
		case "customDetails":
			err = unpopulate(val, "CustomDetails", &s.CustomDetails)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "entityMappings":
			err = unpopulate(val, "EntityMappings", &s.EntityMappings)
			delete(rawMsg, key)
		case "eventGroupingSettings":
			err = unpopulate(val, "EventGroupingSettings", &s.EventGroupingSettings)
			delete(rawMsg, key)
		case "incidentConfiguration":
			err = unpopulate(val, "IncidentConfiguration", &s.IncidentConfiguration)
			delete(rawMsg, key)
		case "lastModifiedUtc":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedUTC", &s.LastModifiedUTC)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &s.Query)
			delete(rawMsg, key)
		case "queryFrequency":
			err = unpopulate(val, "QueryFrequency", &s.QueryFrequency)
			delete(rawMsg, key)
		case "queryPeriod":
			err = unpopulate(val, "QueryPeriod", &s.QueryPeriod)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		case "suppressionDuration":
			err = unpopulate(val, "SuppressionDuration", &s.SuppressionDuration)
			delete(rawMsg, key)
		case "suppressionEnabled":
			err = unpopulate(val, "SuppressionEnabled", &s.SuppressionEnabled)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &s.Tactics)
			delete(rawMsg, key)
		case "templateVersion":
			err = unpopulate(val, "TemplateVersion", &s.TemplateVersion)
			delete(rawMsg, key)
		case "triggerOperator":
			err = unpopulate(val, "TriggerOperator", &s.TriggerOperator)
			delete(rawMsg, key)
		case "triggerThreshold":
			err = unpopulate(val, "TriggerThreshold", &s.TriggerThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledAlertRuleTemplate.
func (s ScheduledAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = AlertRuleKindScheduled
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledAlertRuleTemplate.
func (s *ScheduledAlertRuleTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledAlertRuleTemplateProperties.
func (s ScheduledAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertDetailsOverride", s.AlertDetailsOverride)
	populate(objectMap, "alertRulesCreatedByTemplateCount", s.AlertRulesCreatedByTemplateCount)
	populateDateTimeRFC3339(objectMap, "createdDateUTC", s.CreatedDateUTC)
	populate(objectMap, "customDetails", s.CustomDetails)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "entityMappings", s.EntityMappings)
	populate(objectMap, "eventGroupingSettings", s.EventGroupingSettings)
	populateDateTimeRFC3339(objectMap, "lastUpdatedDateUTC", s.LastUpdatedDateUTC)
	populate(objectMap, "query", s.Query)
	populate(objectMap, "queryFrequency", s.QueryFrequency)
	populate(objectMap, "queryPeriod", s.QueryPeriod)
	populate(objectMap, "requiredDataConnectors", s.RequiredDataConnectors)
	populate(objectMap, "severity", s.Severity)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "tactics", s.Tactics)
	populate(objectMap, "triggerOperator", s.TriggerOperator)
	populate(objectMap, "triggerThreshold", s.TriggerThreshold)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledAlertRuleTemplateProperties.
func (s *ScheduledAlertRuleTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertDetailsOverride":
			err = unpopulate(val, "AlertDetailsOverride", &s.AlertDetailsOverride)
			delete(rawMsg, key)
		case "alertRulesCreatedByTemplateCount":
			err = unpopulate(val, "AlertRulesCreatedByTemplateCount", &s.AlertRulesCreatedByTemplateCount)
			delete(rawMsg, key)
		case "createdDateUTC":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateUTC", &s.CreatedDateUTC)
			delete(rawMsg, key)
		case "customDetails":
			err = unpopulate(val, "CustomDetails", &s.CustomDetails)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "entityMappings":
			err = unpopulate(val, "EntityMappings", &s.EntityMappings)
			delete(rawMsg, key)
		case "eventGroupingSettings":
			err = unpopulate(val, "EventGroupingSettings", &s.EventGroupingSettings)
			delete(rawMsg, key)
		case "lastUpdatedDateUTC":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedDateUTC", &s.LastUpdatedDateUTC)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &s.Query)
			delete(rawMsg, key)
		case "queryFrequency":
			err = unpopulate(val, "QueryFrequency", &s.QueryFrequency)
			delete(rawMsg, key)
		case "queryPeriod":
			err = unpopulate(val, "QueryPeriod", &s.QueryPeriod)
			delete(rawMsg, key)
		case "requiredDataConnectors":
			err = unpopulate(val, "RequiredDataConnectors", &s.RequiredDataConnectors)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &s.Tactics)
			delete(rawMsg, key)
		case "triggerOperator":
			err = unpopulate(val, "TriggerOperator", &s.TriggerOperator)
			delete(rawMsg, key)
		case "triggerThreshold":
			err = unpopulate(val, "TriggerThreshold", &s.TriggerThreshold)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlert.
func (s SecurityAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = EntityKindEnumSecurityAlert
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlert.
func (s *SecurityAlert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertProperties.
func (s SecurityAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", s.AdditionalData)
	populate(objectMap, "alertDisplayName", s.AlertDisplayName)
	populate(objectMap, "alertLink", s.AlertLink)
	populate(objectMap, "alertType", s.AlertType)
	populate(objectMap, "compromisedEntity", s.CompromisedEntity)
	populate(objectMap, "confidenceLevel", s.ConfidenceLevel)
	populate(objectMap, "confidenceReasons", s.ConfidenceReasons)
	populate(objectMap, "confidenceScore", s.ConfidenceScore)
	populate(objectMap, "confidenceScoreStatus", s.ConfidenceScoreStatus)
	populate(objectMap, "description", s.Description)
	populateDateTimeRFC3339(objectMap, "endTimeUtc", s.EndTimeUTC)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "intent", s.Intent)
	populateDateTimeRFC3339(objectMap, "processingEndTime", s.ProcessingEndTime)
	populate(objectMap, "productComponentName", s.ProductComponentName)
	populate(objectMap, "productName", s.ProductName)
	populate(objectMap, "productVersion", s.ProductVersion)
	populate(objectMap, "providerAlertId", s.ProviderAlertID)
	populate(objectMap, "remediationSteps", s.RemediationSteps)
	populate(objectMap, "resourceIdentifiers", s.ResourceIdentifiers)
	populate(objectMap, "severity", s.Severity)
	populateDateTimeRFC3339(objectMap, "startTimeUtc", s.StartTimeUTC)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "systemAlertId", s.SystemAlertID)
	populate(objectMap, "tactics", s.Tactics)
	populateDateTimeRFC3339(objectMap, "timeGenerated", s.TimeGenerated)
	populate(objectMap, "vendorName", s.VendorName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertProperties.
func (s *SecurityAlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &s.AdditionalData)
			delete(rawMsg, key)
		case "alertDisplayName":
			err = unpopulate(val, "AlertDisplayName", &s.AlertDisplayName)
			delete(rawMsg, key)
		case "alertLink":
			err = unpopulate(val, "AlertLink", &s.AlertLink)
			delete(rawMsg, key)
		case "alertType":
			err = unpopulate(val, "AlertType", &s.AlertType)
			delete(rawMsg, key)
		case "compromisedEntity":
			err = unpopulate(val, "CompromisedEntity", &s.CompromisedEntity)
			delete(rawMsg, key)
		case "confidenceLevel":
			err = unpopulate(val, "ConfidenceLevel", &s.ConfidenceLevel)
			delete(rawMsg, key)
		case "confidenceReasons":
			err = unpopulate(val, "ConfidenceReasons", &s.ConfidenceReasons)
			delete(rawMsg, key)
		case "confidenceScore":
			err = unpopulate(val, "ConfidenceScore", &s.ConfidenceScore)
			delete(rawMsg, key)
		case "confidenceScoreStatus":
			err = unpopulate(val, "ConfidenceScoreStatus", &s.ConfidenceScoreStatus)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "endTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "EndTimeUTC", &s.EndTimeUTC)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "intent":
			err = unpopulate(val, "Intent", &s.Intent)
			delete(rawMsg, key)
		case "processingEndTime":
			err = unpopulateDateTimeRFC3339(val, "ProcessingEndTime", &s.ProcessingEndTime)
			delete(rawMsg, key)
		case "productComponentName":
			err = unpopulate(val, "ProductComponentName", &s.ProductComponentName)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &s.ProductName)
			delete(rawMsg, key)
		case "productVersion":
			err = unpopulate(val, "ProductVersion", &s.ProductVersion)
			delete(rawMsg, key)
		case "providerAlertId":
			err = unpopulate(val, "ProviderAlertID", &s.ProviderAlertID)
			delete(rawMsg, key)
		case "remediationSteps":
			err = unpopulate(val, "RemediationSteps", &s.RemediationSteps)
			delete(rawMsg, key)
		case "resourceIdentifiers":
			err = unpopulate(val, "ResourceIdentifiers", &s.ResourceIdentifiers)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &s.Severity)
			delete(rawMsg, key)
		case "startTimeUtc":
			err = unpopulateDateTimeRFC3339(val, "StartTimeUTC", &s.StartTimeUTC)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "systemAlertId":
			err = unpopulate(val, "SystemAlertID", &s.SystemAlertID)
			delete(rawMsg, key)
		case "tactics":
			err = unpopulate(val, "Tactics", &s.Tactics)
			delete(rawMsg, key)
		case "timeGenerated":
			err = unpopulateDateTimeRFC3339(val, "TimeGenerated", &s.TimeGenerated)
			delete(rawMsg, key)
		case "vendorName":
			err = unpopulate(val, "VendorName", &s.VendorName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityAlertPropertiesConfidenceReasonsItem.
func (s SecurityAlertPropertiesConfidenceReasonsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", s.Reason)
	populate(objectMap, "reasonType", s.ReasonType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityAlertPropertiesConfidenceReasonsItem.
func (s *SecurityAlertPropertiesConfidenceReasonsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &s.Reason)
			delete(rawMsg, key)
		case "reasonType":
			err = unpopulate(val, "ReasonType", &s.ReasonType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupEntity.
func (s SecurityGroupEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = EntityKindEnumSecurityGroup
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupEntity.
func (s *SecurityGroupEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupEntityProperties.
func (s SecurityGroupEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", s.AdditionalData)
	populate(objectMap, "distinguishedName", s.DistinguishedName)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "objectGuid", s.ObjectGUID)
	populate(objectMap, "sid", s.Sid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupEntityProperties.
func (s *SecurityGroupEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &s.AdditionalData)
			delete(rawMsg, key)
		case "distinguishedName":
			err = unpopulate(val, "DistinguishedName", &s.DistinguishedName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "objectGuid":
			err = unpopulate(val, "ObjectGUID", &s.ObjectGUID)
			delete(rawMsg, key)
		case "sid":
			err = unpopulate(val, "Sid", &s.Sid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SentinelOnboardingState.
func (s SentinelOnboardingState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SentinelOnboardingState.
func (s *SentinelOnboardingState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SentinelOnboardingStateProperties.
func (s SentinelOnboardingStateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerManagedKey", s.CustomerManagedKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SentinelOnboardingStateProperties.
func (s *SentinelOnboardingStateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerManagedKey":
			err = unpopulate(val, "CustomerManagedKey", &s.CustomerManagedKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SentinelOnboardingStatesList.
func (s SentinelOnboardingStatesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SentinelOnboardingStatesList.
func (s *SentinelOnboardingStatesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubmissionMailEntity.
func (s SubmissionMailEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = EntityKindEnumSubmissionMail
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubmissionMailEntity.
func (s *SubmissionMailEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubmissionMailEntityProperties.
func (s SubmissionMailEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", s.AdditionalData)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "networkMessageId", s.NetworkMessageID)
	populate(objectMap, "recipient", s.Recipient)
	populate(objectMap, "reportType", s.ReportType)
	populate(objectMap, "sender", s.Sender)
	populate(objectMap, "senderIp", s.SenderIP)
	populate(objectMap, "subject", s.Subject)
	populateDateTimeRFC3339(objectMap, "submissionDate", s.SubmissionDate)
	populate(objectMap, "submissionId", s.SubmissionID)
	populate(objectMap, "submitter", s.Submitter)
	populateDateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubmissionMailEntityProperties.
func (s *SubmissionMailEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &s.AdditionalData)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "networkMessageId":
			err = unpopulate(val, "NetworkMessageID", &s.NetworkMessageID)
			delete(rawMsg, key)
		case "recipient":
			err = unpopulate(val, "Recipient", &s.Recipient)
			delete(rawMsg, key)
		case "reportType":
			err = unpopulate(val, "ReportType", &s.ReportType)
			delete(rawMsg, key)
		case "sender":
			err = unpopulate(val, "Sender", &s.Sender)
			delete(rawMsg, key)
		case "senderIp":
			err = unpopulate(val, "SenderIP", &s.SenderIP)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &s.Subject)
			delete(rawMsg, key)
		case "submissionDate":
			err = unpopulateDateTimeRFC3339(val, "SubmissionDate", &s.SubmissionDate)
			delete(rawMsg, key)
		case "submissionId":
			err = unpopulate(val, "SubmissionID", &s.SubmissionID)
			delete(rawMsg, key)
		case "submitter":
			err = unpopulate(val, "Submitter", &s.Submitter)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TIDataConnector.
func (t TIDataConnector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	objectMap["kind"] = DataConnectorKindThreatIntelligence
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TIDataConnector.
func (t *TIDataConnector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TIDataConnectorDataTypes.
func (t TIDataConnectorDataTypes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "indicators", t.Indicators)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TIDataConnectorDataTypes.
func (t *TIDataConnectorDataTypes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "indicators":
			err = unpopulate(val, "Indicators", &t.Indicators)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TIDataConnectorDataTypesIndicators.
func (t TIDataConnectorDataTypesIndicators) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "state", t.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TIDataConnectorDataTypesIndicators.
func (t *TIDataConnectorDataTypesIndicators) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "state":
			err = unpopulate(val, "State", &t.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TIDataConnectorProperties.
func (t TIDataConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataTypes", t.DataTypes)
	populate(objectMap, "tenantId", t.TenantID)
	populateDateTimeRFC3339(objectMap, "tipLookbackPeriod", t.TipLookbackPeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TIDataConnectorProperties.
func (t *TIDataConnectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataTypes":
			err = unpopulate(val, "DataTypes", &t.DataTypes)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &t.TenantID)
			delete(rawMsg, key)
		case "tipLookbackPeriod":
			err = unpopulateDateTimeRFC3339(val, "TipLookbackPeriod", &t.TipLookbackPeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligence.
func (t ThreatIntelligence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "confidence", t.Confidence)
	populate(objectMap, "providerName", t.ProviderName)
	populate(objectMap, "reportLink", t.ReportLink)
	populate(objectMap, "threatDescription", t.ThreatDescription)
	populate(objectMap, "threatName", t.ThreatName)
	populate(objectMap, "threatType", t.ThreatType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligence.
func (t *ThreatIntelligence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "confidence":
			err = unpopulate(val, "Confidence", &t.Confidence)
			delete(rawMsg, key)
		case "providerName":
			err = unpopulate(val, "ProviderName", &t.ProviderName)
			delete(rawMsg, key)
		case "reportLink":
			err = unpopulate(val, "ReportLink", &t.ReportLink)
			delete(rawMsg, key)
		case "threatDescription":
			err = unpopulate(val, "ThreatDescription", &t.ThreatDescription)
			delete(rawMsg, key)
		case "threatName":
			err = unpopulate(val, "ThreatName", &t.ThreatName)
			delete(rawMsg, key)
		case "threatType":
			err = unpopulate(val, "ThreatType", &t.ThreatType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceAppendTags.
func (t ThreatIntelligenceAppendTags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "threatIntelligenceTags", t.ThreatIntelligenceTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceAppendTags.
func (t *ThreatIntelligenceAppendTags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "threatIntelligenceTags":
			err = unpopulate(val, "ThreatIntelligenceTags", &t.ThreatIntelligenceTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceExternalReference.
func (t ThreatIntelligenceExternalReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", t.Description)
	populate(objectMap, "externalId", t.ExternalID)
	populate(objectMap, "hashes", t.Hashes)
	populate(objectMap, "sourceName", t.SourceName)
	populate(objectMap, "url", t.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceExternalReference.
func (t *ThreatIntelligenceExternalReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "externalId":
			err = unpopulate(val, "ExternalID", &t.ExternalID)
			delete(rawMsg, key)
		case "hashes":
			err = unpopulate(val, "Hashes", &t.Hashes)
			delete(rawMsg, key)
		case "sourceName":
			err = unpopulate(val, "SourceName", &t.SourceName)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceFilteringCriteria.
func (t ThreatIntelligenceFilteringCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ids", t.IDs)
	populate(objectMap, "includeDisabled", t.IncludeDisabled)
	populate(objectMap, "keywords", t.Keywords)
	populate(objectMap, "maxConfidence", t.MaxConfidence)
	populate(objectMap, "maxValidUntil", t.MaxValidUntil)
	populate(objectMap, "minConfidence", t.MinConfidence)
	populate(objectMap, "minValidUntil", t.MinValidUntil)
	populate(objectMap, "pageSize", t.PageSize)
	populate(objectMap, "patternTypes", t.PatternTypes)
	populate(objectMap, "skipToken", t.SkipToken)
	populate(objectMap, "sortBy", t.SortBy)
	populate(objectMap, "sources", t.Sources)
	populate(objectMap, "threatTypes", t.ThreatTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceFilteringCriteria.
func (t *ThreatIntelligenceFilteringCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ids":
			err = unpopulate(val, "IDs", &t.IDs)
			delete(rawMsg, key)
		case "includeDisabled":
			err = unpopulate(val, "IncludeDisabled", &t.IncludeDisabled)
			delete(rawMsg, key)
		case "keywords":
			err = unpopulate(val, "Keywords", &t.Keywords)
			delete(rawMsg, key)
		case "maxConfidence":
			err = unpopulate(val, "MaxConfidence", &t.MaxConfidence)
			delete(rawMsg, key)
		case "maxValidUntil":
			err = unpopulate(val, "MaxValidUntil", &t.MaxValidUntil)
			delete(rawMsg, key)
		case "minConfidence":
			err = unpopulate(val, "MinConfidence", &t.MinConfidence)
			delete(rawMsg, key)
		case "minValidUntil":
			err = unpopulate(val, "MinValidUntil", &t.MinValidUntil)
			delete(rawMsg, key)
		case "pageSize":
			err = unpopulate(val, "PageSize", &t.PageSize)
			delete(rawMsg, key)
		case "patternTypes":
			err = unpopulate(val, "PatternTypes", &t.PatternTypes)
			delete(rawMsg, key)
		case "skipToken":
			err = unpopulate(val, "SkipToken", &t.SkipToken)
			delete(rawMsg, key)
		case "sortBy":
			err = unpopulate(val, "SortBy", &t.SortBy)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &t.Sources)
			delete(rawMsg, key)
		case "threatTypes":
			err = unpopulate(val, "ThreatTypes", &t.ThreatTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceGranularMarkingModel.
func (t ThreatIntelligenceGranularMarkingModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "language", t.Language)
	populate(objectMap, "markingRef", t.MarkingRef)
	populate(objectMap, "selectors", t.Selectors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceGranularMarkingModel.
func (t *ThreatIntelligenceGranularMarkingModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "language":
			err = unpopulate(val, "Language", &t.Language)
			delete(rawMsg, key)
		case "markingRef":
			err = unpopulate(val, "MarkingRef", &t.MarkingRef)
			delete(rawMsg, key)
		case "selectors":
			err = unpopulate(val, "Selectors", &t.Selectors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceIndicatorModel.
func (t ThreatIntelligenceIndicatorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	objectMap["kind"] = ThreatIntelligenceResourceInnerKindIndicator
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceIndicatorModel.
func (t *ThreatIntelligenceIndicatorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceIndicatorProperties.
func (t ThreatIntelligenceIndicatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", t.AdditionalData)
	populate(objectMap, "confidence", t.Confidence)
	populate(objectMap, "created", t.Created)
	populate(objectMap, "createdByRef", t.CreatedByRef)
	populate(objectMap, "defanged", t.Defanged)
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "extensions", t.Extensions)
	populate(objectMap, "externalId", t.ExternalID)
	populate(objectMap, "externalLastUpdatedTimeUtc", t.ExternalLastUpdatedTimeUTC)
	populate(objectMap, "externalReferences", t.ExternalReferences)
	populate(objectMap, "friendlyName", t.FriendlyName)
	populate(objectMap, "granularMarkings", t.GranularMarkings)
	populate(objectMap, "indicatorTypes", t.IndicatorTypes)
	populate(objectMap, "killChainPhases", t.KillChainPhases)
	populate(objectMap, "labels", t.Labels)
	populate(objectMap, "language", t.Language)
	populate(objectMap, "lastUpdatedTimeUtc", t.LastUpdatedTimeUTC)
	populate(objectMap, "modified", t.Modified)
	populate(objectMap, "objectMarkingRefs", t.ObjectMarkingRefs)
	populate(objectMap, "parsedPattern", t.ParsedPattern)
	populate(objectMap, "pattern", t.Pattern)
	populate(objectMap, "patternType", t.PatternType)
	populate(objectMap, "patternVersion", t.PatternVersion)
	populate(objectMap, "revoked", t.Revoked)
	populate(objectMap, "source", t.Source)
	populate(objectMap, "threatIntelligenceTags", t.ThreatIntelligenceTags)
	populate(objectMap, "threatTypes", t.ThreatTypes)
	populate(objectMap, "validFrom", t.ValidFrom)
	populate(objectMap, "validUntil", t.ValidUntil)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceIndicatorProperties.
func (t *ThreatIntelligenceIndicatorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &t.AdditionalData)
			delete(rawMsg, key)
		case "confidence":
			err = unpopulate(val, "Confidence", &t.Confidence)
			delete(rawMsg, key)
		case "created":
			err = unpopulate(val, "Created", &t.Created)
			delete(rawMsg, key)
		case "createdByRef":
			err = unpopulate(val, "CreatedByRef", &t.CreatedByRef)
			delete(rawMsg, key)
		case "defanged":
			err = unpopulate(val, "Defanged", &t.Defanged)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &t.DisplayName)
			delete(rawMsg, key)
		case "extensions":
			err = unpopulate(val, "Extensions", &t.Extensions)
			delete(rawMsg, key)
		case "externalId":
			err = unpopulate(val, "ExternalID", &t.ExternalID)
			delete(rawMsg, key)
		case "externalLastUpdatedTimeUtc":
			err = unpopulate(val, "ExternalLastUpdatedTimeUTC", &t.ExternalLastUpdatedTimeUTC)
			delete(rawMsg, key)
		case "externalReferences":
			err = unpopulate(val, "ExternalReferences", &t.ExternalReferences)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &t.FriendlyName)
			delete(rawMsg, key)
		case "granularMarkings":
			err = unpopulate(val, "GranularMarkings", &t.GranularMarkings)
			delete(rawMsg, key)
		case "indicatorTypes":
			err = unpopulate(val, "IndicatorTypes", &t.IndicatorTypes)
			delete(rawMsg, key)
		case "killChainPhases":
			err = unpopulate(val, "KillChainPhases", &t.KillChainPhases)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &t.Labels)
			delete(rawMsg, key)
		case "language":
			err = unpopulate(val, "Language", &t.Language)
			delete(rawMsg, key)
		case "lastUpdatedTimeUtc":
			err = unpopulate(val, "LastUpdatedTimeUTC", &t.LastUpdatedTimeUTC)
			delete(rawMsg, key)
		case "modified":
			err = unpopulate(val, "Modified", &t.Modified)
			delete(rawMsg, key)
		case "objectMarkingRefs":
			err = unpopulate(val, "ObjectMarkingRefs", &t.ObjectMarkingRefs)
			delete(rawMsg, key)
		case "parsedPattern":
			err = unpopulate(val, "ParsedPattern", &t.ParsedPattern)
			delete(rawMsg, key)
		case "pattern":
			err = unpopulate(val, "Pattern", &t.Pattern)
			delete(rawMsg, key)
		case "patternType":
			err = unpopulate(val, "PatternType", &t.PatternType)
			delete(rawMsg, key)
		case "patternVersion":
			err = unpopulate(val, "PatternVersion", &t.PatternVersion)
			delete(rawMsg, key)
		case "revoked":
			err = unpopulate(val, "Revoked", &t.Revoked)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &t.Source)
			delete(rawMsg, key)
		case "threatIntelligenceTags":
			err = unpopulate(val, "ThreatIntelligenceTags", &t.ThreatIntelligenceTags)
			delete(rawMsg, key)
		case "threatTypes":
			err = unpopulate(val, "ThreatTypes", &t.ThreatTypes)
			delete(rawMsg, key)
		case "validFrom":
			err = unpopulate(val, "ValidFrom", &t.ValidFrom)
			delete(rawMsg, key)
		case "validUntil":
			err = unpopulate(val, "ValidUntil", &t.ValidUntil)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceInformation.
func (t ThreatIntelligenceInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "id", t.ID)
	objectMap["kind"] = t.Kind
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceInformation.
func (t *ThreatIntelligenceInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceInformationList.
func (t ThreatIntelligenceInformationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceInformationList.
func (t *ThreatIntelligenceInformationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			t.Value, err = unmarshalThreatIntelligenceInformationClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceKillChainPhase.
func (t ThreatIntelligenceKillChainPhase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "killChainName", t.KillChainName)
	populate(objectMap, "phaseName", t.PhaseName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceKillChainPhase.
func (t *ThreatIntelligenceKillChainPhase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "killChainName":
			err = unpopulate(val, "KillChainName", &t.KillChainName)
			delete(rawMsg, key)
		case "phaseName":
			err = unpopulate(val, "PhaseName", &t.PhaseName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceMetric.
func (t ThreatIntelligenceMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lastUpdatedTimeUtc", t.LastUpdatedTimeUTC)
	populate(objectMap, "patternTypeMetrics", t.PatternTypeMetrics)
	populate(objectMap, "sourceMetrics", t.SourceMetrics)
	populate(objectMap, "threatTypeMetrics", t.ThreatTypeMetrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceMetric.
func (t *ThreatIntelligenceMetric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTimeUtc":
			err = unpopulate(val, "LastUpdatedTimeUTC", &t.LastUpdatedTimeUTC)
			delete(rawMsg, key)
		case "patternTypeMetrics":
			err = unpopulate(val, "PatternTypeMetrics", &t.PatternTypeMetrics)
			delete(rawMsg, key)
		case "sourceMetrics":
			err = unpopulate(val, "SourceMetrics", &t.SourceMetrics)
			delete(rawMsg, key)
		case "threatTypeMetrics":
			err = unpopulate(val, "ThreatTypeMetrics", &t.ThreatTypeMetrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceMetricEntity.
func (t ThreatIntelligenceMetricEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricName", t.MetricName)
	populate(objectMap, "metricValue", t.MetricValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceMetricEntity.
func (t *ThreatIntelligenceMetricEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricName":
			err = unpopulate(val, "MetricName", &t.MetricName)
			delete(rawMsg, key)
		case "metricValue":
			err = unpopulate(val, "MetricValue", &t.MetricValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceMetrics.
func (t ThreatIntelligenceMetrics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceMetrics.
func (t *ThreatIntelligenceMetrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceMetricsList.
func (t ThreatIntelligenceMetricsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceMetricsList.
func (t *ThreatIntelligenceMetricsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceParsedPattern.
func (t ThreatIntelligenceParsedPattern) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "patternTypeKey", t.PatternTypeKey)
	populate(objectMap, "patternTypeValues", t.PatternTypeValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceParsedPattern.
func (t *ThreatIntelligenceParsedPattern) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patternTypeKey":
			err = unpopulate(val, "PatternTypeKey", &t.PatternTypeKey)
			delete(rawMsg, key)
		case "patternTypeValues":
			err = unpopulate(val, "PatternTypeValues", &t.PatternTypeValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceParsedPatternTypeValue.
func (t ThreatIntelligenceParsedPatternTypeValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", t.Value)
	populate(objectMap, "valueType", t.ValueType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceParsedPatternTypeValue.
func (t *ThreatIntelligenceParsedPatternTypeValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		case "valueType":
			err = unpopulate(val, "ValueType", &t.ValueType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ThreatIntelligenceSortingCriteria.
func (t ThreatIntelligenceSortingCriteria) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "itemKey", t.ItemKey)
	populate(objectMap, "sortOrder", t.SortOrder)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ThreatIntelligenceSortingCriteria.
func (t *ThreatIntelligenceSortingCriteria) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "itemKey":
			err = unpopulate(val, "ItemKey", &t.ItemKey)
			delete(rawMsg, key)
		case "sortOrder":
			err = unpopulate(val, "SortOrder", &t.SortOrder)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLEntity.
func (u URLEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	objectMap["kind"] = EntityKindEnumURL
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "systemData", u.SystemData)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLEntity.
func (u *URLEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &u.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URLEntityProperties.
func (u URLEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalData", u.AdditionalData)
	populate(objectMap, "friendlyName", u.FriendlyName)
	populate(objectMap, "url", u.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URLEntityProperties.
func (u *URLEntityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalData":
			err = unpopulate(val, "AdditionalData", &u.AdditionalData)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &u.FriendlyName)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &u.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserInfo.
func (u UserInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "email", u.Email)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "objectId", u.ObjectID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserInfo.
func (u *UserInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "email":
			err = unpopulate(val, "Email", &u.Email)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &u.ObjectID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Watchlist.
func (w Watchlist) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Watchlist.
func (w *Watchlist) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatchlistItem.
func (w WatchlistItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatchlistItem.
func (w *WatchlistItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatchlistItemList.
func (w WatchlistItemList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatchlistItemList.
func (w *WatchlistItemList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatchlistItemProperties.
func (w WatchlistItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "created", w.Created)
	populate(objectMap, "createdBy", w.CreatedBy)
	populateAny(objectMap, "entityMapping", w.EntityMapping)
	populate(objectMap, "isDeleted", w.IsDeleted)
	populateAny(objectMap, "itemsKeyValue", w.ItemsKeyValue)
	populate(objectMap, "tenantId", w.TenantID)
	populateDateTimeRFC3339(objectMap, "updated", w.Updated)
	populate(objectMap, "updatedBy", w.UpdatedBy)
	populate(objectMap, "watchlistItemId", w.WatchlistItemID)
	populate(objectMap, "watchlistItemType", w.WatchlistItemType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatchlistItemProperties.
func (w *WatchlistItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &w.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &w.CreatedBy)
			delete(rawMsg, key)
		case "entityMapping":
			err = unpopulate(val, "EntityMapping", &w.EntityMapping)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &w.IsDeleted)
			delete(rawMsg, key)
		case "itemsKeyValue":
			err = unpopulate(val, "ItemsKeyValue", &w.ItemsKeyValue)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &w.Updated)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &w.UpdatedBy)
			delete(rawMsg, key)
		case "watchlistItemId":
			err = unpopulate(val, "WatchlistItemID", &w.WatchlistItemID)
			delete(rawMsg, key)
		case "watchlistItemType":
			err = unpopulate(val, "WatchlistItemType", &w.WatchlistItemType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatchlistList.
func (w WatchlistList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatchlistList.
func (w *WatchlistList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WatchlistProperties.
func (w WatchlistProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentType", w.ContentType)
	populateDateTimeRFC3339(objectMap, "created", w.Created)
	populate(objectMap, "createdBy", w.CreatedBy)
	populate(objectMap, "defaultDuration", w.DefaultDuration)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "displayName", w.DisplayName)
	populate(objectMap, "isDeleted", w.IsDeleted)
	populate(objectMap, "itemsSearchKey", w.ItemsSearchKey)
	populate(objectMap, "labels", w.Labels)
	populate(objectMap, "numberOfLinesToSkip", w.NumberOfLinesToSkip)
	populate(objectMap, "provider", w.Provider)
	populate(objectMap, "rawContent", w.RawContent)
	populate(objectMap, "source", w.Source)
	populate(objectMap, "tenantId", w.TenantID)
	populateDateTimeRFC3339(objectMap, "updated", w.Updated)
	populate(objectMap, "updatedBy", w.UpdatedBy)
	populate(objectMap, "uploadStatus", w.UploadStatus)
	populate(objectMap, "watchlistAlias", w.WatchlistAlias)
	populate(objectMap, "watchlistId", w.WatchlistID)
	populate(objectMap, "watchlistType", w.WatchlistType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WatchlistProperties.
func (w *WatchlistProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentType":
			err = unpopulate(val, "ContentType", &w.ContentType)
			delete(rawMsg, key)
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &w.Created)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &w.CreatedBy)
			delete(rawMsg, key)
		case "defaultDuration":
			err = unpopulate(val, "DefaultDuration", &w.DefaultDuration)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &w.DisplayName)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &w.IsDeleted)
			delete(rawMsg, key)
		case "itemsSearchKey":
			err = unpopulate(val, "ItemsSearchKey", &w.ItemsSearchKey)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &w.Labels)
			delete(rawMsg, key)
		case "numberOfLinesToSkip":
			err = unpopulate(val, "NumberOfLinesToSkip", &w.NumberOfLinesToSkip)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &w.Provider)
			delete(rawMsg, key)
		case "rawContent":
			err = unpopulate(val, "RawContent", &w.RawContent)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &w.Source)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "updated":
			err = unpopulateDateTimeRFC3339(val, "Updated", &w.Updated)
			delete(rawMsg, key)
		case "updatedBy":
			err = unpopulate(val, "UpdatedBy", &w.UpdatedBy)
			delete(rawMsg, key)
		case "uploadStatus":
			err = unpopulate(val, "UploadStatus", &w.UploadStatus)
			delete(rawMsg, key)
		case "watchlistAlias":
			err = unpopulate(val, "WatchlistAlias", &w.WatchlistAlias)
			delete(rawMsg, key)
		case "watchlistId":
			err = unpopulate(val, "WatchlistID", &w.WatchlistID)
			delete(rawMsg, key)
		case "watchlistType":
			err = unpopulate(val, "WatchlistType", &w.WatchlistType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
