//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armserialconsole

// DisableSerialConsoleResult - Returns whether or not Serial Console is disabled.
type DisableSerialConsoleResult struct {
	// Whether or not Serial Console is disabled.
	Disabled *bool
}

// EnableSerialConsoleResult - Returns whether or not Serial Console is disabled (enabled).
type EnableSerialConsoleResult struct {
	// Whether or not Serial Console is disabled (enabled).
	Disabled *bool
}

// GetSerialConsoleSubscriptionNotFound - Error saying that the provided subscription could not be found
type GetSerialConsoleSubscriptionNotFound struct {
	// Error code
	Code *string

	// Subscription not found message
	Message *string
}

// Operations - Serial Console operations
type Operations struct {
	// A list of Serial Console operations
	Value []*OperationsValueItem
}

type OperationsValueItem struct {
	Display      *OperationsValueItemDisplay
	IsDataAction *string
	Name         *string
}

type OperationsValueItemDisplay struct {
	Description *string
	Operation   *string
	Provider    *string
	Resource    *string
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SerialPort - Represents the serial port of the parent resource.
type SerialPort struct {
	// The properties of the serial port.
	Properties *SerialPortProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SerialPortConnectResult - Returns a connection string to the serial port of the resource.
type SerialPortConnectResult struct {
	// Connection string to the serial port of the resource.
	ConnectionString *string
}

// SerialPortListResult - The list serial ports operation response.
type SerialPortListResult struct {
	// The list of serial ports.
	Value []*SerialPort
}

// SerialPortProperties - The properties of the serial port.
type SerialPortProperties struct {
	// Specifies whether the port is enabled for a serial console connection.
	State *SerialPortState
}

// Status - Returns whether or not Serial Console is disabled.
type Status struct {
	// Whether or not Serial Console is disabled.
	Disabled *bool
}
