//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabasesServer is a fake server for instances of the armsql.DatabasesClient type.
type DatabasesServer struct {
	// BeginCreateOrUpdate is the fake for method DatabasesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters armsql.Database, options *armsql.DatabasesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.DatabasesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DatabasesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.DatabasesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginExport is the fake for method DatabasesClient.BeginExport
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginExport func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters armsql.ExportDatabaseDefinition, options *armsql.DatabasesClientBeginExportOptions) (resp azfake.PollerResponder[armsql.DatabasesClientExportResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method DatabasesClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFailover func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientBeginFailoverOptions) (resp azfake.PollerResponder[armsql.DatabasesClientFailoverResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DatabasesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientGetOptions) (resp azfake.Responder[armsql.DatabasesClientGetResponse], errResp azfake.ErrorResponder)

	// BeginImport is the fake for method DatabasesClient.BeginImport
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginImport func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters armsql.ImportExistingDatabaseDefinition, options *armsql.DatabasesClientBeginImportOptions) (resp azfake.PollerResponder[armsql.DatabasesClientImportResponse], errResp azfake.ErrorResponder)

	// NewListByElasticPoolPager is the fake for method DatabasesClient.NewListByElasticPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByElasticPoolPager func(resourceGroupName string, serverName string, elasticPoolName string, options *armsql.DatabasesClientListByElasticPoolOptions) (resp azfake.PagerResponder[armsql.DatabasesClientListByElasticPoolResponse])

	// NewListByServerPager is the fake for method DatabasesClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, options *armsql.DatabasesClientListByServerOptions) (resp azfake.PagerResponder[armsql.DatabasesClientListByServerResponse])

	// NewListInaccessibleByServerPager is the fake for method DatabasesClient.NewListInaccessibleByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInaccessibleByServerPager func(resourceGroupName string, serverName string, options *armsql.DatabasesClientListInaccessibleByServerOptions) (resp azfake.PagerResponder[armsql.DatabasesClientListInaccessibleByServerResponse])

	// NewListMetricDefinitionsPager is the fake for method DatabasesClient.NewListMetricDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricDefinitionsPager func(resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientListMetricDefinitionsOptions) (resp azfake.PagerResponder[armsql.DatabasesClientListMetricDefinitionsResponse])

	// NewListMetricsPager is the fake for method DatabasesClient.NewListMetricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMetricsPager func(resourceGroupName string, serverName string, databaseName string, filter string, options *armsql.DatabasesClientListMetricsOptions) (resp azfake.PagerResponder[armsql.DatabasesClientListMetricsResponse])

	// BeginPause is the fake for method DatabasesClient.BeginPause
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPause func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientBeginPauseOptions) (resp azfake.PollerResponder[armsql.DatabasesClientPauseResponse], errResp azfake.ErrorResponder)

	// Rename is the fake for method DatabasesClient.Rename
	// HTTP status codes to indicate success: http.StatusOK
	Rename func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters armsql.ResourceMoveDefinition, options *armsql.DatabasesClientRenameOptions) (resp azfake.Responder[armsql.DatabasesClientRenameResponse], errResp azfake.ErrorResponder)

	// BeginResume is the fake for method DatabasesClient.BeginResume
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResume func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientBeginResumeOptions) (resp azfake.PollerResponder[armsql.DatabasesClientResumeResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method DatabasesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters armsql.DatabaseUpdate, options *armsql.DatabasesClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.DatabasesClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpgradeDataWarehouse is the fake for method DatabasesClient.BeginUpgradeDataWarehouse
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpgradeDataWarehouse func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, options *armsql.DatabasesClientBeginUpgradeDataWarehouseOptions) (resp azfake.PollerResponder[armsql.DatabasesClientUpgradeDataWarehouseResponse], errResp azfake.ErrorResponder)
}

// NewDatabasesServerTransport creates a new instance of DatabasesServerTransport with the provided implementation.
// The returned DatabasesServerTransport instance is connected to an instance of armsql.DatabasesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabasesServerTransport(srv *DatabasesServer) *DatabasesServerTransport {
	return &DatabasesServerTransport{
		srv:                              srv,
		beginCreateOrUpdate:              newTracker[azfake.PollerResponder[armsql.DatabasesClientCreateOrUpdateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armsql.DatabasesClientDeleteResponse]](),
		beginExport:                      newTracker[azfake.PollerResponder[armsql.DatabasesClientExportResponse]](),
		beginFailover:                    newTracker[azfake.PollerResponder[armsql.DatabasesClientFailoverResponse]](),
		beginImport:                      newTracker[azfake.PollerResponder[armsql.DatabasesClientImportResponse]](),
		newListByElasticPoolPager:        newTracker[azfake.PagerResponder[armsql.DatabasesClientListByElasticPoolResponse]](),
		newListByServerPager:             newTracker[azfake.PagerResponder[armsql.DatabasesClientListByServerResponse]](),
		newListInaccessibleByServerPager: newTracker[azfake.PagerResponder[armsql.DatabasesClientListInaccessibleByServerResponse]](),
		newListMetricDefinitionsPager:    newTracker[azfake.PagerResponder[armsql.DatabasesClientListMetricDefinitionsResponse]](),
		newListMetricsPager:              newTracker[azfake.PagerResponder[armsql.DatabasesClientListMetricsResponse]](),
		beginPause:                       newTracker[azfake.PollerResponder[armsql.DatabasesClientPauseResponse]](),
		beginResume:                      newTracker[azfake.PollerResponder[armsql.DatabasesClientResumeResponse]](),
		beginUpdate:                      newTracker[azfake.PollerResponder[armsql.DatabasesClientUpdateResponse]](),
		beginUpgradeDataWarehouse:        newTracker[azfake.PollerResponder[armsql.DatabasesClientUpgradeDataWarehouseResponse]](),
	}
}

// DatabasesServerTransport connects instances of armsql.DatabasesClient to instances of DatabasesServer.
// Don't use this type directly, use NewDatabasesServerTransport instead.
type DatabasesServerTransport struct {
	srv                              *DatabasesServer
	beginCreateOrUpdate              *tracker[azfake.PollerResponder[armsql.DatabasesClientCreateOrUpdateResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armsql.DatabasesClientDeleteResponse]]
	beginExport                      *tracker[azfake.PollerResponder[armsql.DatabasesClientExportResponse]]
	beginFailover                    *tracker[azfake.PollerResponder[armsql.DatabasesClientFailoverResponse]]
	beginImport                      *tracker[azfake.PollerResponder[armsql.DatabasesClientImportResponse]]
	newListByElasticPoolPager        *tracker[azfake.PagerResponder[armsql.DatabasesClientListByElasticPoolResponse]]
	newListByServerPager             *tracker[azfake.PagerResponder[armsql.DatabasesClientListByServerResponse]]
	newListInaccessibleByServerPager *tracker[azfake.PagerResponder[armsql.DatabasesClientListInaccessibleByServerResponse]]
	newListMetricDefinitionsPager    *tracker[azfake.PagerResponder[armsql.DatabasesClientListMetricDefinitionsResponse]]
	newListMetricsPager              *tracker[azfake.PagerResponder[armsql.DatabasesClientListMetricsResponse]]
	beginPause                       *tracker[azfake.PollerResponder[armsql.DatabasesClientPauseResponse]]
	beginResume                      *tracker[azfake.PollerResponder[armsql.DatabasesClientResumeResponse]]
	beginUpdate                      *tracker[azfake.PollerResponder[armsql.DatabasesClientUpdateResponse]]
	beginUpgradeDataWarehouse        *tracker[azfake.PollerResponder[armsql.DatabasesClientUpgradeDataWarehouseResponse]]
}

// Do implements the policy.Transporter interface for DatabasesServerTransport.
func (d *DatabasesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabasesClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DatabasesClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DatabasesClient.BeginExport":
		resp, err = d.dispatchBeginExport(req)
	case "DatabasesClient.BeginFailover":
		resp, err = d.dispatchBeginFailover(req)
	case "DatabasesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabasesClient.BeginImport":
		resp, err = d.dispatchBeginImport(req)
	case "DatabasesClient.NewListByElasticPoolPager":
		resp, err = d.dispatchNewListByElasticPoolPager(req)
	case "DatabasesClient.NewListByServerPager":
		resp, err = d.dispatchNewListByServerPager(req)
	case "DatabasesClient.NewListInaccessibleByServerPager":
		resp, err = d.dispatchNewListInaccessibleByServerPager(req)
	case "DatabasesClient.NewListMetricDefinitionsPager":
		resp, err = d.dispatchNewListMetricDefinitionsPager(req)
	case "DatabasesClient.NewListMetricsPager":
		resp, err = d.dispatchNewListMetricsPager(req)
	case "DatabasesClient.BeginPause":
		resp, err = d.dispatchBeginPause(req)
	case "DatabasesClient.Rename":
		resp, err = d.dispatchRename(req)
	case "DatabasesClient.BeginResume":
		resp, err = d.dispatchBeginResume(req)
	case "DatabasesClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	case "DatabasesClient.BeginUpgradeDataWarehouse":
		resp, err = d.dispatchBeginUpgradeDataWarehouse(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.Database](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginExport(req *http.Request) (*http.Response, error) {
	if d.srv.BeginExport == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginExport not implemented")}
	}
	beginExport := d.beginExport.get(req)
	if beginExport == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/export`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ExportDatabaseDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginExport(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginExport = &respr
		d.beginExport.add(req, beginExport)
	}

	resp, err := server.PollerResponderNext(beginExport, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginExport.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginExport) {
		d.beginExport.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if d.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := d.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		replicaTypeUnescaped, err := url.QueryUnescape(qp.Get("replicaType"))
		if err != nil {
			return nil, err
		}
		replicaTypeParam := getOptional(armsql.ReplicaType(replicaTypeUnescaped))
		var options *armsql.DatabasesClientBeginFailoverOptions
		if replicaTypeParam != nil {
			options = &armsql.DatabasesClientBeginFailoverOptions{
				ReplicaType: replicaTypeParam,
			}
		}
		respr, errRespr := d.srv.BeginFailover(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		d.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		d.beginFailover.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var options *armsql.DatabasesClientGetOptions
	if expandParam != nil || filterParam != nil {
		options = &armsql.DatabasesClientGetOptions{
			Expand: expandParam,
			Filter: filterParam,
		}
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Database, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginImport(req *http.Request) (*http.Response, error) {
	if d.srv.BeginImport == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginImport not implemented")}
	}
	beginImport := d.beginImport.get(req)
	if beginImport == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/import`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ImportExistingDatabaseDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginImport(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginImport = &respr
		d.beginImport.add(req, beginImport)
	}

	resp, err := server.PollerResponderNext(beginImport, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginImport.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginImport) {
		d.beginImport.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchNewListByElasticPoolPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByElasticPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByElasticPoolPager not implemented")}
	}
	newListByElasticPoolPager := d.newListByElasticPoolPager.get(req)
	if newListByElasticPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/elasticPools/(?P<elasticPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		elasticPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("elasticPoolName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByElasticPoolPager(resourceGroupNameParam, serverNameParam, elasticPoolNameParam, nil)
		newListByElasticPoolPager = &resp
		d.newListByElasticPoolPager.add(req, newListByElasticPoolPager)
		server.PagerResponderInjectNextLinks(newListByElasticPoolPager, req, func(page *armsql.DatabasesClientListByElasticPoolResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByElasticPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByElasticPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByElasticPoolPager) {
		d.newListByElasticPoolPager.remove(req)
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := d.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armsql.DatabasesClientListByServerOptions
		if skipTokenParam != nil {
			options = &armsql.DatabasesClientListByServerOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := d.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, options)
		newListByServerPager = &resp
		d.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armsql.DatabasesClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		d.newListByServerPager.remove(req)
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchNewListInaccessibleByServerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListInaccessibleByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInaccessibleByServerPager not implemented")}
	}
	newListInaccessibleByServerPager := d.newListInaccessibleByServerPager.get(req)
	if newListInaccessibleByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inaccessibleDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListInaccessibleByServerPager(resourceGroupNameParam, serverNameParam, nil)
		newListInaccessibleByServerPager = &resp
		d.newListInaccessibleByServerPager.add(req, newListInaccessibleByServerPager)
		server.PagerResponderInjectNextLinks(newListInaccessibleByServerPager, req, func(page *armsql.DatabasesClientListInaccessibleByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInaccessibleByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListInaccessibleByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInaccessibleByServerPager) {
		d.newListInaccessibleByServerPager.remove(req)
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchNewListMetricDefinitionsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricDefinitionsPager not implemented")}
	}
	newListMetricDefinitionsPager := d.newListMetricDefinitionsPager.get(req)
	if newListMetricDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metricDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricDefinitionsPager(resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		newListMetricDefinitionsPager = &resp
		d.newListMetricDefinitionsPager.add(req, newListMetricDefinitionsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricDefinitionsPager) {
		d.newListMetricDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchNewListMetricsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListMetricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMetricsPager not implemented")}
	}
	newListMetricsPager := d.newListMetricsPager.get(req)
	if newListMetricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/metrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListMetricsPager(resourceGroupNameParam, serverNameParam, databaseNameParam, filterParam, nil)
		newListMetricsPager = &resp
		d.newListMetricsPager.add(req, newListMetricsPager)
	}
	resp, err := server.PagerResponderNext(newListMetricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListMetricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMetricsPager) {
		d.newListMetricsPager.remove(req)
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginPause(req *http.Request) (*http.Response, error) {
	if d.srv.BeginPause == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPause not implemented")}
	}
	beginPause := d.beginPause.get(req)
	if beginPause == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pause`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginPause(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPause = &respr
		d.beginPause.add(req, beginPause)
	}

	resp, err := server.PollerResponderNext(beginPause, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginPause.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPause) {
		d.beginPause.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchRename(req *http.Request) (*http.Response, error) {
	if d.srv.Rename == nil {
		return nil, &nonRetriableError{errors.New("fake for method Rename not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/move`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.ResourceMoveDefinition](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Rename(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginResume(req *http.Request) (*http.Response, error) {
	if d.srv.BeginResume == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResume not implemented")}
	}
	beginResume := d.beginResume.get(req)
	if beginResume == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resume`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginResume(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResume = &respr
		d.beginResume.add(req, beginResume)
	}

	resp, err := server.PollerResponderNext(beginResume, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginResume.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResume) {
		d.beginResume.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.DatabaseUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}

func (d *DatabasesServerTransport) dispatchBeginUpgradeDataWarehouse(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpgradeDataWarehouse == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgradeDataWarehouse not implemented")}
	}
	beginUpgradeDataWarehouse := d.beginUpgradeDataWarehouse.get(req)
	if beginUpgradeDataWarehouse == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgradeDataWarehouse`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpgradeDataWarehouse(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgradeDataWarehouse = &respr
		d.beginUpgradeDataWarehouse.add(req, beginUpgradeDataWarehouse)
	}

	resp, err := server.PollerResponderNext(beginUpgradeDataWarehouse, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpgradeDataWarehouse.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgradeDataWarehouse) {
		d.beginUpgradeDataWarehouse.remove(req)
	}

	return resp, nil
}
