//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedDatabasesServer is a fake server for instances of the armsql.ManagedDatabasesClient type.
type ManagedDatabasesServer struct {
	// BeginCancelMove is the fake for method ManagedDatabasesClient.BeginCancelMove
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCancelMove func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.ManagedDatabaseMoveDefinition, options *armsql.ManagedDatabasesClientBeginCancelMoveOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientCancelMoveResponse], errResp azfake.ErrorResponder)

	// BeginCompleteMove is the fake for method ManagedDatabasesClient.BeginCompleteMove
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCompleteMove func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.ManagedDatabaseMoveDefinition, options *armsql.ManagedDatabasesClientBeginCompleteMoveOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteMoveResponse], errResp azfake.ErrorResponder)

	// BeginCompleteRestore is the fake for method ManagedDatabasesClient.BeginCompleteRestore
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCompleteRestore func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.CompleteDatabaseRestoreDefinition, options *armsql.ManagedDatabasesClientBeginCompleteRestoreOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteRestoreResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ManagedDatabasesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.ManagedDatabase, options *armsql.ManagedDatabasesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ManagedDatabasesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, options *armsql.ManagedDatabasesClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedDatabasesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, options *armsql.ManagedDatabasesClientGetOptions) (resp azfake.Responder[armsql.ManagedDatabasesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByInstancePager is the fake for method ManagedDatabasesClient.NewListByInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedDatabasesClientListByInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedDatabasesClientListByInstanceResponse])

	// NewListInaccessibleByInstancePager is the fake for method ManagedDatabasesClient.NewListInaccessibleByInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInaccessibleByInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedDatabasesClientListInaccessibleByInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedDatabasesClientListInaccessibleByInstanceResponse])

	// BeginStartMove is the fake for method ManagedDatabasesClient.BeginStartMove
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartMove func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.ManagedDatabaseStartMoveDefinition, options *armsql.ManagedDatabasesClientBeginStartMoveOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientStartMoveResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ManagedDatabasesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.ManagedDatabaseUpdate, options *armsql.ManagedDatabasesClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedDatabasesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewManagedDatabasesServerTransport creates a new instance of ManagedDatabasesServerTransport with the provided implementation.
// The returned ManagedDatabasesServerTransport instance is connected to an instance of armsql.ManagedDatabasesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedDatabasesServerTransport(srv *ManagedDatabasesServer) *ManagedDatabasesServerTransport {
	return &ManagedDatabasesServerTransport{
		srv:                                srv,
		beginCancelMove:                    newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCancelMoveResponse]](),
		beginCompleteMove:                  newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteMoveResponse]](),
		beginCompleteRestore:               newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteRestoreResponse]](),
		beginCreateOrUpdate:                newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCreateOrUpdateResponse]](),
		beginDelete:                        newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientDeleteResponse]](),
		newListByInstancePager:             newTracker[azfake.PagerResponder[armsql.ManagedDatabasesClientListByInstanceResponse]](),
		newListInaccessibleByInstancePager: newTracker[azfake.PagerResponder[armsql.ManagedDatabasesClientListInaccessibleByInstanceResponse]](),
		beginStartMove:                     newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientStartMoveResponse]](),
		beginUpdate:                        newTracker[azfake.PollerResponder[armsql.ManagedDatabasesClientUpdateResponse]](),
	}
}

// ManagedDatabasesServerTransport connects instances of armsql.ManagedDatabasesClient to instances of ManagedDatabasesServer.
// Don't use this type directly, use NewManagedDatabasesServerTransport instead.
type ManagedDatabasesServerTransport struct {
	srv                                *ManagedDatabasesServer
	beginCancelMove                    *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCancelMoveResponse]]
	beginCompleteMove                  *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteMoveResponse]]
	beginCompleteRestore               *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCompleteRestoreResponse]]
	beginCreateOrUpdate                *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientCreateOrUpdateResponse]]
	beginDelete                        *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientDeleteResponse]]
	newListByInstancePager             *tracker[azfake.PagerResponder[armsql.ManagedDatabasesClientListByInstanceResponse]]
	newListInaccessibleByInstancePager *tracker[azfake.PagerResponder[armsql.ManagedDatabasesClientListInaccessibleByInstanceResponse]]
	beginStartMove                     *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientStartMoveResponse]]
	beginUpdate                        *tracker[azfake.PollerResponder[armsql.ManagedDatabasesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ManagedDatabasesServerTransport.
func (m *ManagedDatabasesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedDatabasesClient.BeginCancelMove":
		resp, err = m.dispatchBeginCancelMove(req)
	case "ManagedDatabasesClient.BeginCompleteMove":
		resp, err = m.dispatchBeginCompleteMove(req)
	case "ManagedDatabasesClient.BeginCompleteRestore":
		resp, err = m.dispatchBeginCompleteRestore(req)
	case "ManagedDatabasesClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedDatabasesClient.BeginDelete":
		resp, err = m.dispatchBeginDelete(req)
	case "ManagedDatabasesClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedDatabasesClient.NewListByInstancePager":
		resp, err = m.dispatchNewListByInstancePager(req)
	case "ManagedDatabasesClient.NewListInaccessibleByInstancePager":
		resp, err = m.dispatchNewListInaccessibleByInstancePager(req)
	case "ManagedDatabasesClient.BeginStartMove":
		resp, err = m.dispatchBeginStartMove(req)
	case "ManagedDatabasesClient.BeginUpdate":
		resp, err = m.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginCancelMove(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCancelMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCancelMove not implemented")}
	}
	beginCancelMove := m.beginCancelMove.get(req)
	if beginCancelMove == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancelMove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedDatabaseMoveDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCancelMove(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCancelMove = &respr
		m.beginCancelMove.add(req, beginCancelMove)
	}

	resp, err := server.PollerResponderNext(beginCancelMove, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCancelMove.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCancelMove) {
		m.beginCancelMove.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginCompleteMove(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCompleteMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCompleteMove not implemented")}
	}
	beginCompleteMove := m.beginCompleteMove.get(req)
	if beginCompleteMove == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/completeMove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedDatabaseMoveDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCompleteMove(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCompleteMove = &respr
		m.beginCompleteMove.add(req, beginCompleteMove)
	}

	resp, err := server.PollerResponderNext(beginCompleteMove, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCompleteMove.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCompleteMove) {
		m.beginCompleteMove.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginCompleteRestore(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCompleteRestore == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCompleteRestore not implemented")}
	}
	beginCompleteRestore := m.beginCompleteRestore.get(req)
	if beginCompleteRestore == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/completeRestore`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.CompleteDatabaseRestoreDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCompleteRestore(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCompleteRestore = &respr
		m.beginCompleteRestore.add(req, beginCompleteRestore)
	}

	resp, err := server.PollerResponderNext(beginCompleteRestore, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCompleteRestore.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCompleteRestore) {
		m.beginCompleteRestore.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedDatabase](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := m.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDelete(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		m.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		m.beginDelete.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedDatabase, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchNewListByInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInstancePager not implemented")}
	}
	newListByInstancePager := m.newListByInstancePager.get(req)
	if newListByInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByInstancePager = &resp
		m.newListByInstancePager.add(req, newListByInstancePager)
		server.PagerResponderInjectNextLinks(newListByInstancePager, req, func(page *armsql.ManagedDatabasesClientListByInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInstancePager) {
		m.newListByInstancePager.remove(req)
	}
	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchNewListInaccessibleByInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListInaccessibleByInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInaccessibleByInstancePager not implemented")}
	}
	newListInaccessibleByInstancePager := m.newListInaccessibleByInstancePager.get(req)
	if newListInaccessibleByInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inaccessibleManagedDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListInaccessibleByInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListInaccessibleByInstancePager = &resp
		m.newListInaccessibleByInstancePager.add(req, newListInaccessibleByInstancePager)
		server.PagerResponderInjectNextLinks(newListInaccessibleByInstancePager, req, func(page *armsql.ManagedDatabasesClientListInaccessibleByInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInaccessibleByInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListInaccessibleByInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInaccessibleByInstancePager) {
		m.newListInaccessibleByInstancePager.remove(req)
	}
	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginStartMove(req *http.Request) (*http.Response, error) {
	if m.srv.BeginStartMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartMove not implemented")}
	}
	beginStartMove := m.beginStartMove.get(req)
	if beginStartMove == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startMove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedDatabaseStartMoveDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginStartMove(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartMove = &respr
		m.beginStartMove.add(req, beginStartMove)
	}

	resp, err := server.PollerResponderNext(beginStartMove, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginStartMove.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartMove) {
		m.beginStartMove.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabasesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := m.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedDatabaseUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		m.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		m.beginUpdate.remove(req)
	}

	return resp, nil
}
