//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsqlvirtualmachine_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sqlvirtualmachine/armsqlvirtualmachine"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e79a5aa63c0551c1b5af1d2853cceb495283d334/specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/preview/2022-08-01-preview/examples/ListOperation.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsqlvirtualmachine.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armsqlvirtualmachine.OperationListResult{
		// 	Value: []*armsqlvirtualmachine.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Retrive details of SQL virtual machine group"),
		// 				Operation: to.Ptr("Get SQL virtual machine group details"),
		// 				Resource: to.Ptr("SQL virtual machine group"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/write"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Create a new or change properties of existing SQL virtual machine group"),
		// 				Operation: to.Ptr("Create a new or update existing SQL virtual machine group"),
		// 				Resource: to.Ptr("SQL virtual machine group"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/delete"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Delete existing SQL virtual machine group"),
		// 				Operation: to.Ptr("Delete existing SQL virtual machine group"),
		// 				Resource: to.Ptr("SQL virtual machine group"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/availabilityGroupListeners/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Retrieve details of SQL availability group listener on a given SQL virtual machine group"),
		// 				Operation: to.Ptr("Get availability group listener details"),
		// 				Resource: to.Ptr("SQL availability group listener"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/availabilityGroupListeners/write"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Create a new or changes properties of existing SQL availability group listener"),
		// 				Operation: to.Ptr("Create new or update existing availability group listener"),
		// 				Resource: to.Ptr("SQL availability group listener"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/availabilityGroupListeners/delete"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Delete existing availability group listener"),
		// 				Operation: to.Ptr("Delete existing availability group listener"),
		// 				Resource: to.Ptr("SQL availability group listener"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/sqlVirtualMachines/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("List Sql virtual machines by a particular sql virtual virtual machine group"),
		// 				Operation: to.Ptr("List Sql virtual machines by a particular sql virtual virtual machine group"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachines/startAssessment/action"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachines/redeploy/action"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Redeploy existing SQL virtual machine"),
		// 				Operation: to.Ptr("Redeploy existing SQL virtual machine"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachines/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Retrieve details of SQL virtual machine"),
		// 				Operation: to.Ptr("Get SQL virtual machine instance details"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachines/write"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Create a new or change properties of existing SQL virtual machine"),
		// 				Operation: to.Ptr("Create new or update existing SQL virtual machine"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/sqlVirtualMachines/delete"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Delete existing SQL virtual machine"),
		// 				Operation: to.Ptr("Delete existing SQL virtual machine"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/locations/registerSqlVmCandidate/action"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Register SQL Vm Candidate"),
		// 				Operation: to.Ptr("Register SQL Vm Candidate"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/locations/availabilityGroupListenerOperationResults/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Get result of an availability group listener operation"),
		// 				Operation: to.Ptr("Get availability group listener operation result"),
		// 				Resource: to.Ptr("SQL availability group listener"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/register/action"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Register subscription with Microsoft.SqlVirtualMachine resource provider"),
		// 				Operation: to.Ptr("Register subscription for SQL Virtual Machine"),
		// 				Resource: to.Ptr("Microsoft SQL Virtual Machine"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/unregister/action"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Unregister subscription with Microsoft.SqlVirtualMachine resource provider"),
		// 				Operation: to.Ptr("Unregister subscription for SQL Virtual Machine"),
		// 				Resource: to.Ptr("Microsoft SQL Virtual Machine"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/operations/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Resource: to.Ptr("Available REST operations"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/locations/sqlVirtualMachineGroupOperationResults/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Get result of a SQL virtual machine group operation"),
		// 				Operation: to.Ptr("Get SQL virtual machine group operation result"),
		// 				Resource: to.Ptr("SQL virtual machine group"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.SqlVirtualMachine/locations/sqlVirtualMachineOperationResults/read"),
		// 			Display: &armsqlvirtualmachine.OperationDisplay{
		// 				Description: to.Ptr("Get result of SQL virtual machine operation"),
		// 				Operation: to.Ptr("Get SQL virtual machine operation result"),
		// 				Resource: to.Ptr("SQL virtual machine"),
		// 			},
		// 	}},
		// }
	}
}
