//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
	"net/http"
	"reflect"
	"regexp"
)

// ManagementServer is a fake server for instances of the armstoragecache.ManagementClient type.
type ManagementServer struct {
	// CheckAmlFSSubnets is the fake for method ManagementClient.CheckAmlFSSubnets
	// HTTP status codes to indicate success: http.StatusOK
	CheckAmlFSSubnets func(ctx context.Context, options *armstoragecache.ManagementClientCheckAmlFSSubnetsOptions) (resp azfake.Responder[armstoragecache.ManagementClientCheckAmlFSSubnetsResponse], errResp azfake.ErrorResponder)

	// GetRequiredAmlFSSubnetsSize is the fake for method ManagementClient.GetRequiredAmlFSSubnetsSize
	// HTTP status codes to indicate success: http.StatusOK
	GetRequiredAmlFSSubnetsSize func(ctx context.Context, options *armstoragecache.ManagementClientGetRequiredAmlFSSubnetsSizeOptions) (resp azfake.Responder[armstoragecache.ManagementClientGetRequiredAmlFSSubnetsSizeResponse], errResp azfake.ErrorResponder)
}

// NewManagementServerTransport creates a new instance of ManagementServerTransport with the provided implementation.
// The returned ManagementServerTransport instance is connected to an instance of armstoragecache.ManagementClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagementServerTransport(srv *ManagementServer) *ManagementServerTransport {
	return &ManagementServerTransport{srv: srv}
}

// ManagementServerTransport connects instances of armstoragecache.ManagementClient to instances of ManagementServer.
// Don't use this type directly, use NewManagementServerTransport instead.
type ManagementServerTransport struct {
	srv *ManagementServer
}

// Do implements the policy.Transporter interface for ManagementServerTransport.
func (m *ManagementServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagementClient.CheckAmlFSSubnets":
		resp, err = m.dispatchCheckAmlFSSubnets(req)
	case "ManagementClient.GetRequiredAmlFSSubnetsSize":
		resp, err = m.dispatchGetRequiredAmlFSSubnetsSize(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagementServerTransport) dispatchCheckAmlFSSubnets(req *http.Request) (*http.Response, error) {
	if m.srv.CheckAmlFSSubnets == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckAmlFSSubnets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/checkAmlFSSubnets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstoragecache.AmlFilesystemSubnetInfo](req)
	if err != nil {
		return nil, err
	}
	var options *armstoragecache.ManagementClientCheckAmlFSSubnetsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armstoragecache.ManagementClientCheckAmlFSSubnetsOptions{
			AmlFilesystemSubnetInfo: &body,
		}
	}
	respr, errRespr := m.srv.CheckAmlFSSubnets(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagementServerTransport) dispatchGetRequiredAmlFSSubnetsSize(req *http.Request) (*http.Response, error) {
	if m.srv.GetRequiredAmlFSSubnetsSize == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRequiredAmlFSSubnetsSize not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/getRequiredAmlFSSubnetsSize`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstoragecache.RequiredAmlFilesystemSubnetsSizeInfo](req)
	if err != nil {
		return nil, err
	}
	var options *armstoragecache.ManagementClientGetRequiredAmlFSSubnetsSizeOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armstoragecache.ManagementClientGetRequiredAmlFSSubnetsSizeOptions{
			RequiredAMLFilesystemSubnetsSizeInfo: &body,
		}
	}
	respr, errRespr := m.srv.GetRequiredAmlFSSubnetsSize(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RequiredAmlFilesystemSubnetsSize, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
