//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorageimportexport_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storageimportexport/armstorageimportexport"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/ListJobsInSubscription.json
func ExampleJobsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobsClient().NewListBySubscriptionPager(&armstorageimportexport.JobsClientListBySubscriptionOptions{Top: nil,
		Filter:         nil,
		AcceptLanguage: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListJobsResponse = armstorageimportexport.ListJobsResponse{
		// 	Value: []*armstorageimportexport.JobResponse{
		// 		{
		// 			Name: to.Ptr("test-bn1-import-cpu100-01"),
		// 			Type: to.Ptr("Microsoft.ImportExport/jobs"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/testrg/providers/Microsoft.ImportExport/jobs/test-bn1-import-cpu100-01"),
		// 			Identity: &armstorageimportexport.IdentityDetails{
		// 				Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
		// 			},
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armstorageimportexport.JobDetails{
		// 				BackupDriveManifest: to.Ptr(true),
		// 				CancelRequested: to.Ptr(false),
		// 				DeliveryPackage: &armstorageimportexport.DeliveryPackageInformation{
		// 					CarrierName: to.Ptr("FedEx"),
		// 					DriveCount: to.Ptr[int64](1),
		// 					ShipDate: to.Ptr("8/11/2017 9:05:00 PM"),
		// 					TrackingNumber: to.Ptr("992016102507"),
		// 				},
		// 				DiagnosticsPath: to.Ptr("waimportexport"),
		// 				DriveList: []*armstorageimportexport.DriveStatus{
		// 					{
		// 						DriveID: to.Ptr("7PHR882C"),
		// 						ManifestFile: to.Ptr("\\DriveManifest.xml"),
		// 						ManifestHash: to.Ptr("E5D632DB047C74B3B17C8F3359950ADB"),
		// 						State: to.Ptr(armstorageimportexport.DriveStateReceived),
		// 				}},
		// 				EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
		// 					KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
		// 				},
		// 				JobType: to.Ptr("Import"),
		// 				LogLevel: to.Ptr("Verbose"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ReturnAddress: &armstorageimportexport.ReturnAddress{
		// 					City: to.Ptr("city"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Email: to.Ptr("test@contoso.com"),
		// 					Phone: to.Ptr("425000000"),
		// 					PostalCode: to.Ptr("98007"),
		// 					RecipientName: to.Ptr("La"),
		// 					StateOrProvince: to.Ptr("wa"),
		// 					StreetAddress1: to.Ptr("Street1"),
		// 					StreetAddress2: to.Ptr("street2"),
		// 				},
		// 				ReturnShipping: &armstorageimportexport.ReturnShipping{
		// 					CarrierAccountNumber: to.Ptr("989ffff"),
		// 					CarrierName: to.Ptr("FedEx"),
		// 				},
		// 				ShippingInformation: &armstorageimportexport.ShippingInformation{
		// 					AdditionalInformation: to.Ptr(""),
		// 					City: to.Ptr("Boydton"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Phone: to.Ptr("+1-434-738-9443"),
		// 					PostalCode: to.Ptr("23917"),
		// 					RecipientName: to.Ptr("Windows Azure Import Export Service"),
		// 					StateOrProvince: to.Ptr("VA"),
		// 					StreetAddress1: to.Ptr("Boydton 1 / BLDG # 1 101 Herbert Drive"),
		// 					StreetAddress2: to.Ptr(""),
		// 				},
		// 				State: to.Ptr("Received"),
		// 				StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/testrg/providers/Microsoft.Storage/storageAccounts/xtprodtestarmos2"),
		// 			},
		// 			SystemData: &armstorageimportexport.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("test-bn1-import-cpu100-02"),
		// 			Type: to.Ptr("Microsoft.ImportExport/jobs"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/testrg/providers/Microsoft.ImportExport/jobs/test-bn1-import-cpu100-02"),
		// 			Identity: &armstorageimportexport.IdentityDetails{
		// 				Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
		// 			},
		// 			Location: to.Ptr("East US 2"),
		// 			Properties: &armstorageimportexport.JobDetails{
		// 				BackupDriveManifest: to.Ptr(true),
		// 				CancelRequested: to.Ptr(false),
		// 				DeliveryPackage: &armstorageimportexport.DeliveryPackageInformation{
		// 					CarrierName: to.Ptr("FedEx"),
		// 					DriveCount: to.Ptr[int64](1),
		// 					ShipDate: to.Ptr("8/13/2017 7:32:23 PM"),
		// 					TrackingNumber: to.Ptr("992016102508"),
		// 				},
		// 				DiagnosticsPath: to.Ptr("waimportexport"),
		// 				DriveList: []*armstorageimportexport.DriveStatus{
		// 					{
		// 						CopyStatus: to.Ptr("InProgress"),
		// 						DriveID: to.Ptr("KV6H86XP"),
		// 						ErrorLogURI: to.Ptr("https://foo.blob.core.windows.net/waimportexport/waies/test-bn1-import-cpu100-02_KV6H86XP_20170813-194620-021_error.xml"),
		// 						ManifestFile: to.Ptr("\\DriveManifest.xml"),
		// 						ManifestHash: to.Ptr("F6A488A65AF0CCA7D050B7F9F43A197C"),
		// 						ManifestURI: to.Ptr("https://foo.blob.core.windows.net/waimportexport/waies/test-bn1-import-cpu100-02_KV6H86XP_20170813-194620-574_manifest.xml"),
		// 						State: to.Ptr(armstorageimportexport.DriveStateCompletedMoreInfo),
		// 						VerboseLogURI: to.Ptr("https://foo.blob.core.windows.net/waimportexport/waies/test-bn1-import-cpu100-02_KV6H86XP_20170813-194618-350_verbose.xml"),
		// 				}},
		// 				EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
		// 					KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
		// 				},
		// 				JobType: to.Ptr("Import"),
		// 				LogLevel: to.Ptr("Verbose"),
		// 				PercentComplete: to.Ptr[int64](6),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ReturnAddress: &armstorageimportexport.ReturnAddress{
		// 					City: to.Ptr("city"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Email: to.Ptr("test@contoso.com"),
		// 					Phone: to.Ptr("4256150991"),
		// 					PostalCode: to.Ptr("98007"),
		// 					RecipientName: to.Ptr("La"),
		// 					StateOrProvince: to.Ptr("wa"),
		// 					StreetAddress1: to.Ptr("Street1"),
		// 					StreetAddress2: to.Ptr("street2"),
		// 				},
		// 				ShippingInformation: &armstorageimportexport.ShippingInformation{
		// 					AdditionalInformation: to.Ptr(""),
		// 					City: to.Ptr("Boydton"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Phone: to.Ptr("+1-434-738-9443"),
		// 					PostalCode: to.Ptr("23917"),
		// 					RecipientName: to.Ptr("Windows Azure Import Export Service"),
		// 					StateOrProvince: to.Ptr("VA"),
		// 					StreetAddress1: to.Ptr("Boydton 1 / BLDG # 1 101 Herbert Drive"),
		// 					StreetAddress2: to.Ptr(""),
		// 				},
		// 				State: to.Ptr("Transferring"),
		// 				StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/testrg/providers/Microsoft.Storage/storageAccounts/xtprodtestarmos2"),
		// 			},
		// 			SystemData: &armstorageimportexport.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/ListJobsInResourceGroup.json
func ExampleJobsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewJobsClient().NewListByResourceGroupPager("myResourceGroup", &armstorageimportexport.JobsClientListByResourceGroupOptions{Top: nil,
		Filter:         nil,
		AcceptLanguage: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListJobsResponse = armstorageimportexport.ListJobsResponse{
		// 	Value: []*armstorageimportexport.JobResponse{
		// 		{
		// 			Name: to.Ptr("test-by1-ssd-2"),
		// 			Type: to.Ptr("Microsoft.ImportExport/jobs"),
		// 			ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/test-by1-ssd-2"),
		// 			Identity: &armstorageimportexport.IdentityDetails{
		// 				Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
		// 			},
		// 			Location: to.Ptr("West US"),
		// 			Properties: &armstorageimportexport.JobDetails{
		// 				BackupDriveManifest: to.Ptr(true),
		// 				CancelRequested: to.Ptr(false),
		// 				DeliveryPackage: &armstorageimportexport.DeliveryPackageInformation{
		// 					CarrierName: to.Ptr("FedEx"),
		// 					DriveCount: to.Ptr[int64](1),
		// 					ShipDate: to.Ptr("9/29/2017 10:28:35 PM"),
		// 					TrackingNumber: to.Ptr("787895108176"),
		// 				},
		// 				DiagnosticsPath: to.Ptr("waimportexport"),
		// 				EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
		// 					KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
		// 				},
		// 				JobType: to.Ptr("Import"),
		// 				LogLevel: to.Ptr("Verbose"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ReturnAddress: &armstorageimportexport.ReturnAddress{
		// 					City: to.Ptr("Redmond"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Email: to.Ptr("test@contoso.com"),
		// 					Phone: to.Ptr("4250000000"),
		// 					PostalCode: to.Ptr("98007"),
		// 					RecipientName: to.Ptr("La"),
		// 					StateOrProvince: to.Ptr("wa"),
		// 					StreetAddress1: to.Ptr("Street1"),
		// 					StreetAddress2: to.Ptr("street2"),
		// 				},
		// 				ReturnShipping: &armstorageimportexport.ReturnShipping{
		// 					CarrierAccountNumber: to.Ptr("989ffff"),
		// 					CarrierName: to.Ptr("FedEx"),
		// 				},
		// 				ShippingInformation: &armstorageimportexport.ShippingInformation{
		// 					AdditionalInformation: to.Ptr(""),
		// 					City: to.Ptr("Santa Clara"),
		// 					CountryOrRegion: to.Ptr("USA"),
		// 					Phone: to.Ptr("408 352 7600"),
		// 					PostalCode: to.Ptr("95050"),
		// 					RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
		// 					StateOrProvince: to.Ptr("CA"),
		// 					StreetAddress1: to.Ptr("2045 Lafayette Street"),
		// 					StreetAddress2: to.Ptr(""),
		// 				},
		// 				State: to.Ptr("Received"),
		// 				StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/xtprodtestwu"),
		// 			},
		// 			SystemData: &armstorageimportexport.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/GetExportJob.json
func ExampleJobsClient_Get_getExportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Get(ctx, "myJob", "myResourceGroup", &armstorageimportexport.JobsClientGetOptions{AcceptLanguage: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/test"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		DriveList: []*armstorageimportexport.DriveStatus{
	// 		},
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		Export: &armstorageimportexport.Export{
	// 			BlobList: &armstorageimportexport.ExportBlobList{
	// 				BlobPathPrefix: []*string{
	// 					to.Ptr("/")},
	// 				},
	// 			},
	// 			JobType: to.Ptr("Export"),
	// 			LogLevel: to.Ptr("Verbose"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 				City: to.Ptr("Redmond"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Email: to.Ptr("Test@contoso.com"),
	// 				Phone: to.Ptr("4250000000"),
	// 				PostalCode: to.Ptr("98007"),
	// 				RecipientName: to.Ptr("Test"),
	// 				StateOrProvince: to.Ptr("wa"),
	// 				StreetAddress1: to.Ptr("Street1"),
	// 				StreetAddress2: to.Ptr("street2"),
	// 			},
	// 			ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 				CarrierAccountNumber: to.Ptr("989ffff"),
	// 				CarrierName: to.Ptr("FedEx"),
	// 			},
	// 			ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 				AdditionalInformation: to.Ptr(""),
	// 				City: to.Ptr("Santa Clara"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Phone: to.Ptr("408 0000 0000"),
	// 				PostalCode: to.Ptr("95050"),
	// 				RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 				StreetAddress2: to.Ptr(""),
	// 			},
	// 			State: to.Ptr("Creating"),
	// 			StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 		},
	// 		SystemData: &armstorageimportexport.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/GetJob.json
func ExampleJobsClient_Get_getImportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Get(ctx, "myJob", "myResourceGroup", &armstorageimportexport.JobsClientGetOptions{AcceptLanguage: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/test"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		DriveList: []*armstorageimportexport.DriveStatus{
	// 			{
	// 				DriveHeaderHash: to.Ptr(""),
	// 				DriveID: to.Ptr("9CA995BB"),
	// 				ManifestFile: to.Ptr("\\DriveManifest.xml"),
	// 				ManifestHash: to.Ptr("109B21108597EF36D5785F08303F3638"),
	// 				State: to.Ptr(armstorageimportexport.DriveStateSpecified),
	// 		}},
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		JobType: to.Ptr("Import"),
	// 		LogLevel: to.Ptr("Verbose"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 			City: to.Ptr("Redmond"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Email: to.Ptr("Test@contoso.com"),
	// 			Phone: to.Ptr("4250000000"),
	// 			PostalCode: to.Ptr("98007"),
	// 			RecipientName: to.Ptr("Test"),
	// 			StateOrProvince: to.Ptr("wa"),
	// 			StreetAddress1: to.Ptr("Street1"),
	// 			StreetAddress2: to.Ptr("street2"),
	// 		},
	// 		ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 			CarrierAccountNumber: to.Ptr("989ffff"),
	// 			CarrierName: to.Ptr("FedEx"),
	// 		},
	// 		ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 			AdditionalInformation: to.Ptr(""),
	// 			City: to.Ptr("Santa Clara"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Phone: to.Ptr("408 0000 0000"),
	// 			PostalCode: to.Ptr("95050"),
	// 			RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 			StateOrProvince: to.Ptr("CA"),
	// 			StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 			StreetAddress2: to.Ptr(""),
	// 		},
	// 		State: to.Ptr("Creating"),
	// 		StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 	},
	// 	SystemData: &armstorageimportexport.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/UpdateExportJob.json
func ExampleJobsClient_Update_updateExportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Update(ctx, "myExportJob", "myResourceGroup", armstorageimportexport.UpdateJobParameters{
		Properties: &armstorageimportexport.UpdateJobParametersProperties{
			BackupDriveManifest: to.Ptr(true),
			LogLevel:            to.Ptr("Verbose"),
			State:               to.Ptr(""),
		},
	}, &armstorageimportexport.JobsClientUpdateOptions{AcceptLanguage: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myExportJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/myExportJob"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		Export: &armstorageimportexport.Export{
	// 			BlobList: &armstorageimportexport.ExportBlobList{
	// 				BlobPathPrefix: []*string{
	// 					to.Ptr("/")},
	// 				},
	// 			},
	// 			JobType: to.Ptr("Export"),
	// 			LogLevel: to.Ptr("Verbose"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 				City: to.Ptr("Redmond"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Email: to.Ptr("Test@contoso.com"),
	// 				Phone: to.Ptr("4250000000"),
	// 				PostalCode: to.Ptr("98007"),
	// 				RecipientName: to.Ptr("Test"),
	// 				StateOrProvince: to.Ptr("wa"),
	// 				StreetAddress1: to.Ptr("Street1"),
	// 				StreetAddress2: to.Ptr("street2"),
	// 			},
	// 			ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 				CarrierAccountNumber: to.Ptr("989ffff"),
	// 				CarrierName: to.Ptr("FedEx"),
	// 			},
	// 			ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 				AdditionalInformation: to.Ptr(""),
	// 				City: to.Ptr("Santa Clara"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Phone: to.Ptr("408 352 7600"),
	// 				PostalCode: to.Ptr("95050"),
	// 				RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 				StreetAddress2: to.Ptr(""),
	// 			},
	// 			State: to.Ptr("Creating"),
	// 			StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 		},
	// 		SystemData: &armstorageimportexport.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/UpdateJob.json
func ExampleJobsClient_Update_updateImportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Update(ctx, "myJob", "myResourceGroup", armstorageimportexport.UpdateJobParameters{
		Properties: &armstorageimportexport.UpdateJobParametersProperties{
			BackupDriveManifest: to.Ptr(true),
			LogLevel:            to.Ptr("Verbose"),
			State:               to.Ptr(""),
		},
	}, &armstorageimportexport.JobsClientUpdateOptions{AcceptLanguage: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/myJob"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		DriveList: []*armstorageimportexport.DriveStatus{
	// 			{
	// 				DriveHeaderHash: to.Ptr("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3"),
	// 				DriveID: to.Ptr("9CA995BB"),
	// 				ManifestFile: to.Ptr("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest"),
	// 				ManifestHash: to.Ptr("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E"),
	// 				State: to.Ptr(armstorageimportexport.DriveStateSpecified),
	// 		}},
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		JobType: to.Ptr("Import"),
	// 		LogLevel: to.Ptr("Verbose"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 			City: to.Ptr("Redmond"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Email: to.Ptr("Test@contoso.com"),
	// 			Phone: to.Ptr("4250000000"),
	// 			PostalCode: to.Ptr("98007"),
	// 			RecipientName: to.Ptr("Test"),
	// 			StateOrProvince: to.Ptr("wa"),
	// 			StreetAddress1: to.Ptr("Street1"),
	// 			StreetAddress2: to.Ptr("street2"),
	// 		},
	// 		ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 			CarrierAccountNumber: to.Ptr("989ffff"),
	// 			CarrierName: to.Ptr("FedEx"),
	// 		},
	// 		ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 			AdditionalInformation: to.Ptr(""),
	// 			City: to.Ptr("Santa Clara"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Phone: to.Ptr("408 352 7600"),
	// 			PostalCode: to.Ptr("95050"),
	// 			RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 			StateOrProvince: to.Ptr("CA"),
	// 			StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 			StreetAddress2: to.Ptr(""),
	// 		},
	// 		State: to.Ptr("Creating"),
	// 		StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 	},
	// 	SystemData: &armstorageimportexport.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/CreateExportJob.json
func ExampleJobsClient_Create_createExportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Create(ctx, "myExportJob", "myResourceGroup", armstorageimportexport.PutJobParameters{
		Location: to.Ptr("West US"),
		Properties: &armstorageimportexport.JobDetails{
			BackupDriveManifest: to.Ptr(true),
			DiagnosticsPath:     to.Ptr("waimportexport"),
			Export: &armstorageimportexport.Export{
				BlobList: &armstorageimportexport.ExportBlobList{
					BlobPathPrefix: []*string{
						to.Ptr("/")},
				},
			},
			JobType:  to.Ptr("Export"),
			LogLevel: to.Ptr("Verbose"),
			ReturnAddress: &armstorageimportexport.ReturnAddress{
				City:            to.Ptr("Redmond"),
				CountryOrRegion: to.Ptr("USA"),
				Email:           to.Ptr("Test@contoso.com"),
				Phone:           to.Ptr("4250000000"),
				PostalCode:      to.Ptr("98007"),
				RecipientName:   to.Ptr("Test"),
				StateOrProvince: to.Ptr("wa"),
				StreetAddress1:  to.Ptr("Street1"),
				StreetAddress2:  to.Ptr("street2"),
			},
			ReturnShipping: &armstorageimportexport.ReturnShipping{
				CarrierAccountNumber: to.Ptr("989ffff"),
				CarrierName:          to.Ptr("FedEx"),
			},
			StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
		},
	}, &armstorageimportexport.JobsClientCreateOptions{AcceptLanguage: nil,
		ClientTenantID: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myExportJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/myExportJob"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		Export: &armstorageimportexport.Export{
	// 			BlobList: &armstorageimportexport.ExportBlobList{
	// 				BlobPathPrefix: []*string{
	// 					to.Ptr("/")},
	// 				},
	// 			},
	// 			JobType: to.Ptr("Export"),
	// 			LogLevel: to.Ptr("Verbose"),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 				City: to.Ptr("Redmond"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Email: to.Ptr("Test@contoso.com"),
	// 				Phone: to.Ptr("4250000000"),
	// 				PostalCode: to.Ptr("98007"),
	// 				RecipientName: to.Ptr("Test"),
	// 				StateOrProvince: to.Ptr("wa"),
	// 				StreetAddress1: to.Ptr("Street1"),
	// 				StreetAddress2: to.Ptr("street2"),
	// 			},
	// 			ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 				CarrierAccountNumber: to.Ptr("989ffff"),
	// 				CarrierName: to.Ptr("FedEx"),
	// 			},
	// 			ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 				AdditionalInformation: to.Ptr(""),
	// 				City: to.Ptr("Santa Clara"),
	// 				CountryOrRegion: to.Ptr("USA"),
	// 				Phone: to.Ptr("408 0000 0000"),
	// 				PostalCode: to.Ptr("95050"),
	// 				RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 				StateOrProvince: to.Ptr("CA"),
	// 				StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 				StreetAddress2: to.Ptr(""),
	// 			},
	// 			State: to.Ptr("Creating"),
	// 			StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 		},
	// 		SystemData: &armstorageimportexport.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/CreateJob.json
func ExampleJobsClient_Create_createImportJob() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewJobsClient().Create(ctx, "myJob", "myResourceGroup", armstorageimportexport.PutJobParameters{
		Location: to.Ptr("West US"),
		Properties: &armstorageimportexport.JobDetails{
			BackupDriveManifest: to.Ptr(true),
			DiagnosticsPath:     to.Ptr("waimportexport"),
			DriveList: []*armstorageimportexport.DriveStatus{
				{
					BitLockerKey:    to.Ptr("238810-662376-448998-450120-652806-203390-606320-483076"),
					DriveHeaderHash: to.Ptr("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3"),
					DriveID:         to.Ptr("9CA995BB"),
					ManifestFile:    to.Ptr("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest"),
					ManifestHash:    to.Ptr("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E"),
				}},
			JobType:  to.Ptr("Import"),
			LogLevel: to.Ptr("Verbose"),
			ReturnAddress: &armstorageimportexport.ReturnAddress{
				City:            to.Ptr("Redmond"),
				CountryOrRegion: to.Ptr("USA"),
				Email:           to.Ptr("Test@contoso.com"),
				Phone:           to.Ptr("4250000000"),
				PostalCode:      to.Ptr("98007"),
				RecipientName:   to.Ptr("Test"),
				StateOrProvince: to.Ptr("wa"),
				StreetAddress1:  to.Ptr("Street1"),
				StreetAddress2:  to.Ptr("street2"),
			},
			ReturnShipping: &armstorageimportexport.ReturnShipping{
				CarrierAccountNumber: to.Ptr("989ffff"),
				CarrierName:          to.Ptr("FedEx"),
			},
			StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
		},
	}, &armstorageimportexport.JobsClientCreateOptions{AcceptLanguage: nil,
		ClientTenantID: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.JobResponse = armstorageimportexport.JobResponse{
	// 	Name: to.Ptr("myJob"),
	// 	Type: to.Ptr("Microsoft.ImportExport/jobs"),
	// 	ID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ImportExport/jobs/myJob"),
	// 	Identity: &armstorageimportexport.IdentityDetails{
	// 		Type: to.Ptr(armstorageimportexport.IdentityTypeNone),
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Properties: &armstorageimportexport.JobDetails{
	// 		BackupDriveManifest: to.Ptr(true),
	// 		CancelRequested: to.Ptr(false),
	// 		DiagnosticsPath: to.Ptr("waimportexport"),
	// 		DriveList: []*armstorageimportexport.DriveStatus{
	// 			{
	// 				DriveHeaderHash: to.Ptr("0:1048576:FB6B6ED500D49DA6E0D723C98D42C657F2881CC13357C28DCECA6A524F1292501571A321238540E621AB5BD9C9A32637615919A75593E6CB5C1515DAE341CABF;135266304:143360:C957A189AFC38C4E80731252301EB91427CE55E61448FA3C73C6FDDE70ABBC197947EC8D0249A2C639BB10B95957D5820A4BE8DFBBF76FFFA688AE5CE0D42EC3"),
	// 				DriveID: to.Ptr("9CA995BB"),
	// 				ManifestFile: to.Ptr("\\8a0c23f7-14b7-470a-9633-fcd46590a1bc.manifest"),
	// 				ManifestHash: to.Ptr("4228EC5D8E048CB9B515338C789314BE8D0B2FDBC7C7A0308E1C826242CDE74E"),
	// 				State: to.Ptr(armstorageimportexport.DriveStateSpecified),
	// 		}},
	// 		EncryptionKey: &armstorageimportexport.EncryptionKeyDetails{
	// 			KekType: to.Ptr(armstorageimportexport.EncryptionKekTypeMicrosoftManaged),
	// 		},
	// 		JobType: to.Ptr("Import"),
	// 		LogLevel: to.Ptr("Verbose"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReturnAddress: &armstorageimportexport.ReturnAddress{
	// 			City: to.Ptr("Redmond"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Email: to.Ptr("Test@contoso.com"),
	// 			Phone: to.Ptr("4250000000"),
	// 			PostalCode: to.Ptr("98007"),
	// 			RecipientName: to.Ptr("Test"),
	// 			StateOrProvince: to.Ptr("wa"),
	// 			StreetAddress1: to.Ptr("Street1"),
	// 			StreetAddress2: to.Ptr("street2"),
	// 		},
	// 		ReturnShipping: &armstorageimportexport.ReturnShipping{
	// 			CarrierAccountNumber: to.Ptr("989ffff"),
	// 			CarrierName: to.Ptr("FedEx"),
	// 		},
	// 		ShippingInformation: &armstorageimportexport.ShippingInformation{
	// 			AdditionalInformation: to.Ptr(""),
	// 			City: to.Ptr("Santa Clara"),
	// 			CountryOrRegion: to.Ptr("USA"),
	// 			Phone: to.Ptr("408 0000 0000"),
	// 			PostalCode: to.Ptr("95050"),
	// 			RecipientName: to.Ptr("Microsoft Azure Import/Export Service"),
	// 			StateOrProvince: to.Ptr("CA"),
	// 			StreetAddress1: to.Ptr("2045 Lafayette Street"),
	// 			StreetAddress2: to.Ptr(""),
	// 		},
	// 		State: to.Ptr("Creating"),
	// 		StorageAccountID: to.Ptr("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.ClassicStorage/storageAccounts/test"),
	// 	},
	// 	SystemData: &armstorageimportexport.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-03T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armstorageimportexport.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/storageimportexport/resource-manager/Microsoft.ImportExport/preview/2021-01-01/examples/DeleteJob.json
func ExampleJobsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorageimportexport.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewJobsClient().Delete(ctx, "myJob", "myResourceGroup", &armstorageimportexport.JobsClientDeleteOptions{AcceptLanguage: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
