//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragesync

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type APIError.
func (a APIError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIError.
func (a *APIError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &a.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupRequest.
func (b BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileShare", b.AzureFileShare)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupRequest.
func (b *BackupRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShare":
			err = unpopulate(val, "AzureFileShare", &b.AzureFileShare)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityParameters.
func (c CheckNameAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	objectMap["type"] = "Microsoft.StorageSync/storageSyncServices"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityParameters.
func (c *CheckNameAvailabilityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResult.
func (c CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResult.
func (c *CheckNameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpoint.
func (c CloudEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpoint.
func (c *CloudEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointArray.
func (c CloudEndpointArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointArray.
func (c *CloudEndpointArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointChangeEnumerationActivity.
func (c CloudEndpointChangeEnumerationActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deletesProgressPercent", c.DeletesProgressPercent)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "minutesRemaining", c.MinutesRemaining)
	populate(objectMap, "operationState", c.OperationState)
	populate(objectMap, "processedDirectoriesCount", c.ProcessedDirectoriesCount)
	populate(objectMap, "processedFilesCount", c.ProcessedFilesCount)
	populate(objectMap, "progressPercent", c.ProgressPercent)
	populateDateTimeRFC3339(objectMap, "startedTimestamp", c.StartedTimestamp)
	populate(objectMap, "statusCode", c.StatusCode)
	populate(objectMap, "totalCountsState", c.TotalCountsState)
	populate(objectMap, "totalDirectoriesCount", c.TotalDirectoriesCount)
	populate(objectMap, "totalFilesCount", c.TotalFilesCount)
	populate(objectMap, "totalSizeBytes", c.TotalSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointChangeEnumerationActivity.
func (c *CloudEndpointChangeEnumerationActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deletesProgressPercent":
			err = unpopulate(val, "DeletesProgressPercent", &c.DeletesProgressPercent)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "minutesRemaining":
			err = unpopulate(val, "MinutesRemaining", &c.MinutesRemaining)
			delete(rawMsg, key)
		case "operationState":
			err = unpopulate(val, "OperationState", &c.OperationState)
			delete(rawMsg, key)
		case "processedDirectoriesCount":
			err = unpopulate(val, "ProcessedDirectoriesCount", &c.ProcessedDirectoriesCount)
			delete(rawMsg, key)
		case "processedFilesCount":
			err = unpopulate(val, "ProcessedFilesCount", &c.ProcessedFilesCount)
			delete(rawMsg, key)
		case "progressPercent":
			err = unpopulate(val, "ProgressPercent", &c.ProgressPercent)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "StartedTimestamp", &c.StartedTimestamp)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &c.StatusCode)
			delete(rawMsg, key)
		case "totalCountsState":
			err = unpopulate(val, "TotalCountsState", &c.TotalCountsState)
			delete(rawMsg, key)
		case "totalDirectoriesCount":
			err = unpopulate(val, "TotalDirectoriesCount", &c.TotalDirectoriesCount)
			delete(rawMsg, key)
		case "totalFilesCount":
			err = unpopulate(val, "TotalFilesCount", &c.TotalFilesCount)
			delete(rawMsg, key)
		case "totalSizeBytes":
			err = unpopulate(val, "TotalSizeBytes", &c.TotalSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointChangeEnumerationStatus.
func (c CloudEndpointChangeEnumerationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activity", c.Activity)
	populate(objectMap, "lastEnumerationStatus", c.LastEnumerationStatus)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointChangeEnumerationStatus.
func (c *CloudEndpointChangeEnumerationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activity":
			err = unpopulate(val, "Activity", &c.Activity)
			delete(rawMsg, key)
		case "lastEnumerationStatus":
			err = unpopulate(val, "LastEnumerationStatus", &c.LastEnumerationStatus)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointCreateParameters.
func (c CloudEndpointCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointCreateParameters.
func (c *CloudEndpointCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointCreateParametersProperties.
func (c CloudEndpointCreateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileShareName", c.AzureFileShareName)
	populate(objectMap, "friendlyName", c.FriendlyName)
	populate(objectMap, "storageAccountResourceId", c.StorageAccountResourceID)
	populate(objectMap, "storageAccountTenantId", c.StorageAccountTenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointCreateParametersProperties.
func (c *CloudEndpointCreateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShareName":
			err = unpopulate(val, "AzureFileShareName", &c.AzureFileShareName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &c.FriendlyName)
			delete(rawMsg, key)
		case "storageAccountResourceId":
			err = unpopulate(val, "StorageAccountResourceID", &c.StorageAccountResourceID)
			delete(rawMsg, key)
		case "storageAccountTenantId":
			err = unpopulate(val, "StorageAccountTenantID", &c.StorageAccountTenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointLastChangeEnumerationStatus.
func (c CloudEndpointLastChangeEnumerationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "completedTimestamp", c.CompletedTimestamp)
	populate(objectMap, "namespaceDirectoriesCount", c.NamespaceDirectoriesCount)
	populate(objectMap, "namespaceFilesCount", c.NamespaceFilesCount)
	populate(objectMap, "namespaceSizeBytes", c.NamespaceSizeBytes)
	populateDateTimeRFC3339(objectMap, "nextRunTimestamp", c.NextRunTimestamp)
	populateDateTimeRFC3339(objectMap, "startedTimestamp", c.StartedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointLastChangeEnumerationStatus.
func (c *CloudEndpointLastChangeEnumerationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CompletedTimestamp", &c.CompletedTimestamp)
			delete(rawMsg, key)
		case "namespaceDirectoriesCount":
			err = unpopulate(val, "NamespaceDirectoriesCount", &c.NamespaceDirectoriesCount)
			delete(rawMsg, key)
		case "namespaceFilesCount":
			err = unpopulate(val, "NamespaceFilesCount", &c.NamespaceFilesCount)
			delete(rawMsg, key)
		case "namespaceSizeBytes":
			err = unpopulate(val, "NamespaceSizeBytes", &c.NamespaceSizeBytes)
			delete(rawMsg, key)
		case "nextRunTimestamp":
			err = unpopulateDateTimeRFC3339(val, "NextRunTimestamp", &c.NextRunTimestamp)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "StartedTimestamp", &c.StartedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudEndpointProperties.
func (c CloudEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileShareName", c.AzureFileShareName)
	populate(objectMap, "backupEnabled", c.BackupEnabled)
	populate(objectMap, "changeEnumerationStatus", c.ChangeEnumerationStatus)
	populate(objectMap, "friendlyName", c.FriendlyName)
	populate(objectMap, "lastOperationName", c.LastOperationName)
	populate(objectMap, "lastWorkflowId", c.LastWorkflowID)
	populate(objectMap, "partnershipId", c.PartnershipID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "storageAccountResourceId", c.StorageAccountResourceID)
	populate(objectMap, "storageAccountTenantId", c.StorageAccountTenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudEndpointProperties.
func (c *CloudEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShareName":
			err = unpopulate(val, "AzureFileShareName", &c.AzureFileShareName)
			delete(rawMsg, key)
		case "backupEnabled":
			err = unpopulate(val, "BackupEnabled", &c.BackupEnabled)
			delete(rawMsg, key)
		case "changeEnumerationStatus":
			err = unpopulate(val, "ChangeEnumerationStatus", &c.ChangeEnumerationStatus)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &c.FriendlyName)
			delete(rawMsg, key)
		case "lastOperationName":
			err = unpopulate(val, "LastOperationName", &c.LastOperationName)
			delete(rawMsg, key)
		case "lastWorkflowId":
			err = unpopulate(val, "LastWorkflowID", &c.LastWorkflowID)
			delete(rawMsg, key)
		case "partnershipId":
			err = unpopulate(val, "PartnershipID", &c.PartnershipID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "storageAccountResourceId":
			err = unpopulate(val, "StorageAccountResourceID", &c.StorageAccountResourceID)
			delete(rawMsg, key)
		case "storageAccountTenantId":
			err = unpopulate(val, "StorageAccountTenantID", &c.StorageAccountTenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringCachePerformance.
func (c CloudTieringCachePerformance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cacheHitBytes", c.CacheHitBytes)
	populate(objectMap, "cacheHitBytesPercent", c.CacheHitBytesPercent)
	populate(objectMap, "cacheMissBytes", c.CacheMissBytes)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringCachePerformance.
func (c *CloudTieringCachePerformance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cacheHitBytes":
			err = unpopulate(val, "CacheHitBytes", &c.CacheHitBytes)
			delete(rawMsg, key)
		case "cacheHitBytesPercent":
			err = unpopulate(val, "CacheHitBytesPercent", &c.CacheHitBytesPercent)
			delete(rawMsg, key)
		case "cacheMissBytes":
			err = unpopulate(val, "CacheMissBytes", &c.CacheMissBytes)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringDatePolicyStatus.
func (c CloudTieringDatePolicyStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populateDateTimeRFC3339(objectMap, "tieredFilesMostRecentAccessTimestamp", c.TieredFilesMostRecentAccessTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringDatePolicyStatus.
func (c *CloudTieringDatePolicyStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "tieredFilesMostRecentAccessTimestamp":
			err = unpopulateDateTimeRFC3339(val, "TieredFilesMostRecentAccessTimestamp", &c.TieredFilesMostRecentAccessTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringFilesNotTiering.
func (c CloudTieringFilesNotTiering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errors", c.Errors)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "totalFileCount", c.TotalFileCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringFilesNotTiering.
func (c *CloudTieringFilesNotTiering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "totalFileCount":
			err = unpopulate(val, "TotalFileCount", &c.TotalFileCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringSpaceSavings.
func (c CloudTieringSpaceSavings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cachedSizeBytes", c.CachedSizeBytes)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	populate(objectMap, "spaceSavingsBytes", c.SpaceSavingsBytes)
	populate(objectMap, "spaceSavingsPercent", c.SpaceSavingsPercent)
	populate(objectMap, "totalSizeCloudBytes", c.TotalSizeCloudBytes)
	populate(objectMap, "volumeSizeBytes", c.VolumeSizeBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringSpaceSavings.
func (c *CloudTieringSpaceSavings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cachedSizeBytes":
			err = unpopulate(val, "CachedSizeBytes", &c.CachedSizeBytes)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "spaceSavingsBytes":
			err = unpopulate(val, "SpaceSavingsBytes", &c.SpaceSavingsBytes)
			delete(rawMsg, key)
		case "spaceSavingsPercent":
			err = unpopulate(val, "SpaceSavingsPercent", &c.SpaceSavingsPercent)
			delete(rawMsg, key)
		case "totalSizeCloudBytes":
			err = unpopulate(val, "TotalSizeCloudBytes", &c.TotalSizeCloudBytes)
			delete(rawMsg, key)
		case "volumeSizeBytes":
			err = unpopulate(val, "VolumeSizeBytes", &c.VolumeSizeBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudTieringVolumeFreeSpacePolicyStatus.
func (c CloudTieringVolumeFreeSpacePolicyStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentVolumeFreeSpacePercent", c.CurrentVolumeFreeSpacePercent)
	populate(objectMap, "effectiveVolumeFreeSpacePolicy", c.EffectiveVolumeFreeSpacePolicy)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", c.LastUpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudTieringVolumeFreeSpacePolicyStatus.
func (c *CloudTieringVolumeFreeSpacePolicyStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentVolumeFreeSpacePercent":
			err = unpopulate(val, "CurrentVolumeFreeSpacePercent", &c.CurrentVolumeFreeSpacePercent)
			delete(rawMsg, key)
		case "effectiveVolumeFreeSpacePolicy":
			err = unpopulate(val, "EffectiveVolumeFreeSpacePolicy", &c.EffectiveVolumeFreeSpacePolicy)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &c.LastUpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "innererror", e.Innererror)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &e.Innererror)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "exceptionType", e.ExceptionType)
	populate(objectMap, "httpErrorCode", e.HTTPErrorCode)
	populate(objectMap, "httpMethod", e.HTTPMethod)
	populate(objectMap, "hashedMessage", e.HashedMessage)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "requestUri", e.RequestURI)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "exceptionType":
			err = unpopulate(val, "ExceptionType", &e.ExceptionType)
			delete(rawMsg, key)
		case "httpErrorCode":
			err = unpopulate(val, "HTTPErrorCode", &e.HTTPErrorCode)
			delete(rawMsg, key)
		case "httpMethod":
			err = unpopulate(val, "HTTPMethod", &e.HTTPMethod)
			delete(rawMsg, key)
		case "hashedMessage":
			err = unpopulate(val, "HashedMessage", &e.HashedMessage)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "requestUri":
			err = unpopulate(val, "RequestURI", &e.RequestURI)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilesNotTieringError.
func (f FilesNotTieringError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", f.ErrorCode)
	populate(objectMap, "fileCount", f.FileCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilesNotTieringError.
func (f *FilesNotTieringError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &f.ErrorCode)
			delete(rawMsg, key)
		case "fileCount":
			err = unpopulate(val, "FileCount", &f.FileCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerErrorDetails.
func (i InnerErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "callStack", i.CallStack)
	populate(objectMap, "innerException", i.InnerException)
	populate(objectMap, "innerExceptionCallStack", i.InnerExceptionCallStack)
	populate(objectMap, "message", i.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerErrorDetails.
func (i *InnerErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "callStack":
			err = unpopulate(val, "CallStack", &i.CallStack)
			delete(rawMsg, key)
		case "innerException":
			err = unpopulate(val, "InnerException", &i.InnerException)
			delete(rawMsg, key)
		case "innerExceptionCallStack":
			err = unpopulate(val, "InnerExceptionCallStack", &i.InnerExceptionCallStack)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocationOperationStatus.
func (l LocationOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", l.EndTime)
	populate(objectMap, "error", l.Error)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "percentComplete", l.PercentComplete)
	populateDateTimeRFC3339(objectMap, "startTime", l.StartTime)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocationOperationStatus.
func (l *LocationOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &l.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &l.PercentComplete)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &l.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplayInfo.
func (o OperationDisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplayInfo.
func (o *OperationDisplayInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplayResource.
func (o OperationDisplayResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplayResource.
func (o *OperationDisplayResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntity.
func (o OperationEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntity.
func (o *OperationEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationEntityListResult.
func (o OperationEntityListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationEntityListResult.
func (o *OperationEntityListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResourceMetricSpecification.
func (o OperationResourceMetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", o.AggregationType)
	populate(objectMap, "dimensions", o.Dimensions)
	populate(objectMap, "displayDescription", o.DisplayDescription)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "fillGapWithZero", o.FillGapWithZero)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "supportedAggregationTypes", o.SupportedAggregationTypes)
	populate(objectMap, "unit", o.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResourceMetricSpecification.
func (o *OperationResourceMetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &o.AggregationType)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &o.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &o.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &o.FillGapWithZero)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &o.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &o.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResourceMetricSpecificationDimension.
func (o OperationResourceMetricSpecificationDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", o.DisplayName)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "toBeExportedForShoebox", o.ToBeExportedForShoebox)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResourceMetricSpecificationDimension.
func (o *OperationResourceMetricSpecificationDimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &o.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "toBeExportedForShoebox":
			err = unpopulate(val, "ToBeExportedForShoebox", &o.ToBeExportedForShoebox)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResourceServiceSpecification.
func (o OperationResourceServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricSpecifications", o.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResourceServiceSpecification.
func (o *OperationResourceServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &o.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatus.
func (o OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", o.EndTime)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "name", o.Name)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostBackupResponse.
func (p PostBackupResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupMetadata", p.BackupMetadata)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostBackupResponse.
func (p *PostBackupResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupMetadata":
			err = unpopulate(val, "BackupMetadata", &p.BackupMetadata)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostBackupResponseProperties.
func (p PostBackupResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudEndpointName", p.CloudEndpointName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostBackupResponseProperties.
func (p *PostBackupResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudEndpointName":
			err = unpopulate(val, "CloudEndpointName", &p.CloudEndpointName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostRestoreRequest.
func (p PostRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileShareUri", p.AzureFileShareURI)
	populate(objectMap, "failedFileList", p.FailedFileList)
	populate(objectMap, "partition", p.Partition)
	populate(objectMap, "replicaGroup", p.ReplicaGroup)
	populate(objectMap, "requestId", p.RequestID)
	populate(objectMap, "restoreFileSpec", p.RestoreFileSpec)
	populate(objectMap, "sourceAzureFileShareUri", p.SourceAzureFileShareURI)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostRestoreRequest.
func (p *PostRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShareUri":
			err = unpopulate(val, "AzureFileShareURI", &p.AzureFileShareURI)
			delete(rawMsg, key)
		case "failedFileList":
			err = unpopulate(val, "FailedFileList", &p.FailedFileList)
			delete(rawMsg, key)
		case "partition":
			err = unpopulate(val, "Partition", &p.Partition)
			delete(rawMsg, key)
		case "replicaGroup":
			err = unpopulate(val, "ReplicaGroup", &p.ReplicaGroup)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &p.RequestID)
			delete(rawMsg, key)
		case "restoreFileSpec":
			err = unpopulate(val, "RestoreFileSpec", &p.RestoreFileSpec)
			delete(rawMsg, key)
		case "sourceAzureFileShareUri":
			err = unpopulate(val, "SourceAzureFileShareURI", &p.SourceAzureFileShareURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PreRestoreRequest.
func (p PreRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureFileShareUri", p.AzureFileShareURI)
	populate(objectMap, "backupMetadataPropertyBag", p.BackupMetadataPropertyBag)
	populate(objectMap, "partition", p.Partition)
	populate(objectMap, "pauseWaitForSyncDrainTimePeriodInSeconds", p.PauseWaitForSyncDrainTimePeriodInSeconds)
	populate(objectMap, "replicaGroup", p.ReplicaGroup)
	populate(objectMap, "requestId", p.RequestID)
	populate(objectMap, "restoreFileSpec", p.RestoreFileSpec)
	populate(objectMap, "sourceAzureFileShareUri", p.SourceAzureFileShareURI)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PreRestoreRequest.
func (p *PreRestoreRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureFileShareUri":
			err = unpopulate(val, "AzureFileShareURI", &p.AzureFileShareURI)
			delete(rawMsg, key)
		case "backupMetadataPropertyBag":
			err = unpopulate(val, "BackupMetadataPropertyBag", &p.BackupMetadataPropertyBag)
			delete(rawMsg, key)
		case "partition":
			err = unpopulate(val, "Partition", &p.Partition)
			delete(rawMsg, key)
		case "pauseWaitForSyncDrainTimePeriodInSeconds":
			err = unpopulate(val, "PauseWaitForSyncDrainTimePeriodInSeconds", &p.PauseWaitForSyncDrainTimePeriodInSeconds)
			delete(rawMsg, key)
		case "replicaGroup":
			err = unpopulate(val, "ReplicaGroup", &p.ReplicaGroup)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &p.RequestID)
			delete(rawMsg, key)
		case "restoreFileSpec":
			err = unpopulate(val, "RestoreFileSpec", &p.RestoreFileSpec)
			delete(rawMsg, key)
		case "sourceAzureFileShareUri":
			err = unpopulate(val, "SourceAzureFileShareURI", &p.SourceAzureFileShareURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecallActionParameters.
func (r RecallActionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pattern", r.Pattern)
	populate(objectMap, "recallPath", r.RecallPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecallActionParameters.
func (r *RecallActionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pattern":
			err = unpopulate(val, "Pattern", &r.Pattern)
			delete(rawMsg, key)
		case "recallPath":
			err = unpopulate(val, "RecallPath", &r.RecallPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServer.
func (r RegisteredServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServer.
func (r *RegisteredServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServerArray.
func (r RegisteredServerArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServerArray.
func (r *RegisteredServerArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServerCreateParameters.
func (r RegisteredServerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServerCreateParameters.
func (r *RegisteredServerCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServerCreateParametersProperties.
func (r RegisteredServerCreateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentVersion", r.AgentVersion)
	populate(objectMap, "clusterId", r.ClusterID)
	populate(objectMap, "clusterName", r.ClusterName)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "lastHeartBeat", r.LastHeartBeat)
	populate(objectMap, "serverCertificate", r.ServerCertificate)
	populate(objectMap, "serverId", r.ServerID)
	populate(objectMap, "serverOSVersion", r.ServerOSVersion)
	populate(objectMap, "serverRole", r.ServerRole)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServerCreateParametersProperties.
func (r *RegisteredServerCreateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &r.AgentVersion)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &r.ClusterID)
			delete(rawMsg, key)
		case "clusterName":
			err = unpopulate(val, "ClusterName", &r.ClusterName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulate(val, "LastHeartBeat", &r.LastHeartBeat)
			delete(rawMsg, key)
		case "serverCertificate":
			err = unpopulate(val, "ServerCertificate", &r.ServerCertificate)
			delete(rawMsg, key)
		case "serverId":
			err = unpopulate(val, "ServerID", &r.ServerID)
			delete(rawMsg, key)
		case "serverOSVersion":
			err = unpopulate(val, "ServerOSVersion", &r.ServerOSVersion)
			delete(rawMsg, key)
		case "serverRole":
			err = unpopulate(val, "ServerRole", &r.ServerRole)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegisteredServerProperties.
func (r RegisteredServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentVersion", r.AgentVersion)
	populateDateTimeRFC3339(objectMap, "agentVersionExpirationDate", r.AgentVersionExpirationDate)
	populate(objectMap, "agentVersionStatus", r.AgentVersionStatus)
	populate(objectMap, "clusterId", r.ClusterID)
	populate(objectMap, "clusterName", r.ClusterName)
	populate(objectMap, "discoveryEndpointUri", r.DiscoveryEndpointURI)
	populate(objectMap, "friendlyName", r.FriendlyName)
	populate(objectMap, "lastHeartBeat", r.LastHeartBeat)
	populate(objectMap, "lastOperationName", r.LastOperationName)
	populate(objectMap, "lastWorkflowId", r.LastWorkflowID)
	populate(objectMap, "managementEndpointUri", r.ManagementEndpointURI)
	populate(objectMap, "monitoringConfiguration", r.MonitoringConfiguration)
	populate(objectMap, "monitoringEndpointUri", r.MonitoringEndpointURI)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "resourceLocation", r.ResourceLocation)
	populate(objectMap, "serverCertificate", r.ServerCertificate)
	populate(objectMap, "serverId", r.ServerID)
	populate(objectMap, "serverManagementErrorCode", r.ServerManagementErrorCode)
	populate(objectMap, "serverName", r.ServerName)
	populate(objectMap, "serverOSVersion", r.ServerOSVersion)
	populate(objectMap, "serverRole", r.ServerRole)
	populate(objectMap, "serviceLocation", r.ServiceLocation)
	populate(objectMap, "storageSyncServiceUid", r.StorageSyncServiceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegisteredServerProperties.
func (r *RegisteredServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &r.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionExpirationDate":
			err = unpopulateDateTimeRFC3339(val, "AgentVersionExpirationDate", &r.AgentVersionExpirationDate)
			delete(rawMsg, key)
		case "agentVersionStatus":
			err = unpopulate(val, "AgentVersionStatus", &r.AgentVersionStatus)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &r.ClusterID)
			delete(rawMsg, key)
		case "clusterName":
			err = unpopulate(val, "ClusterName", &r.ClusterName)
			delete(rawMsg, key)
		case "discoveryEndpointUri":
			err = unpopulate(val, "DiscoveryEndpointURI", &r.DiscoveryEndpointURI)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulate(val, "LastHeartBeat", &r.LastHeartBeat)
			delete(rawMsg, key)
		case "lastOperationName":
			err = unpopulate(val, "LastOperationName", &r.LastOperationName)
			delete(rawMsg, key)
		case "lastWorkflowId":
			err = unpopulate(val, "LastWorkflowID", &r.LastWorkflowID)
			delete(rawMsg, key)
		case "managementEndpointUri":
			err = unpopulate(val, "ManagementEndpointURI", &r.ManagementEndpointURI)
			delete(rawMsg, key)
		case "monitoringConfiguration":
			err = unpopulate(val, "MonitoringConfiguration", &r.MonitoringConfiguration)
			delete(rawMsg, key)
		case "monitoringEndpointUri":
			err = unpopulate(val, "MonitoringEndpointURI", &r.MonitoringEndpointURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &r.ResourceLocation)
			delete(rawMsg, key)
		case "serverCertificate":
			err = unpopulate(val, "ServerCertificate", &r.ServerCertificate)
			delete(rawMsg, key)
		case "serverId":
			err = unpopulate(val, "ServerID", &r.ServerID)
			delete(rawMsg, key)
		case "serverManagementErrorCode":
			err = unpopulate(val, "ServerManagementErrorCode", &r.ServerManagementErrorCode)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &r.ServerName)
			delete(rawMsg, key)
		case "serverOSVersion":
			err = unpopulate(val, "ServerOSVersion", &r.ServerOSVersion)
			delete(rawMsg, key)
		case "serverRole":
			err = unpopulate(val, "ServerRole", &r.ServerRole)
			delete(rawMsg, key)
		case "serviceLocation":
			err = unpopulate(val, "ServiceLocation", &r.ServiceLocation)
			delete(rawMsg, key)
		case "storageSyncServiceUid":
			err = unpopulate(val, "StorageSyncServiceUID", &r.StorageSyncServiceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcesMoveInfo.
func (r ResourcesMoveInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resources", r.Resources)
	populate(objectMap, "targetResourceGroup", r.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcesMoveInfo.
func (r *ResourcesMoveInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resources":
			err = unpopulate(val, "Resources", &r.Resources)
			delete(rawMsg, key)
		case "targetResourceGroup":
			err = unpopulate(val, "TargetResourceGroup", &r.TargetResourceGroup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreFileSpec.
func (r RestoreFileSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isdir", r.Isdir)
	populate(objectMap, "path", r.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreFileSpec.
func (r *RestoreFileSpec) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isdir":
			err = unpopulate(val, "Isdir", &r.Isdir)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpoint.
func (s ServerEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpoint.
func (s *ServerEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointArray.
func (s ServerEndpointArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointArray.
func (s *ServerEndpointArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointBackgroundDataDownloadActivity.
func (s ServerEndpointBackgroundDataDownloadActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "downloadedBytes", s.DownloadedBytes)
	populate(objectMap, "percentProgress", s.PercentProgress)
	populateDateTimeRFC3339(objectMap, "startedTimestamp", s.StartedTimestamp)
	populateDateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointBackgroundDataDownloadActivity.
func (s *ServerEndpointBackgroundDataDownloadActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadedBytes":
			err = unpopulate(val, "DownloadedBytes", &s.DownloadedBytes)
			delete(rawMsg, key)
		case "percentProgress":
			err = unpopulate(val, "PercentProgress", &s.PercentProgress)
			delete(rawMsg, key)
		case "startedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "StartedTimestamp", &s.StartedTimestamp)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointCloudTieringStatus.
func (s ServerEndpointCloudTieringStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cachePerformance", s.CachePerformance)
	populate(objectMap, "datePolicyStatus", s.DatePolicyStatus)
	populate(objectMap, "filesNotTiering", s.FilesNotTiering)
	populate(objectMap, "health", s.Health)
	populateDateTimeRFC3339(objectMap, "healthLastUpdatedTimestamp", s.HealthLastUpdatedTimestamp)
	populate(objectMap, "lastCloudTieringResult", s.LastCloudTieringResult)
	populateDateTimeRFC3339(objectMap, "lastSuccessTimestamp", s.LastSuccessTimestamp)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "spaceSavings", s.SpaceSavings)
	populate(objectMap, "volumeFreeSpacePolicyStatus", s.VolumeFreeSpacePolicyStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointCloudTieringStatus.
func (s *ServerEndpointCloudTieringStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cachePerformance":
			err = unpopulate(val, "CachePerformance", &s.CachePerformance)
			delete(rawMsg, key)
		case "datePolicyStatus":
			err = unpopulate(val, "DatePolicyStatus", &s.DatePolicyStatus)
			delete(rawMsg, key)
		case "filesNotTiering":
			err = unpopulate(val, "FilesNotTiering", &s.FilesNotTiering)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &s.Health)
			delete(rawMsg, key)
		case "healthLastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "HealthLastUpdatedTimestamp", &s.HealthLastUpdatedTimestamp)
			delete(rawMsg, key)
		case "lastCloudTieringResult":
			err = unpopulate(val, "LastCloudTieringResult", &s.LastCloudTieringResult)
			delete(rawMsg, key)
		case "lastSuccessTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessTimestamp", &s.LastSuccessTimestamp)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "spaceSavings":
			err = unpopulate(val, "SpaceSavings", &s.SpaceSavings)
			delete(rawMsg, key)
		case "volumeFreeSpacePolicyStatus":
			err = unpopulate(val, "VolumeFreeSpacePolicyStatus", &s.VolumeFreeSpacePolicyStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointCreateParameters.
func (s ServerEndpointCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointCreateParameters.
func (s *ServerEndpointCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointCreateParametersProperties.
func (s ServerEndpointCreateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudTiering", s.CloudTiering)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "initialDownloadPolicy", s.InitialDownloadPolicy)
	populate(objectMap, "initialUploadPolicy", s.InitialUploadPolicy)
	populate(objectMap, "localCacheMode", s.LocalCacheMode)
	populate(objectMap, "offlineDataTransfer", s.OfflineDataTransfer)
	populate(objectMap, "offlineDataTransferShareName", s.OfflineDataTransferShareName)
	populate(objectMap, "serverLocalPath", s.ServerLocalPath)
	populate(objectMap, "serverResourceId", s.ServerResourceID)
	populate(objectMap, "tierFilesOlderThanDays", s.TierFilesOlderThanDays)
	populate(objectMap, "volumeFreeSpacePercent", s.VolumeFreeSpacePercent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointCreateParametersProperties.
func (s *ServerEndpointCreateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudTiering":
			err = unpopulate(val, "CloudTiering", &s.CloudTiering)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "initialDownloadPolicy":
			err = unpopulate(val, "InitialDownloadPolicy", &s.InitialDownloadPolicy)
			delete(rawMsg, key)
		case "initialUploadPolicy":
			err = unpopulate(val, "InitialUploadPolicy", &s.InitialUploadPolicy)
			delete(rawMsg, key)
		case "localCacheMode":
			err = unpopulate(val, "LocalCacheMode", &s.LocalCacheMode)
			delete(rawMsg, key)
		case "offlineDataTransfer":
			err = unpopulate(val, "OfflineDataTransfer", &s.OfflineDataTransfer)
			delete(rawMsg, key)
		case "offlineDataTransferShareName":
			err = unpopulate(val, "OfflineDataTransferShareName", &s.OfflineDataTransferShareName)
			delete(rawMsg, key)
		case "serverLocalPath":
			err = unpopulate(val, "ServerLocalPath", &s.ServerLocalPath)
			delete(rawMsg, key)
		case "serverResourceId":
			err = unpopulate(val, "ServerResourceID", &s.ServerResourceID)
			delete(rawMsg, key)
		case "tierFilesOlderThanDays":
			err = unpopulate(val, "TierFilesOlderThanDays", &s.TierFilesOlderThanDays)
			delete(rawMsg, key)
		case "volumeFreeSpacePercent":
			err = unpopulate(val, "VolumeFreeSpacePercent", &s.VolumeFreeSpacePercent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointFilesNotSyncingError.
func (s ServerEndpointFilesNotSyncingError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", s.ErrorCode)
	populate(objectMap, "persistentCount", s.PersistentCount)
	populate(objectMap, "transientCount", s.TransientCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointFilesNotSyncingError.
func (s *ServerEndpointFilesNotSyncingError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		case "persistentCount":
			err = unpopulate(val, "PersistentCount", &s.PersistentCount)
			delete(rawMsg, key)
		case "transientCount":
			err = unpopulate(val, "TransientCount", &s.TransientCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointProperties.
func (s ServerEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudTiering", s.CloudTiering)
	populate(objectMap, "cloudTieringStatus", s.CloudTieringStatus)
	populate(objectMap, "friendlyName", s.FriendlyName)
	populate(objectMap, "initialDownloadPolicy", s.InitialDownloadPolicy)
	populate(objectMap, "initialUploadPolicy", s.InitialUploadPolicy)
	populate(objectMap, "lastOperationName", s.LastOperationName)
	populate(objectMap, "lastWorkflowId", s.LastWorkflowID)
	populate(objectMap, "localCacheMode", s.LocalCacheMode)
	populate(objectMap, "offlineDataTransfer", s.OfflineDataTransfer)
	populate(objectMap, "offlineDataTransferShareName", s.OfflineDataTransferShareName)
	populate(objectMap, "offlineDataTransferStorageAccountResourceId", s.OfflineDataTransferStorageAccountResourceID)
	populate(objectMap, "offlineDataTransferStorageAccountTenantId", s.OfflineDataTransferStorageAccountTenantID)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "recallStatus", s.RecallStatus)
	populate(objectMap, "serverLocalPath", s.ServerLocalPath)
	populate(objectMap, "serverName", s.ServerName)
	populate(objectMap, "serverResourceId", s.ServerResourceID)
	populate(objectMap, "syncStatus", s.SyncStatus)
	populate(objectMap, "tierFilesOlderThanDays", s.TierFilesOlderThanDays)
	populate(objectMap, "volumeFreeSpacePercent", s.VolumeFreeSpacePercent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointProperties.
func (s *ServerEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudTiering":
			err = unpopulate(val, "CloudTiering", &s.CloudTiering)
			delete(rawMsg, key)
		case "cloudTieringStatus":
			err = unpopulate(val, "CloudTieringStatus", &s.CloudTieringStatus)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &s.FriendlyName)
			delete(rawMsg, key)
		case "initialDownloadPolicy":
			err = unpopulate(val, "InitialDownloadPolicy", &s.InitialDownloadPolicy)
			delete(rawMsg, key)
		case "initialUploadPolicy":
			err = unpopulate(val, "InitialUploadPolicy", &s.InitialUploadPolicy)
			delete(rawMsg, key)
		case "lastOperationName":
			err = unpopulate(val, "LastOperationName", &s.LastOperationName)
			delete(rawMsg, key)
		case "lastWorkflowId":
			err = unpopulate(val, "LastWorkflowID", &s.LastWorkflowID)
			delete(rawMsg, key)
		case "localCacheMode":
			err = unpopulate(val, "LocalCacheMode", &s.LocalCacheMode)
			delete(rawMsg, key)
		case "offlineDataTransfer":
			err = unpopulate(val, "OfflineDataTransfer", &s.OfflineDataTransfer)
			delete(rawMsg, key)
		case "offlineDataTransferShareName":
			err = unpopulate(val, "OfflineDataTransferShareName", &s.OfflineDataTransferShareName)
			delete(rawMsg, key)
		case "offlineDataTransferStorageAccountResourceId":
			err = unpopulate(val, "OfflineDataTransferStorageAccountResourceID", &s.OfflineDataTransferStorageAccountResourceID)
			delete(rawMsg, key)
		case "offlineDataTransferStorageAccountTenantId":
			err = unpopulate(val, "OfflineDataTransferStorageAccountTenantID", &s.OfflineDataTransferStorageAccountTenantID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "recallStatus":
			err = unpopulate(val, "RecallStatus", &s.RecallStatus)
			delete(rawMsg, key)
		case "serverLocalPath":
			err = unpopulate(val, "ServerLocalPath", &s.ServerLocalPath)
			delete(rawMsg, key)
		case "serverName":
			err = unpopulate(val, "ServerName", &s.ServerName)
			delete(rawMsg, key)
		case "serverResourceId":
			err = unpopulate(val, "ServerResourceID", &s.ServerResourceID)
			delete(rawMsg, key)
		case "syncStatus":
			err = unpopulate(val, "SyncStatus", &s.SyncStatus)
			delete(rawMsg, key)
		case "tierFilesOlderThanDays":
			err = unpopulate(val, "TierFilesOlderThanDays", &s.TierFilesOlderThanDays)
			delete(rawMsg, key)
		case "volumeFreeSpacePercent":
			err = unpopulate(val, "VolumeFreeSpacePercent", &s.VolumeFreeSpacePercent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointRecallError.
func (s ServerEndpointRecallError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "errorCode", s.ErrorCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointRecallError.
func (s *ServerEndpointRecallError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &s.ErrorCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointRecallStatus.
func (s ServerEndpointRecallStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "recallErrors", s.RecallErrors)
	populate(objectMap, "totalRecallErrorsCount", s.TotalRecallErrorsCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointRecallStatus.
func (s *ServerEndpointRecallStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "recallErrors":
			err = unpopulate(val, "RecallErrors", &s.RecallErrors)
			delete(rawMsg, key)
		case "totalRecallErrorsCount":
			err = unpopulate(val, "TotalRecallErrorsCount", &s.TotalRecallErrorsCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncActivityStatus.
func (s ServerEndpointSyncActivityStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedBytes", s.AppliedBytes)
	populate(objectMap, "appliedItemCount", s.AppliedItemCount)
	populate(objectMap, "perItemErrorCount", s.PerItemErrorCount)
	populate(objectMap, "sessionMinutesRemaining", s.SessionMinutesRemaining)
	populate(objectMap, "syncMode", s.SyncMode)
	populateDateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	populate(objectMap, "totalBytes", s.TotalBytes)
	populate(objectMap, "totalItemCount", s.TotalItemCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncActivityStatus.
func (s *ServerEndpointSyncActivityStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedBytes":
			err = unpopulate(val, "AppliedBytes", &s.AppliedBytes)
			delete(rawMsg, key)
		case "appliedItemCount":
			err = unpopulate(val, "AppliedItemCount", &s.AppliedItemCount)
			delete(rawMsg, key)
		case "perItemErrorCount":
			err = unpopulate(val, "PerItemErrorCount", &s.PerItemErrorCount)
			delete(rawMsg, key)
		case "sessionMinutesRemaining":
			err = unpopulate(val, "SessionMinutesRemaining", &s.SessionMinutesRemaining)
			delete(rawMsg, key)
		case "syncMode":
			err = unpopulate(val, "SyncMode", &s.SyncMode)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "totalBytes":
			err = unpopulate(val, "TotalBytes", &s.TotalBytes)
			delete(rawMsg, key)
		case "totalItemCount":
			err = unpopulate(val, "TotalItemCount", &s.TotalItemCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncSessionStatus.
func (s ServerEndpointSyncSessionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filesNotSyncingErrors", s.FilesNotSyncingErrors)
	populate(objectMap, "lastSyncMode", s.LastSyncMode)
	populate(objectMap, "lastSyncPerItemErrorCount", s.LastSyncPerItemErrorCount)
	populate(objectMap, "lastSyncResult", s.LastSyncResult)
	populateDateTimeRFC3339(objectMap, "lastSyncSuccessTimestamp", s.LastSyncSuccessTimestamp)
	populateDateTimeRFC3339(objectMap, "lastSyncTimestamp", s.LastSyncTimestamp)
	populate(objectMap, "persistentFilesNotSyncingCount", s.PersistentFilesNotSyncingCount)
	populate(objectMap, "transientFilesNotSyncingCount", s.TransientFilesNotSyncingCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncSessionStatus.
func (s *ServerEndpointSyncSessionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filesNotSyncingErrors":
			err = unpopulate(val, "FilesNotSyncingErrors", &s.FilesNotSyncingErrors)
			delete(rawMsg, key)
		case "lastSyncMode":
			err = unpopulate(val, "LastSyncMode", &s.LastSyncMode)
			delete(rawMsg, key)
		case "lastSyncPerItemErrorCount":
			err = unpopulate(val, "LastSyncPerItemErrorCount", &s.LastSyncPerItemErrorCount)
			delete(rawMsg, key)
		case "lastSyncResult":
			err = unpopulate(val, "LastSyncResult", &s.LastSyncResult)
			delete(rawMsg, key)
		case "lastSyncSuccessTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastSyncSuccessTimestamp", &s.LastSyncSuccessTimestamp)
			delete(rawMsg, key)
		case "lastSyncTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastSyncTimestamp", &s.LastSyncTimestamp)
			delete(rawMsg, key)
		case "persistentFilesNotSyncingCount":
			err = unpopulate(val, "PersistentFilesNotSyncingCount", &s.PersistentFilesNotSyncingCount)
			delete(rawMsg, key)
		case "transientFilesNotSyncingCount":
			err = unpopulate(val, "TransientFilesNotSyncingCount", &s.TransientFilesNotSyncingCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointSyncStatus.
func (s ServerEndpointSyncStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backgroundDataDownloadActivity", s.BackgroundDataDownloadActivity)
	populate(objectMap, "combinedHealth", s.CombinedHealth)
	populate(objectMap, "downloadActivity", s.DownloadActivity)
	populate(objectMap, "downloadHealth", s.DownloadHealth)
	populate(objectMap, "downloadStatus", s.DownloadStatus)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTimestamp", s.LastUpdatedTimestamp)
	populate(objectMap, "offlineDataTransferStatus", s.OfflineDataTransferStatus)
	populate(objectMap, "syncActivity", s.SyncActivity)
	populate(objectMap, "totalPersistentFilesNotSyncingCount", s.TotalPersistentFilesNotSyncingCount)
	populate(objectMap, "uploadActivity", s.UploadActivity)
	populate(objectMap, "uploadHealth", s.UploadHealth)
	populate(objectMap, "uploadStatus", s.UploadStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointSyncStatus.
func (s *ServerEndpointSyncStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backgroundDataDownloadActivity":
			err = unpopulate(val, "BackgroundDataDownloadActivity", &s.BackgroundDataDownloadActivity)
			delete(rawMsg, key)
		case "combinedHealth":
			err = unpopulate(val, "CombinedHealth", &s.CombinedHealth)
			delete(rawMsg, key)
		case "downloadActivity":
			err = unpopulate(val, "DownloadActivity", &s.DownloadActivity)
			delete(rawMsg, key)
		case "downloadHealth":
			err = unpopulate(val, "DownloadHealth", &s.DownloadHealth)
			delete(rawMsg, key)
		case "downloadStatus":
			err = unpopulate(val, "DownloadStatus", &s.DownloadStatus)
			delete(rawMsg, key)
		case "lastUpdatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTimestamp", &s.LastUpdatedTimestamp)
			delete(rawMsg, key)
		case "offlineDataTransferStatus":
			err = unpopulate(val, "OfflineDataTransferStatus", &s.OfflineDataTransferStatus)
			delete(rawMsg, key)
		case "syncActivity":
			err = unpopulate(val, "SyncActivity", &s.SyncActivity)
			delete(rawMsg, key)
		case "totalPersistentFilesNotSyncingCount":
			err = unpopulate(val, "TotalPersistentFilesNotSyncingCount", &s.TotalPersistentFilesNotSyncingCount)
			delete(rawMsg, key)
		case "uploadActivity":
			err = unpopulate(val, "UploadActivity", &s.UploadActivity)
			delete(rawMsg, key)
		case "uploadHealth":
			err = unpopulate(val, "UploadHealth", &s.UploadHealth)
			delete(rawMsg, key)
		case "uploadStatus":
			err = unpopulate(val, "UploadStatus", &s.UploadStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointUpdateParameters.
func (s ServerEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointUpdateParameters.
func (s *ServerEndpointUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerEndpointUpdateProperties.
func (s ServerEndpointUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudTiering", s.CloudTiering)
	populate(objectMap, "localCacheMode", s.LocalCacheMode)
	populate(objectMap, "offlineDataTransfer", s.OfflineDataTransfer)
	populate(objectMap, "offlineDataTransferShareName", s.OfflineDataTransferShareName)
	populate(objectMap, "tierFilesOlderThanDays", s.TierFilesOlderThanDays)
	populate(objectMap, "volumeFreeSpacePercent", s.VolumeFreeSpacePercent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerEndpointUpdateProperties.
func (s *ServerEndpointUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudTiering":
			err = unpopulate(val, "CloudTiering", &s.CloudTiering)
			delete(rawMsg, key)
		case "localCacheMode":
			err = unpopulate(val, "LocalCacheMode", &s.LocalCacheMode)
			delete(rawMsg, key)
		case "offlineDataTransfer":
			err = unpopulate(val, "OfflineDataTransfer", &s.OfflineDataTransfer)
			delete(rawMsg, key)
		case "offlineDataTransferShareName":
			err = unpopulate(val, "OfflineDataTransferShareName", &s.OfflineDataTransferShareName)
			delete(rawMsg, key)
		case "tierFilesOlderThanDays":
			err = unpopulate(val, "TierFilesOlderThanDays", &s.TierFilesOlderThanDays)
			delete(rawMsg, key)
		case "volumeFreeSpacePercent":
			err = unpopulate(val, "VolumeFreeSpacePercent", &s.VolumeFreeSpacePercent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Service.
func (s *Service) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceArray.
func (s ServiceArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceArray.
func (s *ServiceArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceCreateParameters.
func (s ServiceCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceCreateParameters.
func (s *ServiceCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceCreateParametersProperties.
func (s ServiceCreateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incomingTrafficPolicy", s.IncomingTrafficPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceCreateParametersProperties.
func (s *ServiceCreateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incomingTrafficPolicy":
			err = unpopulate(val, "IncomingTrafficPolicy", &s.IncomingTrafficPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceProperties.
func (s ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incomingTrafficPolicy", s.IncomingTrafficPolicy)
	populate(objectMap, "lastOperationName", s.LastOperationName)
	populate(objectMap, "lastWorkflowId", s.LastWorkflowID)
	populate(objectMap, "privateEndpointConnections", s.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "storageSyncServiceStatus", s.StorageSyncServiceStatus)
	populate(objectMap, "storageSyncServiceUid", s.StorageSyncServiceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceProperties.
func (s *ServiceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incomingTrafficPolicy":
			err = unpopulate(val, "IncomingTrafficPolicy", &s.IncomingTrafficPolicy)
			delete(rawMsg, key)
		case "lastOperationName":
			err = unpopulate(val, "LastOperationName", &s.LastOperationName)
			delete(rawMsg, key)
		case "lastWorkflowId":
			err = unpopulate(val, "LastWorkflowID", &s.LastWorkflowID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &s.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "storageSyncServiceStatus":
			err = unpopulate(val, "StorageSyncServiceStatus", &s.StorageSyncServiceStatus)
			delete(rawMsg, key)
		case "storageSyncServiceUid":
			err = unpopulate(val, "StorageSyncServiceUID", &s.StorageSyncServiceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateParameters.
func (s ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUpdateParameters.
func (s *ServiceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceUpdateProperties.
func (s ServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "incomingTrafficPolicy", s.IncomingTrafficPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceUpdateProperties.
func (s *ServiceUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "incomingTrafficPolicy":
			err = unpopulate(val, "IncomingTrafficPolicy", &s.IncomingTrafficPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionState.
func (s SubscriptionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "istransitioning", s.Istransitioning)
	populateAny(objectMap, "properties", s.Properties)
	populate(objectMap, "state", s.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionState.
func (s *SubscriptionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "istransitioning":
			err = unpopulate(val, "Istransitioning", &s.Istransitioning)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroup.
func (s SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroup.
func (s *SyncGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupArray.
func (s SyncGroupArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroupArray.
func (s *SyncGroupArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupCreateParameters.
func (s SyncGroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populateAny(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroupCreateParameters.
func (s *SyncGroupCreateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SyncGroupProperties.
func (s SyncGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "syncGroupStatus", s.SyncGroupStatus)
	populate(objectMap, "uniqueId", s.UniqueID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SyncGroupProperties.
func (s *SyncGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "syncGroupStatus":
			err = unpopulate(val, "SyncGroupStatus", &s.SyncGroupStatus)
			delete(rawMsg, key)
		case "uniqueId":
			err = unpopulate(val, "UniqueID", &s.UniqueID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerChangeDetectionParameters.
func (t TriggerChangeDetectionParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "changeDetectionMode", t.ChangeDetectionMode)
	populate(objectMap, "directoryPath", t.DirectoryPath)
	populate(objectMap, "paths", t.Paths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerChangeDetectionParameters.
func (t *TriggerChangeDetectionParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changeDetectionMode":
			err = unpopulate(val, "ChangeDetectionMode", &t.ChangeDetectionMode)
			delete(rawMsg, key)
		case "directoryPath":
			err = unpopulate(val, "DirectoryPath", &t.DirectoryPath)
			delete(rawMsg, key)
		case "paths":
			err = unpopulate(val, "Paths", &t.Paths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerRolloverRequest.
func (t TriggerRolloverRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serverCertificate", t.ServerCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerRolloverRequest.
func (t *TriggerRolloverRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serverCertificate":
			err = unpopulate(val, "ServerCertificate", &t.ServerCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workflow.
func (w *Workflow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowArray.
func (w WorkflowArray) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowArray.
func (w *WorkflowArray) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowProperties.
func (w WorkflowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "commandName", w.CommandName)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", w.CreatedTimestamp)
	populate(objectMap, "lastOperationId", w.LastOperationID)
	populateDateTimeRFC3339(objectMap, "lastStatusTimestamp", w.LastStatusTimestamp)
	populate(objectMap, "lastStepName", w.LastStepName)
	populate(objectMap, "operation", w.Operation)
	populate(objectMap, "status", w.Status)
	populate(objectMap, "steps", w.Steps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowProperties.
func (w *WorkflowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "commandName":
			err = unpopulate(val, "CommandName", &w.CommandName)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &w.CreatedTimestamp)
			delete(rawMsg, key)
		case "lastOperationId":
			err = unpopulate(val, "LastOperationID", &w.LastOperationID)
			delete(rawMsg, key)
		case "lastStatusTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastStatusTimestamp", &w.LastStatusTimestamp)
			delete(rawMsg, key)
		case "lastStepName":
			err = unpopulate(val, "LastStepName", &w.LastStepName)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &w.Operation)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &w.Status)
			delete(rawMsg, key)
		case "steps":
			err = unpopulate(val, "Steps", &w.Steps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
