//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// DeviceSettingsClient contains the methods for the DeviceSettings group.
// Don't use this type directly, use NewDeviceSettingsClient() instead.
type DeviceSettingsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDeviceSettingsClient creates a new instance of DeviceSettingsClient with the specified values.
//   - subscriptionID - The subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDeviceSettingsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DeviceSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DeviceSettingsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdateAlertSettings - Creates or updates the alert settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The alert settings to be added or updated.
//   - options - DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginCreateOrUpdateAlertSettings
//     method.
func (client *DeviceSettingsClient) BeginCreateOrUpdateAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters AlertSettings, options *DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions) (*runtime.Poller[DeviceSettingsClientCreateOrUpdateAlertSettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateAlertSettings(ctx, deviceName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DeviceSettingsClientCreateOrUpdateAlertSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DeviceSettingsClientCreateOrUpdateAlertSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateAlertSettings - Creates or updates the alert settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DeviceSettingsClient) createOrUpdateAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters AlertSettings, options *DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions) (*http.Response, error) {
	var err error
	const operationName = "DeviceSettingsClient.BeginCreateOrUpdateAlertSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAlertSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateAlertSettingsCreateRequest creates the CreateOrUpdateAlertSettings request.
func (client *DeviceSettingsClient) createOrUpdateAlertSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters AlertSettings, options *DeviceSettingsClientBeginCreateOrUpdateAlertSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginCreateOrUpdateTimeSettings - Creates or updates the time settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The time settings to be added or updated.
//   - options - DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginCreateOrUpdateTimeSettings
//     method.
func (client *DeviceSettingsClient) BeginCreateOrUpdateTimeSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters TimeSettings, options *DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions) (*runtime.Poller[DeviceSettingsClientCreateOrUpdateTimeSettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdateTimeSettings(ctx, deviceName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DeviceSettingsClientCreateOrUpdateTimeSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DeviceSettingsClientCreateOrUpdateTimeSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdateTimeSettings - Creates or updates the time settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DeviceSettingsClient) createOrUpdateTimeSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters TimeSettings, options *DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions) (*http.Response, error) {
	var err error
	const operationName = "DeviceSettingsClient.BeginCreateOrUpdateTimeSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateTimeSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateTimeSettingsCreateRequest creates the CreateOrUpdateTimeSettings request.
func (client *DeviceSettingsClient) createOrUpdateTimeSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters TimeSettings, options *DeviceSettingsClientBeginCreateOrUpdateTimeSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// GetAlertSettings - Gets the alert settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DeviceSettingsClientGetAlertSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetAlertSettings
//     method.
func (client *DeviceSettingsClient) GetAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetAlertSettingsOptions) (DeviceSettingsClientGetAlertSettingsResponse, error) {
	var err error
	const operationName = "DeviceSettingsClient.GetAlertSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAlertSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DeviceSettingsClientGetAlertSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeviceSettingsClientGetAlertSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeviceSettingsClientGetAlertSettingsResponse{}, err
	}
	resp, err := client.getAlertSettingsHandleResponse(httpResp)
	return resp, err
}

// getAlertSettingsCreateRequest creates the GetAlertSettings request.
func (client *DeviceSettingsClient) getAlertSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetAlertSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAlertSettingsHandleResponse handles the GetAlertSettings response.
func (client *DeviceSettingsClient) getAlertSettingsHandleResponse(resp *http.Response) (DeviceSettingsClientGetAlertSettingsResponse, error) {
	result := DeviceSettingsClientGetAlertSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertSettings); err != nil {
		return DeviceSettingsClientGetAlertSettingsResponse{}, err
	}
	return result, nil
}

// GetNetworkSettings - Gets the network settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DeviceSettingsClientGetNetworkSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetNetworkSettings
//     method.
func (client *DeviceSettingsClient) GetNetworkSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetNetworkSettingsOptions) (DeviceSettingsClientGetNetworkSettingsResponse, error) {
	var err error
	const operationName = "DeviceSettingsClient.GetNetworkSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getNetworkSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DeviceSettingsClientGetNetworkSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeviceSettingsClientGetNetworkSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeviceSettingsClientGetNetworkSettingsResponse{}, err
	}
	resp, err := client.getNetworkSettingsHandleResponse(httpResp)
	return resp, err
}

// getNetworkSettingsCreateRequest creates the GetNetworkSettings request.
func (client *DeviceSettingsClient) getNetworkSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetNetworkSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNetworkSettingsHandleResponse handles the GetNetworkSettings response.
func (client *DeviceSettingsClient) getNetworkSettingsHandleResponse(resp *http.Response) (DeviceSettingsClientGetNetworkSettingsResponse, error) {
	result := DeviceSettingsClientGetNetworkSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NetworkSettings); err != nil {
		return DeviceSettingsClientGetNetworkSettingsResponse{}, err
	}
	return result, nil
}

// GetSecuritySettings - Returns the Security properties of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DeviceSettingsClientGetSecuritySettingsOptions contains the optional parameters for the DeviceSettingsClient.GetSecuritySettings
//     method.
func (client *DeviceSettingsClient) GetSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetSecuritySettingsOptions) (DeviceSettingsClientGetSecuritySettingsResponse, error) {
	var err error
	const operationName = "DeviceSettingsClient.GetSecuritySettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getSecuritySettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DeviceSettingsClientGetSecuritySettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeviceSettingsClientGetSecuritySettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeviceSettingsClientGetSecuritySettingsResponse{}, err
	}
	resp, err := client.getSecuritySettingsHandleResponse(httpResp)
	return resp, err
}

// getSecuritySettingsCreateRequest creates the GetSecuritySettings request.
func (client *DeviceSettingsClient) getSecuritySettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetSecuritySettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getSecuritySettingsHandleResponse handles the GetSecuritySettings response.
func (client *DeviceSettingsClient) getSecuritySettingsHandleResponse(resp *http.Response) (DeviceSettingsClientGetSecuritySettingsResponse, error) {
	result := DeviceSettingsClientGetSecuritySettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SecuritySettings); err != nil {
		return DeviceSettingsClientGetSecuritySettingsResponse{}, err
	}
	return result, nil
}

// GetTimeSettings - Gets the time settings of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DeviceSettingsClientGetTimeSettingsOptions contains the optional parameters for the DeviceSettingsClient.GetTimeSettings
//     method.
func (client *DeviceSettingsClient) GetTimeSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetTimeSettingsOptions) (DeviceSettingsClientGetTimeSettingsResponse, error) {
	var err error
	const operationName = "DeviceSettingsClient.GetTimeSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getTimeSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DeviceSettingsClientGetTimeSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeviceSettingsClientGetTimeSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeviceSettingsClientGetTimeSettingsResponse{}, err
	}
	resp, err := client.getTimeSettingsHandleResponse(httpResp)
	return resp, err
}

// getTimeSettingsCreateRequest creates the GetTimeSettings request.
func (client *DeviceSettingsClient) getTimeSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientGetTimeSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getTimeSettingsHandleResponse handles the GetTimeSettings response.
func (client *DeviceSettingsClient) getTimeSettingsHandleResponse(resp *http.Response) (DeviceSettingsClientGetTimeSettingsResponse, error) {
	result := DeviceSettingsClientGetTimeSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TimeSettings); err != nil {
		return DeviceSettingsClientGetTimeSettingsResponse{}, err
	}
	return result, nil
}

// BeginSyncRemotemanagementCertificate - sync Remote management Certificate between appliance and Service
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions contains the optional parameters for the DeviceSettingsClient.BeginSyncRemotemanagementCertificate
//     method.
func (client *DeviceSettingsClient) BeginSyncRemotemanagementCertificate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions) (*runtime.Poller[DeviceSettingsClientSyncRemotemanagementCertificateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.syncRemotemanagementCertificate(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DeviceSettingsClientSyncRemotemanagementCertificateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DeviceSettingsClientSyncRemotemanagementCertificateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// SyncRemotemanagementCertificate - sync Remote management Certificate between appliance and Service
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DeviceSettingsClient) syncRemotemanagementCertificate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions) (*http.Response, error) {
	var err error
	const operationName = "DeviceSettingsClient.BeginSyncRemotemanagementCertificate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.syncRemotemanagementCertificateCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// syncRemotemanagementCertificateCreateRequest creates the SyncRemotemanagementCertificate request.
func (client *DeviceSettingsClient) syncRemotemanagementCertificateCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DeviceSettingsClientBeginSyncRemotemanagementCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default/syncRemoteManagementCertificate"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// BeginUpdateNetworkSettings - Updates the network settings on the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The network settings to be updated.
//   - options - DeviceSettingsClientBeginUpdateNetworkSettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginUpdateNetworkSettings
//     method.
func (client *DeviceSettingsClient) BeginUpdateNetworkSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters NetworkSettingsPatch, options *DeviceSettingsClientBeginUpdateNetworkSettingsOptions) (*runtime.Poller[DeviceSettingsClientUpdateNetworkSettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateNetworkSettings(ctx, deviceName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DeviceSettingsClientUpdateNetworkSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DeviceSettingsClientUpdateNetworkSettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateNetworkSettings - Updates the network settings on the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DeviceSettingsClient) updateNetworkSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters NetworkSettingsPatch, options *DeviceSettingsClientBeginUpdateNetworkSettingsOptions) (*http.Response, error) {
	var err error
	const operationName = "DeviceSettingsClient.BeginUpdateNetworkSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateNetworkSettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateNetworkSettingsCreateRequest creates the UpdateNetworkSettings request.
func (client *DeviceSettingsClient) updateNetworkSettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters NetworkSettingsPatch, options *DeviceSettingsClientBeginUpdateNetworkSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdateSecuritySettings - Patch Security properties of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The security settings properties to be patched.
//   - options - DeviceSettingsClientBeginUpdateSecuritySettingsOptions contains the optional parameters for the DeviceSettingsClient.BeginUpdateSecuritySettings
//     method.
func (client *DeviceSettingsClient) BeginUpdateSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters SecuritySettingsPatch, options *DeviceSettingsClientBeginUpdateSecuritySettingsOptions) (*runtime.Poller[DeviceSettingsClientUpdateSecuritySettingsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateSecuritySettings(ctx, deviceName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DeviceSettingsClientUpdateSecuritySettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DeviceSettingsClientUpdateSecuritySettingsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// UpdateSecuritySettings - Patch Security properties of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DeviceSettingsClient) updateSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters SecuritySettingsPatch, options *DeviceSettingsClientBeginUpdateSecuritySettingsOptions) (*http.Response, error) {
	var err error
	const operationName = "DeviceSettingsClient.BeginUpdateSecuritySettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateSecuritySettingsCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateSecuritySettingsCreateRequest creates the UpdateSecuritySettings request.
func (client *DeviceSettingsClient) updateSecuritySettingsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters SecuritySettingsPatch, options *DeviceSettingsClientBeginUpdateSecuritySettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
