//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ChatTranscriptsClient contains the methods for the ChatTranscripts group.
// Don't use this type directly, use NewChatTranscriptsClient() instead.
type ChatTranscriptsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewChatTranscriptsClient creates a new instance of ChatTranscriptsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewChatTranscriptsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ChatTranscriptsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ChatTranscriptsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Returns chatTranscript details for a support ticket under a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01
//   - supportTicketName - Support ticket name.
//   - chatTranscriptName - ChatTranscript name.
//   - options - ChatTranscriptsClientGetOptions contains the optional parameters for the ChatTranscriptsClient.Get method.
func (client *ChatTranscriptsClient) Get(ctx context.Context, supportTicketName string, chatTranscriptName string, options *ChatTranscriptsClientGetOptions) (ChatTranscriptsClientGetResponse, error) {
	var err error
	const operationName = "ChatTranscriptsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, supportTicketName, chatTranscriptName, options)
	if err != nil {
		return ChatTranscriptsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ChatTranscriptsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ChatTranscriptsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ChatTranscriptsClient) getCreateRequest(ctx context.Context, supportTicketName string, chatTranscriptName string, options *ChatTranscriptsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts/{chatTranscriptName}"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	if chatTranscriptName == "" {
		return nil, errors.New("parameter chatTranscriptName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{chatTranscriptName}", url.PathEscape(chatTranscriptName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ChatTranscriptsClient) getHandleResponse(resp *http.Response) (ChatTranscriptsClientGetResponse, error) {
	result := ChatTranscriptsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatTranscriptDetails); err != nil {
		return ChatTranscriptsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all chat transcripts for a support ticket under subscription
//
// Generated from API version 2024-04-01
//   - supportTicketName - Support ticket name.
//   - options - ChatTranscriptsClientListOptions contains the optional parameters for the ChatTranscriptsClient.NewListPager
//     method.
func (client *ChatTranscriptsClient) NewListPager(supportTicketName string, options *ChatTranscriptsClientListOptions) *runtime.Pager[ChatTranscriptsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ChatTranscriptsClientListResponse]{
		More: func(page ChatTranscriptsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ChatTranscriptsClientListResponse) (ChatTranscriptsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ChatTranscriptsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, supportTicketName, options)
			}, nil)
			if err != nil {
				return ChatTranscriptsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ChatTranscriptsClient) listCreateRequest(ctx context.Context, supportTicketName string, options *ChatTranscriptsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Support/supportTickets/{supportTicketName}/chatTranscripts"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ChatTranscriptsClient) listHandleResponse(resp *http.Response) (ChatTranscriptsClientListResponse, error) {
	result := ChatTranscriptsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatTranscriptsListResult); err != nil {
		return ChatTranscriptsClientListResponse{}, err
	}
	return result, nil
}
