//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// KustoPoolDatabasesServer is a fake server for instances of the armsynapse.KustoPoolDatabasesClient type.
type KustoPoolDatabasesServer struct {
	// BeginCreateOrUpdate is the fake for method KustoPoolDatabasesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, kustoPoolName string, databaseName string, parameters armsynapse.DatabaseClassification, options *armsynapse.KustoPoolDatabasesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method KustoPoolDatabasesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, workspaceName string, kustoPoolName string, databaseName string, options *armsynapse.KustoPoolDatabasesClientBeginDeleteOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method KustoPoolDatabasesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, kustoPoolName string, databaseName string, options *armsynapse.KustoPoolDatabasesClientGetOptions) (resp azfake.Responder[armsynapse.KustoPoolDatabasesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByKustoPoolPager is the fake for method KustoPoolDatabasesClient.NewListByKustoPoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByKustoPoolPager func(resourceGroupName string, workspaceName string, kustoPoolName string, options *armsynapse.KustoPoolDatabasesClientListByKustoPoolOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolDatabasesClientListByKustoPoolResponse])

	// BeginUpdate is the fake for method KustoPoolDatabasesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, workspaceName string, kustoPoolName string, databaseName string, parameters armsynapse.DatabaseClassification, options *armsynapse.KustoPoolDatabasesClientBeginUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewKustoPoolDatabasesServerTransport creates a new instance of KustoPoolDatabasesServerTransport with the provided implementation.
// The returned KustoPoolDatabasesServerTransport instance is connected to an instance of armsynapse.KustoPoolDatabasesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewKustoPoolDatabasesServerTransport(srv *KustoPoolDatabasesServer) *KustoPoolDatabasesServerTransport {
	return &KustoPoolDatabasesServerTransport{
		srv:                     srv,
		beginCreateOrUpdate:     newTracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientCreateOrUpdateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientDeleteResponse]](),
		newListByKustoPoolPager: newTracker[azfake.PagerResponder[armsynapse.KustoPoolDatabasesClientListByKustoPoolResponse]](),
		beginUpdate:             newTracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientUpdateResponse]](),
	}
}

// KustoPoolDatabasesServerTransport connects instances of armsynapse.KustoPoolDatabasesClient to instances of KustoPoolDatabasesServer.
// Don't use this type directly, use NewKustoPoolDatabasesServerTransport instead.
type KustoPoolDatabasesServerTransport struct {
	srv                     *KustoPoolDatabasesServer
	beginCreateOrUpdate     *tracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientCreateOrUpdateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientDeleteResponse]]
	newListByKustoPoolPager *tracker[azfake.PagerResponder[armsynapse.KustoPoolDatabasesClientListByKustoPoolResponse]]
	beginUpdate             *tracker[azfake.PollerResponder[armsynapse.KustoPoolDatabasesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for KustoPoolDatabasesServerTransport.
func (k *KustoPoolDatabasesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "KustoPoolDatabasesClient.BeginCreateOrUpdate":
		resp, err = k.dispatchBeginCreateOrUpdate(req)
	case "KustoPoolDatabasesClient.BeginDelete":
		resp, err = k.dispatchBeginDelete(req)
	case "KustoPoolDatabasesClient.Get":
		resp, err = k.dispatchGet(req)
	case "KustoPoolDatabasesClient.NewListByKustoPoolPager":
		resp, err = k.dispatchNewListByKustoPoolPager(req)
	case "KustoPoolDatabasesClient.BeginUpdate":
		resp, err = k.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (k *KustoPoolDatabasesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := k.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalDatabaseClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, kustoPoolNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		k.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		k.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		k.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolDatabasesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if k.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := k.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginDelete(req.Context(), resourceGroupNameParam, workspaceNameParam, kustoPoolNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		k.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		k.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		k.beginDelete.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolDatabasesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if k.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, kustoPoolNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolDatabasesServerTransport) dispatchNewListByKustoPoolPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListByKustoPoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByKustoPoolPager not implemented")}
	}
	newListByKustoPoolPager := k.newListByKustoPoolPager.get(req)
	if newListByKustoPoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListByKustoPoolPager(resourceGroupNameParam, workspaceNameParam, kustoPoolNameParam, nil)
		newListByKustoPoolPager = &resp
		k.newListByKustoPoolPager.add(req, newListByKustoPoolPager)
	}
	resp, err := server.PagerResponderNext(newListByKustoPoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListByKustoPoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByKustoPoolPager) {
		k.newListByKustoPoolPager.remove(req)
	}
	return resp, nil
}

func (k *KustoPoolDatabasesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := k.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalDatabaseClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginUpdate(req.Context(), resourceGroupNameParam, workspaceNameParam, kustoPoolNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		k.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		k.beginUpdate.remove(req)
	}

	return resp, nil
}
