// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of SLOs created in this account.
func (c *Client) ListServiceLevelObjectives(ctx context.Context, params *ListServiceLevelObjectivesInput, optFns ...func(*Options)) (*ListServiceLevelObjectivesOutput, error) {
	if params == nil {
		params = &ListServiceLevelObjectivesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceLevelObjectives", params, optFns, c.addOperationListServiceLevelObjectivesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceLevelObjectivesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceLevelObjectivesInput struct {

	// Identifies the dependency using the DependencyKeyAttributes and
	// DependencyOperationName .
	DependencyConfig *types.DependencyConfig

	// If you are using this operation in a monitoring account, specify true to
	// include SLO from source accounts in the returned data.
	//
	// When you are monitoring an account, you can use Amazon Web Services account ID
	// in KeyAttribute filter for service source account and SloOwnerawsaccountID for
	// SLO source account with IncludeLinkedAccounts to filter the returned data to
	// only a single source account.
	IncludeLinkedAccounts bool

	// You can use this optional field to specify which services you want to retrieve
	// SLO information for.
	//
	// This is a string-to-string map. It can include the following fields.
	//
	//   - Type designates the type of object this is.
	//
	//   - ResourceType specifies the type of the resource. This field is used only
	//   when the value of the Type field is Resource or AWS::Resource .
	//
	//   - Name specifies the name of the object. This is used only if the value of the
	//   Type field is Service , RemoteService , or AWS::Service .
	//
	//   - Identifier identifies the resource objects of this resource. This is used
	//   only if the value of the Type field is Resource or AWS::Resource .
	//
	//   - Environment specifies the location where this object is hosted, or what it
	//   belongs to.
	KeyAttributes map[string]string

	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	MaxResults *int32

	// Use this optional field to only include SLOs with the specified metric source
	// types in the output. Supported types are:
	//
	//   - Service operation
	//
	//   - Service dependency
	//
	//   - CloudWatch metric
	MetricSourceTypes []types.MetricSourceType

	// Include this value, if it was returned by the previous operation, to get the
	// next set of service level objectives.
	NextToken *string

	// The name of the operation that this SLO is associated with.
	OperationName *string

	// SLO's Amazon Web Services account ID.
	SloOwnerAwsAccountId *string

	noSmithyDocumentSerde
}

type ListServiceLevelObjectivesOutput struct {

	// Include this value in your next use of this API to get next set of service
	// level objectives.
	NextToken *string

	// An array of structures, where each structure contains information about one SLO.
	SloSummaries []types.ServiceLevelObjectiveSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceLevelObjectivesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceLevelObjectives{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceLevelObjectives{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceLevelObjectives"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServiceLevelObjectivesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceLevelObjectives(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListServiceLevelObjectivesPaginatorOptions is the paginator options for
// ListServiceLevelObjectives
type ListServiceLevelObjectivesPaginatorOptions struct {
	// The maximum number of results to return in one operation. If you omit this
	// parameter, the default of 50 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceLevelObjectivesPaginator is a paginator for
// ListServiceLevelObjectives
type ListServiceLevelObjectivesPaginator struct {
	options   ListServiceLevelObjectivesPaginatorOptions
	client    ListServiceLevelObjectivesAPIClient
	params    *ListServiceLevelObjectivesInput
	nextToken *string
	firstPage bool
}

// NewListServiceLevelObjectivesPaginator returns a new
// ListServiceLevelObjectivesPaginator
func NewListServiceLevelObjectivesPaginator(client ListServiceLevelObjectivesAPIClient, params *ListServiceLevelObjectivesInput, optFns ...func(*ListServiceLevelObjectivesPaginatorOptions)) *ListServiceLevelObjectivesPaginator {
	if params == nil {
		params = &ListServiceLevelObjectivesInput{}
	}

	options := ListServiceLevelObjectivesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceLevelObjectivesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceLevelObjectivesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceLevelObjectives page.
func (p *ListServiceLevelObjectivesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceLevelObjectivesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceLevelObjectives(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceLevelObjectivesAPIClient is a client that implements the
// ListServiceLevelObjectives operation.
type ListServiceLevelObjectivesAPIClient interface {
	ListServiceLevelObjectives(context.Context, *ListServiceLevelObjectivesInput, ...func(*Options)) (*ListServiceLevelObjectivesOutput, error)
}

var _ ListServiceLevelObjectivesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceLevelObjectives(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceLevelObjectives",
	}
}
