// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all API key credential providers in your account.
func (c *Client) ListApiKeyCredentialProviders(ctx context.Context, params *ListApiKeyCredentialProvidersInput, optFns ...func(*Options)) (*ListApiKeyCredentialProvidersOutput, error) {
	if params == nil {
		params = &ListApiKeyCredentialProvidersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApiKeyCredentialProviders", params, optFns, c.addOperationListApiKeyCredentialProvidersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApiKeyCredentialProvidersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApiKeyCredentialProvidersInput struct {

	// Maximum number of results to return.
	MaxResults *int32

	// Pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListApiKeyCredentialProvidersOutput struct {

	// The list of API key credential providers.
	//
	// This member is required.
	CredentialProviders []types.ApiKeyCredentialProviderItem

	// Pagination token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApiKeyCredentialProvidersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListApiKeyCredentialProviders{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListApiKeyCredentialProviders{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApiKeyCredentialProviders"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApiKeyCredentialProviders(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListApiKeyCredentialProvidersPaginatorOptions is the paginator options for
// ListApiKeyCredentialProviders
type ListApiKeyCredentialProvidersPaginatorOptions struct {
	// Maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApiKeyCredentialProvidersPaginator is a paginator for
// ListApiKeyCredentialProviders
type ListApiKeyCredentialProvidersPaginator struct {
	options   ListApiKeyCredentialProvidersPaginatorOptions
	client    ListApiKeyCredentialProvidersAPIClient
	params    *ListApiKeyCredentialProvidersInput
	nextToken *string
	firstPage bool
}

// NewListApiKeyCredentialProvidersPaginator returns a new
// ListApiKeyCredentialProvidersPaginator
func NewListApiKeyCredentialProvidersPaginator(client ListApiKeyCredentialProvidersAPIClient, params *ListApiKeyCredentialProvidersInput, optFns ...func(*ListApiKeyCredentialProvidersPaginatorOptions)) *ListApiKeyCredentialProvidersPaginator {
	if params == nil {
		params = &ListApiKeyCredentialProvidersInput{}
	}

	options := ListApiKeyCredentialProvidersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApiKeyCredentialProvidersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApiKeyCredentialProvidersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApiKeyCredentialProviders page.
func (p *ListApiKeyCredentialProvidersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApiKeyCredentialProvidersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListApiKeyCredentialProviders(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListApiKeyCredentialProvidersAPIClient is a client that implements the
// ListApiKeyCredentialProviders operation.
type ListApiKeyCredentialProvidersAPIClient interface {
	ListApiKeyCredentialProviders(context.Context, *ListApiKeyCredentialProvidersInput, ...func(*Options)) (*ListApiKeyCredentialProvidersOutput, error)
}

var _ ListApiKeyCredentialProvidersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListApiKeyCredentialProviders(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApiKeyCredentialProviders",
	}
}
