// Code generated by smithy-go-codegen DO NOT EDIT.

package internetmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/internetmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists internet events that cause performance or availability issues for client
// locations. Amazon CloudWatch Internet Monitor displays information about recent
// global health events, called internet events, on a global outages map that is
// available to all Amazon Web Services customers.
//
// You can constrain the list of internet events returned by providing a start
// time and end time to define a total time frame for events you want to list. Both
// start time and end time specify the time when an event started. End time is
// optional. If you don't include it, the default end time is the current time.
//
// You can also limit the events returned to a specific status ( ACTIVE or RESOLVED
// ) or type ( PERFORMANCE or AVAILABILITY ).
func (c *Client) ListInternetEvents(ctx context.Context, params *ListInternetEventsInput, optFns ...func(*Options)) (*ListInternetEventsOutput, error) {
	if params == nil {
		params = &ListInternetEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInternetEvents", params, optFns, c.addOperationListInternetEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInternetEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListInternetEventsInput struct {

	// The end time of the time window that you want to get a list of internet events
	// for.
	EndTime *time.Time

	// The status of an internet event.
	EventStatus *string

	// The type of network impairment.
	EventType *string

	// The number of query results that you want to return with this call.
	MaxResults *int32

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	// The start time of the time window that you want to get a list of internet
	// events for.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type ListInternetEventsOutput struct {

	// A set of internet events returned for the list operation.
	//
	// This member is required.
	InternetEvents []types.InternetEventSummary

	// The token for the next set of results. You receive this token from a previous
	// call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInternetEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListInternetEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListInternetEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInternetEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInternetEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListInternetEventsPaginatorOptions is the paginator options for
// ListInternetEvents
type ListInternetEventsPaginatorOptions struct {
	// The number of query results that you want to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInternetEventsPaginator is a paginator for ListInternetEvents
type ListInternetEventsPaginator struct {
	options   ListInternetEventsPaginatorOptions
	client    ListInternetEventsAPIClient
	params    *ListInternetEventsInput
	nextToken *string
	firstPage bool
}

// NewListInternetEventsPaginator returns a new ListInternetEventsPaginator
func NewListInternetEventsPaginator(client ListInternetEventsAPIClient, params *ListInternetEventsInput, optFns ...func(*ListInternetEventsPaginatorOptions)) *ListInternetEventsPaginator {
	if params == nil {
		params = &ListInternetEventsInput{}
	}

	options := ListInternetEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInternetEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInternetEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInternetEvents page.
func (p *ListInternetEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInternetEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInternetEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInternetEventsAPIClient is a client that implements the ListInternetEvents
// operation.
type ListInternetEventsAPIClient interface {
	ListInternetEvents(context.Context, *ListInternetEventsInput, ...func(*Options)) (*ListInternetEventsOutput, error)
}

var _ ListInternetEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInternetEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInternetEvents",
	}
}
