// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacedeployment

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/marketplacedeployment/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates or updates a deployment parameter and is targeted by catalog and
// agreementId .
func (c *Client) PutDeploymentParameter(ctx context.Context, params *PutDeploymentParameterInput, optFns ...func(*Options)) (*PutDeploymentParameterOutput, error) {
	if params == nil {
		params = &PutDeploymentParameterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutDeploymentParameter", params, optFns, c.addOperationPutDeploymentParameterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutDeploymentParameterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutDeploymentParameterInput struct {

	// The unique identifier of the agreement.
	//
	// This member is required.
	AgreementId *string

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// This member is required.
	Catalog *string

	// The deployment parameter targeted to the acceptor of an agreement for which to
	// create the AWS Secret Manager resource.
	//
	// This member is required.
	DeploymentParameter *types.DeploymentParameterInput

	// The product for which AWS Marketplace will save secrets for the buyer’s account.
	//
	// This member is required.
	ProductId *string

	// The idempotency token for deployment parameters. A unique identifier for the
	// new version.
	//
	// This field is not required if you're calling using an AWS SDK. Otherwise, a
	// clientToken must be provided with the request.
	ClientToken *string

	// The date when deployment parameters expire and are scheduled for deletion.
	ExpirationDate *time.Time

	// A map of key-value pairs, where each pair represents a tag saved to the
	// resource. Tags will only be applied for create operations, and they'll be
	// ignored if the resource already exists.
	Tags map[string]string

	noSmithyDocumentSerde
}

type PutDeploymentParameterOutput struct {

	// The unique identifier of the agreement.
	//
	// This member is required.
	AgreementId *string

	// The unique identifier of the deployment parameter.
	//
	// This member is required.
	DeploymentParameterId *string

	// The Amazon Resource Name (ARN) associated with the deployment parameter
	// resource you want to create or update.
	//
	// This member is required.
	ResourceArn *string

	// A map of key-value pairs, where each pair represents a tag saved to the
	// resource. Tags will only be applied for create operations, and they'll be
	// ignored if the resource already exists.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutDeploymentParameterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutDeploymentParameter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutDeploymentParameter{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutDeploymentParameter"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opPutDeploymentParameterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpPutDeploymentParameterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutDeploymentParameter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpPutDeploymentParameter struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpPutDeploymentParameter) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpPutDeploymentParameter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*PutDeploymentParameterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *PutDeploymentParameterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opPutDeploymentParameterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpPutDeploymentParameter{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opPutDeploymentParameter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutDeploymentParameter",
	}
}
