// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Create a query that you can use with the Network Flow Monitor query interface
// to return the top contributors for a monitor. Specify the monitor that you want
// to create the query for.
//
// The call returns a query ID that you can use with [GetQueryResultsMonitorTopContributors] to run the query and return
// the top contributors for a specific monitor.
//
// Top contributors in Network Flow Monitor are network flows with the highest
// values for a specific metric type. Top contributors can be across all workload
// insights, for a given scope, or for a specific monitor. Use the applicable APIs
// for the top contributors that you want to be returned.
//
// [GetQueryResultsMonitorTopContributors]: https://docs.aws.amazon.com/networkflowmonitor/2.0/APIReference/API_GetQueryResultsMonitorTopContributors.html
func (c *Client) StartQueryMonitorTopContributors(ctx context.Context, params *StartQueryMonitorTopContributorsInput, optFns ...func(*Options)) (*StartQueryMonitorTopContributorsOutput, error) {
	if params == nil {
		params = &StartQueryMonitorTopContributorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartQueryMonitorTopContributors", params, optFns, c.addOperationStartQueryMonitorTopContributorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartQueryMonitorTopContributorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartQueryMonitorTopContributorsInput struct {

	// The category that you want to query top contributors for, for a specific
	// monitor. Destination categories can be one of the following:
	//
	//   - INTRA_AZ : Top contributor network flows within a single Availability Zone
	//
	//   - INTER_AZ : Top contributor network flows between Availability Zones
	//
	//   - INTER_VPC : Top contributor network flows between VPCs
	//
	//   - AMAZON_S3 : Top contributor network flows to or from Amazon S3
	//
	//   - AMAZON_DYNAMODB : Top contributor network flows to or from Amazon Dynamo DB
	//
	//   - UNCLASSIFIED : Top contributor network flows that do not have a bucket
	//   classification
	//
	// This member is required.
	DestinationCategory types.DestinationCategory

	// The timestamp that is the date and time end of the period that you want to
	// retrieve results for with your query.
	//
	// This member is required.
	EndTime *time.Time

	// The metric that you want to query top contributors for. That is, you can
	// specify a metric with this call and return the top contributor network flows,
	// for that type of metric, for a monitor and (optionally) within a specific
	// category, such as network flows between Availability Zones.
	//
	// This member is required.
	MetricName types.MonitorMetric

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The timestamp that is the date and time beginning of the period that you want
	// to retrieve results for with your query.
	//
	// This member is required.
	StartTime *time.Time

	// The maximum number of top contributors to return.
	Limit *int32

	noSmithyDocumentSerde
}

type StartQueryMonitorTopContributorsOutput struct {

	// The identifier for the query. A query ID is an internally-generated identifier
	// for a specific query returned from an API call to start a query.
	//
	// This member is required.
	QueryId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartQueryMonitorTopContributorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartQueryMonitorTopContributors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartQueryMonitorTopContributors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartQueryMonitorTopContributors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartQueryMonitorTopContributorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartQueryMonitorTopContributors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartQueryMonitorTopContributors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartQueryMonitorTopContributors",
	}
}
