// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Autonomous VMs in an Autonomous VM cluster.
func (c *Client) ListAutonomousVirtualMachines(ctx context.Context, params *ListAutonomousVirtualMachinesInput, optFns ...func(*Options)) (*ListAutonomousVirtualMachinesOutput, error) {
	if params == nil {
		params = &ListAutonomousVirtualMachinesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutonomousVirtualMachines", params, optFns, c.addOperationListAutonomousVirtualMachinesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutonomousVirtualMachinesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutonomousVirtualMachinesInput struct {

	// The unique identifier of the Autonomous VM cluster whose virtual machines
	// you're listing.
	//
	// This member is required.
	CloudAutonomousVmClusterId *string

	// The maximum number of items to return per page.
	MaxResults *int32

	// The pagination token to continue listing from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutonomousVirtualMachinesOutput struct {

	// The list of Autonomous VMs in the specified Autonomous VM cluster.
	//
	// This member is required.
	AutonomousVirtualMachines []types.AutonomousVirtualMachineSummary

	// The pagination token from which to continue listing.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutonomousVirtualMachinesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutonomousVirtualMachines{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutonomousVirtualMachines{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutonomousVirtualMachines"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutonomousVirtualMachinesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutonomousVirtualMachines(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAutonomousVirtualMachinesPaginatorOptions is the paginator options for
// ListAutonomousVirtualMachines
type ListAutonomousVirtualMachinesPaginatorOptions struct {
	// The maximum number of items to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutonomousVirtualMachinesPaginator is a paginator for
// ListAutonomousVirtualMachines
type ListAutonomousVirtualMachinesPaginator struct {
	options   ListAutonomousVirtualMachinesPaginatorOptions
	client    ListAutonomousVirtualMachinesAPIClient
	params    *ListAutonomousVirtualMachinesInput
	nextToken *string
	firstPage bool
}

// NewListAutonomousVirtualMachinesPaginator returns a new
// ListAutonomousVirtualMachinesPaginator
func NewListAutonomousVirtualMachinesPaginator(client ListAutonomousVirtualMachinesAPIClient, params *ListAutonomousVirtualMachinesInput, optFns ...func(*ListAutonomousVirtualMachinesPaginatorOptions)) *ListAutonomousVirtualMachinesPaginator {
	if params == nil {
		params = &ListAutonomousVirtualMachinesInput{}
	}

	options := ListAutonomousVirtualMachinesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutonomousVirtualMachinesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutonomousVirtualMachinesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutonomousVirtualMachines page.
func (p *ListAutonomousVirtualMachinesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutonomousVirtualMachinesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutonomousVirtualMachines(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutonomousVirtualMachinesAPIClient is a client that implements the
// ListAutonomousVirtualMachines operation.
type ListAutonomousVirtualMachinesAPIClient interface {
	ListAutonomousVirtualMachines(context.Context, *ListAutonomousVirtualMachinesInput, ...func(*Options)) (*ListAutonomousVirtualMachinesOutput, error)
}

var _ ListAutonomousVirtualMachinesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutonomousVirtualMachines(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutonomousVirtualMachines",
	}
}
