// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new workflow version for the workflow that you specify with the
// workflowId parameter.
//
// When you create a new version of a workflow, you need to specify the
// configuration for the new version. It doesn't inherit any configuration values
// from the workflow.
//
// Provide a version name that is unique for this workflow. You cannot change the
// name after HealthOmics creates the version.
//
// Don’t include any personally identifiable information (PII) in the version
// name. Version names appear in the workflow version ARN.
//
// For more information, see [Workflow versioning in Amazon Web Services HealthOmics] in the Amazon Web Services HealthOmics User Guide.
//
// [Workflow versioning in Amazon Web Services HealthOmics]: https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html
func (c *Client) CreateWorkflowVersion(ctx context.Context, params *CreateWorkflowVersionInput, optFns ...func(*Options)) (*CreateWorkflowVersionOutput, error) {
	if params == nil {
		params = &CreateWorkflowVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkflowVersion", params, optFns, c.addOperationCreateWorkflowVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkflowVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkflowVersionInput struct {

	// To ensure that requests don't run multiple times, specify a unique ID for each
	// request.
	//
	// This member is required.
	RequestId *string

	// A name for the workflow version. Provide a version name that is unique for this
	// workflow. You cannot change the name after HealthOmics creates the version.
	//
	// The version name must start with a letter or number and it can include
	// upper-case and lower-case letters, numbers, hyphens, periods and underscores.
	// The maximum length is 64 characters. You can use a simple naming scheme, such as
	// version1, version2, version3. You can also match your workflow versions with
	// your own internal versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
	//
	// This member is required.
	VersionName *string

	// The ID of the workflow where you are creating the new version.
	//
	// This member is required.
	WorkflowId *string

	// The computational accelerator for this workflow version.
	Accelerators types.Accelerators

	// The repository information for the workflow version definition. This allows you
	// to source your workflow version definition directly from a code repository.
	DefinitionRepository *types.DefinitionRepository

	// The URI specifies the location of the workflow definition for this workflow
	// version.
	DefinitionUri *string

	// A zip archive containing the workflow definition for this workflow version.
	DefinitionZip []byte

	// A description for this workflow version.
	Description *string

	// The workflow engine for this workflow version.
	Engine types.WorkflowEngine

	// The path of the main definition file for this workflow version.
	Main *string

	// The parameter template defines the input parameters for runs that use this
	// workflow version.
	ParameterTemplate map[string]types.WorkflowParameter

	// The path to the workflow version parameter template JSON file within the
	// repository. This file defines the input parameters for runs that use this
	// workflow version. If not specified, the workflow version will be created without
	// a parameter template.
	ParameterTemplatePath *string

	// The markdown content for the workflow version's README file. This provides
	// documentation and usage information for users of this specific workflow version.
	//
	// This value conforms to the media type: text/markdown
	ReadmeMarkdown *string

	// The path to the workflow version README markdown file within the repository.
	// This file provides documentation and usage information for the workflow. If not
	// specified, the README.md file from the root directory of the repository will be
	// used.
	ReadmePath *string

	// The S3 URI of the README file for the workflow version. This file provides
	// documentation and usage information for the workflow version. Requirements
	// include:
	//
	//   - The S3 URI must begin with s3://USER-OWNED-BUCKET/
	//
	//   - The requester must have access to the S3 bucket and object.
	//
	//   - The max README content length is 500 KiB.
	ReadmeUri *string

	// The default static storage capacity (in gibibytes) for runs that use this
	// workflow or workflow version.
	StorageCapacity *int32

	// The default storage type for runs that use this workflow. STATIC storage
	// allocates a fixed amount of storage. DYNAMIC storage dynamically scales the
	// storage up or down, based on file system utilization. For more information about
	// static and dynamic storage, see [Running workflows]in the Amazon Web Services HealthOmics User
	// Guide.
	//
	// [Running workflows]: https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html
	StorageType types.StorageType

	// Optional tags to associate with this workflow version.
	Tags map[string]string

	// Amazon Web Services Id of the owner of the S3 bucket that contains the workflow
	// definition. You need to specify this parameter if your account is not the bucket
	// owner.
	WorkflowBucketOwnerId *string

	noSmithyDocumentSerde
}

type CreateWorkflowVersionOutput struct {

	// ARN of the workflow version.
	Arn *string

	// The workflow version status.
	Status types.WorkflowStatus

	// The workflow version's tags.
	Tags map[string]string

	// The universally unique identifier (UUID) value for this workflow version.
	Uuid *string

	// The workflow version name.
	VersionName *string

	// The workflow's ID.
	WorkflowId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkflowVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkflowVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateWorkflowVersionMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateWorkflowVersionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkflowVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkflowVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateWorkflowVersionMiddleware struct {
}

func (*endpointPrefix_opCreateWorkflowVersionMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateWorkflowVersionMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateWorkflowVersionMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateWorkflowVersionMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateWorkflowVersion struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateWorkflowVersion) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateWorkflowVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateWorkflowVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateWorkflowVersionInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateWorkflowVersionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateWorkflowVersion{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateWorkflowVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkflowVersion",
	}
}
