// Copyright 2025 Ksctl Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cmd

import (
	"fmt"

	"github.com/fatih/color"
	"github.com/ksctl/cli/v2/pkg/config"
	"github.com/spf13/cobra"
)

func (k *KsctlCommand) Version() *cobra.Command {

	logoKsctl := `
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⠵[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⠽[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⠷[0m[48;2;218;226;214m⠝[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢷[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⣯[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡳[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⡜[0m[48;2;216;224;212m⢊[0m[48;2;226;233;220m⠡[0m[48;2;128;155;149m⡀[0m[48;2;58;99;97m⢁[0m[48;2;53;95;94m⠠[0m[48;2;56;98;96m⠀[0m[48;2;55;97;95m⢔[0m[48;2;224;231;219m⡯[0m[48;2;218;226;214m⣞[0m[48;2;216;224;212m⠎[0m[48;2;182;198;188m⠠[0m[48;2;51;94;92m⢐[0m[48;2;47;91;90m⣰[0m[48;2;192;205;195m⡳[0m[48;2;217;225;213m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;215;224;212m⠙[0m[48;2;217;225;214m⠚[0m[48;2;222;229;217m⠊[0m[48;2;228;234;221m⢹[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡵[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢗[0m[48;2;218;226;214m⡗[0m[48;2;229;234;222m⠡[0m[48;2;61;101;99m⠐[0m[48;2;65;105;103m⣰[0m[48;2;156;176;168m⢝[0m[48;2;212;221;210m⠂[0m[48;2;61;101;99m⠄[0m[48;2;63;103;101m⡀[0m[48;2;65;104;102m⠂[0m[48;2;171;189;180m⣯[0m[48;2;216;225;213m⡺[0m[48;2;227;233;220m⠁[0m[48;2;59;100;98m⠂[0m[48;2;66;106;104m⣡[0m[48;2;133;159;152m⢞[0m[48;2;216;224;212m⣞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⢷[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡵[0m[48;2;218;226;214m⣫[0m[48;2;218;226;214m⢯[0m[48;2;220;228;216m⠎[0m[48;2;171;188;179m⢈[0m[48;2;131;157;150m⠀[0m[48;2;93;127;123m⡀[0m[48;2;73;111;108m⢜[0m[48;2;222;229;217m⣗[0m[48;2;218;226;214m⢵[0m[48;2;220;227;215m⠅[0m[48;2;59;100;98m⠐[0m[48;2;65;104;102m⠈[0m[48;2;66;105;103m⡀[0m[48;2;147;169;162m⣽[0m[48;2;216;224;212m⣪[0m[48;2;218;226;214m⣻[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⣪[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⢽[0m[48;2;216;224;212m⡝[0m[48;2;144;167;160m⢀[0m[48;2;66;106;104m⠐[0m[48;2;55;96;95m⡸[0m[48;2;228;234;221m⣕[0m[48;2;218;226;214m⡯[0m[48;2;89;124;120m⠐[0m[48;2;64;104;102m⢀[0m[48;2;63;103;101m⠐[0m[48;2;52;94;93m⢸[0m[48;2;227;233;220m⠎[0m[48;2;186;200;190m⠐[0m[48;2;65;104;102m⣈[0m[48;2;69;108;106m⢮[0m[48;2;225;231;219m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⠻[0m[48;2;217;225;213m⠪[0m[48;2;216;224;212m⠓[0m[48;2;217;225;213m⢳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⠽[0m[48;2;218;226;214m⠵[0m[48;2;218;226;214m⡫[0m[48;2;218;226;214m⢗[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣪[0m[48;2;217;225;213m⢯[0m[48;2;191;204;194m⠁[0m[48;2;63;103;101m⠄[0m[48;2;63;103;101m⠠[0m[48;2;63;103;101m⢀[0m[48;2;191;204;194m⢯[0m[48;2;217;225;213m⢮[0m[48;2;216;225;213m⠯[0m[48;2;111;141;136m⠀[0m[48;2;65;105;103m⠌[0m[48;2;63;103;101m⢀[0m[48;2;52;94;93m⢰[0m[48;2;228;234;222m⡳[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;229;235;222m⡧[0m[48;2;52;94;93m⡀[0m[48;2;65;105;103m⠄[0m[48;2;164;184;175m⢝[0m[48;2;216;224;212m⣞[0m[48;2;226;232;220m⠆[0m[48;2;54;96;94m⠐[0m[48;2;63;103;101m⠀[0m[48;2;65;105;103m⠄[0m[48;2;133;158;152m⠑[0m[48;2;58;99;98m⠠[0m[48;2;52;94;93m⠼[0m[48;2;228;234;221m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⡵[0m[48;2;218;226;214m⣻[0m[48;2;218;226;214m⡪[0m[48;2;216;224;212m⡟[0m[48;2;170;188;179m⡀[0m[48;2;60;101;99m⠐[0m[48;2;63;103;101m⠀[0m[48;2;67;107;104m⠂[0m[48;2;110;141;136m⢱[0m[48;2;216;225;213m⡳[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡳[0m[48;2;217;225;213m⠋[0m[48;2;198;211;200m⡀[0m[48;2;70;109;106m⠂[0m[48;2;52;95;93m⣄[0m[48;2;52;94;93m⡤[0m[48;2;55;97;95m⠀[0m[48;2;175;192;183m⠙[0m[48;2;214;223;211m⣞[0m[48;2;108;138;134m⡤[0m[48;2;64;104;102m⠐[0m[48;2;63;103;101m⠀[0m[48;2;63;103;101m⠂[0m[48;2;63;103;101m⢤[0m[48;2;58;99;97m⣢[0m[48;2;160;180;172m⣺[0m[48;2;227;233;220m⢃[0m[48;2;52;94;93m⠁[0m[48;2;63;103;101m⠐[0m[48;2;65;104;102m⡀[0m[48;2;101;134;129m⢼[0m[48;2;217;225;213m⣺[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⣪[0m[48;2;218;226;214m⢗[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⢷[0m[48;2;218;226;214m⢝[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;219;227;215m⡳[0m[48;2;80;117;113m⡦[0m[48;2;106;138;133m⡳[0m[48;2;214;223;211m⣝[0m[48;2;131;157;151m⠀[0m[48;2;66;105;103m⠌[0m[48;2;63;103;101m⠠[0m[48;2;63;103;101m⢨[0m[48;2;59;100;98m⢤[0m[48;2;64;104;102m⡅[0m[48;2;51;94;92m⠐[0m[48;2;57;98;96m⢀[0m[48;2;120;148;142m⠈[0m[48;2;222;229;217m⢫[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⣺[0m[48;2;227;233;220m⠁[0m[48;2;53;95;94m⣐[0m[48;2;63;103;101m⠈[0m[48;2;63;103;101m⡀[0m[48;2;64;104;102m⢁[0m[48;2;83;119;116m⢸[0m[48;2;219;227;215m⢝[0m[48;2;218;226;214m⡮[0m[48;2;215;224;212m⡏[0m[48;2;149;171;163m⠠[0m[48;2;66;106;103m⠀[0m[48;2;63;103;101m⠄[0m[48;2;52;94;93m⣲[0m[48;2;231;236;224m⢳[0m[48;2;220;228;216m⢝[0m[48;2;69;108;105m⠀[0m[48;2;57;98;97m⣢[0m[48;2;221;229;216m⣳[0m[48;2;219;227;215m⠅[0m[48;2;57;98;97m⠐[0m[48;2;63;103;101m⠈[0m[48;2;66;105;103m⡀[0m[48;2;144;167;160m⣗[0m[48;2;215;224;212m⢵[0m[48;2;216;224;212m⢽[0m[48;2;156;177;169m⠀[0m[48;2;65;105;103m⠄[0m[48;2;63;103;101m⢁[0m[48;2;58;99;97m⢠[0m[48;2;215;224;212m⡻[0m[48;2;218;226;214m⣜[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⣫[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣫[0m[48;2;218;226;214m⢯[0m[48;2;229;235;222m⡃[0m[48;2;52;94;93m⠄[0m[48;2;63;103;101m⠂[0m[48;2;64;104;102m⠐[0m[48;2;86;121;118m⣸[0m[48;2;218;226;214m⣕[0m[48;2;217;226;214m⢯[0m[48;2;81;118;114m⠂[0m[48;2;64;104;102m⢀[0m[48;2;64;104;102m⠂[0m[48;2;84;120;116m⢸[0m[48;2;219;227;215m⡳[0m[48;2;218;226;214m⡵[0m[48;2;227;233;221m⡃[0m[48;2;53;95;94m⢠[0m[48;2;214;223;211m⡗[0m[48;2;53;95;94m⡀[0m[48;2;63;103;101m⠄[0m[48;2;63;103;101m⠠[0m[48;2;60;101;99m⠨[0m[48;2;225;231;219m⣗[0m[48;2;216;224;212m⡝[0m[48;2;119;148;142m⠀[0m[48;2;66;105;103m⡐[0m[48;2;63;103;101m⠀[0m[48;2;53;95;93m⢢[0m[48;2;228;234;221m⢯[0m[48;2;218;226;214m⡫[0m[48;2;217;225;213m⣏[0m[48;2;228;234;221m⢯[0m[48;2;226;232;220m⡺[0m[48;2;216;225;213m⡮[0m[48;2;110;141;135m⠀[0m[48;2;65;105;102m⡈[0m[48;2;63;103;101m⠄[0m[48;2;53;95;93m⢰[0m[48;2;228;234;221m⢝[0m[48;2;218;226;214m⡽[0m[48;2;226;233;220m⡕[0m[48;2;56;98;96m⠀[0m[48;2;63;103;101m⡐[0m[48;2;64;103;101m⠀[0m[48;2;68;107;105m⣸[0m[48;2;222;229;217m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡫[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⡫[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⣗[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;216;225;213m⢵[0m[48;2;177;193;184m⠁[0m[48;2;64;104;102m⠠[0m[48;2;63;103;101m⠈[0m[48;2;61;101;99m⢠[0m[48;2;204;215;204m⡳[0m[48;2;217;225;213m⣳[0m[48;2;227;233;221m⠣[0m[48;2;55;97;95m⠐[0m[48;2;63;103;101m⠀[0m[48;2;66;105;103m⠄[0m[48;2;140;164;157m⡽[0m[48;2;216;224;212m⡪[0m[48;2;224;230;218m⠃[0m[48;2;61;101;100m⠄[0m[48;2;182;197;187m⢷[0m[48;2;218;226;214m⢽[0m[48;2;77;115;112m⠀[0m[48;2;64;104;102m⠐[0m[48;2;63;103;101m⡀[0m[48;2;52;94;93m⠌[0m[48;2;229;235;222m⣞[0m[48;2;213;222;210m⠆[0m[48;2;59;100;98m⠁[0m[48;2;63;103;101m⠠[0m[48;2;66;105;103m⠈[0m[48;2;136;161;154m⡮[0m[48;2;215;224;212m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;229;235;222m⠕[0m[48;2;52;94;93m⠀[0m[48;2;63;103;101m⠄[0m[48;2;65;104;102m⠂[0m[48;2;100;133;128m⡼[0m[48;2;217;225;213m⡳[0m[48;2;217;225;213m⣝[0m[48;2;196;208;198m⠂[0m[48;2;62;103;101m⠄[0m[48;2;63;103;101m⠐[0m[48;2;64;104;102m⢀[0m[48;2;183;198;189m⣗[0m[48;2;216;225;213m⢗[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢗[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢵[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡺[0m[48;2;223;230;218m⡇[0m[48;2;65;104;102m⠂[0m[48;2;63;103;101m⢁[0m[48;2;63;103;101m⠈[0m[48;2;60;101;99m⡰[0m[48;2;225;231;219m⡯[0m[48;2;216;224;212m⣺[0m[48;2;171;188;179m⠁[0m[48;2;65;104;102m⠠[0m[48;2;63;103;101m⠁[0m[48;2;52;94;93m⣨[0m[48;2;227;233;221m⣻[0m[48;2;176;193;184m⠀[0m[48;2;65;105;103m⢡[0m[48;2;68;107;105m⡠[0m[48;2;154;175;168m⡯[0m[48;2;213;222;211m⡫[0m[48;2;118;147;141m⠂[0m[48;2;65;105;103m⠁[0m[48;2;63;103;101m⠠[0m[48;2;54;96;95m⠐[0m[48;2;225;232;219m⠩[0m[48;2;134;159;153m⡀[0m[48;2;66;105;103m⠌[0m[48;2;63;103;101m⠀[0m[48;2;61;102;100m⠂[0m[48;2;202;213;202m⢯[0m[48;2;217;225;213m⡺[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⡗[0m[48;2;218;226;214m⠋[0m[48;2;115;144;139m⠠[0m[48;2;65;104;102m⠈[0m[48;2;63;103;101m⡀[0m[48;2;58;99;98m⠂[0m[48;2;215;223;212m⡯[0m[48;2;218;226;214m⡯[0m[48;2;219;227;215m⠎[0m[48;2;78;115;112m⢀[0m[48;2;64;104;102m⠂[0m[48;2;63;103;101m⢁[0m[48;2;53;95;94m⢰[0m[48;2;228;234;221m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣫[0m[48;2;217;226;214m⣻[0m[48;2;211;220;209m⠂[0m[48;2;59;100;98m⢈[0m[48;2;63;103;101m⠀[0m[48;2;65;105;103m⠄[0m[48;2;166;185;176m⡯[0m[48;2;216;224;212m⣫[0m[48;2;227;233;221m⡎[0m[48;2;55;97;95m⠀[0m[48;2;63;103;101m⠂[0m[48;2;65;105;103m⡐[0m[48;2;129;155;149m⢸[0m[48;2;214;223;211m⡺[0m[48;2;104;135;131m⣄[0m[48;2;56;97;96m⠠[0m[48;2;231;237;224m⠉[0m[48;2;229;235;222m⡉[0m[48;2;183;198;188m⠄[0m[48;2;59;100;98m⢁[0m[48;2;63;103;101m⠈[0m[48;2;63;103;101m⣠[0m[48;2;57;99;97m⣢[0m[48;2;133;159;152m⡻[0m[48;2;195;208;197m⣆[0m[48;2;63;103;101m⠠[0m[48;2;63;103;101m⠁[0m[48;2;64;104;102m⠂[0m[48;2;74;112;109m⡈[0m[48;2;222;229;217m⢉[0m[48;2;223;230;217m⠈[0m[48;2;192;205;195m⢄[0m[48;2;69;108;105m⡰[0m[48;2;66;105;103m⣼[0m[48;2;122;149;144m⡐[0m[48;2;65;105;103m⠠[0m[48;2;63;103;101m⠐[0m[48;2;63;103;101m⢀[0m[48;2;123;151;145m⠡[0m[48;2;140;164;157m⠐[0m[48;2;56;98;96m⣰[0m[48;2;62;102;100m⡀[0m[48;2;63;103;101m⠐[0m[48;2;63;103;101m⡀[0m[48;2;59;100;99m⠄[0m[48;2;138;163;156m⢈[0m[48;2;143;167;159m⣜[0m[48;2;217;225;213m⣗[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⢷[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⡽[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⡺[0m[48;2;89;124;120m⣔[0m[48;2;59;100;98m⢦[0m[48;2;57;98;97m⢖[0m[48;2;46;89;89m⡼[0m[48;2;229;235;222m⣝[0m[48;2;218;226;214m⢞[0m[48;2;224;230;218m⣞[0m[48;2;59;100;98m⡤[0m[48;2;62;102;100m⡥[0m[48;2;61;101;100m⡤[0m[48;2;49;92;91m⡦[0m[48;2;220;228;216m⣻[0m[48;2;216;224;213m⡪[0m[48;2;207;218;206m⣗[0m[48;2;66;106;104m⢦[0m[48;2;52;94;93m⢦[0m[48;2;52;94;93m⢦[0m[48;2;57;98;97m⣲[0m[48;2;125;152;146m⢳[0m[48;2;228;234;222m⡳[0m[48;2;217;225;213m⡵[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;227;233;220m⡳[0m[48;2;96;129;125m⡧[0m[48;2;53;95;94m⡦[0m[48;2;52;94;93m⡦[0m[48;2;53;95;94m⣲[0m[48;2;82;118;115m⡺[0m[48;2;198;210;199m⣪[0m[48;2;219;227;215m⢞[0m[48;2;218;226;214m⣞[0m[48;2;219;227;215m⢞[0m[48;2;127;154;148m⢶[0m[48;2;52;94;93m⢴[0m[48;2;52;94;93m⢔[0m[48;2;65;105;103m⣖[0m[48;2;179;196;186m⢯[0m[48;2;218;226;214m⣳[0m[48;2;226;232;220m⡳[0m[48;2;82;119;115m⡵[0m[48;2;52;94;93m⡴[0m[48;2;53;95;93m⣔[0m[48;2;145;168;161m⣗[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣻[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⢝[0m[48;2;218;226;214m⣞[0m
[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⡮[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢽[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⡯[0m[48;2;218;226;214m⣺[0m[48;2;218;226;214m⢕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢽[0m[48;2;217;225;213m⢝[0m[48;2;217;225;213m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⢯[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⡵[0m[48;2;218;226;214m⣫[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡳[0m[48;2;218;226;214m⡽[0m[48;2;218;226;214m⣝[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⣫[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣳[0m[48;2;218;226;214m⡣[0m[48;2;218;226;214m⣯[0m[48;2;218;226;214m⡺[0m[48;2;218;226;214m⣕[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⡫[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢵[0m[48;2;218;226;214m⡫[0m[48;2;218;226;214m⣞[0m[48;2;218;226;214m⢮[0m[48;2;218;226;214m⣻[0m[48;2;218;226;214m⡪[0m[48;2;218;226;214m⣗[0m[48;2;218;226;214m⣗[0m
`

	cmd := &cobra.Command{
		Use: "version",
		Example: `
ksctl version --help
		`,
		Short: "ksctl version",
		Long:  "To get version for ksctl components",
		Run: func(cmd *cobra.Command, args []string) {

			fmt.Println(logoKsctl)

			k.l.Note(k.Ctx, "Components", color.HiGreenString("ksctl:cli"), color.HiBlueString(config.Version), color.HiGreenString("ksctl:core"), color.HiBlueString(config.KsctlCoreVer))
			k.l.Note(k.Ctx, "Build Information", "date", config.BuildDate)
		},
	}

	return cmd
}
