// Code generated by capnpc-go. DO NOT EDIT.

package tunnelrpc

import (
	context "golang.org/x/net/context"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

type Authentication struct{ capnp.Struct }

// Authentication_TypeID is the unique identifier for the type Authentication.
const Authentication_TypeID = 0xc082ef6e0d42ed1d

func NewAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func NewRootAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func ReadRootAuthentication(msg *capnp.Message) (Authentication, error) {
	root, err := msg.RootPtr()
	return Authentication{root.Struct()}, err
}

func (s Authentication) String() string {
	str, _ := text.Marshal(0xc082ef6e0d42ed1d, s.Struct)
	return str
}

func (s Authentication) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Authentication) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Authentication) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Authentication) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Authentication) Email() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Authentication) HasEmail() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Authentication) EmailBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Authentication) SetEmail(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Authentication) OriginCAKey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Authentication) HasOriginCAKey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Authentication) OriginCAKeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Authentication) SetOriginCAKey(v string) error {
	return s.Struct.SetText(2, v)
}

// Authentication_List is a list of Authentication.
type Authentication_List struct{ capnp.List }

// NewAuthentication creates a new list of Authentication.
func NewAuthentication_List(s *capnp.Segment, sz int32) (Authentication_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return Authentication_List{l}, err
}

func (s Authentication_List) At(i int) Authentication { return Authentication{s.List.Struct(i)} }

func (s Authentication_List) Set(i int, v Authentication) error { return s.List.SetStruct(i, v.Struct) }

func (s Authentication_List) String() string {
	str, _ := text.MarshalList(0xc082ef6e0d42ed1d, s.List)
	return str
}

// Authentication_Promise is a wrapper for a Authentication promised by a client call.
type Authentication_Promise struct{ *capnp.Pipeline }

func (p Authentication_Promise) Struct() (Authentication, error) {
	s, err := p.Pipeline.Struct()
	return Authentication{s}, err
}

type TunnelRegistration struct{ capnp.Struct }

// TunnelRegistration_TypeID is the unique identifier for the type TunnelRegistration.
const TunnelRegistration_TypeID = 0xf41a0f001ad49e46

func NewTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func NewRootTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func ReadRootTunnelRegistration(msg *capnp.Message) (TunnelRegistration, error) {
	root, err := msg.RootPtr()
	return TunnelRegistration{root.Struct()}, err
}

func (s TunnelRegistration) String() string {
	str, _ := text.Marshal(0xf41a0f001ad49e46, s.Struct)
	return str
}

func (s TunnelRegistration) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelRegistration) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelRegistration) Url() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelRegistration) HasUrl() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) UrlBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetUrl(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelRegistration) LogLines() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s TunnelRegistration) HasLogLines() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetLogLines(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLogLines sets the logLines field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TunnelRegistration) NewLogLines(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s TunnelRegistration) PermanentFailure() bool {
	return s.Struct.Bit(0)
}

func (s TunnelRegistration) SetPermanentFailure(v bool) {
	s.Struct.SetBit(0, v)
}

func (s TunnelRegistration) TunnelID() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelRegistration) HasTunnelID() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) TunnelIDBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetTunnelID(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelRegistration) RetryAfterSeconds() uint16 {
	return s.Struct.Uint16(2)
}

func (s TunnelRegistration) SetRetryAfterSeconds(v uint16) {
	s.Struct.SetUint16(2, v)
}

func (s TunnelRegistration) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasEventDigest() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetEventDigest(v []byte) error {
	return s.Struct.SetData(4, v)
}

func (s TunnelRegistration) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasConnDigest() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetConnDigest(v []byte) error {
	return s.Struct.SetData(5, v)
}

// TunnelRegistration_List is a list of TunnelRegistration.
type TunnelRegistration_List struct{ capnp.List }

// NewTunnelRegistration creates a new list of TunnelRegistration.
func NewTunnelRegistration_List(s *capnp.Segment, sz int32) (TunnelRegistration_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6}, sz)
	return TunnelRegistration_List{l}, err
}

func (s TunnelRegistration_List) At(i int) TunnelRegistration {
	return TunnelRegistration{s.List.Struct(i)}
}

func (s TunnelRegistration_List) Set(i int, v TunnelRegistration) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelRegistration_List) String() string {
	str, _ := text.MarshalList(0xf41a0f001ad49e46, s.List)
	return str
}

// TunnelRegistration_Promise is a wrapper for a TunnelRegistration promised by a client call.
type TunnelRegistration_Promise struct{ *capnp.Pipeline }

func (p TunnelRegistration_Promise) Struct() (TunnelRegistration, error) {
	s, err := p.Pipeline.Struct()
	return TunnelRegistration{s}, err
}

type RegistrationOptions struct{ capnp.Struct }

// RegistrationOptions_TypeID is the unique identifier for the type RegistrationOptions.
const RegistrationOptions_TypeID = 0xc793e50592935b4a

func NewRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func NewRootRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func ReadRootRegistrationOptions(msg *capnp.Message) (RegistrationOptions, error) {
	root, err := msg.RootPtr()
	return RegistrationOptions{root.Struct()}, err
}

func (s RegistrationOptions) String() string {
	str, _ := text.Marshal(0xc793e50592935b4a, s.Struct)
	return str
}

func (s RegistrationOptions) ClientId() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegistrationOptions) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) ClientIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetClientId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegistrationOptions) Version() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s RegistrationOptions) HasVersion() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetVersion(v string) error {
	return s.Struct.SetText(1, v)
}

func (s RegistrationOptions) Os() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s RegistrationOptions) HasOs() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOs(v string) error {
	return s.Struct.SetText(2, v)
}

func (s RegistrationOptions) ExistingTunnelPolicy() ExistingTunnelPolicy {
	return ExistingTunnelPolicy(s.Struct.Uint16(0))
}

func (s RegistrationOptions) SetExistingTunnelPolicy(v ExistingTunnelPolicy) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s RegistrationOptions) PoolName() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s RegistrationOptions) HasPoolName() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) PoolNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetPoolName(v string) error {
	return s.Struct.SetText(3, v)
}

func (s RegistrationOptions) Tags() (Tag_List, error) {
	p, err := s.Struct.Ptr(4)
	return Tag_List{List: p.List()}, err
}

func (s RegistrationOptions) HasTags() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetTags(v Tag_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewTags sets the tags field to a newly
// allocated Tag_List, preferring placement in s's segment.
func (s RegistrationOptions) NewTags(n int32) (Tag_List, error) {
	l, err := NewTag_List(s.Struct.Segment(), n)
	if err != nil {
		return Tag_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

func (s RegistrationOptions) ConnectionId() uint8 {
	return s.Struct.Uint8(2)
}

func (s RegistrationOptions) SetConnectionId(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s RegistrationOptions) OriginLocalIp() (string, error) {
	p, err := s.Struct.Ptr(5)
	return p.Text(), err
}

func (s RegistrationOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OriginLocalIpBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOriginLocalIp(v string) error {
	return s.Struct.SetText(5, v)
}

func (s RegistrationOptions) IsAutoupdated() bool {
	return s.Struct.Bit(24)
}

func (s RegistrationOptions) SetIsAutoupdated(v bool) {
	s.Struct.SetBit(24, v)
}

func (s RegistrationOptions) RunFromTerminal() bool {
	return s.Struct.Bit(25)
}

func (s RegistrationOptions) SetRunFromTerminal(v bool) {
	s.Struct.SetBit(25, v)
}

func (s RegistrationOptions) CompressionQuality() uint64 {
	return s.Struct.Uint64(8)
}

func (s RegistrationOptions) SetCompressionQuality(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s RegistrationOptions) Uuid() (string, error) {
	p, err := s.Struct.Ptr(6)
	return p.Text(), err
}

func (s RegistrationOptions) HasUuid() bool {
	p, err := s.Struct.Ptr(6)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) UuidBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(6)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetUuid(v string) error {
	return s.Struct.SetText(6, v)
}

func (s RegistrationOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(4)
}

func (s RegistrationOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(4, v)
}

func (s RegistrationOptions) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(7)
	return capnp.TextList{List: p.List()}, err
}

func (s RegistrationOptions) HasFeatures() bool {
	p, err := s.Struct.Ptr(7)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(7, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s RegistrationOptions) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(7, l.List.ToPtr())
	return l, err
}

// RegistrationOptions_List is a list of RegistrationOptions.
type RegistrationOptions_List struct{ capnp.List }

// NewRegistrationOptions creates a new list of RegistrationOptions.
func NewRegistrationOptions_List(s *capnp.Segment, sz int32) (RegistrationOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8}, sz)
	return RegistrationOptions_List{l}, err
}

func (s RegistrationOptions_List) At(i int) RegistrationOptions {
	return RegistrationOptions{s.List.Struct(i)}
}

func (s RegistrationOptions_List) Set(i int, v RegistrationOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationOptions_List) String() string {
	str, _ := text.MarshalList(0xc793e50592935b4a, s.List)
	return str
}

// RegistrationOptions_Promise is a wrapper for a RegistrationOptions promised by a client call.
type RegistrationOptions_Promise struct{ *capnp.Pipeline }

func (p RegistrationOptions_Promise) Struct() (RegistrationOptions, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationOptions{s}, err
}

type Tag struct{ capnp.Struct }

// Tag_TypeID is the unique identifier for the type Tag.
const Tag_TypeID = 0xcbd96442ae3bb01a

func NewTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func NewRootTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func ReadRootTag(msg *capnp.Message) (Tag, error) {
	root, err := msg.RootPtr()
	return Tag{root.Struct()}, err
}

func (s Tag) String() string {
	str, _ := text.Marshal(0xcbd96442ae3bb01a, s.Struct)
	return str
}

func (s Tag) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Tag) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Tag) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Tag) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Tag) Value() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Tag) HasValue() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Tag) ValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Tag) SetValue(v string) error {
	return s.Struct.SetText(1, v)
}

// Tag_List is a list of Tag.
type Tag_List struct{ capnp.List }

// NewTag creates a new list of Tag.
func NewTag_List(s *capnp.Segment, sz int32) (Tag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Tag_List{l}, err
}

func (s Tag_List) At(i int) Tag { return Tag{s.List.Struct(i)} }

func (s Tag_List) Set(i int, v Tag) error { return s.List.SetStruct(i, v.Struct) }

func (s Tag_List) String() string {
	str, _ := text.MarshalList(0xcbd96442ae3bb01a, s.List)
	return str
}

// Tag_Promise is a wrapper for a Tag promised by a client call.
type Tag_Promise struct{ *capnp.Pipeline }

func (p Tag_Promise) Struct() (Tag, error) {
	s, err := p.Pipeline.Struct()
	return Tag{s}, err
}

type ExistingTunnelPolicy uint16

// ExistingTunnelPolicy_TypeID is the unique identifier for the type ExistingTunnelPolicy.
const ExistingTunnelPolicy_TypeID = 0x84cb9536a2cf6d3c

// Values of ExistingTunnelPolicy.
const (
	ExistingTunnelPolicy_ignore     ExistingTunnelPolicy = 0
	ExistingTunnelPolicy_disconnect ExistingTunnelPolicy = 1
	ExistingTunnelPolicy_balance    ExistingTunnelPolicy = 2
)

// String returns the enum's constant name.
func (c ExistingTunnelPolicy) String() string {
	switch c {
	case ExistingTunnelPolicy_ignore:
		return "ignore"
	case ExistingTunnelPolicy_disconnect:
		return "disconnect"
	case ExistingTunnelPolicy_balance:
		return "balance"

	default:
		return ""
	}
}

// ExistingTunnelPolicyFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ExistingTunnelPolicyFromString(c string) ExistingTunnelPolicy {
	switch c {
	case "ignore":
		return ExistingTunnelPolicy_ignore
	case "disconnect":
		return ExistingTunnelPolicy_disconnect
	case "balance":
		return ExistingTunnelPolicy_balance

	default:
		return 0
	}
}

type ExistingTunnelPolicy_List struct{ capnp.List }

func NewExistingTunnelPolicy_List(s *capnp.Segment, sz int32) (ExistingTunnelPolicy_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return ExistingTunnelPolicy_List{l.List}, err
}

func (l ExistingTunnelPolicy_List) At(i int) ExistingTunnelPolicy {
	ul := capnp.UInt16List{List: l.List}
	return ExistingTunnelPolicy(ul.At(i))
}

func (l ExistingTunnelPolicy_List) Set(i int, v ExistingTunnelPolicy) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type ServerInfo struct{ capnp.Struct }

// ServerInfo_TypeID is the unique identifier for the type ServerInfo.
const ServerInfo_TypeID = 0xf2c68e2547ec3866

func NewServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func NewRootServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func ReadRootServerInfo(msg *capnp.Message) (ServerInfo, error) {
	root, err := msg.RootPtr()
	return ServerInfo{root.Struct()}, err
}

func (s ServerInfo) String() string {
	str, _ := text.Marshal(0xf2c68e2547ec3866, s.Struct)
	return str
}

func (s ServerInfo) LocationName() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ServerInfo) HasLocationName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ServerInfo) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ServerInfo) SetLocationName(v string) error {
	return s.Struct.SetText(0, v)
}

// ServerInfo_List is a list of ServerInfo.
type ServerInfo_List struct{ capnp.List }

// NewServerInfo creates a new list of ServerInfo.
func NewServerInfo_List(s *capnp.Segment, sz int32) (ServerInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ServerInfo_List{l}, err
}

func (s ServerInfo_List) At(i int) ServerInfo { return ServerInfo{s.List.Struct(i)} }

func (s ServerInfo_List) Set(i int, v ServerInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ServerInfo_List) String() string {
	str, _ := text.MarshalList(0xf2c68e2547ec3866, s.List)
	return str
}

// ServerInfo_Promise is a wrapper for a ServerInfo promised by a client call.
type ServerInfo_Promise struct{ *capnp.Pipeline }

func (p ServerInfo_Promise) Struct() (ServerInfo, error) {
	s, err := p.Pipeline.Struct()
	return ServerInfo{s}, err
}

type AuthenticateResponse struct{ capnp.Struct }

// AuthenticateResponse_TypeID is the unique identifier for the type AuthenticateResponse.
const AuthenticateResponse_TypeID = 0x82c325a07ad22a65

func NewAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func NewRootAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func ReadRootAuthenticateResponse(msg *capnp.Message) (AuthenticateResponse, error) {
	root, err := msg.RootPtr()
	return AuthenticateResponse{root.Struct()}, err
}

func (s AuthenticateResponse) String() string {
	str, _ := text.Marshal(0x82c325a07ad22a65, s.Struct)
	return str
}

func (s AuthenticateResponse) PermanentErr() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AuthenticateResponse) HasPermanentErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) PermanentErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetPermanentErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s AuthenticateResponse) RetryableErr() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s AuthenticateResponse) HasRetryableErr() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) RetryableErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetRetryableErr(v string) error {
	return s.Struct.SetText(1, v)
}

func (s AuthenticateResponse) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s AuthenticateResponse) HasJwt() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) SetJwt(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s AuthenticateResponse) HoursUntilRefresh() uint8 {
	return s.Struct.Uint8(0)
}

func (s AuthenticateResponse) SetHoursUntilRefresh(v uint8) {
	s.Struct.SetUint8(0, v)
}

// AuthenticateResponse_List is a list of AuthenticateResponse.
type AuthenticateResponse_List struct{ capnp.List }

// NewAuthenticateResponse creates a new list of AuthenticateResponse.
func NewAuthenticateResponse_List(s *capnp.Segment, sz int32) (AuthenticateResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return AuthenticateResponse_List{l}, err
}

func (s AuthenticateResponse_List) At(i int) AuthenticateResponse {
	return AuthenticateResponse{s.List.Struct(i)}
}

func (s AuthenticateResponse_List) Set(i int, v AuthenticateResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AuthenticateResponse_List) String() string {
	str, _ := text.MarshalList(0x82c325a07ad22a65, s.List)
	return str
}

// AuthenticateResponse_Promise is a wrapper for a AuthenticateResponse promised by a client call.
type AuthenticateResponse_Promise struct{ *capnp.Pipeline }

func (p AuthenticateResponse_Promise) Struct() (AuthenticateResponse, error) {
	s, err := p.Pipeline.Struct()
	return AuthenticateResponse{s}, err
}

type ClientInfo struct{ capnp.Struct }

// ClientInfo_TypeID is the unique identifier for the type ClientInfo.
const ClientInfo_TypeID = 0x83ced0145b2f114b

func NewClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func NewRootClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func ReadRootClientInfo(msg *capnp.Message) (ClientInfo, error) {
	root, err := msg.RootPtr()
	return ClientInfo{root.Struct()}, err
}

func (s ClientInfo) String() string {
	str, _ := text.Marshal(0x83ced0145b2f114b, s.Struct)
	return str
}

func (s ClientInfo) ClientId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ClientInfo) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetClientId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ClientInfo) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s ClientInfo) HasFeatures() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s ClientInfo) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s ClientInfo) Version() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s ClientInfo) HasVersion() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ClientInfo) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s ClientInfo) SetVersion(v string) error {
	return s.Struct.SetText(2, v)
}

func (s ClientInfo) Arch() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s ClientInfo) HasArch() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s ClientInfo) ArchBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s ClientInfo) SetArch(v string) error {
	return s.Struct.SetText(3, v)
}

// ClientInfo_List is a list of ClientInfo.
type ClientInfo_List struct{ capnp.List }

// NewClientInfo creates a new list of ClientInfo.
func NewClientInfo_List(s *capnp.Segment, sz int32) (ClientInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return ClientInfo_List{l}, err
}

func (s ClientInfo_List) At(i int) ClientInfo { return ClientInfo{s.List.Struct(i)} }

func (s ClientInfo_List) Set(i int, v ClientInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ClientInfo_List) String() string {
	str, _ := text.MarshalList(0x83ced0145b2f114b, s.List)
	return str
}

// ClientInfo_Promise is a wrapper for a ClientInfo promised by a client call.
type ClientInfo_Promise struct{ *capnp.Pipeline }

func (p ClientInfo_Promise) Struct() (ClientInfo, error) {
	s, err := p.Pipeline.Struct()
	return ClientInfo{s}, err
}

type ConnectionOptions struct{ capnp.Struct }

// ConnectionOptions_TypeID is the unique identifier for the type ConnectionOptions.
const ConnectionOptions_TypeID = 0xb4bf9861fe035d04

func NewConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func NewRootConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func ReadRootConnectionOptions(msg *capnp.Message) (ConnectionOptions, error) {
	root, err := msg.RootPtr()
	return ConnectionOptions{root.Struct()}, err
}

func (s ConnectionOptions) String() string {
	str, _ := text.Marshal(0xb4bf9861fe035d04, s.Struct)
	return str
}

func (s ConnectionOptions) Client() (ClientInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ClientInfo{Struct: p.Struct()}, err
}

func (s ConnectionOptions) HasClient() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetClient(v ClientInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewClient sets the client field to a newly
// allocated ClientInfo struct, preferring placement in s's segment.
func (s ConnectionOptions) NewClient() (ClientInfo, error) {
	ss, err := NewClientInfo(s.Struct.Segment())
	if err != nil {
		return ClientInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionOptions) OriginLocalIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s ConnectionOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetOriginLocalIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s ConnectionOptions) ReplaceExisting() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionOptions) SetReplaceExisting(v bool) {
	s.Struct.SetBit(0, v)
}

func (s ConnectionOptions) CompressionQuality() uint8 {
	return s.Struct.Uint8(1)
}

func (s ConnectionOptions) SetCompressionQuality(v uint8) {
	s.Struct.SetUint8(1, v)
}

func (s ConnectionOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(2)
}

func (s ConnectionOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(2, v)
}

// ConnectionOptions_List is a list of ConnectionOptions.
type ConnectionOptions_List struct{ capnp.List }

// NewConnectionOptions creates a new list of ConnectionOptions.
func NewConnectionOptions_List(s *capnp.Segment, sz int32) (ConnectionOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionOptions_List{l}, err
}

func (s ConnectionOptions_List) At(i int) ConnectionOptions {
	return ConnectionOptions{s.List.Struct(i)}
}

func (s ConnectionOptions_List) Set(i int, v ConnectionOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionOptions_List) String() string {
	str, _ := text.MarshalList(0xb4bf9861fe035d04, s.List)
	return str
}

// ConnectionOptions_Promise is a wrapper for a ConnectionOptions promised by a client call.
type ConnectionOptions_Promise struct{ *capnp.Pipeline }

func (p ConnectionOptions_Promise) Struct() (ConnectionOptions, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionOptions{s}, err
}

func (p ConnectionOptions_Promise) Client() ClientInfo_Promise {
	return ClientInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionResponse struct{ capnp.Struct }
type ConnectionResponse_result ConnectionResponse
type ConnectionResponse_result_Which uint16

const (
	ConnectionResponse_result_Which_error             ConnectionResponse_result_Which = 0
	ConnectionResponse_result_Which_connectionDetails ConnectionResponse_result_Which = 1
)

func (w ConnectionResponse_result_Which) String() string {
	const s = "errorconnectionDetails"
	switch w {
	case ConnectionResponse_result_Which_error:
		return s[0:5]
	case ConnectionResponse_result_Which_connectionDetails:
		return s[5:22]

	}
	return "ConnectionResponse_result_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// ConnectionResponse_TypeID is the unique identifier for the type ConnectionResponse.
const ConnectionResponse_TypeID = 0xdbaa9d03d52b62dc

func NewConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func NewRootConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func ReadRootConnectionResponse(msg *capnp.Message) (ConnectionResponse, error) {
	root, err := msg.RootPtr()
	return ConnectionResponse{root.Struct()}, err
}

func (s ConnectionResponse) String() string {
	str, _ := text.Marshal(0xdbaa9d03d52b62dc, s.Struct)
	return str
}

func (s ConnectionResponse) Result() ConnectionResponse_result { return ConnectionResponse_result(s) }

func (s ConnectionResponse_result) Which() ConnectionResponse_result_Which {
	return ConnectionResponse_result_Which(s.Struct.Uint16(0))
}
func (s ConnectionResponse_result) Error() (ConnectionError, error) {
	if s.Struct.Uint16(0) != 0 {
		panic("Which() != error")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionError{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasError() bool {
	if s.Struct.Uint16(0) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetError(v ConnectionError) error {
	s.Struct.SetUint16(0, 0)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewError sets the error field to a newly
// allocated ConnectionError struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewError() (ConnectionError, error) {
	s.Struct.SetUint16(0, 0)
	ss, err := NewConnectionError(s.Struct.Segment())
	if err != nil {
		return ConnectionError{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionResponse_result) ConnectionDetails() (ConnectionDetails, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != connectionDetails")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionDetails{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasConnectionDetails() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetConnectionDetails(v ConnectionDetails) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewConnectionDetails sets the connectionDetails field to a newly
// allocated ConnectionDetails struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewConnectionDetails() (ConnectionDetails, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewConnectionDetails(s.Struct.Segment())
	if err != nil {
		return ConnectionDetails{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConnectionResponse_List is a list of ConnectionResponse.
type ConnectionResponse_List struct{ capnp.List }

// NewConnectionResponse creates a new list of ConnectionResponse.
func NewConnectionResponse_List(s *capnp.Segment, sz int32) (ConnectionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConnectionResponse_List{l}, err
}

func (s ConnectionResponse_List) At(i int) ConnectionResponse {
	return ConnectionResponse{s.List.Struct(i)}
}

func (s ConnectionResponse_List) Set(i int, v ConnectionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionResponse_List) String() string {
	str, _ := text.MarshalList(0xdbaa9d03d52b62dc, s.List)
	return str
}

// ConnectionResponse_Promise is a wrapper for a ConnectionResponse promised by a client call.
type ConnectionResponse_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_Promise) Struct() (ConnectionResponse, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse{s}, err
}

func (p ConnectionResponse_Promise) Result() ConnectionResponse_result_Promise {
	return ConnectionResponse_result_Promise{p.Pipeline}
}

// ConnectionResponse_result_Promise is a wrapper for a ConnectionResponse_result promised by a client call.
type ConnectionResponse_result_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_result_Promise) Struct() (ConnectionResponse_result, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse_result{s}, err
}

func (p ConnectionResponse_result_Promise) Error() ConnectionError_Promise {
	return ConnectionError_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p ConnectionResponse_result_Promise) ConnectionDetails() ConnectionDetails_Promise {
	return ConnectionDetails_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionError struct{ capnp.Struct }

// ConnectionError_TypeID is the unique identifier for the type ConnectionError.
const ConnectionError_TypeID = 0xf5f383d2785edb86

func NewConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func NewRootConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func ReadRootConnectionError(msg *capnp.Message) (ConnectionError, error) {
	root, err := msg.RootPtr()
	return ConnectionError{root.Struct()}, err
}

func (s ConnectionError) String() string {
	str, _ := text.Marshal(0xf5f383d2785edb86, s.Struct)
	return str
}

func (s ConnectionError) Cause() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ConnectionError) HasCause() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionError) CauseBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ConnectionError) SetCause(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ConnectionError) RetryAfter() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s ConnectionError) SetRetryAfter(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s ConnectionError) ShouldRetry() bool {
	return s.Struct.Bit(64)
}

func (s ConnectionError) SetShouldRetry(v bool) {
	s.Struct.SetBit(64, v)
}

// ConnectionError_List is a list of ConnectionError.
type ConnectionError_List struct{ capnp.List }

// NewConnectionError creates a new list of ConnectionError.
func NewConnectionError_List(s *capnp.Segment, sz int32) (ConnectionError_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return ConnectionError_List{l}, err
}

func (s ConnectionError_List) At(i int) ConnectionError { return ConnectionError{s.List.Struct(i)} }

func (s ConnectionError_List) Set(i int, v ConnectionError) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionError_List) String() string {
	str, _ := text.MarshalList(0xf5f383d2785edb86, s.List)
	return str
}

// ConnectionError_Promise is a wrapper for a ConnectionError promised by a client call.
type ConnectionError_Promise struct{ *capnp.Pipeline }

func (p ConnectionError_Promise) Struct() (ConnectionError, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionError{s}, err
}

type ConnectionDetails struct{ capnp.Struct }

// ConnectionDetails_TypeID is the unique identifier for the type ConnectionDetails.
const ConnectionDetails_TypeID = 0xb5f39f082b9ac18a

func NewConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func NewRootConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func ReadRootConnectionDetails(msg *capnp.Message) (ConnectionDetails, error) {
	root, err := msg.RootPtr()
	return ConnectionDetails{root.Struct()}, err
}

func (s ConnectionDetails) String() string {
	str, _ := text.Marshal(0xb5f39f082b9ac18a, s.Struct)
	return str
}

func (s ConnectionDetails) Uuid() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConnectionDetails) HasUuid() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) SetUuid(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ConnectionDetails) LocationName() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ConnectionDetails) HasLocationName() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ConnectionDetails) SetLocationName(v string) error {
	return s.Struct.SetText(1, v)
}

// ConnectionDetails_List is a list of ConnectionDetails.
type ConnectionDetails_List struct{ capnp.List }

// NewConnectionDetails creates a new list of ConnectionDetails.
func NewConnectionDetails_List(s *capnp.Segment, sz int32) (ConnectionDetails_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return ConnectionDetails_List{l}, err
}

func (s ConnectionDetails_List) At(i int) ConnectionDetails {
	return ConnectionDetails{s.List.Struct(i)}
}

func (s ConnectionDetails_List) Set(i int, v ConnectionDetails) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionDetails_List) String() string {
	str, _ := text.MarshalList(0xb5f39f082b9ac18a, s.List)
	return str
}

// ConnectionDetails_Promise is a wrapper for a ConnectionDetails promised by a client call.
type ConnectionDetails_Promise struct{ *capnp.Pipeline }

func (p ConnectionDetails_Promise) Struct() (ConnectionDetails, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionDetails{s}, err
}

type TunnelAuth struct{ capnp.Struct }

// TunnelAuth_TypeID is the unique identifier for the type TunnelAuth.
const TunnelAuth_TypeID = 0x9496331ab9cd463f

func NewTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func NewRootTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func ReadRootTunnelAuth(msg *capnp.Message) (TunnelAuth, error) {
	root, err := msg.RootPtr()
	return TunnelAuth{root.Struct()}, err
}

func (s TunnelAuth) String() string {
	str, _ := text.Marshal(0x9496331ab9cd463f, s.Struct)
	return str
}

func (s TunnelAuth) AccountTag() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelAuth) HasAccountTag() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) AccountTagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelAuth) SetAccountTag(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelAuth) TunnelSecret() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelAuth) HasTunnelSecret() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) SetTunnelSecret(v []byte) error {
	return s.Struct.SetData(1, v)
}

// TunnelAuth_List is a list of TunnelAuth.
type TunnelAuth_List struct{ capnp.List }

// NewTunnelAuth creates a new list of TunnelAuth.
func NewTunnelAuth_List(s *capnp.Segment, sz int32) (TunnelAuth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return TunnelAuth_List{l}, err
}

func (s TunnelAuth_List) At(i int) TunnelAuth { return TunnelAuth{s.List.Struct(i)} }

func (s TunnelAuth_List) Set(i int, v TunnelAuth) error { return s.List.SetStruct(i, v.Struct) }

func (s TunnelAuth_List) String() string {
	str, _ := text.MarshalList(0x9496331ab9cd463f, s.List)
	return str
}

// TunnelAuth_Promise is a wrapper for a TunnelAuth promised by a client call.
type TunnelAuth_Promise struct{ *capnp.Pipeline }

func (p TunnelAuth_Promise) Struct() (TunnelAuth, error) {
	s, err := p.Pipeline.Struct()
	return TunnelAuth{s}, err
}

type RegistrationServer struct{ Client capnp.Client }

// RegistrationServer_TypeID is the unique identifier for the type RegistrationServer.
const RegistrationServer_TypeID = 0xf71695ec7fe85497

func (c RegistrationServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type RegistrationServer_Server interface {
	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func RegistrationServer_ServerToClient(s RegistrationServer_Server) RegistrationServer {
	c, _ := s.(server.Closer)
	return RegistrationServer{Client: server.New(RegistrationServer_Methods(nil, s), c)}
}

func RegistrationServer_Methods(methods []server.Method, s RegistrationServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// RegistrationServer_registerConnection holds the arguments for a server call to RegistrationServer.registerConnection.
type RegistrationServer_registerConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_registerConnection_Params
	Results RegistrationServer_registerConnection_Results
}

// RegistrationServer_unregisterConnection holds the arguments for a server call to RegistrationServer.unregisterConnection.
type RegistrationServer_unregisterConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_unregisterConnection_Params
	Results RegistrationServer_unregisterConnection_Results
}

type RegistrationServer_registerConnection_Params struct{ capnp.Struct }

// RegistrationServer_registerConnection_Params_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Params.
const RegistrationServer_registerConnection_Params_TypeID = 0xe6646dec8feaa6ee

func NewRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func NewRootRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func ReadRootRegistrationServer_registerConnection_Params(msg *capnp.Message) (RegistrationServer_registerConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) String() string {
	str, _ := text.Marshal(0xe6646dec8feaa6ee, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Params) Auth() (TunnelAuth, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelAuth{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasAuth() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetAuth(v TunnelAuth) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAuth sets the auth field to a newly
// allocated TunnelAuth struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewAuth() (TunnelAuth, error) {
	ss, err := NewTunnelAuth(s.Struct.Segment())
	if err != nil {
		return TunnelAuth{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s RegistrationServer_registerConnection_Params) TunnelId() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegistrationServer_registerConnection_Params) HasTunnelId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetTunnelId(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s RegistrationServer_registerConnection_Params) ConnIndex() uint8 {
	return s.Struct.Uint8(0)
}

func (s RegistrationServer_registerConnection_Params) SetConnIndex(v uint8) {
	s.Struct.SetUint8(0, v)
}

func (s RegistrationServer_registerConnection_Params) Options() (ConnectionOptions, error) {
	p, err := s.Struct.Ptr(2)
	return ConnectionOptions{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetOptions(v ConnectionOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated ConnectionOptions struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewOptions() (ConnectionOptions, error) {
	ss, err := NewConnectionOptions(s.Struct.Segment())
	if err != nil {
		return ConnectionOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Params_List is a list of RegistrationServer_registerConnection_Params.
type RegistrationServer_registerConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Params creates a new list of RegistrationServer_registerConnection_Params.
func NewRegistrationServer_registerConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return RegistrationServer_registerConnection_Params_List{l}, err
}

func (s RegistrationServer_registerConnection_Params_List) At(i int) RegistrationServer_registerConnection_Params {
	return RegistrationServer_registerConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Params_List) Set(i int, v RegistrationServer_registerConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xe6646dec8feaa6ee, s.List)
	return str
}

// RegistrationServer_registerConnection_Params_Promise is a wrapper for a RegistrationServer_registerConnection_Params promised by a client call.
type RegistrationServer_registerConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Params_Promise) Struct() (RegistrationServer_registerConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Params{s}, err
}

func (p RegistrationServer_registerConnection_Params_Promise) Auth() TunnelAuth_Promise {
	return TunnelAuth_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p RegistrationServer_registerConnection_Params_Promise) Options() ConnectionOptions_Promise {
	return ConnectionOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type RegistrationServer_registerConnection_Results struct{ capnp.Struct }

// RegistrationServer_registerConnection_Results_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Results.
const RegistrationServer_registerConnection_Results_TypeID = 0xea50d822450d1f17

func NewRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func NewRootRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func ReadRootRegistrationServer_registerConnection_Results(msg *capnp.Message) (RegistrationServer_registerConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) String() string {
	str, _ := text.Marshal(0xea50d822450d1f17, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Results) Result() (ConnectionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return ConnectionResponse{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Results) SetResult(v ConnectionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ConnectionResponse struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Results) NewResult() (ConnectionResponse, error) {
	ss, err := NewConnectionResponse(s.Struct.Segment())
	if err != nil {
		return ConnectionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Results_List is a list of RegistrationServer_registerConnection_Results.
type RegistrationServer_registerConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Results creates a new list of RegistrationServer_registerConnection_Results.
func NewRegistrationServer_registerConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_registerConnection_Results_List{l}, err
}

func (s RegistrationServer_registerConnection_Results_List) At(i int) RegistrationServer_registerConnection_Results {
	return RegistrationServer_registerConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Results_List) Set(i int, v RegistrationServer_registerConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xea50d822450d1f17, s.List)
	return str
}

// RegistrationServer_registerConnection_Results_Promise is a wrapper for a RegistrationServer_registerConnection_Results promised by a client call.
type RegistrationServer_registerConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Results_Promise) Struct() (RegistrationServer_registerConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Results{s}, err
}

func (p RegistrationServer_registerConnection_Results_Promise) Result() ConnectionResponse_Promise {
	return ConnectionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegistrationServer_unregisterConnection_Params struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Params_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Params.
const RegistrationServer_unregisterConnection_Params_TypeID = 0xf9cb7f4431a307d0

func NewRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Params(msg *capnp.Message) (RegistrationServer_unregisterConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Params) String() string {
	str, _ := text.Marshal(0xf9cb7f4431a307d0, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Params_List is a list of RegistrationServer_unregisterConnection_Params.
type RegistrationServer_unregisterConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Params creates a new list of RegistrationServer_unregisterConnection_Params.
func NewRegistrationServer_unregisterConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Params_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Params_List) At(i int) RegistrationServer_unregisterConnection_Params {
	return RegistrationServer_unregisterConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Params_List) Set(i int, v RegistrationServer_unregisterConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xf9cb7f4431a307d0, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Params_Promise is a wrapper for a RegistrationServer_unregisterConnection_Params promised by a client call.
type RegistrationServer_unregisterConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Params_Promise) Struct() (RegistrationServer_unregisterConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Params{s}, err
}

type RegistrationServer_unregisterConnection_Results struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Results_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Results.
const RegistrationServer_unregisterConnection_Results_TypeID = 0xb046e578094b1ead

func NewRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Results(msg *capnp.Message) (RegistrationServer_unregisterConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Results) String() string {
	str, _ := text.Marshal(0xb046e578094b1ead, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Results_List is a list of RegistrationServer_unregisterConnection_Results.
type RegistrationServer_unregisterConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Results creates a new list of RegistrationServer_unregisterConnection_Results.
func NewRegistrationServer_unregisterConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Results_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Results_List) At(i int) RegistrationServer_unregisterConnection_Results {
	return RegistrationServer_unregisterConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Results_List) Set(i int, v RegistrationServer_unregisterConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xb046e578094b1ead, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Results_Promise is a wrapper for a RegistrationServer_unregisterConnection_Results promised by a client call.
type RegistrationServer_unregisterConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Results_Promise) Struct() (RegistrationServer_unregisterConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Results{s}, err
}

type TunnelServer struct{ Client capnp.Client }

// TunnelServer_TypeID is the unique identifier for the type TunnelServer.
const TunnelServer_TypeID = 0xea58385c65416035

func (c TunnelServer) RegisterTunnel(ctx context.Context, params func(TunnelServer_registerTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_registerTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_registerTunnel_Params{Struct: s}) }
	}
	return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) GetServerInfo(ctx context.Context, params func(TunnelServer_getServerInfo_Params) error, opts ...capnp.CallOption) TunnelServer_getServerInfo_Results_Promise {
	if c.Client == nil {
		return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_getServerInfo_Params{Struct: s}) }
	}
	return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterTunnel(ctx context.Context, params func(TunnelServer_unregisterTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_unregisterTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_unregisterTunnel_Params{Struct: s}) }
	}
	return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ObsoleteDeclarativeTunnelConnect(ctx context.Context, params func(TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error, opts ...capnp.CallOption) TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise {
	if c.Client == nil {
		return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: s})
		}
	}
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) Authenticate(ctx context.Context, params func(TunnelServer_authenticate_Params) error, opts ...capnp.CallOption) TunnelServer_authenticate_Results_Promise {
	if c.Client == nil {
		return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_authenticate_Params{Struct: s}) }
	}
	return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ReconnectTunnel(ctx context.Context, params func(TunnelServer_reconnectTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_reconnectTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 5}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_reconnectTunnel_Params{Struct: s}) }
	}
	return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type TunnelServer_Server interface {
	RegisterTunnel(TunnelServer_registerTunnel) error

	GetServerInfo(TunnelServer_getServerInfo) error

	UnregisterTunnel(TunnelServer_unregisterTunnel) error

	ObsoleteDeclarativeTunnelConnect(TunnelServer_obsoleteDeclarativeTunnelConnect) error

	Authenticate(TunnelServer_authenticate) error

	ReconnectTunnel(TunnelServer_reconnectTunnel) error

	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error
}

func TunnelServer_ServerToClient(s TunnelServer_Server) TunnelServer {
	c, _ := s.(server.Closer)
	return TunnelServer{Client: server.New(TunnelServer_Methods(nil, s), c)}
}

func TunnelServer_Methods(methods []server.Method, s TunnelServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 8)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_registerTunnel{c, opts, TunnelServer_registerTunnel_Params{Struct: p}, TunnelServer_registerTunnel_Results{Struct: r}}
			return s.RegisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_getServerInfo{c, opts, TunnelServer_getServerInfo_Params{Struct: p}, TunnelServer_getServerInfo_Results{Struct: r}}
			return s.GetServerInfo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_unregisterTunnel{c, opts, TunnelServer_unregisterTunnel_Params{Struct: p}, TunnelServer_unregisterTunnel_Results{Struct: r}}
			return s.UnregisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_obsoleteDeclarativeTunnelConnect{c, opts, TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: p}, TunnelServer_obsoleteDeclarativeTunnelConnect_Results{Struct: r}}
			return s.ObsoleteDeclarativeTunnelConnect(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_authenticate{c, opts, TunnelServer_authenticate_Params{Struct: p}, TunnelServer_authenticate_Results{Struct: r}}
			return s.Authenticate(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_reconnectTunnel{c, opts, TunnelServer_reconnectTunnel_Params{Struct: p}, TunnelServer_reconnectTunnel_Results{Struct: r}}
			return s.ReconnectTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// TunnelServer_registerTunnel holds the arguments for a server call to TunnelServer.registerTunnel.
type TunnelServer_registerTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_registerTunnel_Params
	Results TunnelServer_registerTunnel_Results
}

// TunnelServer_getServerInfo holds the arguments for a server call to TunnelServer.getServerInfo.
type TunnelServer_getServerInfo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_getServerInfo_Params
	Results TunnelServer_getServerInfo_Results
}

// TunnelServer_unregisterTunnel holds the arguments for a server call to TunnelServer.unregisterTunnel.
type TunnelServer_unregisterTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_unregisterTunnel_Params
	Results TunnelServer_unregisterTunnel_Results
}

// TunnelServer_obsoleteDeclarativeTunnelConnect holds the arguments for a server call to TunnelServer.obsoleteDeclarativeTunnelConnect.
type TunnelServer_obsoleteDeclarativeTunnelConnect struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_obsoleteDeclarativeTunnelConnect_Params
	Results TunnelServer_obsoleteDeclarativeTunnelConnect_Results
}

// TunnelServer_authenticate holds the arguments for a server call to TunnelServer.authenticate.
type TunnelServer_authenticate struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_authenticate_Params
	Results TunnelServer_authenticate_Results
}

// TunnelServer_reconnectTunnel holds the arguments for a server call to TunnelServer.reconnectTunnel.
type TunnelServer_reconnectTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_reconnectTunnel_Params
	Results TunnelServer_reconnectTunnel_Results
}

type TunnelServer_registerTunnel_Params struct{ capnp.Struct }

// TunnelServer_registerTunnel_Params_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Params.
const TunnelServer_registerTunnel_Params_TypeID = 0xb70431c0dc014915

func NewTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func NewRootTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func ReadRootTunnelServer_registerTunnel_Params(msg *capnp.Message) (TunnelServer_registerTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) String() string {
	str, _ := text.Marshal(0xb70431c0dc014915, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_registerTunnel_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_registerTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_registerTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_registerTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_registerTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Params_List is a list of TunnelServer_registerTunnel_Params.
type TunnelServer_registerTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Params creates a new list of TunnelServer_registerTunnel_Params.
func NewTunnelServer_registerTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_registerTunnel_Params_List{l}, err
}

func (s TunnelServer_registerTunnel_Params_List) At(i int) TunnelServer_registerTunnel_Params {
	return TunnelServer_registerTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Params_List) Set(i int, v TunnelServer_registerTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xb70431c0dc014915, s.List)
	return str
}

// TunnelServer_registerTunnel_Params_Promise is a wrapper for a TunnelServer_registerTunnel_Params promised by a client call.
type TunnelServer_registerTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Params_Promise) Struct() (TunnelServer_registerTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Params{s}, err
}

func (p TunnelServer_registerTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_registerTunnel_Results struct{ capnp.Struct }

// TunnelServer_registerTunnel_Results_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Results.
const TunnelServer_registerTunnel_Results_TypeID = 0xf2c122394f447e8e

func NewTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func NewRootTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func ReadRootTunnelServer_registerTunnel_Results(msg *capnp.Message) (TunnelServer_registerTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) String() string {
	str, _ := text.Marshal(0xf2c122394f447e8e, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Results_List is a list of TunnelServer_registerTunnel_Results.
type TunnelServer_registerTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Results creates a new list of TunnelServer_registerTunnel_Results.
func NewTunnelServer_registerTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_registerTunnel_Results_List{l}, err
}

func (s TunnelServer_registerTunnel_Results_List) At(i int) TunnelServer_registerTunnel_Results {
	return TunnelServer_registerTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Results_List) Set(i int, v TunnelServer_registerTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xf2c122394f447e8e, s.List)
	return str
}

// TunnelServer_registerTunnel_Results_Promise is a wrapper for a TunnelServer_registerTunnel_Results promised by a client call.
type TunnelServer_registerTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Results_Promise) Struct() (TunnelServer_registerTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Results{s}, err
}

func (p TunnelServer_registerTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_getServerInfo_Params struct{ capnp.Struct }

// TunnelServer_getServerInfo_Params_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Params.
const TunnelServer_getServerInfo_Params_TypeID = 0xdc3ed6801961e502

func NewTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func NewRootTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func ReadRootTunnelServer_getServerInfo_Params(msg *capnp.Message) (TunnelServer_getServerInfo_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Params{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Params) String() string {
	str, _ := text.Marshal(0xdc3ed6801961e502, s.Struct)
	return str
}

// TunnelServer_getServerInfo_Params_List is a list of TunnelServer_getServerInfo_Params.
type TunnelServer_getServerInfo_Params_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Params creates a new list of TunnelServer_getServerInfo_Params.
func NewTunnelServer_getServerInfo_Params_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_getServerInfo_Params_List{l}, err
}

func (s TunnelServer_getServerInfo_Params_List) At(i int) TunnelServer_getServerInfo_Params {
	return TunnelServer_getServerInfo_Params{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Params_List) Set(i int, v TunnelServer_getServerInfo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Params_List) String() string {
	str, _ := text.MarshalList(0xdc3ed6801961e502, s.List)
	return str
}

// TunnelServer_getServerInfo_Params_Promise is a wrapper for a TunnelServer_getServerInfo_Params promised by a client call.
type TunnelServer_getServerInfo_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Params_Promise) Struct() (TunnelServer_getServerInfo_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Params{s}, err
}

type TunnelServer_getServerInfo_Results struct{ capnp.Struct }

// TunnelServer_getServerInfo_Results_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Results.
const TunnelServer_getServerInfo_Results_TypeID = 0xe3e37d096a5b564e

func NewTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func NewRootTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func ReadRootTunnelServer_getServerInfo_Results(msg *capnp.Message) (TunnelServer_getServerInfo_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Results{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) String() string {
	str, _ := text.Marshal(0xe3e37d096a5b564e, s.Struct)
	return str
}

func (s TunnelServer_getServerInfo_Results) Result() (ServerInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ServerInfo{Struct: p.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_getServerInfo_Results) SetResult(v ServerInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ServerInfo struct, preferring placement in s's segment.
func (s TunnelServer_getServerInfo_Results) NewResult() (ServerInfo, error) {
	ss, err := NewServerInfo(s.Struct.Segment())
	if err != nil {
		return ServerInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_getServerInfo_Results_List is a list of TunnelServer_getServerInfo_Results.
type TunnelServer_getServerInfo_Results_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Results creates a new list of TunnelServer_getServerInfo_Results.
func NewTunnelServer_getServerInfo_Results_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_getServerInfo_Results_List{l}, err
}

func (s TunnelServer_getServerInfo_Results_List) At(i int) TunnelServer_getServerInfo_Results {
	return TunnelServer_getServerInfo_Results{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Results_List) Set(i int, v TunnelServer_getServerInfo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Results_List) String() string {
	str, _ := text.MarshalList(0xe3e37d096a5b564e, s.List)
	return str
}

// TunnelServer_getServerInfo_Results_Promise is a wrapper for a TunnelServer_getServerInfo_Results promised by a client call.
type TunnelServer_getServerInfo_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Results_Promise) Struct() (TunnelServer_getServerInfo_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Results{s}, err
}

func (p TunnelServer_getServerInfo_Results_Promise) Result() ServerInfo_Promise {
	return ServerInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_unregisterTunnel_Params struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Params_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Params.
const TunnelServer_unregisterTunnel_Params_TypeID = 0x9b87b390babc2ccf

func NewTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Params(msg *capnp.Message) (TunnelServer_unregisterTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Params) String() string {
	str, _ := text.Marshal(0x9b87b390babc2ccf, s.Struct)
	return str
}

func (s TunnelServer_unregisterTunnel_Params) GracePeriodNanoSec() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s TunnelServer_unregisterTunnel_Params) SetGracePeriodNanoSec(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

// TunnelServer_unregisterTunnel_Params_List is a list of TunnelServer_unregisterTunnel_Params.
type TunnelServer_unregisterTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Params creates a new list of TunnelServer_unregisterTunnel_Params.
func NewTunnelServer_unregisterTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Params_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Params_List) At(i int) TunnelServer_unregisterTunnel_Params {
	return TunnelServer_unregisterTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Params_List) Set(i int, v TunnelServer_unregisterTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0x9b87b390babc2ccf, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Params_Promise is a wrapper for a TunnelServer_unregisterTunnel_Params promised by a client call.
type TunnelServer_unregisterTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Params_Promise) Struct() (TunnelServer_unregisterTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Params{s}, err
}

type TunnelServer_unregisterTunnel_Results struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Results_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Results.
const TunnelServer_unregisterTunnel_Results_TypeID = 0xa29a916d4ebdd894

func NewTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Results(msg *capnp.Message) (TunnelServer_unregisterTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Results) String() string {
	str, _ := text.Marshal(0xa29a916d4ebdd894, s.Struct)
	return str
}

// TunnelServer_unregisterTunnel_Results_List is a list of TunnelServer_unregisterTunnel_Results.
type TunnelServer_unregisterTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Results creates a new list of TunnelServer_unregisterTunnel_Results.
func NewTunnelServer_unregisterTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Results_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Results_List) At(i int) TunnelServer_unregisterTunnel_Results {
	return TunnelServer_unregisterTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Results_List) Set(i int, v TunnelServer_unregisterTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xa29a916d4ebdd894, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Results_Promise is a wrapper for a TunnelServer_unregisterTunnel_Results promised by a client call.
type TunnelServer_unregisterTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Results_Promise) Struct() (TunnelServer_unregisterTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Results{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Params struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID = 0xa766b24d4fe5da35

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params) String() string {
	str, _ := text.Marshal(0xa766b24d4fe5da35, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Params {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) String() string {
	str, _ := text.MarshalList(0xa766b24d4fe5da35, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Params promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Results struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID = 0xfeac5c8f4899ef7c

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results) String() string {
	str, _ := text.Marshal(0xfeac5c8f4899ef7c, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Results {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) String() string {
	str, _ := text.MarshalList(0xfeac5c8f4899ef7c, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Results promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s}, err
}

type TunnelServer_authenticate_Params struct{ capnp.Struct }

// TunnelServer_authenticate_Params_TypeID is the unique identifier for the type TunnelServer_authenticate_Params.
const TunnelServer_authenticate_Params_TypeID = 0x85c8cea1ab1894f3

func NewTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func NewRootTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func ReadRootTunnelServer_authenticate_Params(msg *capnp.Message) (TunnelServer_authenticate_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Params{root.Struct()}, err
}

func (s TunnelServer_authenticate_Params) String() string {
	str, _ := text.Marshal(0x85c8cea1ab1894f3, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_authenticate_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_authenticate_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_authenticate_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_authenticate_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_authenticate_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Params_List is a list of TunnelServer_authenticate_Params.
type TunnelServer_authenticate_Params_List struct{ capnp.List }

// NewTunnelServer_authenticate_Params creates a new list of TunnelServer_authenticate_Params.
func NewTunnelServer_authenticate_Params_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_authenticate_Params_List{l}, err
}

func (s TunnelServer_authenticate_Params_List) At(i int) TunnelServer_authenticate_Params {
	return TunnelServer_authenticate_Params{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Params_List) Set(i int, v TunnelServer_authenticate_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Params_List) String() string {
	str, _ := text.MarshalList(0x85c8cea1ab1894f3, s.List)
	return str
}

// TunnelServer_authenticate_Params_Promise is a wrapper for a TunnelServer_authenticate_Params promised by a client call.
type TunnelServer_authenticate_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Params_Promise) Struct() (TunnelServer_authenticate_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Params{s}, err
}

func (p TunnelServer_authenticate_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_authenticate_Results struct{ capnp.Struct }

// TunnelServer_authenticate_Results_TypeID is the unique identifier for the type TunnelServer_authenticate_Results.
const TunnelServer_authenticate_Results_TypeID = 0xfc5edf80e39c0796

func NewTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func NewRootTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func ReadRootTunnelServer_authenticate_Results(msg *capnp.Message) (TunnelServer_authenticate_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Results{root.Struct()}, err
}

func (s TunnelServer_authenticate_Results) String() string {
	str, _ := text.Marshal(0xfc5edf80e39c0796, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Results) Result() (AuthenticateResponse, error) {
	p, err := s.Struct.Ptr(0)
	return AuthenticateResponse{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Results) SetResult(v AuthenticateResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated AuthenticateResponse struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Results) NewResult() (AuthenticateResponse, error) {
	ss, err := NewAuthenticateResponse(s.Struct.Segment())
	if err != nil {
		return AuthenticateResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Results_List is a list of TunnelServer_authenticate_Results.
type TunnelServer_authenticate_Results_List struct{ capnp.List }

// NewTunnelServer_authenticate_Results creates a new list of TunnelServer_authenticate_Results.
func NewTunnelServer_authenticate_Results_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_authenticate_Results_List{l}, err
}

func (s TunnelServer_authenticate_Results_List) At(i int) TunnelServer_authenticate_Results {
	return TunnelServer_authenticate_Results{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Results_List) Set(i int, v TunnelServer_authenticate_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Results_List) String() string {
	str, _ := text.MarshalList(0xfc5edf80e39c0796, s.List)
	return str
}

// TunnelServer_authenticate_Results_Promise is a wrapper for a TunnelServer_authenticate_Results promised by a client call.
type TunnelServer_authenticate_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Results_Promise) Struct() (TunnelServer_authenticate_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Results{s}, err
}

func (p TunnelServer_authenticate_Results_Promise) Result() AuthenticateResponse_Promise {
	return AuthenticateResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_reconnectTunnel_Params struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Params_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Params.
const TunnelServer_reconnectTunnel_Params_TypeID = 0xa353a3556df74984

func NewTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Params(msg *capnp.Message) (TunnelServer_reconnectTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) String() string {
	str, _ := text.Marshal(0xa353a3556df74984, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Params) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasJwt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetJwt(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_reconnectTunnel_Params) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasEventDigest() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetEventDigest(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s TunnelServer_reconnectTunnel_Params) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasConnDigest() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetConnDigest(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s TunnelServer_reconnectTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelServer_reconnectTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelServer_reconnectTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelServer_reconnectTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(4)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(4, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(4, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Params_List is a list of TunnelServer_reconnectTunnel_Params.
type TunnelServer_reconnectTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Params creates a new list of TunnelServer_reconnectTunnel_Params.
func NewTunnelServer_reconnectTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5}, sz)
	return TunnelServer_reconnectTunnel_Params_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Params_List) At(i int) TunnelServer_reconnectTunnel_Params {
	return TunnelServer_reconnectTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Params_List) Set(i int, v TunnelServer_reconnectTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xa353a3556df74984, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Params_Promise is a wrapper for a TunnelServer_reconnectTunnel_Params promised by a client call.
type TunnelServer_reconnectTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Params_Promise) Struct() (TunnelServer_reconnectTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Params{s}, err
}

func (p TunnelServer_reconnectTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(4)}
}

type TunnelServer_reconnectTunnel_Results struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Results_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Results.
const TunnelServer_reconnectTunnel_Results_TypeID = 0xd4d18de97bb12de3

func NewTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Results(msg *capnp.Message) (TunnelServer_reconnectTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) String() string {
	str, _ := text.Marshal(0xd4d18de97bb12de3, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Results_List is a list of TunnelServer_reconnectTunnel_Results.
type TunnelServer_reconnectTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Results creates a new list of TunnelServer_reconnectTunnel_Results.
func NewTunnelServer_reconnectTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_reconnectTunnel_Results_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Results_List) At(i int) TunnelServer_reconnectTunnel_Results {
	return TunnelServer_reconnectTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Results_List) Set(i int, v TunnelServer_reconnectTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xd4d18de97bb12de3, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Results_Promise is a wrapper for a TunnelServer_reconnectTunnel_Results promised by a client call.
type TunnelServer_reconnectTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Results_Promise) Struct() (TunnelServer_reconnectTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Results{s}, err
}

func (p TunnelServer_reconnectTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

const schema_db8274f9144abc7e = "x\xda\xccY{l\x1c\xd5\xd5?g\xee\xaeg\xed\xd8" +
	"\xac\x87\xd9\xc4\x89\x05\x9f\xbf/\x0a\xe2\xc3`\xc0q\xa9" +
	"\xd2\x94\xd6v\xb0Sl\xf2\xf0x\x93\x96G\x82\x18\xef" +
	"\xde\xd8\xe3\xee\xce,3\xb3\xc6N\x13\x92\x98\xa4\x10\xc4" +
	"+!\xe1\x91\x926\x04\xd1\xaa\x14ZR@m*\xaa" +
	"B_\x80x\xa3P%\x10\xd4\x96\x90>\xa2PJ\xa0" +
	"BT\x94\xa9\xce\xcc\xce\xc3kc;\xd0?\xfa\xdf\xea" +
	"\xcc\xb9\xf7\x9es~\xe7\x9e\xf3\xbbg\xcf\xff\x9a\xd8&" +
	"4\xc7\xc5\x19\x00\xca\xc6x\x85\xc3\x1b_Y\xbb\xe7\x8c" +
	"_\x8d\x82R\x8f\xe8\\\xfbxw\xeaC{\xf4u\x88" +
	"3\x11\xa0E\x8b\xafEy}\\\x04\x90G\xe2\x7f\x06" +
	"t.\x91\xce\xbb\"\xf5\xd2\x0b\xd7\x81T\x1fU\x8e\x91" +
	"\xf2\xea\x8aF\x94\xf3\x15\xa4\xacU\x90\xf2\x85\xf9\x17\xf7" +
	"~~\xe7\xb3\x9bA\xaa\x17Be\xc0\x96\x95\xe2Z\x94" +
	"5\x914\xb9\xb8\x1c\xd0yo\xc7\xec\x1f\xdc\xfb\xc2\xd3" +
	"[@:\x13\xa1t\xf6z\xf15\x04\x94\xb7\x89?\x02" +
	"tZ\x17?\xbf\xbf\xbe\xe5\x8e\x1de\xe7\x0a\xa4\xd8\x9c" +
	"hD\xb9=A\xbb})q\x0d\xa03w\xe8\x8c\xab" +
	"~\xf9\x9bG\xee\x04\xa5\x09\xd19\xdcw\xf6\xabl\xf7" +
	"\x03\xaf\xc3J\x14Q\x00h\xb97\xb1\x976\xde\xe7\xea" +
	"\xbex\xce\xe3?\xbb\xed\x91\xeb\xbf\x05\xca\x99\x88\x00\xae" +
	"#3+\xffI\x0agU\xb6\x02:;\x0e\xfe|Y" +
	"~\xdb\xae\xbd\x9ei\xeew\xa5R\x10 \xe6l\xee\xfa" +
	" \xbf\xf2\xbe\xf4}%\xa3)J-\x9d\x95'\x10\xb0" +
	"\xe5\xb2\xca\x06\x04t.x\xed\xe8\xf2\xa5?^\xf3\xbd" +
	"\xc8\xdab\xd5ZZ\xfb\xd0\xff\\R9|t\xf1\xc3" +
	" 5\xf9_\xae\xae\xea\xa5/\xb1\xd5\xecc\xf5\xae_" +
	"<Z\x8e\x87\xebj\xbe\xaa\x0f\xe5MUnx\xaa\xdc" +
	"#n|r\xd7\xd9\x89\xef\xbc\xf7\xd8D\x81\xb9\x7fF" +
	"\x1f\xca\xfbgP`\x1e\x9bA\xce\xce\xec\xc2\xc3O4" +
	"\xc7~\x12\x0d\xf3\xcc\xeac\xae\xb3\xd5\x14\xe6\xd3\xdf^" +
	"T\xa3\xbf3\xfaD\xd9n\xae\xe23\xd5\xdd(\xbfQ" +
	"M\xbb\x1dr\x95\xbb\xaf\xb8}{\xfc\xe8\xedO\x91\xa5" +
	"\x11|\xe3\x09\xd7\xcf\x1a\x13\xe5\xad5\xf4sKM\x1d" +
	"\x03t\xea\x1f\xfe\xe2\x0f\x17e\x0f=;\x81\xa5r\\" +
	":!K\x12\xfd\xaa\x91\xc8\xd0#M\xfb\xbe\xf1\xd7\x9b" +
	"_>P2\x14\xdd\\\x94\\T\xd6K\x84J\x00j" +
	"Y\x94\\\xcd\xdd\xd2 \xca\xfb\xdc\xed\x1er\xb5\x85\xa3" +
	"\xea\x9c\x8d\xbf\xfb\xf2\xe1\x08\x0e\xfb\xa47\x11b\xce\xb2" +
	"\xaf^1X\xb9\xfe\xc8\x91\xe8A\xf7KnD\xf6\xbb" +
	"K\xff\xf6\xddc\xb7\x1e\xcfg\xff\xe4\xe6\x92\x1f\xb3C" +
	"\xd2B\x01P~W\xa2,\xafk\xa8\xe9\x9c{\xb0\xe7" +
	"\x98\x07\xa5\xb7\xc5\xf3\xa7.\"\x85\xa3\xa7\xd2\x16\x17\\" +
	"\xd5\xceW-\xb8\xf4\x18H\xf5l\xcc5\x88\xcb\x0bQ" +
	"\x9e)\xd3\x02I\xbe\x1e\xe5\xb3Ru\x00\xce-\xd7v" +
	",\xff\xc2\xdc'ODM\x9a\x93\xa2\xb4\x92\x9bR\xb4" +
	"\xdf\x9a\x05\xc7\xbfr\xc6-\xbf=Q\x16HWqi" +
	"\xaa\x11\xe5\xd5)r\xfd2R~g\xf1\xb7\x0f\xd4'" +
	"\xeb\xdf/\x0bS\x85\x9bA\xa9A\x94\xb7\x91n\xcb\xcd" +
	"\xa9\xa7(\x99\xbe\xf9\xfa\x95\xc3\xaf\\\xf7\xde?\xca\x11" +
	"u\xb7\xde4\xab\x17\xe5\x9d\xb3h\xebm\xb3\x08\xff;" +
	"W\xfce\xc3\xf1\x9d\xb3>\x18\xe7Ws\xdd \xca\x9d" +
	"u\xa4\xd9^w\xbd|/\xfdr^\x12\xefk\xee\xd8" +
	"\xf0\xec\x87\x91\x8c\xdfZ\xd7M\x19\x7f\x87x\xcf\x91\x8d" +
	"\xbf\xbf\xf2\xa3\xa8\xc3[\xea\xde$\x87\xef\xae#\x87\xd7" +
	"\xbds\xf7\xc5\xb7\xaez\xf0\xe3\x08|\xfb\xebFi\xa9" +
	"]\xd4u\x9e3\x0b\xb1\xccy\xfe\xcf\xcc\xb9\x19\xb5\xa0" +
	"\x17\x16\xb6\x17\xed\x01\xae\xdbZF\xb5y/o\xb5\x0a" +
	"\x86n\xf1\x1eD\xa5\x96\xc5\x00b\x08 \xa9\x83\x00\xca" +
	"U\x0c\x95\x9c\x80\x12b\x8a\x00\x964\x12\x0e0Tl" +
	"\x01%AHQ\xc9\x90\xae\x9e\x0b\xa0\xe4\x18*\xc3\x02" +
	"\"K!\x03\x90\x8a\xdb\x01\x94a\x86\xcaf\x01\x9d\x02" +
	"7\xf3\xaa\xceuH\xda\x9d\xa6\x89\xd5 `5\xa0c" +
	"r\xdb\x1cQ\xfbr\x90\xe4\x11\xb18x\x8d\x8d5 " +
	"`\x0d\xa03`\x14Mk\xa5n\xa3\x96\xeb\xe5kL" +
	"n\xe1\x00V\x80\x80\x15\x80\x81{l\xbc{\x17\xe54" +
	"\xae\xdb\xc9.}\x8dQ\xe6T\xf7DNu\x97\x9c\xda" +
	"\x1cqj\xd3\"\x00e\x1dC\xe5\x06\x01%V\xf2j" +
	"K#\xf5\x05\x86\xcaM\x02:\x19\xf7\x90\xae,\x00\x04" +
	"\xf6\xae\xe1\xaa]4\xb9E\xb2S\x00{\x18\xban\x9d" +
	"\x02\xb8a\x88\x9b\x96f\xe8\xbe\x9bI\xd5\xcc\x0c\x04\xa1" +
	"\x98\x04\xaa\xcea\xcd\xb25\xbd\x7f\x85+o\xed1r" +
	"Zf\x84\xbc\xaav\xed<}!\x00\xa24\xf3r\x00" +
	"\x14$i\x11@\xab\xd6\xaf\x1b&w\xb2\x9a\x951t" +
	"\x9d\x03\xcb\xd8\x1b\xfa\xd4\x9c\xaagxpP\xc5\xf8\x83" +
	"\xbc\x03\xd2\xdc\x1c\xe2\xe6\xb9j$A\xe6\xf5\xa8\xa6\xca" +
	"\xf2\x96R\x1d\xc4\xb1\xf3r\x00\xa5\x83\xa1\xd2\x13\x89\xe3" +
	"R\x8a\xe3\x12\x86\xca\xa5\x918\xae\xa48\xf60TV" +
	"\x09\xe8\x18\xa6\xd6\xaf\xe9\x17q`f\x14c\xcb\xd6\xd5" +
	"<\xa7\x98\x95\xe2\xb1\xc1(\xd8\x9a\xa1[X\x1b\xd6Q" +
	"@\xac\x9d\x1cu\xcf\x81$\xe56\xc5'\x11X{\x16" +
	"Y\xfb\xff\x0c\x95\xcfE\xacm\xa6T>\x9f\xa1r\xa1" +
	"\x80\x8e\x9a\xc9\x18E\xdd^\x01L\xed/\x03%\xcd!" +
	"\x991yh\xaf\x7fl|\x82\xbc\xa3xg\xc8\xf4^" +
	"\xee\xdd\xa9sMn\x89\xc5\x9cM\xd6T;\x8eg\xce" +
	"|\x00e\x1eC\xe5|\x01k\xf0c\xc7\xb3\xa7i{" +
	"hO\x037M\xc3\xc4\xda\xb0\xe6\x94\xbc\xcf\x94\x0e@" +
	"C\xef\xe0\xb6\xaa\xe5\x90b\x14\xb4\xb9\xb2\x18M\x05r" +
	"Q7y\xbff\xd9\xdc\xf4\xc4\xf3Z\x09\xe9\xbc\xa5\xc4" +
	"\x82\xd0\xd5\xec\x02Pj\x19*\xa7\x09\xe8\xf4\x9bj\x86" +
	"\xf7p\x135#\xbbL\xd5\x8d4\xe3\x19\x8c\x83\x80\xf1" +
	"\xc8\xa1\xa7\x9c\xec\xa1\xbd\xdc*\xe6l\x0b\x82U\x93\xaf" +
	"7y)\x08\xa5\xe5=\x0d\x9e\xcd\xa9\xc0\xe6\xf5s\xc3" +
	"\xda\x13\xc0\xbd\xa9/\xbc\xbaArn\xa5\xc4\xb8\x81\xa1" +
	"\xb2#r\xc9\xb7Q\x1a\xdf\xc6P\xb9G@)\x16K" +
	"a\x0c@\xba\x9b\xd2x\x07Ce\x8f0\xb6B\xf1!" +
	"\xae\xdb\x1dZ?\x88\xdc\x0a\xa5db\x87\xd6\xcf\x81Y" +
	"\x9f5\xd1\x13S\xc4\xc3\xe8\xb3\x8c\x1c\xb7y\x07\xcf\xe4" +
	"TS\xb5\xb5!\xee}/%\xa3\x0f\xead\x1b\xf6\xba" +
	"\x88\xd0bC\x1f\x07S\x98\xd4%\xa8\xd0\x9a\xac^\x85" +
	"\xea\xcb\x0b\xb6&\x1a\xbaE\x971\x82\xce\xc2\x89\xd01" +
	"Ct\xd0\x07g4\x0a\x0e\x96\xc0\xd9\x15\xe2 \xc5\x04" +
	"\x0f\x9c\xdd{\x01\x94=\x0c\x95\x07\x05l\xf5\xca2\xd6" +
	"\x86l\xbc\x14P\xaf\xf8,1\xa0!\xa3\xe6\xba\x0a\x01" +
	",&/\xe4\xd4\x0c\xef\xc4R\xa1\x05D\x10\x10]\x14" +
	"\xf3\x05\x93[\x16j\x86\xae\x14\xd5\x9c\xc6\xec\x91\xa0\xfd" +
	"\xe8\xc5|\x8f\xc9\x8744\x8aV\xbbm\xf3\xbcX\xb0" +
	"\xadq\xcdi\xd2\x00\xd1\x15\x16\xb5\x9cUV\xad\x1a\xc3" +
	"\xf2\x10\x04\xa8\x89\xaa\xd59\x0c\x95\x05\x02&\x8bE-" +
	"\x1b\x98\x9f32.n\x90\\\xa6\xe6\xf9\xb8\x8eR1" +
	"\xe5u\x1as\x19{\xd4\xa4{\x9b\xfe\x9bJ\xfd\xe4\xfc" +
	"\x85\\\x07\xb7\x1f\x86&S\x01hc\xa8,\x89\x98\xdc" +
	"5?\xe2\x87o\xf2\xd2\xbe\xd0\x0f\xf1\xeb|\xc4\xb7\xaa" +
	"\x81\xe7\xa9\xb8\xfa\xc1,9\xd3\x0e\xe2%\xa1\xced\xf6" +
	"E/\xd4\xf2B\x83\xeb!\xd9\xb8\xc0\xb7Q\x1e\xc1n" +
	"\x80\xf402Lo\xc6\xd0Ly\x13.\x02H\xaf#" +
	"\xf9\x0d\x18Z*o\xc1z\x80\xf4F\x92\xdf\x84\x01\xcf" +
	"\x92\xb7\xe2\x03\x00\xe9\x9bH|\x17\xa9\xc7\x98{%\xe4" +
	"\x9d\xee\xf6;H\xbe\x87\xe4\xf1X\x0a\xe3\x00\xf2nl" +
	"\x04H\xdfE\xf2GI^!\xa4\xb0\x02@\xde\x87\x83" +
	"\x00\xe9\x87I\xfe8\xc9\xc5x\x8a\xa8\xa6\xbc\x1fM\x80" +
	"\xf4OI\xfek\x92'f\xa70\x01 ?\xe9\xca\x9f" +
	" \xf9s$\xaf\x9c\x93\xc2J\x00\xf9\x19\x1c\x05H?" +
	"M\xf2\x03$\xaf\xc2\x14V\x01\xc8/\xe3.\x80\xf4\x01" +
	"\x92\xff\x81\xe43*R8\x03@~\xc3\xb5\xe7 \xc9" +
	"\xdf\"yu,\x85\xd5\x00\xf2\x1fq/@\xfa-\x92" +
	"\xff\x9d\xe45b\x0ak\x00\xe4\xb7]\xbf\x8e\x93<!" +
	"\x94\x910?\xa3\xca\x98\x163\xac\x002^\xba\xe3\xe8" +
	"\xa5{\x8f\x91$6\x85\xc9\xf05\x0e\x88I@\xa7`" +
	"\x18\xb9ec35i\xab\xfd\x96\xcf\xeaj\xc3\x17\x1b" +
	" \x09\x83\xd6\x0cIC\xef\xca\x06\x85\xa0\xbc\xea\xf8\x96" +
	"hV{\xd16\x8a\x05h\xc8\xaa6\xcf\x065\xc7," +
	"\xea\x8bM#\xbf\x02\xb9\x99\xd7t57E5\xaa\x04" +
	"\x01+\xa1T\x12\xfc\xbd'/M\x9f\xccQ\x83\x8c\x16" +
	"\xca3\xba\xa1\xb0p\x85\xda?\x9d:5?\xa4ZI" +
	"=R\x90\x1a\x86\xd4\\\xf1\xd3\x94\xa7\xb1\xdd\xbe\xb7\xd5" +
	"c\x0bQ\x8aB\x0d%\xc1PI\x09\xd8jz\x1d\xaa" +
	"\xd6\x7f\xdaM]J\xc6r\xb6\xa4\xff\x10r\xf7\xc7\xc8" +
	"\xb8\x84\xce\x11J\xfbO\xdb\xfc~n{\xbf\xe8)B" +
	"<Z\x8cv\xe2\x93[\xdd\xcb\xad\xe4t\\\x0f\x9f\xc0" +
	"e\xce\x8b\xd3j\xfc\x13\xb4}\x9f\x16F\xdeQ\x84\xfd" +
	"*\x86\xca@\x04{NM!\xcbP)\x84M<\xdf" +
	"\x1b\xbe\x0d%&\x94\x1e\x87\xd4(\x0a\x0c\x95u\x02&" +
	"\xe9\xa5\x81\xb5\xe1\x0ck\x8c\xd1c_W\x94\x0a]z" +
	"\x96\x03\x0e\xfb\xd9\x1ci\x1f\xc1lhj\x025=\xb7" +
	"}b:e\xc0\x83y\xcbt\xdf(\xad\xde\xa1\x94g" +
	"\xb3Y\x1c \x98=\xa1?\xdf\x90\xf6\xad\x05A\xfa\xbe" +
	"\x88\xe1|\x06\xfdq\x8c\xb4\xdb\x04A\xda)\xa2\x10\x0c" +
	"\xe8\xd0\x1f\xc4I[o\x04A\xda\"\"\x0b\xe6k\xe8" +
	"O\x08\x9aG\xaa\x10\x04i\xbd\x88\xb1`\xa6\x88\xfe|" +
	"A\xbaz\x10\x04I\x131\x1e\x8c\xee\xd0\x1f4I\xab" +
	"GA\x90V\x8a\x8e\x1f$h\xf5\xfchC\xc7\xcfQ" +
	"hp\xb3\xb4\x0d\x1d\x9f9\xa2O*\x00\xda\xd0\xf1i" +
	"*\xfb$\x9e\xeaj\xf9\xcfNH\xd2\xc3\xb3\x8d\xc8\x99" +
	"w\xff\xb1T\x00\xa0\x0d\x95\x18F\xc6+\x00\x9f\x96\xea" +
	"\xf4\xf2\x86\xcfRJ&\x00\xd7;'\x18;D\xf6%" +
	"\xf6V\xcdP\x99-LI\xd8b\x9f\xe4\x85\x9f\xb4I" +
	"ZL\xfb\xffo\xb0\xff\xcbDx\x9ec\xa8\x1c\x8c\\" +
	"\xc7WI\xf8\x12C\xe5p\x84\xf0\x1c\xa2;z\x90\xa1" +
	"\xf2~8\xaby\xf7F\x00\xe5}\x86\xbd\x11\x02!\xfd" +
	"\x8b\x14?\xa26\xeb\xd2\x07\xf4\xe8C\x1c\xb7\x03\xa4\x13" +
	"\xd4~S.}\x88y\xf4A\xc2>\x80t-\xc9O" +
	"\x8b\xd2\x879x9@z6\xc9\xe7\xa1\x80\"\x8f\xcc" +
	"y\x8afH\xb0rF\xff\x12M\x9f\xb0'\xf9\xc3#" +
	"\xb4\x17\xabZ\xaehr\x08[b\xa9HtD\xba\xb4" +
	"7Uj_C\xe9\x97\xa6\xe4\xc9\xa2\x85\"\x08(\x9e" +
	"\xdccmZ\x1d\xa3\xd34\x0d4\xcb\xc8\xe7\xfc\x90|" +
	"\x06\xdc\x938\xf4\xc5\x0c\x95\x15\x04E\x9b\x07\x85\xd2\x17" +
	"\xd2\xe5\x86\x8cZ\xb4\xf88\x1f\x80q3x`[\x03" +
	"F1\x97\xed\xe5 \xda\xe6HY\x08\xa6$\xa1i\x9e" +
	"\xf4+N\xc2\xad8\xfe\xe8\x16\xfd\x09\xad\xd4\xbc\x0b\x04" +
	"\xa9\x89*\x8e?\x8dD\x7f\x10/\xfd\xdf\x03 H\xa7" +
	"\x87\x05\x00\xfd\x180C\x1f{\xe5\xbd\x0fn\x8e\xb6a" +
	"\x0f\xe2\x7f\xe2\xd9\xe9\xb5\x9f\x93\xb8\xe9c\xa6WT\xc6" +
	"\xc5\xe9\xf4\xcd\xe0\xcf\x9e\xb2\x9b^\xf9Y_\xe0~#" +
	"\xf9w\x00\x00\x00\xff\xffH\xa22\xa3"

func init() {
	schemas.Register(schema_db8274f9144abc7e,
		0x82c325a07ad22a65,
		0x83ced0145b2f114b,
		0x84cb9536a2cf6d3c,
		0x85c8cea1ab1894f3,
		0x9496331ab9cd463f,
		0x97b3c5c260257622,
		0x9b87b390babc2ccf,
		0xa29a916d4ebdd894,
		0xa353a3556df74984,
		0xa766b24d4fe5da35,
		0xb046e578094b1ead,
		0xb4bf9861fe035d04,
		0xb5f39f082b9ac18a,
		0xb70431c0dc014915,
		0xc082ef6e0d42ed1d,
		0xc793e50592935b4a,
		0xcbd96442ae3bb01a,
		0xd4d18de97bb12de3,
		0xdbaa9d03d52b62dc,
		0xdc3ed6801961e502,
		0xe3e37d096a5b564e,
		0xe6646dec8feaa6ee,
		0xea50d822450d1f17,
		0xea58385c65416035,
		0xf2c122394f447e8e,
		0xf2c68e2547ec3866,
		0xf41a0f001ad49e46,
		0xf5f383d2785edb86,
		0xf71695ec7fe85497,
		0xf9cb7f4431a307d0,
		0xfc5edf80e39c0796,
		0xfeac5c8f4899ef7c)
}
