// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeDecimal65_1(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0")`,
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1")`,
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1")`,
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1")`,
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1")`,
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1")`,
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1")`,
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-1"), (1,"0"), (2,"1")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{float64(0), float64(1), float64(2.200000047683716)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{float64(0), float64(1), float64(2.2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{"00:00:00", "00:00:01", "00:00:02.200000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{float64(-2.200000047683716), float64(-1), float64(0), float64(1), float64(2.200000047683716)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{float64(-2.2), float64(-1), float64(0), float64(1), float64(2.2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.200000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-2.2", "-1.0", "0.0", "1.0", "2.2"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{"-00:00:02.200000", "-00:00:01", "00:00:00", "00:00:01", "00:00:02.200000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-2.2"), (1,"-1"), (2,"0"), (3,"1"), (4,"2.2")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{float64(0), float64(1), float64(2.200000047683716), float64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{float64(0), float64(1), float64(2.2), float64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{"00:00:00", "00:00:01", "00:00:02.200000", "00:12:34"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{float64(-1234), float64(-2.200000047683716), float64(-1), float64(0), float64(1), float64(2.200000047683716), float64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{float64(-1234), float64(-2.2), float64(-1), float64(0), float64(1), float64(2.2), float64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234", "-2", "-1", "0", "1", "2", "1234"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000", "-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000", "-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.000000000000000000000000000000", "-2.200000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{uint64(18446744073709550382), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(1234)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{"-00:12:34", "-00:00:02.200000", "-00:00:01", "00:00:00", "00:00:01", "00:00:02.200000", "00:12:34"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-1234"), (1,"-2.2"), (2,"-1"), (3,"0"), (4,"1"), (5,"2.2"), (6,"1234")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{int64(0), int64(1), int64(2), int64(1234), int64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{float64(0), float64(1), float64(2.200000047683716), float64(1234), float64(1.2345679020032e+13)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000", "12345678901234.500000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(1234), uint64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{int64(-12345678901235), int64(-1234), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(1234), int64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{float64(-1.2345679020032e+13), float64(-1234), float64(-2.200000047683716), float64(-1), float64(0), float64(1), float64(2.200000047683716), float64(1234), float64(1.2345679020032e+13)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{float64(-12345678901234.5), float64(-1234), float64(-2.2), float64(-1), float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.500000000000000", "-1234.000000000000000", "-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.500000000000000", "-1234.000000000000000", "-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.500000000000000000000000000000", "-1234.000000000000000000000000000000", "-2.200000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000", "12345678901234.500000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{uint64(18446731728030650381), uint64(18446744073709550382), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(1234), uint64(12345678901235)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{"-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-12345678901234.5"), (1,"-1234"), (2,"-2.2"), (3,"-1"), (4,"0"), (5,"1"), (6,"2.2"), (7,"1234"), (8,"12345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{float64(0), float64(1), float64(2.200000047683716), float64(1234), float64(1.2345679020032e+13), float64(1.2345678918272927e+29)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5), float64(1.2345678901234568e29)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000", "123456789012345678901234567890.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000", "12345678901234.500000000000000000000000000000", "123456789012345678901234567890.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{float64(-1.2345678918272927e+29), float64(-1.2345679020032e+13), float64(-1234), float64(-2.200000047683716), float64(-1), float64(0), float64(1), float64(2.200000047683716), float64(1234), float64(1.2345679020032e+13), float64(1.2345678918272927e+29)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{float64(-1.2345678901234568e29), float64(-12345678901234.5), float64(-1234), float64(-2.2), float64(-1), float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5), float64(1.2345678901234568e29)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890", "-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890", "-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.000000000000000", "-12345678901234.500000000000000", "-1234.000000000000000", "-2.200000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.200000000000000", "1234.000000000000000", "12345678901234.500000000000000", "123456789012345678901234567890.000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.000000000000000000000000000000", "-12345678901234.500000000000000000000000000000", "-1234.000000000000000000000000000000", "-2.200000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.200000000000000000000000000000", "1234.000000000000000000000000000000", "12345678901234.500000000000000000000000000000", "123456789012345678901234567890.000000000000000000000000000000"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{"-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-123456789012345678901234567890"), (1,"-12345678901234.5"), (2,"-1234"), (3,"-2.2"), (4,"-1"), (5,"0"), (6,"1"), (7,"2.2"), (8,"1234"), (9,"12345678901234.5"), (10,"123456789012345678901234567890")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5), float64(1.2345678901234568e29), float64(1.2345678901234568e63)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890", "1234567890123456789012345678901234567890123456789012345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"0"), (1,"1"), (2,"2.2"), (3,"1234"), (4,"12345678901234.5"), (5,"123456789012345678901234567890"), (6,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYINT UNSIGNED",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SMALLINT UNSIGNED",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMINT UNSIGNED",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"INT UNSIGNED",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIGINT UNSIGNED",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"FLOAT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DOUBLE",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{float64(-1.2345678901234568e63), float64(-1.2345678901234568e29), float64(-12345678901234.5), float64(-1234), float64(-2.2), float64(-1), float64(0), float64(1), float64(2.2), float64(1234), float64(12345678901234.5), float64(1.2345678901234568e29), float64(1.2345678901234568e63)},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,0)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,0)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,0)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,0)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901235", "-123456789012345678901234567890", "-12345678901235", "-1234", "-2", "-1", "0", "1", "2", "1234", "12345678901235", "123456789012345678901234567890", "1234567890123456789012345678901234567890123456789012345678901235"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(1,1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(15,15)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,15)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,15)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(30,30)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DECIMAL(65,30)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(8)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(16)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(24)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(32)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(48)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BIT(64)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TINYBLOB",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BLOB",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMBLOB",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGBLOB",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TINYTEXT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"TEXT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"MEDIUMTEXT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"LONGTEXT",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(10)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(100)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"CHAR(255)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(10)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(100)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"BINARY(255)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2.2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "12345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "123456789012345678901234567890.0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1234567890123456789012345678901234567890123456789012345678901234.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(10)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(100)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(255)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(1023)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARCHAR(4095)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(10)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(100)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(255)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(1023)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(4095)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"VARBINARY(16383)",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{"-1234567890123456789012345678901234567890123456789012345678901234.5", "-123456789012345678901234567890.0", "-12345678901234.5", "-1234.0", "-2.2", "-1.0", "0.0", "1.0", "2.2", "1234.0", "12345678901234.5", "123456789012345678901234567890.0", "1234567890123456789012345678901234567890123456789012345678901234.5"},
			false,
		},
		{
			"DECIMAL(65,1)",
			"YEAR",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATE",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIME",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"TIMESTAMP",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"DATETIME",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('B','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('A','B','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"ENUM('C','A','B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('B','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('A','B','C')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
		{
			"DECIMAL(65,1)",
			"SET('C','A','B')",
			`(0,"-1234567890123456789012345678901234567890123456789012345678901234.5"), (1,"-123456789012345678901234567890"), (2,"-12345678901234.5"), (3,"-1234"), (4,"-2.2"), (5,"-1"), (6,"0"), (7,"1"), (8,"2.2"), (9,"1234"), (10,"12345678901234.5"), (11,"123456789012345678901234567890"), (12,"1234567890123456789012345678901234567890123456789012345678901234.5")`,
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
