#!/usr/bin/env bats
load $BATS_TEST_DIRNAME/helper/common.bash

setup() {
    setup_common
    dolt sql <<SQL
CREATE TABLE test1 (
  pk BIGINT NOT NULL,
  c1 BIGINT,
  c2 BIGINT,
  c3 BIGINT,
  c4 BIGINT,
  c5 BIGINT,
  PRIMARY KEY (pk)
);
SQL
    dolt sql <<SQL
CREATE TABLE test2 (
  pk BIGINT NOT NULL,
  c1 BIGINT,
  c2 BIGINT,
  c3 BIGINT,
  c4 BIGINT,
  c5 BIGINT,
  PRIMARY KEY (pk)
);
SQL
}

teardown() {
    assert_feature_version
    teardown_common
}

@test "multiple-tables: examine a multi table repo" {
      run dolt ls
      [ "$status" -eq 0 ]
      [[ "$output" =~ "test1" ]] || false
      [[ "$output" =~ "test2" ]] || false
      [ "${#lines[@]}" -eq 3 ]
      run dolt schema show
      [ "$status" -eq 0 ]
      [[ "$output" =~ "test1 @ working" ]] || false
      [[ "$output" =~ "test2 @ working" ]] || false
      run dolt status
      [ "$status" -eq 0 ]
      [[ "$output" =~ "test1" ]] || false
      [[ "$output" =~ "test2" ]] || false
}

@test "multiple-tables: modify both tables, commit only one" {
    dolt sql -q "insert into test1 values (0, 1, 2, 3, 4, 5)"
    dolt sql -q "insert into test2 values (0, 1, 2, 3, 4, 5)"
    dolt add test1
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ "$output" =~ "Untracked files" ]] || false
    run dolt commit -m "added one table"
    run dolt status
    [[ ! "$output" =~ "Changes to be committed" ]] || false
    [[ "$output" =~ "Untracked files" ]] || false
    run dolt diff
    [[ "$output" =~ "test2" ]] || false
    run dolt checkout test2
    [ "$output" = "" ]
    run dolt status
    [[ "$output" =~ "nothing to commit" ]] || false
    run dolt ls
    [[ "$output" =~ "test1" ]] || false
    [[ ! "$output" =~ "test2" ]] || false
    [ "${#lines[@]}" -eq 2 ]
}

@test "multiple-tables: dolt add --all, dolt add -A, and dolt add . adds all changes" {
    dolt sql -q "insert into test1 values (0, 1, 2, 3, 4, 5)"
    dolt sql -q "insert into test2 values (0, 1, 2, 3, 4, 5)"
    dolt add --all
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
    run dolt reset test1 test2
    [ "$status" -eq 0 ]
    [ "$output" = "" ]
    run dolt status
    [[ ! "$output" =~ "Changes to be committed" ]] || false
    [[ "$output" =~ "Untracked files" ]] || false
    run dolt add -A
    [ "$status" -eq 0 ]
    [ "$output" = "" ]
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
    dolt reset test1 test2
    run dolt add .
    [ "$status" -eq 0 ]
    [ "$output" = "" ]
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
}

@test "multiple-tables: dolt commit with -a flag adds all changes" {
    dolt sql -q "insert into test1 values (0, 1, 2, 3, 4, 5)"
    dolt sql -q "insert into test2 values (0, 1, 2, 3, 4, 5)"
    run dolt commit -a -m "Commit1"
    [[ "$output" =~ "Commit1" ]] || false

    run dolt status
    [ "$status" -eq 0 ]
    [[ "$output" =~ "nothing to commit, working tree clean" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
}

@test "multiple-tables: dolt reset . resets all tables" {
    dolt add --all
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
    run dolt reset .
    [ "$status" -eq 0 ]
    [ "$output" = "" ]
    run dolt status
    [[ ! "$output" =~ "Changes to be committed" ]] || false
    [[ "$output" =~ "Untracked files" ]] || false
}

@test "multiple-tables: dolt reset --hard" {
    dolt add --all
    run dolt status
    [[ "$output" =~ "Changes to be committed" ]] || false
    [[ ! "$output" =~ "Untracked files" ]] || false
    run dolt reset .
    [ "$status" -eq 0 ]
    [ "$output" = "" ]
    run dolt status
    [[ ! "$output" =~ "Changes to be committed" ]] || false
    [[ "$output" =~ "Untracked files" ]] || false

    dolt add --all
    dolt commit -m "commit file1 and file2"

    dolt sql -q "insert into test1 values (0, 1, 2, 3, 4, 5)"
    dolt sql -q "insert into test2 values (0, 1, 2, 3, 4, 5)"

    dolt sql <<SQL
CREATE TABLE test3 (
  pk BIGINT NOT NULL,
  c1 BIGINT,
  c2 BIGINT,
  c3 BIGINT,
  c4 BIGINT,
  c5 BIGINT,
  PRIMARY KEY (pk)
);
SQL
    dolt sql <<SQL
CREATE TABLE test4 (
  pk BIGINT NOT NULL,
  c1 BIGINT,
  c2 BIGINT,
  c3 BIGINT,
  c4 BIGINT,
  c5 BIGINT,
  PRIMARY KEY (pk)
);
SQL

    run dolt status
    [[ "$output" =~ modified.*test1 ]] || false
    [[ "$output" =~ modified.*test2 ]] || false
    [[ "$output" =~ file.*test3 ]] || false
    [[ "$output" =~ file.*test4 ]] || false

    dolt add test1 test2 test3
    dolt reset --hard

    run dolt status
    [[ ! "$output" =~ "test1" ]] || false
    [[ ! "$output" =~ "test2" ]] || false
    [[ ! "$output" =~ file.*test3 ]] || false
    [[ "$output" =~ file.*test4 ]] || false
}

@test "multiple-tables: dolt reset --hard on new tables" {
    # Per Git, dolt reset --hard on an untracked table should do nothing
    dolt reset --hard
    run dolt status
    [[ "$output" =~ table.*test1 ]] || false
    [[ "$output" =~ table.*test2 ]] || false

    # Per Git, if you add the table and do git reset --hard, the tables
    # should be deleted
    dolt add test1 test2
    dolt reset --hard
    run dolt status
    [[ ! "$output" =~ table.*test1 ]] || false
    [[ ! "$output" =~ table.*test2 ]] || false
    [[ "$output" =~ "nothing to commit" ]] || false
}
