package aws_test

import (
	"testing"

	"github.com/snyk/driftctl/test"
	"github.com/snyk/driftctl/test/acceptance"
)

func TestAcc_Aws_ApiGatewayModel(t *testing.T) {
	acceptance.Run(t, acceptance.AccTestCase{
		TerraformVersion: "0.15.5",
		Paths:            []string{"./testdata/acc/aws_api_gateway_model"},
		Args:             []string{"scan"},
		Checks: []acceptance.AccCheck{
			{
				Env: map[string]string{
					"AWS_REGION": "us-east-1",
				},
				Check: func(result *test.ScanResult, stdout string, err error) {
					if err != nil {
						t.Fatal(err)
					}
					result.AssertManagedCount(2)

					// Models creating from an empty aws_api_gateway_rest_api
					// (e.g. empty body) result in 2 aws_api_gateway_model
					// created by default, hence unmanaged resources.
					result.AssertUnmanagedCount(2)
				},
			},
		},
	})
}
