// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs"
	. "github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs"
)

// CloudWatchLogs provides an interface to the AWS CloudWatchLogs service.
type CloudWatchLogs interface {
	// Options returns a copy of the client configuration.
	//
	// Callers SHOULD NOT perform mutations on any inner structures within client
	// config. Config overrides should instead be made on a per-operation basis through
	// functional options.
	Options() cloudwatchlogs.Options
	// Associates the specified KMS key with either one log group in the account, or
	// with all stored CloudWatch Logs query insights results in the account.
	//
	// When you use AssociateKmsKey , you specify either the logGroupName parameter or
	// the resourceIdentifier parameter. You can't specify both of those parameters in
	// the same operation.
	//
	//   - Specify the logGroupName parameter to cause log events ingested into that
	//     log group to be encrypted with that key. Only the log events ingested after the
	//     key is associated are encrypted with that key.
	//
	// Associating a KMS key with a log group overrides any existing associations
	//
	//	between the log group and a KMS key. After a KMS key is associated with a log
	//	group, all newly ingested data for the log group is encrypted using the KMS key.
	//	This association is stored as long as the data encrypted with the KMS key is
	//	still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this data
	//	whenever it is requested.
	//
	// Associating a key with a log group does not cause the results of queries of
	//
	//	that log group to be encrypted with that key. To have query results encrypted
	//	with a KMS key, you must use an AssociateKmsKey operation with the
	//	resourceIdentifier parameter that specifies a query-result resource.
	//
	//	- Specify the resourceIdentifier parameter with a query-result resource, to
	//	use that key to encrypt the stored results of all future [StartQuery]operations in the
	//	account. The response from a [GetQueryResults]operation will still return the query results in
	//	plain text.
	//
	// Even if you have not associated a key with your query results, the query
	//
	//	results are encrypted when stored, using the default CloudWatch Logs method.
	//
	// If you run a query from a monitoring account that queries logs in a source
	//
	//	account, the query results key from the monitoring account, if any, is used.
	//
	// If you delete the key that is used to encrypt log events or log group query
	// results, then all the associated stored log events or query results that were
	// encrypted with that key will be unencryptable and unusable.
	//
	// CloudWatch Logs supports only symmetric KMS keys. Do not associate an
	// asymmetric KMS key with your log group or query results. For more information,
	// see [Using Symmetric and Asymmetric Keys].
	//
	// It can take up to 5 minutes for this operation to take effect.
	//
	// If you attempt to associate a KMS key with a log group but the KMS key does not
	// exist or the KMS key is disabled, you receive an InvalidParameterException
	// error.
	//
	// [Using Symmetric and Asymmetric Keys]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
	//
	// [StartQuery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
	// [GetQueryResults]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html
	AssociateKmsKey(ctx context.Context, params *cloudwatchlogs.AssociateKmsKeyInput, optFns ...func(*Options)) (*cloudwatchlogs.AssociateKmsKeyOutput, error)
	// Cancels the specified export task.
	//
	// The task must be in the PENDING or RUNNING state.
	CancelExportTask(ctx context.Context, params *cloudwatchlogs.CancelExportTaskInput, optFns ...func(*Options)) (*cloudwatchlogs.CancelExportTaskOutput, error)
	// Creates a delivery. A delivery is a connection between a logical delivery
	// source and a logical delivery destination that you have already created.
	//
	// Only some Amazon Web Services services support being configured as a delivery
	// source using this operation. These services are listed as Supported [V2
	// Permissions] in the table at [Enabling logging from Amazon Web Services services.]
	//
	// A delivery destination can represent a log group in CloudWatch Logs, an Amazon
	// S3 bucket, a delivery stream in Firehose, or X-Ray.
	//
	// To configure logs delivery between a supported Amazon Web Services service and
	// a destination, you must do the following:
	//
	//   - Create a delivery source, which is a logical object that represents the
	//     resource that is actually sending the logs. For more information, see [PutDeliverySource].
	//
	//   - Create a delivery destination, which is a logical object that represents
	//     the actual delivery destination. For more information, see [PutDeliveryDestination].
	//
	//   - If you are delivering logs cross-account, you must use [PutDeliveryDestinationPolicy]in the destination
	//     account to assign an IAM policy to the destination. This policy allows delivery
	//     to that destination.
	//
	//   - Use CreateDelivery to create a delivery by pairing exactly one delivery
	//     source and one delivery destination.
	//
	// You can configure a single delivery source to send logs to multiple
	// destinations by creating multiple deliveries. You can also create multiple
	// deliveries to configure multiple delivery sources to send logs to the same
	// delivery destination.
	//
	// To update an existing delivery configuration, use [UpdateDeliveryConfiguration].
	//
	// [PutDeliveryDestination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html
	// [PutDeliverySource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html
	// [Enabling logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	// [PutDeliveryDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html
	// [UpdateDeliveryConfiguration]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html
	CreateDelivery(ctx context.Context, params *cloudwatchlogs.CreateDeliveryInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateDeliveryOutput, error)
	// Creates an export task so that you can efficiently export data from a log group
	// to an Amazon S3 bucket. When you perform a CreateExportTask operation, you must
	// use credentials that have permission to write to the S3 bucket that you specify
	// as the destination.
	//
	// Exporting log data to S3 buckets that are encrypted by KMS is supported.
	// Exporting log data to Amazon S3 buckets that have S3 Object Lock enabled with a
	// retention period is also supported.
	//
	// Exporting to S3 buckets that are encrypted with AES-256 is supported.
	//
	// This is an asynchronous call. If all the required information is provided, this
	// operation initiates an export task and responds with the ID of the task. After
	// the task has started, you can use [DescribeExportTasks]to get the status of the export task. Each
	// account can only have one active ( RUNNING or PENDING ) export task at a time.
	// To cancel an export task, use [CancelExportTask].
	//
	// You can export logs from multiple log groups or multiple time ranges to the
	// same S3 bucket. To separate log data for each export task, specify a prefix to
	// be used as the Amazon S3 key prefix for all exported objects.
	//
	// We recommend that you don't regularly export to Amazon S3 as a way to
	// continuously archive your logs. For that use case, we instead recommend that you
	// use subscriptions. For more information about subscriptions, see [Real-time processing of log data with subscriptions].
	//
	// Time-based sorting on chunks of log data inside an exported file is not
	// guaranteed. You can sort the exported log field data by using Linux utilities.
	//
	// [CancelExportTask]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html
	// [DescribeExportTasks]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html
	// [Real-time processing of log data with subscriptions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions.html
	CreateExportTask(ctx context.Context, params *cloudwatchlogs.CreateExportTaskInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateExportTaskOutput, error)
	// Creates an anomaly detector that regularly scans one or more log groups and
	// look for patterns and anomalies in the logs.
	//
	// An anomaly detector can help surface issues by automatically discovering
	// anomalies in your log event traffic. An anomaly detector uses machine learning
	// algorithms to scan log events and find patterns. A pattern is a shared text
	// structure that recurs among your log fields. Patterns provide a useful tool for
	// analyzing large sets of logs because a large number of log events can often be
	// compressed into a few patterns.
	//
	// The anomaly detector uses pattern recognition to find anomalies , which are
	// unusual log events. It uses the evaluationFrequency to compare current log
	// events and patterns with trained baselines.
	//
	// Fields within a pattern are called tokens. Fields that vary within a pattern,
	// such as a request ID or timestamp, are referred to as dynamic tokens and
	// represented by <*> .
	//
	// The following is an example of a pattern:
	//
	//	[INFO] Request time: <*> ms
	//
	// This pattern represents log events like [INFO] Request time: 327 ms and other
	// similar log events that differ only by the number, in this csse 327. When the
	// pattern is displayed, the different numbers are replaced by <*>
	//
	// Any parts of log events that are masked as sensitive data are not scanned for
	// anomalies. For more information about masking sensitive data, see [Help protect sensitive log data with masking].
	//
	// [Help protect sensitive log data with masking]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html
	CreateLogAnomalyDetector(ctx context.Context, params *cloudwatchlogs.CreateLogAnomalyDetectorInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateLogAnomalyDetectorOutput, error)
	// Creates a log group with the specified name. You can create up to 1,000,000 log
	// groups per Region per account.
	//
	// You must use the following guidelines when naming a log group:
	//
	//   - Log group names must be unique within a Region for an Amazon Web Services
	//     account.
	//
	//   - Log group names can be between 1 and 512 characters long.
	//
	//   - Log group names consist of the following characters: a-z, A-Z, 0-9, '_'
	//     (underscore), '-' (hyphen), '/' (forward slash), '.' (period), and '#' (number
	//     sign)
	//
	//   - Log group names can't start with the string aws/
	//
	// When you create a log group, by default the log events in the log group do not
	// expire. To set a retention policy so that events expire and are deleted after a
	// specified time, use [PutRetentionPolicy].
	//
	// If you associate an KMS key with the log group, ingested data is encrypted
	// using the KMS key. This association is stored as long as the data encrypted with
	// the KMS key is still within CloudWatch Logs. This enables CloudWatch Logs to
	// decrypt this data whenever it is requested.
	//
	// If you attempt to associate a KMS key with the log group but the KMS key does
	// not exist or the KMS key is disabled, you receive an InvalidParameterException
	// error.
	//
	// CloudWatch Logs supports only symmetric KMS keys. Do not associate an
	// asymmetric KMS key with your log group. For more information, see [Using Symmetric and Asymmetric Keys].
	//
	// [Using Symmetric and Asymmetric Keys]: https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html
	// [PutRetentionPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html
	CreateLogGroup(ctx context.Context, params *cloudwatchlogs.CreateLogGroupInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateLogGroupOutput, error)
	// Creates a log stream for the specified log group. A log stream is a sequence of
	// log events that originate from a single source, such as an application instance
	// or a resource that is being monitored.
	//
	// There is no limit on the number of log streams that you can create for a log
	// group. There is a limit of 50 TPS on CreateLogStream operations, after which
	// transactions are throttled.
	//
	// You must use the following guidelines when naming a log stream:
	//
	//   - Log stream names must be unique within the log group.
	//
	//   - Log stream names can be between 1 and 512 characters long.
	//
	//   - Don't use ':' (colon) or '*' (asterisk) characters.
	CreateLogStream(ctx context.Context, params *cloudwatchlogs.CreateLogStreamInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateLogStreamOutput, error)
	// Creates a new Scheduled Query that runs CloudWatch Logs Insights queries on a
	// schedule and delivers results to specified destinations.
	CreateScheduledQuery(ctx context.Context, params *cloudwatchlogs.CreateScheduledQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.CreateScheduledQueryOutput, error)
	// Deletes a CloudWatch Logs account policy. This stops the account-wide policy
	// from applying to log groups in the account. If you delete a data protection
	// policy or subscription filter policy, any log-group level policies of those
	// types remain in effect.
	//
	// To use this operation, you must be signed on with the correct permissions
	// depending on the type of policy that you are deleting.
	//
	//   - To delete a data protection policy, you must have the
	//     logs:DeleteDataProtectionPolicy and logs:DeleteAccountPolicy permissions.
	//
	//   - To delete a subscription filter policy, you must have the
	//     logs:DeleteSubscriptionFilter and logs:DeleteAccountPolicy permissions.
	//
	//   - To delete a transformer policy, you must have the logs:DeleteTransformer and
	//     logs:DeleteAccountPolicy permissions.
	//
	//   - To delete a field index policy, you must have the logs:DeleteIndexPolicy and
	//     logs:DeleteAccountPolicy permissions.
	//
	// If you delete a field index policy, the indexing of the log events that
	// happened before you deleted the policy will still be used for up to 30 days to
	// improve CloudWatch Logs Insights queries.
	DeleteAccountPolicy(ctx context.Context, params *cloudwatchlogs.DeleteAccountPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteAccountPolicyOutput, error)
	// Deletes the data protection policy from the specified log group.
	//
	// For more information about data protection policies, see [PutDataProtectionPolicy].
	//
	// [PutDataProtectionPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html
	DeleteDataProtectionPolicy(ctx context.Context, params *cloudwatchlogs.DeleteDataProtectionPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDataProtectionPolicyOutput, error)
	// Deletes a delivery. A delivery is a connection between a logical delivery
	// source and a logical delivery destination. Deleting a delivery only deletes the
	// connection between the delivery source and delivery destination. It does not
	// delete the delivery destination or the delivery source.
	DeleteDelivery(ctx context.Context, params *cloudwatchlogs.DeleteDeliveryInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDeliveryOutput, error)
	// Deletes a delivery destination. A delivery is a connection between a logical
	// delivery source and a logical delivery destination.
	//
	// You can't delete a delivery destination if any current deliveries are
	// associated with it. To find whether any deliveries are associated with this
	// delivery destination, use the [DescribeDeliveries]operation and check the deliveryDestinationArn
	// field in the results.
	//
	// [DescribeDeliveries]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html
	DeleteDeliveryDestination(ctx context.Context, params *cloudwatchlogs.DeleteDeliveryDestinationInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDeliveryDestinationOutput, error)
	// Deletes a delivery destination policy. For more information about these
	// policies, see [PutDeliveryDestinationPolicy].
	//
	// [PutDeliveryDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html
	DeleteDeliveryDestinationPolicy(ctx context.Context, params *cloudwatchlogs.DeleteDeliveryDestinationPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDeliveryDestinationPolicyOutput, error)
	// Deletes a delivery source. A delivery is a connection between a logical
	// delivery source and a logical delivery destination.
	//
	// You can't delete a delivery source if any current deliveries are associated
	// with it. To find whether any deliveries are associated with this delivery
	// source, use the [DescribeDeliveries]operation and check the deliverySourceName field in the results.
	//
	// [DescribeDeliveries]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html
	DeleteDeliverySource(ctx context.Context, params *cloudwatchlogs.DeleteDeliverySourceInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDeliverySourceOutput, error)
	// Deletes the specified destination, and eventually disables all the subscription
	// filters that publish to it. This operation does not delete the physical resource
	// encapsulated by the destination.
	DeleteDestination(ctx context.Context, params *cloudwatchlogs.DeleteDestinationInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteDestinationOutput, error)
	// Deletes a log-group level field index policy that was applied to a single log
	// group. The indexing of the log events that happened before you delete the policy
	// will still be used for as many as 30 days to improve CloudWatch Logs Insights
	// queries.
	//
	// You can't use this operation to delete an account-level index policy. Instead,
	// use [DeletAccountPolicy].
	//
	// If you delete a log-group level field index policy and there is an
	// account-level field index policy, in a few minutes the log group begins using
	// that account-wide policy to index new incoming log events.
	//
	// [DeletAccountPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteAccountPolicy.html
	DeleteIndexPolicy(ctx context.Context, params *cloudwatchlogs.DeleteIndexPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteIndexPolicyOutput, error)
	// Deletes the integration between CloudWatch Logs and OpenSearch Service. If your
	// integration has active vended logs dashboards, you must specify true for the
	// force parameter, otherwise the operation will fail. If you delete the
	// integration by setting force to true , all your vended logs dashboards powered
	// by OpenSearch Service will be deleted and the data that was on them will no
	// longer be accessible.
	DeleteIntegration(ctx context.Context, params *cloudwatchlogs.DeleteIntegrationInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteIntegrationOutput, error)
	// Deletes the specified CloudWatch Logs anomaly detector.
	DeleteLogAnomalyDetector(ctx context.Context, params *cloudwatchlogs.DeleteLogAnomalyDetectorInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteLogAnomalyDetectorOutput, error)
	// Deletes the specified log group and permanently deletes all the archived log
	// events associated with the log group.
	DeleteLogGroup(ctx context.Context, params *cloudwatchlogs.DeleteLogGroupInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteLogGroupOutput, error)
	// Deletes the specified log stream and permanently deletes all the archived log
	// events associated with the log stream.
	DeleteLogStream(ctx context.Context, params *cloudwatchlogs.DeleteLogStreamInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteLogStreamOutput, error)
	// Deletes the specified metric filter.
	DeleteMetricFilter(ctx context.Context, params *cloudwatchlogs.DeleteMetricFilterInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteMetricFilterOutput, error)
	// Deletes a saved CloudWatch Logs Insights query definition. A query definition
	// contains details about a saved CloudWatch Logs Insights query.
	//
	// Each DeleteQueryDefinition operation can delete one query definition.
	//
	// You must have the logs:DeleteQueryDefinition permission to be able to perform
	// this operation.
	DeleteQueryDefinition(ctx context.Context, params *cloudwatchlogs.DeleteQueryDefinitionInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteQueryDefinitionOutput, error)
	// Deletes a resource policy from this account. This revokes the access of the
	// identities in that policy to put log events to this account.
	DeleteResourcePolicy(ctx context.Context, params *cloudwatchlogs.DeleteResourcePolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteResourcePolicyOutput, error)
	// Deletes the specified retention policy.
	//
	// Log events do not expire if they belong to log groups without a retention
	// policy.
	DeleteRetentionPolicy(ctx context.Context, params *cloudwatchlogs.DeleteRetentionPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteRetentionPolicyOutput, error)
	// Deletes an existing scheduled query and all its associated configurations. This
	// operation permanently removes the scheduled query and cannot be undone.
	DeleteScheduledQuery(ctx context.Context, params *cloudwatchlogs.DeleteScheduledQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteScheduledQueryOutput, error)
	// Deletes the specified subscription filter.
	DeleteSubscriptionFilter(ctx context.Context, params *cloudwatchlogs.DeleteSubscriptionFilterInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteSubscriptionFilterOutput, error)
	// Deletes the log transformer for the specified log group. As soon as you do
	// this, the transformation of incoming log events according to that transformer
	// stops. If this account has an account-level transformer that applies to this log
	// group, the log group begins using that account-level transformer when this
	// log-group level transformer is deleted.
	//
	// After you delete a transformer, be sure to edit any metric filters or
	// subscription filters that relied on the transformed versions of the log events.
	DeleteTransformer(ctx context.Context, params *cloudwatchlogs.DeleteTransformerInput, optFns ...func(*Options)) (*cloudwatchlogs.DeleteTransformerOutput, error)
	// Returns a list of all CloudWatch Logs account policies in the account.
	//
	// To use this operation, you must be signed on with the correct permissions
	// depending on the type of policy that you are retrieving information for.
	//
	//   - To see data protection policies, you must have the
	//     logs:GetDataProtectionPolicy and logs:DescribeAccountPolicies permissions.
	//
	//   - To see subscription filter policies, you must have the
	//     logs:DescribeSubscriptionFilters and logs:DescribeAccountPolicies permissions.
	//
	//   - To see transformer policies, you must have the logs:GetTransformer and
	//     logs:DescribeAccountPolicies permissions.
	//
	//   - To see field index policies, you must have the logs:DescribeIndexPolicies
	//     and logs:DescribeAccountPolicies permissions.
	DescribeAccountPolicies(ctx context.Context, params *cloudwatchlogs.DescribeAccountPoliciesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeAccountPoliciesOutput, error)
	// Use this operation to return the valid and default values that are used when
	// creating delivery sources, delivery destinations, and deliveries. For more
	// information about deliveries, see [CreateDelivery].
	//
	// [CreateDelivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html
	DescribeConfigurationTemplates(ctx context.Context, params *cloudwatchlogs.DescribeConfigurationTemplatesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeConfigurationTemplatesOutput, error)
	// Retrieves a list of the deliveries that have been created in the account.
	//
	// A delivery is a connection between a [delivery source] and a [delivery destination].
	//
	// A delivery source represents an Amazon Web Services resource that sends logs to
	// an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3,
	// Firehose or X-Ray. Only some Amazon Web Services services support being
	// configured as a delivery source. These services are listed in [Enable logging from Amazon Web Services services.]
	//
	// [delivery destination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html
	// [delivery source]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html
	// [Enable logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	DescribeDeliveries(ctx context.Context, params *cloudwatchlogs.DescribeDeliveriesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeDeliveriesOutput, error)
	// Retrieves a list of the delivery destinations that have been created in the
	// account.
	DescribeDeliveryDestinations(ctx context.Context, params *cloudwatchlogs.DescribeDeliveryDestinationsInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeDeliveryDestinationsOutput, error)
	// Retrieves a list of the delivery sources that have been created in the account.
	DescribeDeliverySources(ctx context.Context, params *cloudwatchlogs.DescribeDeliverySourcesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeDeliverySourcesOutput, error)
	// Lists all your destinations. The results are ASCII-sorted by destination name.
	DescribeDestinations(ctx context.Context, params *cloudwatchlogs.DescribeDestinationsInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeDestinationsOutput, error)
	// Lists the specified export tasks. You can list all your export tasks or filter
	// the results based on task ID or task status.
	DescribeExportTasks(ctx context.Context, params *cloudwatchlogs.DescribeExportTasksInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeExportTasksOutput, error)
	// Returns a list of custom and default field indexes which are discovered in log
	// data. For more information about field index policies, see [PutIndexPolicy].
	//
	// [PutIndexPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html
	DescribeFieldIndexes(ctx context.Context, params *cloudwatchlogs.DescribeFieldIndexesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeFieldIndexesOutput, error)
	// Returns the field index policies of the specified log group. For more
	// information about field index policies, see [PutIndexPolicy].
	//
	// If a specified log group has a log-group level index policy, that policy is
	// returned by this operation.
	//
	// If a specified log group doesn't have a log-group level index policy, but an
	// account-wide index policy applies to it, that account-wide policy is returned by
	// this operation.
	//
	// To find information about only account-level policies, use [DescribeAccountPolicies] instead.
	//
	// [PutIndexPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html
	// [DescribeAccountPolicies]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html
	DescribeIndexPolicies(ctx context.Context, params *cloudwatchlogs.DescribeIndexPoliciesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeIndexPoliciesOutput, error)
	// Returns information about log groups. You can return all your log groups or
	// filter the results by prefix. The results are ASCII-sorted by log group name.
	//
	// CloudWatch Logs doesn't support IAM policies that control access to the
	// DescribeLogGroups action by using the aws:ResourceTag/key-name  condition key.
	// Other CloudWatch Logs actions do support the use of the
	// aws:ResourceTag/key-name condition key to control access. For more information
	// about using tags to control access, see [Controlling access to Amazon Web Services resources using tags].
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account and view data from the linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [Controlling access to Amazon Web Services resources using tags]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html
	DescribeLogGroups(ctx context.Context, params *cloudwatchlogs.DescribeLogGroupsInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeLogGroupsOutput, error)
	// Lists the log streams for the specified log group. You can list all the log
	// streams or filter the results by prefix. You can also control how the results
	// are ordered.
	//
	// You can specify the log group to search by using either logGroupIdentifier or
	// logGroupName . You must include one of these two parameters, but you can't
	// include both.
	//
	// This operation has a limit of 25 transactions per second, after which
	// transactions are throttled.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account and view data from the linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	DescribeLogStreams(ctx context.Context, params *cloudwatchlogs.DescribeLogStreamsInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeLogStreamsOutput, error)
	// Lists the specified metric filters. You can list all of the metric filters or
	// filter the results by log name, prefix, metric name, or metric namespace. The
	// results are ASCII-sorted by filter name.
	DescribeMetricFilters(ctx context.Context, params *cloudwatchlogs.DescribeMetricFiltersInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeMetricFiltersOutput, error)
	// Returns a list of CloudWatch Logs Insights queries that are scheduled, running,
	// or have been run recently in this account. You can request all queries or limit
	// it to queries of a specific log group or queries with a certain status.
	DescribeQueries(ctx context.Context, params *cloudwatchlogs.DescribeQueriesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeQueriesOutput, error)
	// This operation returns a paginated list of your saved CloudWatch Logs Insights
	// query definitions. You can retrieve query definitions from the current account
	// or from a source account that is linked to the current account.
	//
	// You can use the queryDefinitionNamePrefix parameter to limit the results to
	// only the query definitions that have names that start with a certain string.
	DescribeQueryDefinitions(ctx context.Context, params *cloudwatchlogs.DescribeQueryDefinitionsInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeQueryDefinitionsOutput, error)
	// Lists the resource policies in this account.
	DescribeResourcePolicies(ctx context.Context, params *cloudwatchlogs.DescribeResourcePoliciesInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeResourcePoliciesOutput, error)
	// Lists the subscription filters for the specified log group. You can list all
	// the subscription filters or filter the results by prefix. The results are
	// ASCII-sorted by filter name.
	DescribeSubscriptionFilters(ctx context.Context, params *cloudwatchlogs.DescribeSubscriptionFiltersInput, optFns ...func(*Options)) (*cloudwatchlogs.DescribeSubscriptionFiltersOutput, error)
	// Disassociates the specified KMS key from the specified log group or from all
	// CloudWatch Logs Insights query results in the account.
	//
	// When you use DisassociateKmsKey , you specify either the logGroupName parameter
	// or the resourceIdentifier parameter. You can't specify both of those parameters
	// in the same operation.
	//
	//   - Specify the logGroupName parameter to stop using the KMS key to encrypt
	//     future log events ingested and stored in the log group. Instead, they will be
	//     encrypted with the default CloudWatch Logs method. The log events that were
	//     ingested while the key was associated with the log group are still encrypted
	//     with that key. Therefore, CloudWatch Logs will need permissions for the key
	//     whenever that data is accessed.
	//
	//   - Specify the resourceIdentifier parameter with the query-result resource to
	//     stop using the KMS key to encrypt the results of all future [StartQuery]operations in the
	//     account. They will instead be encrypted with the default CloudWatch Logs method.
	//     The results from queries that ran while the key was associated with the account
	//     are still encrypted with that key. Therefore, CloudWatch Logs will need
	//     permissions for the key whenever that data is accessed.
	//
	// It can take up to 5 minutes for this operation to take effect.
	//
	// [StartQuery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
	DisassociateKmsKey(ctx context.Context, params *cloudwatchlogs.DisassociateKmsKeyInput, optFns ...func(*Options)) (*cloudwatchlogs.DisassociateKmsKeyOutput, error)
	// Lists log events from the specified log group. You can list all the log events
	// or filter the results using one or more of the following:
	//
	//   - A filter pattern
	//
	//   - A time range
	//
	//   - The log stream name, or a log stream name prefix that matches multiple log
	//     streams
	//
	// You must have the logs:FilterLogEvents permission to perform this operation.
	//
	// You can specify the log group to search by using either logGroupIdentifier or
	// logGroupName . You must include one of these two parameters, but you can't
	// include both.
	//
	// FilterLogEvents is a paginated operation. Each page returned can contain up to
	// 1 MB of log events or up to 10,000 log events. A returned page might only be
	// partially full, or even empty. For example, if the result of a query would
	// return 15,000 log events, the first page isn't guaranteed to have 10,000 log
	// events even if they all fit into 1 MB.
	//
	// Partially full or empty pages don't necessarily mean that pagination is
	// finished. If the results include a nextToken , there might be more log events
	// available. You can return these additional log events by providing the nextToken
	// in a subsequent FilterLogEvents operation. If the results don't include a
	// nextToken , then pagination is finished.
	//
	// Specifying the limit parameter only guarantees that a single page doesn't
	// return more log events than the specified limit, but it might return fewer
	// events than the limit. This is the expected API behavior.
	//
	// The returned log events are sorted by event timestamp, the timestamp when the
	// event was ingested by CloudWatch Logs, and the ID of the PutLogEvents request.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account and view data from the linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// If you are using [log transformation], the FilterLogEvents operation returns only the original
	// versions of log events, before they were transformed. To view the transformed
	// versions, you must use a [CloudWatch Logs query.]
	//
	// [log transformation]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [CloudWatch Logs query.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html
	FilterLogEvents(ctx context.Context, params *cloudwatchlogs.FilterLogEventsInput, optFns ...func(*Options)) (*cloudwatchlogs.FilterLogEventsOutput, error)
	// Returns information about a log group data protection policy.
	GetDataProtectionPolicy(ctx context.Context, params *cloudwatchlogs.GetDataProtectionPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.GetDataProtectionPolicyOutput, error)
	// Returns complete information about one logical delivery. A delivery is a
	// connection between a [delivery source]and a [delivery destination].
	//
	// A delivery source represents an Amazon Web Services resource that sends logs to
	// an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3,
	// or Firehose. Only some Amazon Web Services services support being configured as
	// a delivery source. These services are listed in [Enable logging from Amazon Web Services services.]
	//
	// You need to specify the delivery id in this operation. You can find the IDs of
	// the deliveries in your account with the [DescribeDeliveries]operation.
	//
	// [delivery destination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html
	// [delivery source]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html
	// [Enable logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	// [DescribeDeliveries]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html
	GetDelivery(ctx context.Context, params *cloudwatchlogs.GetDeliveryInput, optFns ...func(*Options)) (*cloudwatchlogs.GetDeliveryOutput, error)
	// Retrieves complete information about one delivery destination.
	GetDeliveryDestination(ctx context.Context, params *cloudwatchlogs.GetDeliveryDestinationInput, optFns ...func(*Options)) (*cloudwatchlogs.GetDeliveryDestinationOutput, error)
	// Retrieves the delivery destination policy assigned to the delivery destination
	// that you specify. For more information about delivery destinations and their
	// policies, see [PutDeliveryDestinationPolicy].
	//
	// [PutDeliveryDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html
	GetDeliveryDestinationPolicy(ctx context.Context, params *cloudwatchlogs.GetDeliveryDestinationPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.GetDeliveryDestinationPolicyOutput, error)
	// Retrieves complete information about one delivery source.
	GetDeliverySource(ctx context.Context, params *cloudwatchlogs.GetDeliverySourceInput, optFns ...func(*Options)) (*cloudwatchlogs.GetDeliverySourceOutput, error)
	// Returns information about one integration between CloudWatch Logs and
	// OpenSearch Service.
	GetIntegration(ctx context.Context, params *cloudwatchlogs.GetIntegrationInput, optFns ...func(*Options)) (*cloudwatchlogs.GetIntegrationOutput, error)
	// Retrieves information about the log anomaly detector that you specify. The KMS
	// key ARN detected is valid.
	GetLogAnomalyDetector(ctx context.Context, params *cloudwatchlogs.GetLogAnomalyDetectorInput, optFns ...func(*Options)) (*cloudwatchlogs.GetLogAnomalyDetectorOutput, error)
	// Lists log events from the specified log stream. You can list all of the log
	// events or filter using a time range.
	//
	// GetLogEvents is a paginated operation. Each page returned can contain up to 1
	// MB of log events or up to 10,000 log events. A returned page might only be
	// partially full, or even empty. For example, if the result of a query would
	// return 15,000 log events, the first page isn't guaranteed to have 10,000 log
	// events even if they all fit into 1 MB.
	//
	// Partially full or empty pages don't necessarily mean that pagination is
	// finished. As long as the nextBackwardToken or nextForwardToken returned is NOT
	// equal to the nextToken that you passed into the API call, there might be more
	// log events available. The token that you use depends on the direction you want
	// to move in along the log stream. The returned tokens are never null.
	//
	// If you set startFromHead to true and you don’t include endTime in your request,
	// you can end up in a situation where the pagination doesn't terminate. This can
	// happen when the new log events are being added to the target log streams faster
	// than they are being read. This situation is a good use case for the CloudWatch
	// Logs [Live Tail]feature.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account and view data from the linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// You can specify the log group to search by using either logGroupIdentifier or
	// logGroupName . You must include one of these two parameters, but you can't
	// include both.
	//
	// If you are using [log transformation], the GetLogEvents operation returns only the original
	// versions of log events, before they were transformed. To view the transformed
	// versions, you must use a [CloudWatch Logs query.]
	//
	// [log transformation]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [CloudWatch Logs query.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html
	// [Live Tail]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html
	GetLogEvents(ctx context.Context, params *cloudwatchlogs.GetLogEventsInput, optFns ...func(*Options)) (*cloudwatchlogs.GetLogEventsOutput, error)
	// Returns a list of the fields that are included in log events in the specified
	// log group. Includes the percentage of log events that contain each field. The
	// search is limited to a time period that you specify.
	//
	// You can specify the log group to search by using either logGroupIdentifier or
	// logGroupName . You must specify one of these parameters, but you can't specify
	// both.
	//
	// In the results, fields that start with @ are fields generated by CloudWatch
	// Logs. For example, @timestamp is the timestamp of each log event. For more
	// information about the fields that are generated by CloudWatch logs, see [Supported Logs and Discovered Fields].
	//
	// The response results are sorted by the frequency percentage, starting with the
	// highest percentage.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account and view data from the linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [Supported Logs and Discovered Fields]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html
	GetLogGroupFields(ctx context.Context, params *cloudwatchlogs.GetLogGroupFieldsInput, optFns ...func(*Options)) (*cloudwatchlogs.GetLogGroupFieldsOutput, error)
	// Retrieves a large logging object (LLO) and streams it back. This API is used to
	// fetch the content of large portions of log events that have been ingested
	// through the PutOpenTelemetryLogs API. When log events contain fields that would
	// cause the total event size to exceed 1MB, CloudWatch Logs automatically
	// processes up to 10 fields, starting with the largest fields. Each field is
	// truncated as needed to keep the total event size as close to 1MB as possible.
	// The excess portions are stored as Large Log Objects (LLOs) and these fields are
	// processed separately and LLO reference system fields (in the format
	// @ptr.$[path.to.field] ) are added. The path in the reference field reflects the
	// original JSON structure where the large field was located. For example, this
	// could be @ptr.$['input']['message'] , @ptr.$['AAA']['BBB']['CCC']['DDD'] ,
	// @ptr.$['AAA'] , or any other path matching your log structure.
	GetLogObject(ctx context.Context, params *cloudwatchlogs.GetLogObjectInput, optFns ...func(*Options)) (*cloudwatchlogs.GetLogObjectOutput, error)
	// Retrieves all of the fields and values of a single log event. All fields are
	// retrieved, even if the original query that produced the logRecordPointer
	// retrieved only a subset of fields. Fields are returned as field name/field value
	// pairs.
	//
	// The full unparsed log event is returned within @message .
	GetLogRecord(ctx context.Context, params *cloudwatchlogs.GetLogRecordInput, optFns ...func(*Options)) (*cloudwatchlogs.GetLogRecordOutput, error)
	// Returns the results from the specified query.
	//
	// Only the fields requested in the query are returned, along with a @ptr field,
	// which is the identifier for the log record. You can use the value of @ptr in a [GetLogRecord]
	// operation to get the full log record.
	//
	// GetQueryResults does not start running a query. To run a query, use [StartQuery]. For more
	// information about how long results of previous queries are available, see [CloudWatch Logs quotas].
	//
	// If the value of the Status field in the output is Running , this operation
	// returns only partial results. If you see a value of Scheduled or Running for
	// the status, you can retry the operation later to see the final results.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account to start queries in linked source accounts.
	// For more information, see [CloudWatch cross-account observability].
	//
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [GetLogRecord]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html
	// [CloudWatch Logs quotas]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/cloudwatch_limits_cwl.html
	// [StartQuery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
	GetQueryResults(ctx context.Context, params *cloudwatchlogs.GetQueryResultsInput, optFns ...func(*Options)) (*cloudwatchlogs.GetQueryResultsOutput, error)
	// Returns detailed information about a specified scheduled query, including its
	// configuration, current state, and execution history.
	GetScheduledQuery(ctx context.Context, params *cloudwatchlogs.GetScheduledQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.GetScheduledQueryOutput, error)
	// Retrieves the execution history of a scheduled query within a specified time
	// range, including execution status and destination processing metadata.
	GetScheduledQueryHistory(ctx context.Context, params *cloudwatchlogs.GetScheduledQueryHistoryInput, optFns ...func(*Options)) (*cloudwatchlogs.GetScheduledQueryHistoryOutput, error)
	// Returns the information about the log transformer associated with this log
	// group.
	//
	// This operation returns data only for transformers created at the log group
	// level. To get information for an account-level transformer, use [DescribeAccountPolicies].
	//
	// [DescribeAccountPolicies]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html
	GetTransformer(ctx context.Context, params *cloudwatchlogs.GetTransformerInput, optFns ...func(*Options)) (*cloudwatchlogs.GetTransformerOutput, error)
	// Returns a list of anomalies that log anomaly detectors have found. For details
	// about the structure format of each anomaly object that is returned, see the
	// example in this section.
	ListAnomalies(ctx context.Context, params *cloudwatchlogs.ListAnomaliesInput, optFns ...func(*Options)) (*cloudwatchlogs.ListAnomaliesOutput, error)
	// Returns a list of integrations between CloudWatch Logs and other services in
	// this account. Currently, only one integration can be created in an account, and
	// this integration must be with OpenSearch Service.
	ListIntegrations(ctx context.Context, params *cloudwatchlogs.ListIntegrationsInput, optFns ...func(*Options)) (*cloudwatchlogs.ListIntegrationsOutput, error)
	// Retrieves a list of the log anomaly detectors in the account.
	ListLogAnomalyDetectors(ctx context.Context, params *cloudwatchlogs.ListLogAnomalyDetectorsInput, optFns ...func(*Options)) (*cloudwatchlogs.ListLogAnomalyDetectorsOutput, error)
	// Returns a list of log groups in the Region in your account. If you are
	// performing this action in a monitoring account, you can choose to also return
	// log groups from source accounts that are linked to the monitoring account. For
	// more information about using cross-account observability to set up monitoring
	// accounts and source accounts, see [CloudWatch cross-account observability].
	//
	// You can optionally filter the list by log group class and by using regular
	// expressions in your request to match strings in the log group names.
	//
	// This operation is paginated. By default, your first use of this operation
	// returns 50 results, and includes a token to use in a subsequent operation to
	// return more results.
	//
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	ListLogGroups(ctx context.Context, params *cloudwatchlogs.ListLogGroupsInput, optFns ...func(*Options)) (*cloudwatchlogs.ListLogGroupsOutput, error)
	// Returns a list of the log groups that were analyzed during a single CloudWatch
	// Logs Insights query. This can be useful for queries that use log group name
	// prefixes or the filterIndex command, because the log groups are dynamically
	// selected in these cases.
	//
	// For more information about field indexes, see [Create field indexes to improve query performance and reduce costs].
	//
	// [Create field indexes to improve query performance and reduce costs]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html
	ListLogGroupsForQuery(ctx context.Context, params *cloudwatchlogs.ListLogGroupsForQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.ListLogGroupsForQueryOutput, error)
	// Lists all scheduled queries in the current AWS account and region with optional
	// filtering by state.
	ListScheduledQueries(ctx context.Context, params *cloudwatchlogs.ListScheduledQueriesInput, optFns ...func(*Options)) (*cloudwatchlogs.ListScheduledQueriesOutput, error)
	// Displays the tags associated with a CloudWatch Logs resource. Currently, log
	// groups and destinations support tagging.
	ListTagsForResource(ctx context.Context, params *cloudwatchlogs.ListTagsForResourceInput, optFns ...func(*Options)) (*cloudwatchlogs.ListTagsForResourceOutput, error)
	// The ListTagsLogGroup operation is on the path to deprecation. We recommend that
	// you use [ListTagsForResource]instead.
	//
	// Lists the tags for the specified log group.
	//
	// Deprecated: Please use the generic tagging API ListTagsForResource
	//
	// [ListTagsForResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html
	ListTagsLogGroup(ctx context.Context, params *cloudwatchlogs.ListTagsLogGroupInput, optFns ...func(*Options)) (*cloudwatchlogs.ListTagsLogGroupOutput, error)
	// Creates an account-level data protection policy, subscription filter policy,
	// field index policy, transformer policy, or metric extraction policy that applies
	// to all log groups or a subset of log groups in the account.
	//
	// To use this operation, you must be signed on with the correct permissions
	// depending on the type of policy that you are creating.
	//
	//   - To create a data protection policy, you must have the
	//     logs:PutDataProtectionPolicy and logs:PutAccountPolicy permissions.
	//
	//   - To create a subscription filter policy, you must have the
	//     logs:PutSubscriptionFilter and logs:PutAccountPolicy permissions.
	//
	//   - To create a transformer policy, you must have the logs:PutTransformer and
	//     logs:PutAccountPolicy permissions.
	//
	//   - To create a field index policy, you must have the logs:PutIndexPolicy and
	//     logs:PutAccountPolicy permissions.
	//
	//   - To create a metric extraction policy, you must have the
	//     logs:PutMetricExtractionPolicy and logs:PutAccountPolicy permissions.
	//
	// # Data protection policy
	//
	// A data protection policy can help safeguard sensitive data that's ingested by
	// your log groups by auditing and masking the sensitive log data. Each account can
	// have only one account-level data protection policy.
	//
	// Sensitive data is detected and masked when it is ingested into a log group.
	// When you set a data protection policy, log events ingested into the log groups
	// before that time are not masked.
	//
	// If you use PutAccountPolicy to create a data protection policy for your whole
	// account, it applies to both existing log groups and all log groups that are
	// created later in this account. The account-level policy is applied to existing
	// log groups with eventual consistency. It might take up to 5 minutes before
	// sensitive data in existing log groups begins to be masked.
	//
	// By default, when a user views a log event that includes masked data, the
	// sensitive data is replaced by asterisks. A user who has the logs:Unmask
	// permission can use a [GetLogEvents]or [FilterLogEvents] operation with the unmask parameter set to true to
	// view the unmasked log events. Users with the logs:Unmask can also view unmasked
	// data in the CloudWatch Logs console by running a CloudWatch Logs Insights query
	// with the unmask query command.
	//
	// For more information, including a list of types of data that can be audited and
	// masked, see [Protect sensitive log data with masking].
	//
	// To use the PutAccountPolicy operation for a data protection policy, you must be
	// signed on with the logs:PutDataProtectionPolicy and logs:PutAccountPolicy
	// permissions.
	//
	// The PutAccountPolicy operation applies to all log groups in the account. You
	// can use [PutDataProtectionPolicy]to create a data protection policy that applies to just one log group.
	// If a log group has its own data protection policy and the account also has an
	// account-level data protection policy, then the two policies are cumulative. Any
	// sensitive term specified in either policy is masked.
	//
	// # Subscription filter policy
	//
	// A subscription filter policy sets up a real-time feed of log events from
	// CloudWatch Logs to other Amazon Web Services services. Account-level
	// subscription filter policies apply to both existing log groups and log groups
	// that are created later in this account. Supported destinations are Kinesis Data
	// Streams, Firehose, and Lambda. When log events are sent to the receiving
	// service, they are Base64 encoded and compressed with the GZIP format.
	//
	// The following destinations are supported for subscription filters:
	//
	//   - An Kinesis Data Streams data stream in the same account as the subscription
	//     policy, for same-account delivery.
	//
	//   - An Firehose data stream in the same account as the subscription policy, for
	//     same-account delivery.
	//
	//   - A Lambda function in the same account as the subscription policy, for
	//     same-account delivery.
	//
	//   - A logical destination in a different account created with [PutDestination], for
	//     cross-account delivery. Kinesis Data Streams and Firehose are supported as
	//     logical destinations.
	//
	// Each account can have one account-level subscription filter policy per Region.
	// If you are updating an existing filter, you must specify the correct name in
	// PolicyName . To perform a PutAccountPolicy subscription filter operation for
	// any destination except a Lambda function, you must also have the iam:PassRole
	// permission.
	//
	// # Transformer policy
	//
	// Creates or updates a log transformer policy for your account. You use log
	// transformers to transform log events into a different format, making them easier
	// for you to process and analyze. You can also transform logs from different
	// sources into standardized formats that contain relevant, source-specific
	// information. After you have created a transformer, CloudWatch Logs performs this
	// transformation at the time of log ingestion. You can then refer to the
	// transformed versions of the logs during operations such as querying with
	// CloudWatch Logs Insights or creating metric filters or subscription filters.
	//
	// You can also use a transformer to copy metadata from metadata keys into the log
	// events themselves. This metadata can include log group name, log stream name,
	// account ID and Region.
	//
	// A transformer for a log group is a series of processors, where each processor
	// applies one type of transformation to the log events ingested into this log
	// group. For more information about the available processors to use in a
	// transformer, see [Processors that you can use].
	//
	// Having log events in standardized format enables visibility across your
	// applications for your log analysis, reporting, and alarming needs. CloudWatch
	// Logs provides transformation for common log types with out-of-the-box
	// transformation templates for major Amazon Web Services log sources such as VPC
	// flow logs, Lambda, and Amazon RDS. You can use pre-built transformation
	// templates or create custom transformation policies.
	//
	// You can create transformers only for the log groups in the Standard log class.
	//
	// You can have one account-level transformer policy that applies to all log
	// groups in the account. Or you can create as many as 20 account-level transformer
	// policies that are each scoped to a subset of log groups with the
	// selectionCriteria parameter. If you have multiple account-level transformer
	// policies with selection criteria, no two of them can use the same or overlapping
	// log group name prefixes. For example, if you have one policy filtered to log
	// groups that start with my-log , you can't have another field index policy
	// filtered to my-logpprod or my-logging .
	//
	// CloudWatch Logs provides default field indexes for all log groups in the
	// Standard log class. Default field indexes are automatically available for the
	// following fields:
	//
	//   - @logStream
	//
	//   - @aws.region
	//
	//   - @aws.account
	//
	//   - @source.log
	//
	//   - traceId
	//
	// Default field indexes are in addition to any custom field indexes you define
	// within your policy. Default field indexes are not counted towards your field
	// index quota.
	//
	// You can also set up a transformer at the log-group level. For more information,
	// see [PutTransformer]. If there is both a log-group level transformer created with PutTransformer
	// and an account-level transformer that could apply to the same log group, the log
	// group uses only the log-group level transformer. It ignores the account-level
	// transformer.
	//
	// # Field index policy
	//
	// You can use field index policies to create indexes on fields found in log
	// events in the log group. Creating field indexes can help lower the scan volume
	// for CloudWatch Logs Insights queries that reference those fields, because these
	// queries attempt to skip the processing of log events that are known to not match
	// the indexed field. Good fields to index are fields that you often need to query
	// for and fields or values that match only a small fraction of the total log
	// events. Common examples of indexes include request ID, session ID, user IDs, or
	// instance IDs. For more information, see [Create field indexes to improve query performance and reduce costs]
	//
	// To find the fields that are in your log group events, use the [GetLogGroupFields] operation.
	//
	// For example, suppose you have created a field index for requestId . Then, any
	// CloudWatch Logs Insights query on that log group that includes requestId =
	// value or requestId in [value, value, ...] will attempt to process only the log
	// events where the indexed field matches the specified value.
	//
	// Matches of log events to the names of indexed fields are case-sensitive. For
	// example, an indexed field of RequestId won't match a log event containing
	// requestId .
	//
	// You can have one account-level field index policy that applies to all log
	// groups in the account. Or you can create as many as 20 account-level field index
	// policies that are each scoped to a subset of log groups with the
	// selectionCriteria parameter. If you have multiple account-level index policies
	// with selection criteria, no two of them can use the same or overlapping log
	// group name prefixes. For example, if you have one policy filtered to log groups
	// that start with my-log , you can't have another field index policy filtered to
	// my-logpprod or my-logging .
	//
	// If you create an account-level field index policy in a monitoring account in
	// cross-account observability, the policy is applied only to the monitoring
	// account and not to any source accounts.
	//
	// If you want to create a field index policy for a single log group, you can use [PutIndexPolicy]
	// instead of PutAccountPolicy . If you do so, that log group will use only that
	// log-group level policy, and will ignore the account-level policy that you create
	// with [PutAccountPolicy].
	//
	// # Metric extraction policy
	//
	// A metric extraction policy controls whether CloudWatch Metrics can be created
	// through the Embedded Metrics Format (EMF) for log groups in your account. By
	// default, EMF metric creation is enabled for all log groups. You can use metric
	// extraction policies to disable EMF metric creation for your entire account or
	// specific log groups.
	//
	// When a policy disables EMF metric creation for a log group, log events in the
	// EMF format are still ingested, but no CloudWatch Metrics are created from them.
	//
	// Creating a policy disables metrics for AWS features that use EMF to create
	// metrics, such as CloudWatch Container Insights and CloudWatch Application
	// Signals. To prevent turning off those features by accident, we recommend that
	// you exclude the underlying log-groups through a selection-criteria such as
	// LogGroupNamePrefix NOT IN ["/aws/containerinsights",
	// "/aws/ecs/containerinsights", "/aws/application-signals/data"] .
	//
	// Each account can have either one account-level metric extraction policy that
	// applies to all log groups, or up to 5 policies that are each scoped to a subset
	// of log groups with the selectionCriteria parameter. The selection criteria
	// supports filtering by LogGroupName and LogGroupNamePrefix using the operators IN
	// and NOT IN . You can specify up to 50 values in each IN or NOT IN list.
	//
	// The selection criteria can be specified in these formats:
	//
	//	LogGroupName IN ["log-group-1", "log-group-2"]
	//
	//	LogGroupNamePrefix NOT IN ["/aws/prefix1", "/aws/prefix2"]
	//
	// If you have multiple account-level metric extraction policies with selection
	// criteria, no two of them can have overlapping criteria. For example, if you have
	// one policy with selection criteria LogGroupNamePrefix IN ["my-log"] , you can't
	// have another metric extraction policy with selection criteria
	// LogGroupNamePrefix IN ["/my-log-prod"] or LogGroupNamePrefix IN ["/my-logging"]
	// , as the set of log groups matching these prefixes would be a subset of the log
	// groups matching the first policy's prefix, creating an overlap.
	//
	// When using NOT IN , only one policy with this operator is allowed per account.
	//
	// When combining policies with IN and NOT IN operators, the overlap check ensures
	// that policies don't have conflicting effects. Two policies with IN and NOT IN
	// operators do not overlap if and only if every value in the IN policy is
	// completely contained within some value in the NOT IN policy. For example:
	//
	//   - If you have a NOT IN policy for prefix "/aws/lambda" , you can create an IN
	//     policy for the exact log group name "/aws/lambda/function1" because the set of
	//     log groups matching "/aws/lambda/function1" is a subset of the log groups
	//     matching "/aws/lambda" .
	//
	//   - If you have a NOT IN policy for prefix "/aws/lambda" , you cannot create an
	//     IN policy for prefix "/aws" because the set of log groups matching "/aws" is
	//     not a subset of the log groups matching "/aws/lambda" .
	//
	// [PutDestination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html
	// [PutTransformer]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html
	// [PutIndexPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html
	// [PutDataProtectionPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html
	// [Protect sensitive log data with masking]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html
	// [FilterLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html
	// [GetLogGroupFields]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html
	// [Processors that you can use]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors
	// [PutAccountPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html
	// [Create field indexes to improve query performance and reduce costs]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html
	// [GetLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html
	PutAccountPolicy(ctx context.Context, params *cloudwatchlogs.PutAccountPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutAccountPolicyOutput, error)
	// Creates a data protection policy for the specified log group. A data protection
	// policy can help safeguard sensitive data that's ingested by the log group by
	// auditing and masking the sensitive log data.
	//
	// Sensitive data is detected and masked when it is ingested into the log group.
	// When you set a data protection policy, log events ingested into the log group
	// before that time are not masked.
	//
	// By default, when a user views a log event that includes masked data, the
	// sensitive data is replaced by asterisks. A user who has the logs:Unmask
	// permission can use a [GetLogEvents]or [FilterLogEvents] operation with the unmask parameter set to true to
	// view the unmasked log events. Users with the logs:Unmask can also view unmasked
	// data in the CloudWatch Logs console by running a CloudWatch Logs Insights query
	// with the unmask query command.
	//
	// For more information, including a list of types of data that can be audited and
	// masked, see [Protect sensitive log data with masking].
	//
	// The PutDataProtectionPolicy operation applies to only the specified log group.
	// You can also use [PutAccountPolicy]to create an account-level data protection policy that applies
	// to all log groups in the account, including both existing log groups and log
	// groups that are created level. If a log group has its own data protection policy
	// and the account also has an account-level data protection policy, then the two
	// policies are cumulative. Any sensitive term specified in either policy is
	// masked.
	//
	// [Protect sensitive log data with masking]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html
	// [FilterLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html
	// [PutAccountPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html
	// [GetLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html
	PutDataProtectionPolicy(ctx context.Context, params *cloudwatchlogs.PutDataProtectionPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDataProtectionPolicyOutput, error)
	// Creates or updates a logical delivery destination. A delivery destination is an
	// Amazon Web Services resource that represents an Amazon Web Services service that
	// logs can be sent to. CloudWatch Logs, Amazon S3, and Firehose are supported as
	// logs delivery destinations and X-Ray as the trace delivery destination.
	//
	// To configure logs delivery between a supported Amazon Web Services service and
	// a destination, you must do the following:
	//
	//   - Create a delivery source, which is a logical object that represents the
	//     resource that is actually sending the logs. For more information, see [PutDeliverySource].
	//
	//   - Use PutDeliveryDestination to create a delivery destination in the same
	//     account of the actual delivery destination. The delivery destination that you
	//     create is a logical object that represents the actual delivery destination.
	//
	//   - If you are delivering logs cross-account, you must use [PutDeliveryDestinationPolicy]in the destination
	//     account to assign an IAM policy to the destination. This policy allows delivery
	//     to that destination.
	//
	//   - Use CreateDelivery to create a delivery by pairing exactly one delivery
	//     source and one delivery destination. For more information, see [CreateDelivery].
	//
	// You can configure a single delivery source to send logs to multiple
	// destinations by creating multiple deliveries. You can also create multiple
	// deliveries to configure multiple delivery sources to send logs to the same
	// delivery destination.
	//
	// Only some Amazon Web Services services support being configured as a delivery
	// source. These services are listed as Supported [V2 Permissions] in the table at [Enabling logging from Amazon Web Services services.]
	//
	// If you use this operation to update an existing delivery destination, all the
	// current delivery destination parameters are overwritten with the new parameter
	// values that you specify.
	//
	// [PutDeliverySource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html
	// [Enabling logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	// [CreateDelivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html
	// [PutDeliveryDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html
	PutDeliveryDestination(ctx context.Context, params *cloudwatchlogs.PutDeliveryDestinationInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDeliveryDestinationOutput, error)
	// Creates and assigns an IAM policy that grants permissions to CloudWatch Logs to
	// deliver logs cross-account to a specified destination in this account. To
	// configure the delivery of logs from an Amazon Web Services service in another
	// account to a logs delivery destination in the current account, you must do the
	// following:
	//
	//   - Create a delivery source, which is a logical object that represents the
	//     resource that is actually sending the logs. For more information, see [PutDeliverySource].
	//
	//   - Create a delivery destination, which is a logical object that represents
	//     the actual delivery destination. For more information, see [PutDeliveryDestination].
	//
	//   - Use this operation in the destination account to assign an IAM policy to
	//     the destination. This policy allows delivery to that destination.
	//
	//   - Create a delivery by pairing exactly one delivery source and one delivery
	//     destination. For more information, see [CreateDelivery].
	//
	// Only some Amazon Web Services services support being configured as a delivery
	// source. These services are listed as Supported [V2 Permissions] in the table at [Enabling logging from Amazon Web Services services.]
	//
	// The contents of the policy must include two statements. One statement enables
	// general logs delivery, and the other allows delivery to the chosen destination.
	// See the examples for the needed policies.
	//
	// [PutDeliveryDestination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html
	// [PutDeliverySource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html
	// [Enabling logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	// [CreateDelivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html
	PutDeliveryDestinationPolicy(ctx context.Context, params *cloudwatchlogs.PutDeliveryDestinationPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDeliveryDestinationPolicyOutput, error)
	// Creates or updates a logical delivery source. A delivery source represents an
	// Amazon Web Services resource that sends logs to an logs delivery destination.
	// The destination can be CloudWatch Logs, Amazon S3, Firehose or X-Ray for sending
	// traces.
	//
	// To configure logs delivery between a delivery destination and an Amazon Web
	// Services service that is supported as a delivery source, you must do the
	// following:
	//
	//   - Use PutDeliverySource to create a delivery source, which is a logical object
	//     that represents the resource that is actually sending the logs.
	//
	//   - Use PutDeliveryDestination to create a delivery destination, which is a
	//     logical object that represents the actual delivery destination. For more
	//     information, see [PutDeliveryDestination].
	//
	//   - If you are delivering logs cross-account, you must use [PutDeliveryDestinationPolicy]in the destination
	//     account to assign an IAM policy to the destination. This policy allows delivery
	//     to that destination.
	//
	//   - Use CreateDelivery to create a delivery by pairing exactly one delivery
	//     source and one delivery destination. For more information, see [CreateDelivery].
	//
	// You can configure a single delivery source to send logs to multiple
	// destinations by creating multiple deliveries. You can also create multiple
	// deliveries to configure multiple delivery sources to send logs to the same
	// delivery destination.
	//
	// Only some Amazon Web Services services support being configured as a delivery
	// source. These services are listed as Supported [V2 Permissions] in the table at [Enabling logging from Amazon Web Services services.]
	//
	// If you use this operation to update an existing delivery source, all the
	// current delivery source parameters are overwritten with the new parameter values
	// that you specify.
	//
	// [PutDeliveryDestination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html
	// [Enabling logging from Amazon Web Services services.]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html
	// [CreateDelivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html
	// [PutDeliveryDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html
	PutDeliverySource(ctx context.Context, params *cloudwatchlogs.PutDeliverySourceInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDeliverySourceOutput, error)
	// Creates or updates a destination. This operation is used only to create
	// destinations for cross-account subscriptions.
	//
	// A destination encapsulates a physical resource (such as an Amazon Kinesis
	// stream). With a destination, you can subscribe to a real-time stream of log
	// events for a different account, ingested using [PutLogEvents].
	//
	// Through an access policy, a destination controls what is written to it. By
	// default, PutDestination does not set any access policy with the destination,
	// which means a cross-account user cannot call [PutSubscriptionFilter]against this destination. To
	// enable this, the destination owner must call [PutDestinationPolicy]after PutDestination .
	//
	// To perform a PutDestination operation, you must also have the iam:PassRole
	// permission.
	//
	// [PutSubscriptionFilter]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html
	// [PutLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html
	// [PutDestinationPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html
	PutDestination(ctx context.Context, params *cloudwatchlogs.PutDestinationInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDestinationOutput, error)
	// Creates or updates an access policy associated with an existing destination. An
	// access policy is an [IAM policy document]that is used to authorize claims to register a subscription
	// filter against a given destination.
	//
	// [IAM policy document]: https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html
	PutDestinationPolicy(ctx context.Context, params *cloudwatchlogs.PutDestinationPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutDestinationPolicyOutput, error)
	// Creates or updates a field index policy for the specified log group. Only log
	// groups in the Standard log class support field index policies. For more
	// information about log classes, see [Log classes].
	//
	// You can use field index policies to create field indexes on fields found in log
	// events in the log group. Creating field indexes speeds up and lowers the costs
	// for CloudWatch Logs Insights queries that reference those field indexes, because
	// these queries attempt to skip the processing of log events that are known to not
	// match the indexed field. Good fields to index are fields that you often need to
	// query for and fields or values that match only a small fraction of the total log
	// events. Common examples of indexes include request ID, session ID, userID, and
	// instance IDs. For more information, see [Create field indexes to improve query performance and reduce costs].
	//
	// To find the fields that are in your log group events, use the [GetLogGroupFields] operation.
	//
	// For example, suppose you have created a field index for requestId . Then, any
	// CloudWatch Logs Insights query on that log group that includes requestId =
	// value or requestId IN [value, value, ...] will process fewer log events to
	// reduce costs, and have improved performance.
	//
	// CloudWatch Logs provides default field indexes for all log groups in the
	// Standard log class. Default field indexes are automatically available for the
	// following fields:
	//
	//   - @logStream
	//
	//   - @aws.region
	//
	//   - @aws.account
	//
	//   - @source.log
	//
	//   - traceId
	//
	// Default field indexes are in addition to any custom field indexes you define
	// within your policy. Default field indexes are not counted towards your field
	// index quota.
	//
	// Each index policy has the following quotas and restrictions:
	//
	//   - As many as 20 fields can be included in the policy.
	//
	//   - Each field name can include as many as 100 characters.
	//
	// Matches of log events to the names of indexed fields are case-sensitive. For
	// example, a field index of RequestId won't match a log event containing requestId
	// .
	//
	// Log group-level field index policies created with PutIndexPolicy override
	// account-level field index policies created with [PutAccountPolicy]. If you use PutIndexPolicy to
	// create a field index policy for a log group, that log group uses only that
	// policy. The log group ignores any account-wide field index policy that you might
	// have created.
	//
	// [Log classes]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html
	// [GetLogGroupFields]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html
	// [PutAccountPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html
	// [Create field indexes to improve query performance and reduce costs]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html
	PutIndexPolicy(ctx context.Context, params *cloudwatchlogs.PutIndexPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutIndexPolicyOutput, error)
	// Creates an integration between CloudWatch Logs and another service in this
	// account. Currently, only integrations with OpenSearch Service are supported, and
	// currently you can have only one integration in your account.
	//
	// Integrating with OpenSearch Service makes it possible for you to create curated
	// vended logs dashboards, powered by OpenSearch Service analytics. For more
	// information, see [Vended log dashboards powered by Amazon OpenSearch Service].
	//
	// You can use this operation only to create a new integration. You can't modify
	// an existing integration.
	//
	// [Vended log dashboards powered by Amazon OpenSearch Service]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-OpenSearch-Dashboards.html
	PutIntegration(ctx context.Context, params *cloudwatchlogs.PutIntegrationInput, optFns ...func(*Options)) (*cloudwatchlogs.PutIntegrationOutput, error)
	// Uploads a batch of log events to the specified log stream.
	//
	// The sequence token is now ignored in PutLogEvents actions. PutLogEvents actions
	// are always accepted and never return InvalidSequenceTokenException or
	// DataAlreadyAcceptedException even if the sequence token is not valid. You can
	// use parallel PutLogEvents actions on the same log stream.
	//
	// The batch of events must satisfy the following constraints:
	//
	//   - The maximum batch size is 1,048,576 bytes. This size is calculated as the
	//     sum of all event messages in UTF-8, plus 26 bytes for each log event.
	//
	//   - Events more than 2 hours in the future are rejected while processing
	//     remaining valid events.
	//
	//   - Events older than 14 days or preceding the log group's retention period are
	//     rejected while processing remaining valid events.
	//
	//   - The log events in the batch must be in chronological order by their
	//     timestamp. The timestamp is the time that the event occurred, expressed as the
	//     number of milliseconds after Jan 1, 1970 00:00:00 UTC . (In Amazon Web
	//     Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the
	//     timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss . For example,
	//     2017-09-15T13:45:30 .)
	//
	//   - A batch of log events in a single request must be in a chronological order.
	//     Otherwise, the operation fails.
	//
	//   - Each log event can be no larger than 1 MB.
	//
	//   - The maximum number of log events in a batch is 10,000.
	//
	//   - For valid events (within 14 days in the past to 2 hours in future), the
	//     time span in a single batch cannot exceed 24 hours. Otherwise, the operation
	//     fails.
	//
	// The quota of five requests per second per log stream has been removed. Instead,
	// PutLogEvents actions are throttled based on a per-second per-account quota. You
	// can request an increase to the per-second throttling quota by using the Service
	// Quotas service.
	//
	// If a call to PutLogEvents returns "UnrecognizedClientException" the most likely
	// cause is a non-valid Amazon Web Services access key ID or secret key.
	PutLogEvents(ctx context.Context, params *cloudwatchlogs.PutLogEventsInput, optFns ...func(*Options)) (*cloudwatchlogs.PutLogEventsOutput, error)
	// Enables or disables deletion protection for the specified log group. When
	// enabled on a log group, deletion protection blocks all deletion operations until
	// it is explicitly disabled.
	//
	// For information about the parameters that are common to all actions, see [Common Parameters].
	//
	// [Common Parameters]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/CommonParameters.html
	PutLogGroupDeletionProtection(ctx context.Context, params *cloudwatchlogs.PutLogGroupDeletionProtectionInput, optFns ...func(*Options)) (*cloudwatchlogs.PutLogGroupDeletionProtectionOutput, error)
	// Creates or updates a metric filter and associates it with the specified log
	// group. With metric filters, you can configure rules to extract metric data from
	// log events ingested through [PutLogEvents].
	//
	// The maximum number of metric filters that can be associated with a log group is
	// 100.
	//
	// Using regular expressions in filter patterns is supported. For these filters,
	// there is a quota of two regular expression patterns within a single filter
	// pattern. There is also a quota of five regular expression patterns per log
	// group. For more information about using regular expressions in filter patterns,
	// see [Filter pattern syntax for metric filters, subscription filters, filter log events, and Live Tail].
	//
	// When you create a metric filter, you can also optionally assign a unit and
	// dimensions to the metric that is created.
	//
	// Metrics extracted from log events are charged as custom metrics. To prevent
	// unexpected high charges, do not specify high-cardinality fields such as
	// IPAddress or requestID as dimensions. Each different value found for a
	// dimension is treated as a separate metric and accrues charges as a separate
	// custom metric.
	//
	// CloudWatch Logs might disable a metric filter if it generates 1,000 different
	// name/value pairs for your specified dimensions within one hour.
	//
	// You can also set up a billing alarm to alert you if your charges are higher
	// than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges].
	//
	// [Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html
	// [PutLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html
	// [Filter pattern syntax for metric filters, subscription filters, filter log events, and Live Tail]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
	PutMetricFilter(ctx context.Context, params *cloudwatchlogs.PutMetricFilterInput, optFns ...func(*Options)) (*cloudwatchlogs.PutMetricFilterOutput, error)
	// Creates or updates a query definition for CloudWatch Logs Insights. For more
	// information, see [Analyzing Log Data with CloudWatch Logs Insights].
	//
	// To update a query definition, specify its queryDefinitionId in your request.
	// The values of name , queryString , and logGroupNames are changed to the values
	// that you specify in your update operation. No current values are retained from
	// the current query definition. For example, imagine updating a current query
	// definition that includes log groups. If you don't specify the logGroupNames
	// parameter in your update operation, the query definition changes to contain no
	// log groups.
	//
	// You must have the logs:PutQueryDefinition permission to be able to perform this
	// operation.
	//
	// [Analyzing Log Data with CloudWatch Logs Insights]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html
	PutQueryDefinition(ctx context.Context, params *cloudwatchlogs.PutQueryDefinitionInput, optFns ...func(*Options)) (*cloudwatchlogs.PutQueryDefinitionOutput, error)
	// Creates or updates a resource policy allowing other Amazon Web Services
	// services to put log events to this account, such as Amazon Route 53. This API
	// has the following restrictions:
	//
	//   - Supported actions - Policy only supports logs:PutLogEvents and
	//     logs:CreateLogStream actions
	//
	//   - Supported principals - Policy only applies when operations are invoked by
	//     Amazon Web Services service principals (not IAM users, roles, or cross-account
	//     principals
	//
	//   - Policy limits - An account can have a maximum of 10 policies without
	//     resourceARN and one per LogGroup resourceARN
	//
	// Resource policies with actions invoked by non-Amazon Web Services service
	// principals (such as IAM users, roles, or other Amazon Web Services accounts)
	// will not be enforced. For access control involving these principals, use the IAM
	// policies.
	PutResourcePolicy(ctx context.Context, params *cloudwatchlogs.PutResourcePolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutResourcePolicyOutput, error)
	// Sets the retention of the specified log group. With a retention policy, you can
	// configure the number of days for which to retain log events in the specified log
	// group.
	//
	// CloudWatch Logs doesn't immediately delete log events when they reach their
	// retention setting. It typically takes up to 72 hours after that before log
	// events are deleted, but in rare situations might take longer.
	//
	// To illustrate, imagine that you change a log group to have a longer retention
	// setting when it contains log events that are past the expiration date, but
	// haven't been deleted. Those log events will take up to 72 hours to be deleted
	// after the new retention date is reached. To make sure that log data is deleted
	// permanently, keep a log group at its lower retention setting until 72 hours
	// after the previous retention period ends. Alternatively, wait to change the
	// retention setting until you confirm that the earlier log events are deleted.
	//
	// When log events reach their retention setting they are marked for deletion.
	// After they are marked for deletion, they do not add to your archival storage
	// costs anymore, even if they are not actually deleted until later. These log
	// events marked for deletion are also not included when you use an API to retrieve
	// the storedBytes value to see how many bytes a log group is storing.
	PutRetentionPolicy(ctx context.Context, params *cloudwatchlogs.PutRetentionPolicyInput, optFns ...func(*Options)) (*cloudwatchlogs.PutRetentionPolicyOutput, error)
	// Creates or updates a subscription filter and associates it with the specified
	// log group. With subscription filters, you can subscribe to a real-time stream of
	// log events ingested through [PutLogEvents]and have them delivered to a specific destination.
	// When log events are sent to the receiving service, they are Base64 encoded and
	// compressed with the GZIP format.
	//
	// The following destinations are supported for subscription filters:
	//
	//   - An Amazon Kinesis data stream belonging to the same account as the
	//     subscription filter, for same-account delivery.
	//
	//   - A logical destination created with [PutDestination]that belongs to a different account, for
	//     cross-account delivery. We currently support Kinesis Data Streams and Firehose
	//     as logical destinations.
	//
	//   - An Amazon Kinesis Data Firehose delivery stream that belongs to the same
	//     account as the subscription filter, for same-account delivery.
	//
	//   - An Lambda function that belongs to the same account as the subscription
	//     filter, for same-account delivery.
	//
	// Each log group can have up to two subscription filters associated with it. If
	// you are updating an existing filter, you must specify the correct name in
	// filterName .
	//
	// Using regular expressions in filter patterns is supported. For these filters,
	// there is a quotas of quota of two regular expression patterns within a single
	// filter pattern. There is also a quota of five regular expression patterns per
	// log group. For more information about using regular expressions in filter
	// patterns, see [Filter pattern syntax for metric filters, subscription filters, filter log events, and Live Tail].
	//
	// To perform a PutSubscriptionFilter operation for any destination except a
	// Lambda function, you must also have the iam:PassRole permission.
	//
	// [PutDestination]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html
	// [PutLogEvents]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html
	// [Filter pattern syntax for metric filters, subscription filters, filter log events, and Live Tail]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html
	PutSubscriptionFilter(ctx context.Context, params *cloudwatchlogs.PutSubscriptionFilterInput, optFns ...func(*Options)) (*cloudwatchlogs.PutSubscriptionFilterOutput, error)
	// Creates or updates a log transformer for a single log group. You use log
	// transformers to transform log events into a different format, making them easier
	// for you to process and analyze. You can also transform logs from different
	// sources into standardized formats that contains relevant, source-specific
	// information.
	//
	// After you have created a transformer, CloudWatch Logs performs the
	// transformations at the time of log ingestion. You can then refer to the
	// transformed versions of the logs during operations such as querying with
	// CloudWatch Logs Insights or creating metric filters or subscription filers.
	//
	// You can also use a transformer to copy metadata from metadata keys into the log
	// events themselves. This metadata can include log group name, log stream name,
	// account ID and Region.
	//
	// A transformer for a log group is a series of processors, where each processor
	// applies one type of transformation to the log events ingested into this log
	// group. The processors work one after another, in the order that you list them,
	// like a pipeline. For more information about the available processors to use in a
	// transformer, see [Processors that you can use].
	//
	// Having log events in standardized format enables visibility across your
	// applications for your log analysis, reporting, and alarming needs. CloudWatch
	// Logs provides transformation for common log types with out-of-the-box
	// transformation templates for major Amazon Web Services log sources such as VPC
	// flow logs, Lambda, and Amazon RDS. You can use pre-built transformation
	// templates or create custom transformation policies.
	//
	// You can create transformers only for the log groups in the Standard log class.
	//
	// You can also set up a transformer at the account level. For more information,
	// see [PutAccountPolicy]. If there is both a log-group level transformer created with PutTransformer
	// and an account-level transformer that could apply to the same log group, the log
	// group uses only the log-group level transformer. It ignores the account-level
	// transformer.
	//
	// [Processors that you can use]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors
	// [PutAccountPolicy]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html
	PutTransformer(ctx context.Context, params *cloudwatchlogs.PutTransformerInput, optFns ...func(*Options)) (*cloudwatchlogs.PutTransformerOutput, error)
	// Starts a Live Tail streaming session for one or more log groups. A Live Tail
	// session returns a stream of log events that have been recently ingested in the
	// log groups. For more information, see [Use Live Tail to view logs in near real time].
	//
	// The response to this operation is a response stream, over which the server
	// sends live log events and the client receives them.
	//
	// The following objects are sent over the stream:
	//
	//   - A single [LiveTailSessionStart]object is sent at the start of the session.
	//
	//   - Every second, a [LiveTailSessionUpdate]object is sent. Each of these objects contains an array of
	//     the actual log events.
	//
	// If no new log events were ingested in the past second, the LiveTailSessionUpdate
	//
	//	object will contain an empty array.
	//
	// The array of log events contained in a LiveTailSessionUpdate can include as many
	//
	//	as 500 log events. If the number of log events matching the request exceeds 500
	//	per second, the log events are sampled down to 500 log events to be included in
	//	each LiveTailSessionUpdate object.
	//
	// If your client consumes the log events slower than the server produces them,
	//
	//	CloudWatch Logs buffers up to 10 LiveTailSessionUpdate events or 5000 log
	//	events, after which it starts dropping the oldest events.
	//
	//	- A [SessionStreamingException]object is returned if an unknown error occurs on the server side.
	//
	//	- A [SessionTimeoutException]object is returned when the session times out, after it has been kept
	//	open for three hours.
	//
	// The StartLiveTail API routes requests to streaming-logs.Region.amazonaws.com
	// using SDK host prefix injection. VPC endpoint support is not available for this
	// API.
	//
	// You can end a session before it times out by closing the session stream or by
	// closing the client that is receiving the stream. The session also ends if the
	// established connection between the client and the server breaks.
	//
	// For examples of using an SDK to start a Live Tail session, see [Start a Live Tail session using an Amazon Web Services SDK].
	//
	// [LiveTailSessionStart]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionStart.html
	// [LiveTailSessionUpdate]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_LiveTailSessionUpdate.html
	// [Use Live Tail to view logs in near real time]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html
	// [Start a Live Tail session using an Amazon Web Services SDK]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/example_cloudwatch-logs_StartLiveTail_section.html
	//
	// [SessionTimeoutException]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionTimeoutException
	// [SessionStreamingException]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartLiveTailResponseStream.html#CWL-Type-StartLiveTailResponseStream-SessionStreamingException
	StartLiveTail(ctx context.Context, params *cloudwatchlogs.StartLiveTailInput, optFns ...func(*Options)) (*cloudwatchlogs.StartLiveTailOutput, error)
	// Starts a query of one or more log groups using CloudWatch Logs Insights. You
	// specify the log groups and time range to query and the query string to use.
	//
	// For more information, see [CloudWatch Logs Insights Query Syntax].
	//
	// After you run a query using StartQuery , the query results are stored by
	// CloudWatch Logs. You can use [GetQueryResults]to retrieve the results of a query, using the
	// queryId that StartQuery returns.
	//
	// To specify the log groups to query, a StartQuery operation must include one of
	// the following:
	//
	//   - Either exactly one of the following parameters: logGroupName , logGroupNames
	//     , or logGroupIdentifiers
	//
	//   - Or the queryString must include a SOURCE command to select log groups for
	//     the query. The SOURCE command can select log groups based on log group name
	//     prefix, account ID, and log class.
	//
	// For more information about the SOURCE command, see [SOURCE].
	//
	// If you have associated a KMS key with the query results in this account, then [StartQuery]
	// uses that key to encrypt the results when it stores them. If no key is
	// associated with query results, the query results are encrypted with the default
	// CloudWatch Logs encryption method.
	//
	// Queries time out after 60 minutes of runtime. If your queries are timing out,
	// reduce the time range being searched or partition your query into a number of
	// queries.
	//
	// If you are using CloudWatch cross-account observability, you can use this
	// operation in a monitoring account to start a query in a linked source account.
	// For more information, see [CloudWatch cross-account observability]. For a cross-account StartQuery operation, the query
	// definition must be defined in the monitoring account.
	//
	// You can have up to 30 concurrent CloudWatch Logs insights queries, including
	// queries that have been added to dashboards.
	//
	// [CloudWatch Logs Insights Query Syntax]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html
	// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
	// [SOURCE]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax-Source.html
	// [GetQueryResults]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html
	// [StartQuery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html
	StartQuery(ctx context.Context, params *cloudwatchlogs.StartQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.StartQueryOutput, error)
	// Stops a CloudWatch Logs Insights query that is in progress. If the query has
	// already ended, the operation returns an error indicating that the specified
	// query is not running.
	StopQuery(ctx context.Context, params *cloudwatchlogs.StopQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.StopQueryOutput, error)
	// The TagLogGroup operation is on the path to deprecation. We recommend that you
	// use [TagResource]instead.
	//
	// Adds or updates the specified tags for the specified log group.
	//
	// To list the tags for a log group, use [ListTagsForResource]. To remove tags, use [UntagResource].
	//
	// For more information about tags, see [Tag Log Groups in Amazon CloudWatch Logs] in the Amazon CloudWatch Logs User Guide.
	//
	// CloudWatch Logs doesn't support IAM policies that prevent users from assigning
	// specified tags to log groups using the aws:Resource/key-name  or aws:TagKeys
	// condition keys. For more information about using tags to control access, see [Controlling access to Amazon Web Services resources using tags].
	//
	// Deprecated: Please use the generic tagging API TagResource
	//
	// [TagResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html
	// [UntagResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html
	// [Tag Log Groups in Amazon CloudWatch Logs]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging
	// [Controlling access to Amazon Web Services resources using tags]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html
	// [ListTagsForResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html
	TagLogGroup(ctx context.Context, params *cloudwatchlogs.TagLogGroupInput, optFns ...func(*Options)) (*cloudwatchlogs.TagLogGroupOutput, error)
	// Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs
	// resource. Currently, the only CloudWatch Logs resources that can be tagged are
	// log groups and destinations.
	//
	// Tags can help you organize and categorize your resources. You can also use them
	// to scope user permissions by granting a user permission to access or change only
	// resources with certain tag values.
	//
	// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
	// strictly as strings of characters.
	//
	// You can use the TagResource action with a resource that already has tags. If
	// you specify a new tag key for the alarm, this tag is appended to the list of
	// tags associated with the alarm. If you specify a tag key that is already
	// associated with the alarm, the new tag value that you specify replaces the
	// previous value for that tag.
	//
	// You can associate as many as 50 tags with a CloudWatch Logs resource.
	TagResource(ctx context.Context, params *cloudwatchlogs.TagResourceInput, optFns ...func(*Options)) (*cloudwatchlogs.TagResourceOutput, error)
	// Tests the filter pattern of a metric filter against a sample of log event
	// messages. You can use this operation to validate the correctness of a metric
	// filter pattern.
	TestMetricFilter(ctx context.Context, params *cloudwatchlogs.TestMetricFilterInput, optFns ...func(*Options)) (*cloudwatchlogs.TestMetricFilterOutput, error)
	// Use this operation to test a log transformer. You enter the transformer
	// configuration and a set of log events to test with. The operation responds with
	// an array that includes the original log events and the transformed versions.
	TestTransformer(ctx context.Context, params *cloudwatchlogs.TestTransformerInput, optFns ...func(*Options)) (*cloudwatchlogs.TestTransformerOutput, error)
	// The UntagLogGroup operation is on the path to deprecation. We recommend that
	// you use [UntagResource]instead.
	//
	// Removes the specified tags from the specified log group.
	//
	// To list the tags for a log group, use [ListTagsForResource]. To add tags, use [TagResource].
	//
	// When using IAM policies to control tag management for CloudWatch Logs log
	// groups, the condition keys aws:Resource/key-name and aws:TagKeys cannot be used
	// to restrict which tags users can assign.
	//
	// Deprecated: Please use the generic tagging API UntagResource
	//
	// [TagResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html
	// [UntagResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html
	// [ListTagsForResource]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html
	UntagLogGroup(ctx context.Context, params *cloudwatchlogs.UntagLogGroupInput, optFns ...func(*Options)) (*cloudwatchlogs.UntagLogGroupOutput, error)
	// Removes one or more tags from the specified resource.
	UntagResource(ctx context.Context, params *cloudwatchlogs.UntagResourceInput, optFns ...func(*Options)) (*cloudwatchlogs.UntagResourceOutput, error)
	// Use this operation to suppress anomaly detection for a specified anomaly or
	// pattern. If you suppress an anomaly, CloudWatch Logs won't report new
	// occurrences of that anomaly and won't update that anomaly with new data. If you
	// suppress a pattern, CloudWatch Logs won't report any anomalies related to that
	// pattern.
	//
	// You must specify either anomalyId or patternId , but you can't specify both
	// parameters in the same operation.
	//
	// If you have previously used this operation to suppress detection of a pattern
	// or anomaly, you can use it again to cause CloudWatch Logs to end the
	// suppression. To do this, use this operation and specify the anomaly or pattern
	// to stop suppressing, and omit the suppressionType and suppressionPeriod
	// parameters.
	UpdateAnomaly(ctx context.Context, params *cloudwatchlogs.UpdateAnomalyInput, optFns ...func(*Options)) (*cloudwatchlogs.UpdateAnomalyOutput, error)
	// Use this operation to update the configuration of a [delivery] to change either the S3
	// path pattern or the format of the delivered logs. You can't use this operation
	// to change the source or destination of the delivery.
	//
	// [delivery]: https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html
	UpdateDeliveryConfiguration(ctx context.Context, params *cloudwatchlogs.UpdateDeliveryConfigurationInput, optFns ...func(*Options)) (*cloudwatchlogs.UpdateDeliveryConfigurationOutput, error)
	// Updates an existing log anomaly detector.
	UpdateLogAnomalyDetector(ctx context.Context, params *cloudwatchlogs.UpdateLogAnomalyDetectorInput, optFns ...func(*Options)) (*cloudwatchlogs.UpdateLogAnomalyDetectorOutput, error)
	// Updates the configuration of an existing scheduled query. This operation
	// follows PUT semantics, replacing the existing configuration with the provided
	// values.
	UpdateScheduledQuery(ctx context.Context, params *cloudwatchlogs.UpdateScheduledQueryInput, optFns ...func(*Options)) (*cloudwatchlogs.UpdateScheduledQueryOutput, error)
}

