/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	core "github.com/gardener/gardener/pkg/apis/core"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PlantLister helps list Plants.
type PlantLister interface {
	// List lists all Plants in the indexer.
	List(selector labels.Selector) (ret []*core.Plant, err error)
	// Plants returns an object that can list and get Plants.
	Plants(namespace string) PlantNamespaceLister
	PlantListerExpansion
}

// plantLister implements the PlantLister interface.
type plantLister struct {
	indexer cache.Indexer
}

// NewPlantLister returns a new PlantLister.
func NewPlantLister(indexer cache.Indexer) PlantLister {
	return &plantLister{indexer: indexer}
}

// List lists all Plants in the indexer.
func (s *plantLister) List(selector labels.Selector) (ret []*core.Plant, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*core.Plant))
	})
	return ret, err
}

// Plants returns an object that can list and get Plants.
func (s *plantLister) Plants(namespace string) PlantNamespaceLister {
	return plantNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PlantNamespaceLister helps list and get Plants.
type PlantNamespaceLister interface {
	// List lists all Plants in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*core.Plant, err error)
	// Get retrieves the Plant from the indexer for a given namespace and name.
	Get(name string) (*core.Plant, error)
	PlantNamespaceListerExpansion
}

// plantNamespaceLister implements the PlantNamespaceLister
// interface.
type plantNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Plants in the indexer for a given namespace.
func (s plantNamespaceLister) List(selector labels.Selector) (ret []*core.Plant, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*core.Plant))
	})
	return ret, err
}

// Get retrieves the Plant from the indexer for a given namespace and name.
func (s plantNamespaceLister) Get(name string) (*core.Plant, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(core.Resource("plant"), name)
	}
	return obj.(*core.Plant), nil
}
