/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeWorkers implements WorkerInterface
type FakeWorkers struct {
	Fake *FakeExtensionsV1alpha1
	ns   string
}

var workersResource = schema.GroupVersionResource{Group: "extensions.gardener.cloud", Version: "v1alpha1", Resource: "workers"}

var workersKind = schema.GroupVersionKind{Group: "extensions.gardener.cloud", Version: "v1alpha1", Kind: "Worker"}

// Get takes name of the worker, and returns the corresponding worker object, and an error if there is any.
func (c *FakeWorkers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Worker, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(workersResource, c.ns, name), &v1alpha1.Worker{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Worker), err
}

// List takes label and field selectors, and returns the list of Workers that match those selectors.
func (c *FakeWorkers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.WorkerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(workersResource, workersKind, c.ns, opts), &v1alpha1.WorkerList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.WorkerList{ListMeta: obj.(*v1alpha1.WorkerList).ListMeta}
	for _, item := range obj.(*v1alpha1.WorkerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested workers.
func (c *FakeWorkers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(workersResource, c.ns, opts))

}

// Create takes the representation of a worker and creates it.  Returns the server's representation of the worker, and an error, if there is any.
func (c *FakeWorkers) Create(ctx context.Context, worker *v1alpha1.Worker, opts v1.CreateOptions) (result *v1alpha1.Worker, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(workersResource, c.ns, worker), &v1alpha1.Worker{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Worker), err
}

// Update takes the representation of a worker and updates it. Returns the server's representation of the worker, and an error, if there is any.
func (c *FakeWorkers) Update(ctx context.Context, worker *v1alpha1.Worker, opts v1.UpdateOptions) (result *v1alpha1.Worker, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(workersResource, c.ns, worker), &v1alpha1.Worker{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Worker), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeWorkers) UpdateStatus(ctx context.Context, worker *v1alpha1.Worker, opts v1.UpdateOptions) (*v1alpha1.Worker, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(workersResource, "status", c.ns, worker), &v1alpha1.Worker{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Worker), err
}

// Delete takes name of the worker and deletes it. Returns an error if one occurs.
func (c *FakeWorkers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(workersResource, c.ns, name), &v1alpha1.Worker{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeWorkers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(workersResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.WorkerList{})
	return err
}

// Patch applies the patch and returns the patched worker.
func (c *FakeWorkers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Worker, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(workersResource, c.ns, name, pt, data, subresources...), &v1alpha1.Worker{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Worker), err
}
