/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// WorkerLister helps list Workers.
type WorkerLister interface {
	// List lists all Workers in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Worker, err error)
	// Workers returns an object that can list and get Workers.
	Workers(namespace string) WorkerNamespaceLister
	WorkerListerExpansion
}

// workerLister implements the WorkerLister interface.
type workerLister struct {
	indexer cache.Indexer
}

// NewWorkerLister returns a new WorkerLister.
func NewWorkerLister(indexer cache.Indexer) WorkerLister {
	return &workerLister{indexer: indexer}
}

// List lists all Workers in the indexer.
func (s *workerLister) List(selector labels.Selector) (ret []*v1alpha1.Worker, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Worker))
	})
	return ret, err
}

// Workers returns an object that can list and get Workers.
func (s *workerLister) Workers(namespace string) WorkerNamespaceLister {
	return workerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// WorkerNamespaceLister helps list and get Workers.
type WorkerNamespaceLister interface {
	// List lists all Workers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Worker, err error)
	// Get retrieves the Worker from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Worker, error)
	WorkerNamespaceListerExpansion
}

// workerNamespaceLister implements the WorkerNamespaceLister
// interface.
type workerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Workers in the indexer for a given namespace.
func (s workerNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Worker, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Worker))
	})
	return ret, err
}

// Get retrieves the Worker from the indexer for a given namespace and name.
func (s workerNamespaceLister) Get(name string) (*v1alpha1.Worker, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("worker"), name)
	}
	return obj.(*v1alpha1.Worker), nil
}
