/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/settings/v1alpha1"
	scheme "github.com/gardener/gardener/pkg/client/settings/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterOpenIDConnectPresetsGetter has a method to return a ClusterOpenIDConnectPresetInterface.
// A group's client should implement this interface.
type ClusterOpenIDConnectPresetsGetter interface {
	ClusterOpenIDConnectPresets() ClusterOpenIDConnectPresetInterface
}

// ClusterOpenIDConnectPresetInterface has methods to work with ClusterOpenIDConnectPreset resources.
type ClusterOpenIDConnectPresetInterface interface {
	Create(ctx context.Context, clusterOpenIDConnectPreset *v1alpha1.ClusterOpenIDConnectPreset, opts v1.CreateOptions) (*v1alpha1.ClusterOpenIDConnectPreset, error)
	Update(ctx context.Context, clusterOpenIDConnectPreset *v1alpha1.ClusterOpenIDConnectPreset, opts v1.UpdateOptions) (*v1alpha1.ClusterOpenIDConnectPreset, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterOpenIDConnectPreset, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterOpenIDConnectPresetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterOpenIDConnectPreset, err error)
	ClusterOpenIDConnectPresetExpansion
}

// clusterOpenIDConnectPresets implements ClusterOpenIDConnectPresetInterface
type clusterOpenIDConnectPresets struct {
	client rest.Interface
}

// newClusterOpenIDConnectPresets returns a ClusterOpenIDConnectPresets
func newClusterOpenIDConnectPresets(c *SettingsV1alpha1Client) *clusterOpenIDConnectPresets {
	return &clusterOpenIDConnectPresets{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterOpenIDConnectPreset, and returns the corresponding clusterOpenIDConnectPreset object, and an error if there is any.
func (c *clusterOpenIDConnectPresets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ClusterOpenIDConnectPreset, err error) {
	result = &v1alpha1.ClusterOpenIDConnectPreset{}
	err = c.client.Get().
		Resource("clusteropenidconnectpresets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterOpenIDConnectPresets that match those selectors.
func (c *clusterOpenIDConnectPresets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ClusterOpenIDConnectPresetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterOpenIDConnectPresetList{}
	err = c.client.Get().
		Resource("clusteropenidconnectpresets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterOpenIDConnectPresets.
func (c *clusterOpenIDConnectPresets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clusteropenidconnectpresets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterOpenIDConnectPreset and creates it.  Returns the server's representation of the clusterOpenIDConnectPreset, and an error, if there is any.
func (c *clusterOpenIDConnectPresets) Create(ctx context.Context, clusterOpenIDConnectPreset *v1alpha1.ClusterOpenIDConnectPreset, opts v1.CreateOptions) (result *v1alpha1.ClusterOpenIDConnectPreset, err error) {
	result = &v1alpha1.ClusterOpenIDConnectPreset{}
	err = c.client.Post().
		Resource("clusteropenidconnectpresets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterOpenIDConnectPreset).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterOpenIDConnectPreset and updates it. Returns the server's representation of the clusterOpenIDConnectPreset, and an error, if there is any.
func (c *clusterOpenIDConnectPresets) Update(ctx context.Context, clusterOpenIDConnectPreset *v1alpha1.ClusterOpenIDConnectPreset, opts v1.UpdateOptions) (result *v1alpha1.ClusterOpenIDConnectPreset, err error) {
	result = &v1alpha1.ClusterOpenIDConnectPreset{}
	err = c.client.Put().
		Resource("clusteropenidconnectpresets").
		Name(clusterOpenIDConnectPreset.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterOpenIDConnectPreset).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterOpenIDConnectPreset and deletes it. Returns an error if one occurs.
func (c *clusterOpenIDConnectPresets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clusteropenidconnectpresets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterOpenIDConnectPresets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clusteropenidconnectpresets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterOpenIDConnectPreset.
func (c *clusterOpenIDConnectPresets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterOpenIDConnectPreset, err error) {
	result = &v1alpha1.ClusterOpenIDConnectPreset{}
	err = c.client.Patch(pt).
		Resource("clusteropenidconnectpresets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
