/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	internalinterfaces "github.com/gardener/gardener/pkg/client/settings/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// ClusterOpenIDConnectPresets returns a ClusterOpenIDConnectPresetInformer.
	ClusterOpenIDConnectPresets() ClusterOpenIDConnectPresetInformer
	// OpenIDConnectPresets returns a OpenIDConnectPresetInformer.
	OpenIDConnectPresets() OpenIDConnectPresetInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// ClusterOpenIDConnectPresets returns a ClusterOpenIDConnectPresetInformer.
func (v *version) ClusterOpenIDConnectPresets() ClusterOpenIDConnectPresetInformer {
	return &clusterOpenIDConnectPresetInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// OpenIDConnectPresets returns a OpenIDConnectPresetInformer.
func (v *version) OpenIDConnectPresets() OpenIDConnectPresetInformer {
	return &openIDConnectPresetInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
