// +build !ignore_autogenerated

/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	config "github.com/gardener/gardener/pkg/controllermanager/apis/config"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	configv1alpha1 "k8s.io/component-base/config/v1alpha1"
	klog "k8s.io/klog"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*CloudProfileControllerConfiguration)(nil), (*config.CloudProfileControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_CloudProfileControllerConfiguration_To_config_CloudProfileControllerConfiguration(a.(*CloudProfileControllerConfiguration), b.(*config.CloudProfileControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.CloudProfileControllerConfiguration)(nil), (*CloudProfileControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_CloudProfileControllerConfiguration_To_v1alpha1_CloudProfileControllerConfiguration(a.(*config.CloudProfileControllerConfiguration), b.(*CloudProfileControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerManagerConfiguration)(nil), (*config.ControllerManagerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerManagerConfiguration_To_config_ControllerManagerConfiguration(a.(*ControllerManagerConfiguration), b.(*config.ControllerManagerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerManagerConfiguration)(nil), (*ControllerManagerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerManagerConfiguration_To_v1alpha1_ControllerManagerConfiguration(a.(*config.ControllerManagerConfiguration), b.(*ControllerManagerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerManagerControllerConfiguration)(nil), (*config.ControllerManagerControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration(a.(*ControllerManagerControllerConfiguration), b.(*config.ControllerManagerControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerManagerControllerConfiguration)(nil), (*ControllerManagerControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration(a.(*config.ControllerManagerControllerConfiguration), b.(*ControllerManagerControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControllerRegistrationControllerConfiguration)(nil), (*config.ControllerRegistrationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ControllerRegistrationControllerConfiguration_To_config_ControllerRegistrationControllerConfiguration(a.(*ControllerRegistrationControllerConfiguration), b.(*config.ControllerRegistrationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ControllerRegistrationControllerConfiguration)(nil), (*ControllerRegistrationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ControllerRegistrationControllerConfiguration_To_v1alpha1_ControllerRegistrationControllerConfiguration(a.(*config.ControllerRegistrationControllerConfiguration), b.(*ControllerRegistrationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*EventControllerConfiguration)(nil), (*config.EventControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_EventControllerConfiguration_To_config_EventControllerConfiguration(a.(*EventControllerConfiguration), b.(*config.EventControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.EventControllerConfiguration)(nil), (*EventControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_EventControllerConfiguration_To_v1alpha1_EventControllerConfiguration(a.(*config.EventControllerConfiguration), b.(*EventControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HTTPSServer)(nil), (*config.HTTPSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(a.(*HTTPSServer), b.(*config.HTTPSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.HTTPSServer)(nil), (*HTTPSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(a.(*config.HTTPSServer), b.(*HTTPSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LeaderElectionConfiguration)(nil), (*config.LeaderElectionConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(a.(*LeaderElectionConfiguration), b.(*config.LeaderElectionConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.LeaderElectionConfiguration)(nil), (*LeaderElectionConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(a.(*config.LeaderElectionConfiguration), b.(*LeaderElectionConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*PlantControllerConfiguration)(nil), (*config.PlantControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PlantControllerConfiguration_To_config_PlantControllerConfiguration(a.(*PlantControllerConfiguration), b.(*config.PlantControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.PlantControllerConfiguration)(nil), (*PlantControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_PlantControllerConfiguration_To_v1alpha1_PlantControllerConfiguration(a.(*config.PlantControllerConfiguration), b.(*PlantControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ProjectControllerConfiguration)(nil), (*config.ProjectControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ProjectControllerConfiguration_To_config_ProjectControllerConfiguration(a.(*ProjectControllerConfiguration), b.(*config.ProjectControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ProjectControllerConfiguration)(nil), (*ProjectControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ProjectControllerConfiguration_To_v1alpha1_ProjectControllerConfiguration(a.(*config.ProjectControllerConfiguration), b.(*ProjectControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*QuotaControllerConfiguration)(nil), (*config.QuotaControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_QuotaControllerConfiguration_To_config_QuotaControllerConfiguration(a.(*QuotaControllerConfiguration), b.(*config.QuotaControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.QuotaControllerConfiguration)(nil), (*QuotaControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_QuotaControllerConfiguration_To_v1alpha1_QuotaControllerConfiguration(a.(*config.QuotaControllerConfiguration), b.(*QuotaControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecretBindingControllerConfiguration)(nil), (*config.SecretBindingControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SecretBindingControllerConfiguration_To_config_SecretBindingControllerConfiguration(a.(*SecretBindingControllerConfiguration), b.(*config.SecretBindingControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SecretBindingControllerConfiguration)(nil), (*SecretBindingControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SecretBindingControllerConfiguration_To_v1alpha1_SecretBindingControllerConfiguration(a.(*config.SecretBindingControllerConfiguration), b.(*SecretBindingControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SeedControllerConfiguration)(nil), (*config.SeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(a.(*SeedControllerConfiguration), b.(*config.SeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.SeedControllerConfiguration)(nil), (*SeedControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(a.(*config.SeedControllerConfiguration), b.(*SeedControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Server)(nil), (*config.Server)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Server_To_config_Server(a.(*Server), b.(*config.Server), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.Server)(nil), (*Server)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Server_To_v1alpha1_Server(a.(*config.Server), b.(*Server), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ServerConfiguration)(nil), (*config.ServerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(a.(*ServerConfiguration), b.(*config.ServerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ServerConfiguration)(nil), (*ServerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(a.(*config.ServerConfiguration), b.(*ServerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootHibernationControllerConfiguration)(nil), (*config.ShootHibernationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration(a.(*ShootHibernationControllerConfiguration), b.(*config.ShootHibernationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootHibernationControllerConfiguration)(nil), (*ShootHibernationControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration(a.(*config.ShootHibernationControllerConfiguration), b.(*ShootHibernationControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootMaintenanceControllerConfiguration)(nil), (*config.ShootMaintenanceControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration(a.(*ShootMaintenanceControllerConfiguration), b.(*config.ShootMaintenanceControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootMaintenanceControllerConfiguration)(nil), (*ShootMaintenanceControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration(a.(*config.ShootMaintenanceControllerConfiguration), b.(*ShootMaintenanceControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ShootQuotaControllerConfiguration)(nil), (*config.ShootQuotaControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration(a.(*ShootQuotaControllerConfiguration), b.(*config.ShootQuotaControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.ShootQuotaControllerConfiguration)(nil), (*ShootQuotaControllerConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration(a.(*config.ShootQuotaControllerConfiguration), b.(*ShootQuotaControllerConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*TLSServer)(nil), (*config.TLSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_TLSServer_To_config_TLSServer(a.(*TLSServer), b.(*config.TLSServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.TLSServer)(nil), (*TLSServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_TLSServer_To_v1alpha1_TLSServer(a.(*config.TLSServer), b.(*TLSServer), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_CloudProfileControllerConfiguration_To_config_CloudProfileControllerConfiguration(in *CloudProfileControllerConfiguration, out *config.CloudProfileControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_v1alpha1_CloudProfileControllerConfiguration_To_config_CloudProfileControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_CloudProfileControllerConfiguration_To_config_CloudProfileControllerConfiguration(in *CloudProfileControllerConfiguration, out *config.CloudProfileControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_CloudProfileControllerConfiguration_To_config_CloudProfileControllerConfiguration(in, out, s)
}

func autoConvert_config_CloudProfileControllerConfiguration_To_v1alpha1_CloudProfileControllerConfiguration(in *config.CloudProfileControllerConfiguration, out *CloudProfileControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_config_CloudProfileControllerConfiguration_To_v1alpha1_CloudProfileControllerConfiguration is an autogenerated conversion function.
func Convert_config_CloudProfileControllerConfiguration_To_v1alpha1_CloudProfileControllerConfiguration(in *config.CloudProfileControllerConfiguration, out *CloudProfileControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_CloudProfileControllerConfiguration_To_v1alpha1_CloudProfileControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ControllerManagerConfiguration_To_config_ControllerManagerConfiguration(in *ControllerManagerConfiguration, out *config.ControllerManagerConfiguration, s conversion.Scope) error {
	if err := configv1alpha1.Convert_v1alpha1_ClientConnectionConfiguration_To_config_ClientConnectionConfiguration(&in.GardenClientConnection, &out.GardenClientConnection, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration(&in.Controllers, &out.Controllers, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(&in.LeaderElection, &out.LeaderElection, s); err != nil {
		return err
	}
	out.LogLevel = in.LogLevel
	out.KubernetesLogLevel = klog.Level(in.KubernetesLogLevel)
	if err := Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(&in.Server, &out.Server, s); err != nil {
		return err
	}
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_v1alpha1_ControllerManagerConfiguration_To_config_ControllerManagerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerManagerConfiguration_To_config_ControllerManagerConfiguration(in *ControllerManagerConfiguration, out *config.ControllerManagerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerManagerConfiguration_To_config_ControllerManagerConfiguration(in, out, s)
}

func autoConvert_config_ControllerManagerConfiguration_To_v1alpha1_ControllerManagerConfiguration(in *config.ControllerManagerConfiguration, out *ControllerManagerConfiguration, s conversion.Scope) error {
	if err := configv1alpha1.Convert_config_ClientConnectionConfiguration_To_v1alpha1_ClientConnectionConfiguration(&in.GardenClientConnection, &out.GardenClientConnection, s); err != nil {
		return err
	}
	if err := Convert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration(&in.Controllers, &out.Controllers, s); err != nil {
		return err
	}
	if err := Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(&in.LeaderElection, &out.LeaderElection, s); err != nil {
		return err
	}
	out.LogLevel = in.LogLevel
	out.KubernetesLogLevel = klog.Level(in.KubernetesLogLevel)
	if err := Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(&in.Server, &out.Server, s); err != nil {
		return err
	}
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	return nil
}

// Convert_config_ControllerManagerConfiguration_To_v1alpha1_ControllerManagerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerManagerConfiguration_To_v1alpha1_ControllerManagerConfiguration(in *config.ControllerManagerConfiguration, out *ControllerManagerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerManagerConfiguration_To_v1alpha1_ControllerManagerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration(in *ControllerManagerControllerConfiguration, out *config.ControllerManagerControllerConfiguration, s conversion.Scope) error {
	out.CloudProfile = (*config.CloudProfileControllerConfiguration)(unsafe.Pointer(in.CloudProfile))
	out.ControllerRegistration = (*config.ControllerRegistrationControllerConfiguration)(unsafe.Pointer(in.ControllerRegistration))
	out.Event = (*config.EventControllerConfiguration)(unsafe.Pointer(in.Event))
	out.Plant = (*config.PlantControllerConfiguration)(unsafe.Pointer(in.Plant))
	out.Project = (*config.ProjectControllerConfiguration)(unsafe.Pointer(in.Project))
	out.Quota = (*config.QuotaControllerConfiguration)(unsafe.Pointer(in.Quota))
	out.SecretBinding = (*config.SecretBindingControllerConfiguration)(unsafe.Pointer(in.SecretBinding))
	out.Seed = (*config.SeedControllerConfiguration)(unsafe.Pointer(in.Seed))
	if err := Convert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration(&in.ShootMaintenance, &out.ShootMaintenance, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration(&in.ShootQuota, &out.ShootQuota, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration(&in.ShootHibernation, &out.ShootHibernation, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration(in *ControllerManagerControllerConfiguration, out *config.ControllerManagerControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerManagerControllerConfiguration_To_config_ControllerManagerControllerConfiguration(in, out, s)
}

func autoConvert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration(in *config.ControllerManagerControllerConfiguration, out *ControllerManagerControllerConfiguration, s conversion.Scope) error {
	out.CloudProfile = (*CloudProfileControllerConfiguration)(unsafe.Pointer(in.CloudProfile))
	out.ControllerRegistration = (*ControllerRegistrationControllerConfiguration)(unsafe.Pointer(in.ControllerRegistration))
	out.Event = (*EventControllerConfiguration)(unsafe.Pointer(in.Event))
	out.Plant = (*PlantControllerConfiguration)(unsafe.Pointer(in.Plant))
	out.Project = (*ProjectControllerConfiguration)(unsafe.Pointer(in.Project))
	out.Quota = (*QuotaControllerConfiguration)(unsafe.Pointer(in.Quota))
	out.SecretBinding = (*SecretBindingControllerConfiguration)(unsafe.Pointer(in.SecretBinding))
	out.Seed = (*SeedControllerConfiguration)(unsafe.Pointer(in.Seed))
	if err := Convert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration(&in.ShootMaintenance, &out.ShootMaintenance, s); err != nil {
		return err
	}
	if err := Convert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration(&in.ShootQuota, &out.ShootQuota, s); err != nil {
		return err
	}
	if err := Convert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration(&in.ShootHibernation, &out.ShootHibernation, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration(in *config.ControllerManagerControllerConfiguration, out *ControllerManagerControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerManagerControllerConfiguration_To_v1alpha1_ControllerManagerControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ControllerRegistrationControllerConfiguration_To_config_ControllerRegistrationControllerConfiguration(in *ControllerRegistrationControllerConfiguration, out *config.ControllerRegistrationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_v1alpha1_ControllerRegistrationControllerConfiguration_To_config_ControllerRegistrationControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ControllerRegistrationControllerConfiguration_To_config_ControllerRegistrationControllerConfiguration(in *ControllerRegistrationControllerConfiguration, out *config.ControllerRegistrationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ControllerRegistrationControllerConfiguration_To_config_ControllerRegistrationControllerConfiguration(in, out, s)
}

func autoConvert_config_ControllerRegistrationControllerConfiguration_To_v1alpha1_ControllerRegistrationControllerConfiguration(in *config.ControllerRegistrationControllerConfiguration, out *ControllerRegistrationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_config_ControllerRegistrationControllerConfiguration_To_v1alpha1_ControllerRegistrationControllerConfiguration is an autogenerated conversion function.
func Convert_config_ControllerRegistrationControllerConfiguration_To_v1alpha1_ControllerRegistrationControllerConfiguration(in *config.ControllerRegistrationControllerConfiguration, out *ControllerRegistrationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ControllerRegistrationControllerConfiguration_To_v1alpha1_ControllerRegistrationControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_EventControllerConfiguration_To_config_EventControllerConfiguration(in *EventControllerConfiguration, out *config.EventControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.TTLNonShootEvents = (*v1.Duration)(unsafe.Pointer(in.TTLNonShootEvents))
	return nil
}

// Convert_v1alpha1_EventControllerConfiguration_To_config_EventControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_EventControllerConfiguration_To_config_EventControllerConfiguration(in *EventControllerConfiguration, out *config.EventControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_EventControllerConfiguration_To_config_EventControllerConfiguration(in, out, s)
}

func autoConvert_config_EventControllerConfiguration_To_v1alpha1_EventControllerConfiguration(in *config.EventControllerConfiguration, out *EventControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.TTLNonShootEvents = (*v1.Duration)(unsafe.Pointer(in.TTLNonShootEvents))
	return nil
}

// Convert_config_EventControllerConfiguration_To_v1alpha1_EventControllerConfiguration is an autogenerated conversion function.
func Convert_config_EventControllerConfiguration_To_v1alpha1_EventControllerConfiguration(in *config.EventControllerConfiguration, out *EventControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_EventControllerConfiguration_To_v1alpha1_EventControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in *HTTPSServer, out *config.HTTPSServer, s conversion.Scope) error {
	if err := Convert_v1alpha1_Server_To_config_Server(&in.Server, &out.Server, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_TLSServer_To_config_TLSServer(&in.TLS, &out.TLS, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer is an autogenerated conversion function.
func Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in *HTTPSServer, out *config.HTTPSServer, s conversion.Scope) error {
	return autoConvert_v1alpha1_HTTPSServer_To_config_HTTPSServer(in, out, s)
}

func autoConvert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in *config.HTTPSServer, out *HTTPSServer, s conversion.Scope) error {
	if err := Convert_config_Server_To_v1alpha1_Server(&in.Server, &out.Server, s); err != nil {
		return err
	}
	if err := Convert_config_TLSServer_To_v1alpha1_TLSServer(&in.TLS, &out.TLS, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer is an autogenerated conversion function.
func Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in *config.HTTPSServer, out *HTTPSServer, s conversion.Scope) error {
	return autoConvert_config_HTTPSServer_To_v1alpha1_HTTPSServer(in, out, s)
}

func autoConvert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(in *LeaderElectionConfiguration, out *config.LeaderElectionConfiguration, s conversion.Scope) error {
	if err := configv1alpha1.Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(&in.LeaderElectionConfiguration, &out.LeaderElectionConfiguration, s); err != nil {
		return err
	}
	out.LockObjectNamespace = in.LockObjectNamespace
	out.LockObjectName = in.LockObjectName
	return nil
}

// Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(in *LeaderElectionConfiguration, out *config.LeaderElectionConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_LeaderElectionConfiguration_To_config_LeaderElectionConfiguration(in, out, s)
}

func autoConvert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in *config.LeaderElectionConfiguration, out *LeaderElectionConfiguration, s conversion.Scope) error {
	if err := configv1alpha1.Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(&in.LeaderElectionConfiguration, &out.LeaderElectionConfiguration, s); err != nil {
		return err
	}
	out.LockObjectNamespace = in.LockObjectNamespace
	out.LockObjectName = in.LockObjectName
	return nil
}

// Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration is an autogenerated conversion function.
func Convert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in *config.LeaderElectionConfiguration, out *LeaderElectionConfiguration, s conversion.Scope) error {
	return autoConvert_config_LeaderElectionConfiguration_To_v1alpha1_LeaderElectionConfiguration(in, out, s)
}

func autoConvert_v1alpha1_PlantControllerConfiguration_To_config_PlantControllerConfiguration(in *PlantControllerConfiguration, out *config.PlantControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_v1alpha1_PlantControllerConfiguration_To_config_PlantControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_PlantControllerConfiguration_To_config_PlantControllerConfiguration(in *PlantControllerConfiguration, out *config.PlantControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_PlantControllerConfiguration_To_config_PlantControllerConfiguration(in, out, s)
}

func autoConvert_config_PlantControllerConfiguration_To_v1alpha1_PlantControllerConfiguration(in *config.PlantControllerConfiguration, out *PlantControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_config_PlantControllerConfiguration_To_v1alpha1_PlantControllerConfiguration is an autogenerated conversion function.
func Convert_config_PlantControllerConfiguration_To_v1alpha1_PlantControllerConfiguration(in *config.PlantControllerConfiguration, out *PlantControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_PlantControllerConfiguration_To_v1alpha1_PlantControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ProjectControllerConfiguration_To_config_ProjectControllerConfiguration(in *ProjectControllerConfiguration, out *config.ProjectControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.MinimumLifetimeDays = (*int)(unsafe.Pointer(in.MinimumLifetimeDays))
	out.StaleGracePeriodDays = (*int)(unsafe.Pointer(in.StaleGracePeriodDays))
	out.StaleExpirationTimeDays = (*int)(unsafe.Pointer(in.StaleExpirationTimeDays))
	out.StaleSyncPeriod = (*v1.Duration)(unsafe.Pointer(in.StaleSyncPeriod))
	return nil
}

// Convert_v1alpha1_ProjectControllerConfiguration_To_config_ProjectControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ProjectControllerConfiguration_To_config_ProjectControllerConfiguration(in *ProjectControllerConfiguration, out *config.ProjectControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ProjectControllerConfiguration_To_config_ProjectControllerConfiguration(in, out, s)
}

func autoConvert_config_ProjectControllerConfiguration_To_v1alpha1_ProjectControllerConfiguration(in *config.ProjectControllerConfiguration, out *ProjectControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.MinimumLifetimeDays = (*int)(unsafe.Pointer(in.MinimumLifetimeDays))
	out.StaleGracePeriodDays = (*int)(unsafe.Pointer(in.StaleGracePeriodDays))
	out.StaleExpirationTimeDays = (*int)(unsafe.Pointer(in.StaleExpirationTimeDays))
	out.StaleSyncPeriod = (*v1.Duration)(unsafe.Pointer(in.StaleSyncPeriod))
	return nil
}

// Convert_config_ProjectControllerConfiguration_To_v1alpha1_ProjectControllerConfiguration is an autogenerated conversion function.
func Convert_config_ProjectControllerConfiguration_To_v1alpha1_ProjectControllerConfiguration(in *config.ProjectControllerConfiguration, out *ProjectControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ProjectControllerConfiguration_To_v1alpha1_ProjectControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_QuotaControllerConfiguration_To_config_QuotaControllerConfiguration(in *QuotaControllerConfiguration, out *config.QuotaControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_v1alpha1_QuotaControllerConfiguration_To_config_QuotaControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_QuotaControllerConfiguration_To_config_QuotaControllerConfiguration(in *QuotaControllerConfiguration, out *config.QuotaControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_QuotaControllerConfiguration_To_config_QuotaControllerConfiguration(in, out, s)
}

func autoConvert_config_QuotaControllerConfiguration_To_v1alpha1_QuotaControllerConfiguration(in *config.QuotaControllerConfiguration, out *QuotaControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_config_QuotaControllerConfiguration_To_v1alpha1_QuotaControllerConfiguration is an autogenerated conversion function.
func Convert_config_QuotaControllerConfiguration_To_v1alpha1_QuotaControllerConfiguration(in *config.QuotaControllerConfiguration, out *QuotaControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_QuotaControllerConfiguration_To_v1alpha1_QuotaControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_SecretBindingControllerConfiguration_To_config_SecretBindingControllerConfiguration(in *SecretBindingControllerConfiguration, out *config.SecretBindingControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_v1alpha1_SecretBindingControllerConfiguration_To_config_SecretBindingControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_SecretBindingControllerConfiguration_To_config_SecretBindingControllerConfiguration(in *SecretBindingControllerConfiguration, out *config.SecretBindingControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_SecretBindingControllerConfiguration_To_config_SecretBindingControllerConfiguration(in, out, s)
}

func autoConvert_config_SecretBindingControllerConfiguration_To_v1alpha1_SecretBindingControllerConfiguration(in *config.SecretBindingControllerConfiguration, out *SecretBindingControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_config_SecretBindingControllerConfiguration_To_v1alpha1_SecretBindingControllerConfiguration is an autogenerated conversion function.
func Convert_config_SecretBindingControllerConfiguration_To_v1alpha1_SecretBindingControllerConfiguration(in *config.SecretBindingControllerConfiguration, out *SecretBindingControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_SecretBindingControllerConfiguration_To_v1alpha1_SecretBindingControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in *SeedControllerConfiguration, out *config.SeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.MonitorPeriod = (*v1.Duration)(unsafe.Pointer(in.MonitorPeriod))
	out.ShootMonitorPeriod = (*v1.Duration)(unsafe.Pointer(in.ShootMonitorPeriod))
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in *SeedControllerConfiguration, out *config.SeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_SeedControllerConfiguration_To_config_SeedControllerConfiguration(in, out, s)
}

func autoConvert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in *config.SeedControllerConfiguration, out *SeedControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.MonitorPeriod = (*v1.Duration)(unsafe.Pointer(in.MonitorPeriod))
	out.ShootMonitorPeriod = (*v1.Duration)(unsafe.Pointer(in.ShootMonitorPeriod))
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration is an autogenerated conversion function.
func Convert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in *config.SeedControllerConfiguration, out *SeedControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_SeedControllerConfiguration_To_v1alpha1_SeedControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_Server_To_config_Server(in *Server, out *config.Server, s conversion.Scope) error {
	out.BindAddress = in.BindAddress
	out.Port = in.Port
	return nil
}

// Convert_v1alpha1_Server_To_config_Server is an autogenerated conversion function.
func Convert_v1alpha1_Server_To_config_Server(in *Server, out *config.Server, s conversion.Scope) error {
	return autoConvert_v1alpha1_Server_To_config_Server(in, out, s)
}

func autoConvert_config_Server_To_v1alpha1_Server(in *config.Server, out *Server, s conversion.Scope) error {
	out.BindAddress = in.BindAddress
	out.Port = in.Port
	return nil
}

// Convert_config_Server_To_v1alpha1_Server is an autogenerated conversion function.
func Convert_config_Server_To_v1alpha1_Server(in *config.Server, out *Server, s conversion.Scope) error {
	return autoConvert_config_Server_To_v1alpha1_Server(in, out, s)
}

func autoConvert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in *ServerConfiguration, out *config.ServerConfiguration, s conversion.Scope) error {
	if err := Convert_v1alpha1_Server_To_config_Server(&in.HTTP, &out.HTTP, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_HTTPSServer_To_config_HTTPSServer(&in.HTTPS, &out.HTTPS, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in *ServerConfiguration, out *config.ServerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ServerConfiguration_To_config_ServerConfiguration(in, out, s)
}

func autoConvert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in *config.ServerConfiguration, out *ServerConfiguration, s conversion.Scope) error {
	if err := Convert_config_Server_To_v1alpha1_Server(&in.HTTP, &out.HTTP, s); err != nil {
		return err
	}
	if err := Convert_config_HTTPSServer_To_v1alpha1_HTTPSServer(&in.HTTPS, &out.HTTPS, s); err != nil {
		return err
	}
	return nil
}

// Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration is an autogenerated conversion function.
func Convert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in *config.ServerConfiguration, out *ServerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ServerConfiguration_To_v1alpha1_ServerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration(in *ShootHibernationControllerConfiguration, out *config.ShootHibernationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration(in *ShootHibernationControllerConfiguration, out *config.ShootHibernationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootHibernationControllerConfiguration_To_config_ShootHibernationControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration(in *config.ShootHibernationControllerConfiguration, out *ShootHibernationControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	return nil
}

// Convert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration(in *config.ShootHibernationControllerConfiguration, out *ShootHibernationControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootHibernationControllerConfiguration_To_v1alpha1_ShootHibernationControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration(in *ShootMaintenanceControllerConfiguration, out *config.ShootMaintenanceControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.EnableShootControlPlaneRestarter = (*bool)(unsafe.Pointer(in.EnableShootControlPlaneRestarter))
	return nil
}

// Convert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration(in *ShootMaintenanceControllerConfiguration, out *config.ShootMaintenanceControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootMaintenanceControllerConfiguration_To_config_ShootMaintenanceControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration(in *config.ShootMaintenanceControllerConfiguration, out *ShootMaintenanceControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.EnableShootControlPlaneRestarter = (*bool)(unsafe.Pointer(in.EnableShootControlPlaneRestarter))
	return nil
}

// Convert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration(in *config.ShootMaintenanceControllerConfiguration, out *ShootMaintenanceControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootMaintenanceControllerConfiguration_To_v1alpha1_ShootMaintenanceControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration(in *ShootQuotaControllerConfiguration, out *config.ShootQuotaControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration is an autogenerated conversion function.
func Convert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration(in *ShootQuotaControllerConfiguration, out *config.ShootQuotaControllerConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha1_ShootQuotaControllerConfiguration_To_config_ShootQuotaControllerConfiguration(in, out, s)
}

func autoConvert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration(in *config.ShootQuotaControllerConfiguration, out *ShootQuotaControllerConfiguration, s conversion.Scope) error {
	out.ConcurrentSyncs = in.ConcurrentSyncs
	out.SyncPeriod = in.SyncPeriod
	return nil
}

// Convert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration is an autogenerated conversion function.
func Convert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration(in *config.ShootQuotaControllerConfiguration, out *ShootQuotaControllerConfiguration, s conversion.Scope) error {
	return autoConvert_config_ShootQuotaControllerConfiguration_To_v1alpha1_ShootQuotaControllerConfiguration(in, out, s)
}

func autoConvert_v1alpha1_TLSServer_To_config_TLSServer(in *TLSServer, out *config.TLSServer, s conversion.Scope) error {
	out.ServerCertPath = in.ServerCertPath
	out.ServerKeyPath = in.ServerKeyPath
	return nil
}

// Convert_v1alpha1_TLSServer_To_config_TLSServer is an autogenerated conversion function.
func Convert_v1alpha1_TLSServer_To_config_TLSServer(in *TLSServer, out *config.TLSServer, s conversion.Scope) error {
	return autoConvert_v1alpha1_TLSServer_To_config_TLSServer(in, out, s)
}

func autoConvert_config_TLSServer_To_v1alpha1_TLSServer(in *config.TLSServer, out *TLSServer, s conversion.Scope) error {
	out.ServerCertPath = in.ServerCertPath
	out.ServerKeyPath = in.ServerKeyPath
	return nil
}

// Convert_config_TLSServer_To_v1alpha1_TLSServer is an autogenerated conversion function.
func Convert_config_TLSServer_To_v1alpha1_TLSServer(in *config.TLSServer, out *TLSServer, s conversion.Scope) error {
	return autoConvert_config_TLSServer_To_v1alpha1_TLSServer(in, out, s)
}
