// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/aiplatform/v1/specialist_pool_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [SpecialistPoolService.CreateSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.CreateSpecialistPool].
type CreateSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent Project name for the new SpecialistPool.
	// The form is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SpecialistPool to create.
	SpecialistPool *SpecialistPool `protobuf:"bytes,2,opt,name=specialist_pool,json=specialistPool,proto3" json:"specialist_pool,omitempty"`
}

func (x *CreateSpecialistPoolRequest) Reset() {
	*x = CreateSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpecialistPoolRequest) ProtoMessage() {}

func (x *CreateSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*CreateSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSpecialistPoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSpecialistPoolRequest) GetSpecialistPool() *SpecialistPool {
	if x != nil {
		return x.SpecialistPool
	}
	return nil
}

// Runtime operation information for
// [SpecialistPoolService.CreateSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.CreateSpecialistPool].
type CreateSpecialistPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateSpecialistPoolOperationMetadata) Reset() {
	*x = CreateSpecialistPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpecialistPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpecialistPoolOperationMetadata) ProtoMessage() {}

func (x *CreateSpecialistPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpecialistPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateSpecialistPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateSpecialistPoolOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [SpecialistPoolService.GetSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.GetSpecialistPool].
type GetSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SpecialistPool resource.
	// The form is
	// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpecialistPoolRequest) Reset() {
	*x = GetSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpecialistPoolRequest) ProtoMessage() {}

func (x *GetSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*GetSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetSpecialistPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [SpecialistPoolService.ListSpecialistPools][google.cloud.aiplatform.v1.SpecialistPoolService.ListSpecialistPools].
type ListSpecialistPoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SpecialistPool's parent resource.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard list page token.
	// Typically obtained by
	// [ListSpecialistPoolsResponse.next_page_token][google.cloud.aiplatform.v1.ListSpecialistPoolsResponse.next_page_token]
	// of the previous
	// [SpecialistPoolService.ListSpecialistPools][google.cloud.aiplatform.v1.SpecialistPoolService.ListSpecialistPools]
	// call. Return first page if empty.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Mask specifying which fields to read. FieldMask represents a set of
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListSpecialistPoolsRequest) Reset() {
	*x = ListSpecialistPoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpecialistPoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecialistPoolsRequest) ProtoMessage() {}

func (x *ListSpecialistPoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecialistPoolsRequest.ProtoReflect.Descriptor instead.
func (*ListSpecialistPoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListSpecialistPoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpecialistPoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpecialistPoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpecialistPoolsRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [SpecialistPoolService.ListSpecialistPools][google.cloud.aiplatform.v1.SpecialistPoolService.ListSpecialistPools].
type ListSpecialistPoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of SpecialistPools that matches the specified filter in the request.
	SpecialistPools []*SpecialistPool `protobuf:"bytes,1,rep,name=specialist_pools,json=specialistPools,proto3" json:"specialist_pools,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpecialistPoolsResponse) Reset() {
	*x = ListSpecialistPoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpecialistPoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpecialistPoolsResponse) ProtoMessage() {}

func (x *ListSpecialistPoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpecialistPoolsResponse.ProtoReflect.Descriptor instead.
func (*ListSpecialistPoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListSpecialistPoolsResponse) GetSpecialistPools() []*SpecialistPool {
	if x != nil {
		return x.SpecialistPools
	}
	return nil
}

func (x *ListSpecialistPoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [SpecialistPoolService.DeleteSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.DeleteSpecialistPool].
type DeleteSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the SpecialistPool to delete. Format:
	// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, any specialist managers in this SpecialistPool will also be
	// deleted. (Otherwise, the request will only work if the SpecialistPool has
	// no specialist managers.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteSpecialistPoolRequest) Reset() {
	*x = DeleteSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpecialistPoolRequest) ProtoMessage() {}

func (x *DeleteSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSpecialistPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSpecialistPoolRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [SpecialistPoolService.UpdateSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.UpdateSpecialistPool].
type UpdateSpecialistPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SpecialistPool which replaces the resource on the server.
	SpecialistPool *SpecialistPool `protobuf:"bytes,1,opt,name=specialist_pool,json=specialistPool,proto3" json:"specialist_pool,omitempty"`
	// Required. The update mask applies to the resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpecialistPoolRequest) Reset() {
	*x = UpdateSpecialistPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpecialistPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpecialistPoolRequest) ProtoMessage() {}

func (x *UpdateSpecialistPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpecialistPoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpecialistPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSpecialistPoolRequest) GetSpecialistPool() *SpecialistPool {
	if x != nil {
		return x.SpecialistPool
	}
	return nil
}

func (x *UpdateSpecialistPoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Runtime operation metadata for
// [SpecialistPoolService.UpdateSpecialistPool][google.cloud.aiplatform.v1.SpecialistPoolService.UpdateSpecialistPool].
type UpdateSpecialistPoolOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the SpecialistPool to which the specialists are
	// being added. Format:
	// `projects/{project_id}/locations/{location_id}/specialistPools/{specialist_pool}`
	SpecialistPool string `protobuf:"bytes,1,opt,name=specialist_pool,json=specialistPool,proto3" json:"specialist_pool,omitempty"`
	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,2,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateSpecialistPoolOperationMetadata) Reset() {
	*x = UpdateSpecialistPoolOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpecialistPoolOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpecialistPoolOperationMetadata) ProtoMessage() {}

func (x *UpdateSpecialistPoolOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpecialistPoolOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateSpecialistPoolOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateSpecialistPoolOperationMetadata) GetSpecialistPool() string {
	if x != nil {
		return x.SpecialistPool
	}
	return ""
}

func (x *UpdateSpecialistPoolOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

var File_google_cloud_aiplatform_v1_specialist_pool_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xba, 0x01, 0x0a, 0x1b,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58,
	0x0a, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x88, 0x01, 0x0a, 0x25, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x60, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9c, 0x01, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x79, 0x0a, 0x1b, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xe3, 0x01, 0x0a, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32, 0x94, 0x0a, 0x0a, 0x15, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x90, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0xca, 0x41, 0x37, 0x0a, 0x0e, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a,
	0x0f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x42, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x12, 0xe5, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x75, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01, 0xca, 0x41, 0x37, 0x0a,
	0x0e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x0f, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x32, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xd8, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x42, 0x1a, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x6f, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescData = file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1_specialist_pool_service_proto_goTypes = []interface{}{
	(*CreateSpecialistPoolRequest)(nil),           // 0: google.cloud.aiplatform.v1.CreateSpecialistPoolRequest
	(*CreateSpecialistPoolOperationMetadata)(nil), // 1: google.cloud.aiplatform.v1.CreateSpecialistPoolOperationMetadata
	(*GetSpecialistPoolRequest)(nil),              // 2: google.cloud.aiplatform.v1.GetSpecialistPoolRequest
	(*ListSpecialistPoolsRequest)(nil),            // 3: google.cloud.aiplatform.v1.ListSpecialistPoolsRequest
	(*ListSpecialistPoolsResponse)(nil),           // 4: google.cloud.aiplatform.v1.ListSpecialistPoolsResponse
	(*DeleteSpecialistPoolRequest)(nil),           // 5: google.cloud.aiplatform.v1.DeleteSpecialistPoolRequest
	(*UpdateSpecialistPoolRequest)(nil),           // 6: google.cloud.aiplatform.v1.UpdateSpecialistPoolRequest
	(*UpdateSpecialistPoolOperationMetadata)(nil), // 7: google.cloud.aiplatform.v1.UpdateSpecialistPoolOperationMetadata
	(*SpecialistPool)(nil),                        // 8: google.cloud.aiplatform.v1.SpecialistPool
	(*GenericOperationMetadata)(nil),              // 9: google.cloud.aiplatform.v1.GenericOperationMetadata
	(*fieldmaskpb.FieldMask)(nil),                 // 10: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),               // 11: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1_specialist_pool_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.aiplatform.v1.CreateSpecialistPoolRequest.specialist_pool:type_name -> google.cloud.aiplatform.v1.SpecialistPool
	9,  // 1: google.cloud.aiplatform.v1.CreateSpecialistPoolOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	10, // 2: google.cloud.aiplatform.v1.ListSpecialistPoolsRequest.read_mask:type_name -> google.protobuf.FieldMask
	8,  // 3: google.cloud.aiplatform.v1.ListSpecialistPoolsResponse.specialist_pools:type_name -> google.cloud.aiplatform.v1.SpecialistPool
	8,  // 4: google.cloud.aiplatform.v1.UpdateSpecialistPoolRequest.specialist_pool:type_name -> google.cloud.aiplatform.v1.SpecialistPool
	10, // 5: google.cloud.aiplatform.v1.UpdateSpecialistPoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,  // 6: google.cloud.aiplatform.v1.UpdateSpecialistPoolOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	0,  // 7: google.cloud.aiplatform.v1.SpecialistPoolService.CreateSpecialistPool:input_type -> google.cloud.aiplatform.v1.CreateSpecialistPoolRequest
	2,  // 8: google.cloud.aiplatform.v1.SpecialistPoolService.GetSpecialistPool:input_type -> google.cloud.aiplatform.v1.GetSpecialistPoolRequest
	3,  // 9: google.cloud.aiplatform.v1.SpecialistPoolService.ListSpecialistPools:input_type -> google.cloud.aiplatform.v1.ListSpecialistPoolsRequest
	5,  // 10: google.cloud.aiplatform.v1.SpecialistPoolService.DeleteSpecialistPool:input_type -> google.cloud.aiplatform.v1.DeleteSpecialistPoolRequest
	6,  // 11: google.cloud.aiplatform.v1.SpecialistPoolService.UpdateSpecialistPool:input_type -> google.cloud.aiplatform.v1.UpdateSpecialistPoolRequest
	11, // 12: google.cloud.aiplatform.v1.SpecialistPoolService.CreateSpecialistPool:output_type -> google.longrunning.Operation
	8,  // 13: google.cloud.aiplatform.v1.SpecialistPoolService.GetSpecialistPool:output_type -> google.cloud.aiplatform.v1.SpecialistPool
	4,  // 14: google.cloud.aiplatform.v1.SpecialistPoolService.ListSpecialistPools:output_type -> google.cloud.aiplatform.v1.ListSpecialistPoolsResponse
	11, // 15: google.cloud.aiplatform.v1.SpecialistPoolService.DeleteSpecialistPool:output_type -> google.longrunning.Operation
	11, // 16: google.cloud.aiplatform.v1.SpecialistPoolService.UpdateSpecialistPool:output_type -> google.longrunning.Operation
	12, // [12:17] is the sub-list for method output_type
	7,  // [7:12] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_specialist_pool_service_proto_init() }
func file_google_cloud_aiplatform_v1_specialist_pool_service_proto_init() {
	if File_google_cloud_aiplatform_v1_specialist_pool_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_operation_proto_init()
	file_google_cloud_aiplatform_v1_specialist_pool_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpecialistPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpecialistPoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpecialistPoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpecialistPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpecialistPoolOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_specialist_pool_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_specialist_pool_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_specialist_pool_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_specialist_pool_service_proto = out.File
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_specialist_pool_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpecialistPoolServiceClient is the client API for SpecialistPoolService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpecialistPoolServiceClient interface {
	// Creates a SpecialistPool.
	CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error)
	// Lists SpecialistPools in a Location.
	ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool as well as all Specialists in the pool.
	DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type specialistPoolServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSpecialistPoolServiceClient(cc grpc.ClientConnInterface) SpecialistPoolServiceClient {
	return &specialistPoolServiceClient{cc}
}

func (c *specialistPoolServiceClient) CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.SpecialistPoolService/CreateSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error) {
	out := new(SpecialistPool)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.SpecialistPoolService/GetSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error) {
	out := new(ListSpecialistPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.SpecialistPoolService/ListSpecialistPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.SpecialistPoolService/DeleteSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.SpecialistPoolService/UpdateSpecialistPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpecialistPoolServiceServer is the server API for SpecialistPoolService service.
type SpecialistPoolServiceServer interface {
	// Creates a SpecialistPool.
	CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunningpb.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error)
	// Lists SpecialistPools in a Location.
	ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool as well as all Specialists in the pool.
	DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunningpb.Operation, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSpecialistPoolServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSpecialistPoolServiceServer struct {
}

func (*UnimplementedSpecialistPoolServiceServer) CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpecialistPool not implemented")
}
func (*UnimplementedSpecialistPoolServiceServer) GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecialistPool not implemented")
}
func (*UnimplementedSpecialistPoolServiceServer) ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpecialistPools not implemented")
}
func (*UnimplementedSpecialistPoolServiceServer) DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpecialistPool not implemented")
}
func (*UnimplementedSpecialistPoolServiceServer) UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpecialistPool not implemented")
}

func RegisterSpecialistPoolServiceServer(s *grpc.Server, srv SpecialistPoolServiceServer) {
	s.RegisterService(&_SpecialistPoolService_serviceDesc, srv)
}

func _SpecialistPoolService_CreateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).CreateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.SpecialistPoolService/CreateSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).CreateSpecialistPool(ctx, req.(*CreateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_GetSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).GetSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.SpecialistPoolService/GetSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).GetSpecialistPool(ctx, req.(*GetSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_ListSpecialistPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpecialistPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).ListSpecialistPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.SpecialistPoolService/ListSpecialistPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).ListSpecialistPools(ctx, req.(*ListSpecialistPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_DeleteSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).DeleteSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.SpecialistPoolService/DeleteSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).DeleteSpecialistPool(ctx, req.(*DeleteSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_UpdateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).UpdateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.SpecialistPoolService/UpdateSpecialistPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).UpdateSpecialistPool(ctx, req.(*UpdateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SpecialistPoolService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.SpecialistPoolService",
	HandlerType: (*SpecialistPoolServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSpecialistPool",
			Handler:    _SpecialistPoolService_CreateSpecialistPool_Handler,
		},
		{
			MethodName: "GetSpecialistPool",
			Handler:    _SpecialistPoolService_GetSpecialistPool_Handler,
		},
		{
			MethodName: "ListSpecialistPools",
			Handler:    _SpecialistPoolService_ListSpecialistPools_Handler,
		},
		{
			MethodName: "DeleteSpecialistPool",
			Handler:    _SpecialistPoolService_DeleteSpecialistPool_Handler,
		},
		{
			MethodName: "UpdateSpecialistPool",
			Handler:    _SpecialistPoolService_UpdateSpecialistPool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/specialist_pool_service.proto",
}
