// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/tasks/v2beta3/target.proto

package cloudtaskspb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The HTTP method used to execute the task.
type HttpMethod int32

const (
	// HTTP method unspecified
	HttpMethod_HTTP_METHOD_UNSPECIFIED HttpMethod = 0
	// HTTP POST
	HttpMethod_POST HttpMethod = 1
	// HTTP GET
	HttpMethod_GET HttpMethod = 2
	// HTTP HEAD
	HttpMethod_HEAD HttpMethod = 3
	// HTTP PUT
	HttpMethod_PUT HttpMethod = 4
	// HTTP DELETE
	HttpMethod_DELETE HttpMethod = 5
	// HTTP PATCH
	HttpMethod_PATCH HttpMethod = 6
	// HTTP OPTIONS
	HttpMethod_OPTIONS HttpMethod = 7
)

// Enum value maps for HttpMethod.
var (
	HttpMethod_name = map[int32]string{
		0: "HTTP_METHOD_UNSPECIFIED",
		1: "POST",
		2: "GET",
		3: "HEAD",
		4: "PUT",
		5: "DELETE",
		6: "PATCH",
		7: "OPTIONS",
	}
	HttpMethod_value = map[string]int32{
		"HTTP_METHOD_UNSPECIFIED": 0,
		"POST":                    1,
		"GET":                     2,
		"HEAD":                    3,
		"PUT":                     4,
		"DELETE":                  5,
		"PATCH":                   6,
		"OPTIONS":                 7,
	}
)

func (x HttpMethod) Enum() *HttpMethod {
	p := new(HttpMethod)
	*p = x
	return p
}

func (x HttpMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_tasks_v2beta3_target_proto_enumTypes[0].Descriptor()
}

func (HttpMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_tasks_v2beta3_target_proto_enumTypes[0]
}

func (x HttpMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpMethod.Descriptor instead.
func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{0}
}

// Pull Message.
//
// This proto can only be used for tasks in a queue which has
// [PULL][google.cloud.tasks.v2beta3.Queue.type] type. It currently exists for
// backwards compatibility with the App Engine Task Queue SDK. This message type
// maybe returned with methods
// [list][google.cloud.tasks.v2beta3.CloudTask.ListTasks] and
// [get][google.cloud.tasks.v2beta3.CloudTask.ListTasks], when the response view
// is [FULL][google.cloud.tasks.v2beta3.Task.View.Full].
type PullMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A data payload consumed by the worker to execute the task.
	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// The tasks's tag.
	//
	// The tag is less than 500 characters.
	//
	// SDK compatibility: Although the SDK allows tags to be either
	// string or
	// [bytes](https://cloud.google.com/appengine/docs/standard/java/javadoc/com/google/appengine/api/taskqueue/TaskOptions.html#tag-byte:A-),
	// only UTF-8 encoded tags can be used in Cloud Tasks. If a tag isn't UTF-8
	// encoded, the tag will be empty when the task is returned by Cloud Tasks.
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *PullMessage) Reset() {
	*x = PullMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullMessage) ProtoMessage() {}

func (x *PullMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullMessage.ProtoReflect.Descriptor instead.
func (*PullMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{0}
}

func (x *PullMessage) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *PullMessage) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// HTTP request.
//
// The task will be pushed to the worker as an HTTP request. If the worker
// or the redirected worker acknowledges the task by returning a successful HTTP
// response code ([`200` - `299`]), the task will be removed from the queue. If
// any other HTTP response code is returned or no response is received, the
// task will be retried according to the following:
//
// * User-specified throttling: [retry
// configuration][google.cloud.tasks.v2beta3.Queue.retry_config],
//
//		[rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits], and the
//		[queue's state][google.cloud.tasks.v2beta3.Queue.state].
//
//	  - System throttling: To prevent the worker from overloading, Cloud Tasks may
//	    temporarily reduce the queue's effective rate. User-specified settings
//	    will not be changed.
//
//	    System throttling happens because:
//
//	  - Cloud Tasks backs off on all errors. Normally the backoff specified in
//	    [rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits] will be used.
//	    But if the worker returns `429` (Too Many Requests), `503` (Service
//	    Unavailable), or the rate of errors is high, Cloud Tasks will use a
//	    higher backoff rate. The retry specified in the `Retry-After` HTTP
//	    response header is considered.
//
//	  - To prevent traffic spikes and to smooth sudden increases in traffic,
//	    dispatches ramp up slowly when the queue is newly created or idle and
//	    if large numbers of tasks suddenly become available to dispatch (due to
//	    spikes in create task rates, the queue being unpaused, or many tasks
//	    that are scheduled at the same time).
type HttpRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full url path that the request will be sent to.
	//
	// This string must begin with either "http://" or "https://". Some examples
	// are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
	// encode some characters for safety and compatibility. The maximum allowed
	// URL length is 2083 characters after encoding.
	//
	// The `Location` header response from a redirect response [`300` - `399`]
	// may be followed. The redirect is not counted as a separate attempt.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The HTTP method to use for the request. The default is POST.
	HttpMethod HttpMethod `protobuf:"varint,2,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.tasks.v2beta3.HttpMethod" json:"http_method,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values.
	// Headers can be set when the
	// [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	//
	// These headers represent a subset of the headers that will accompany the
	// task's HTTP request. Some HTTP request headers will be ignored or replaced.
	//
	// A partial list of headers that will be ignored or replaced is:
	//
	// * Host: This will be computed by Cloud Tasks and derived from
	//   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
	// * Content-Length: This will be computed by Cloud Tasks.
	// * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
	// * `X-Google-*`: Google use only.
	// * `X-AppEngine-*`: Google use only.
	//
	// `Content-Type` won't be set by Cloud Tasks. You can explicitly set
	// `Content-Type` to a media type when the
	//  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	//  For example, `Content-Type` can be set to `"application/octet-stream"` or
	//  `"application/json"`.
	//
	// Headers which can have multiple values (according to RFC2616) can be
	// specified using comma-separated values.
	//
	// The size of the headers must be less than 80KB.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body.
	//
	// A request body is allowed only if the
	// [HTTP method][google.cloud.tasks.v2beta3.HttpRequest.http_method] is POST,
	// PUT, or PATCH. It is an error to set body on a task with an incompatible
	// [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	// The mode for generating an `Authorization` header for HTTP requests.
	//
	// If specified, all `Authorization` headers in the
	// [HttpRequest.headers][google.cloud.tasks.v2beta3.HttpRequest.headers] field
	// will be overridden.
	//
	// Types that are assignable to AuthorizationHeader:
	//	*HttpRequest_OauthToken
	//	*HttpRequest_OidcToken
	AuthorizationHeader isHttpRequest_AuthorizationHeader `protobuf_oneof:"authorization_header"`
}

func (x *HttpRequest) Reset() {
	*x = HttpRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRequest) ProtoMessage() {}

func (x *HttpRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRequest.ProtoReflect.Descriptor instead.
func (*HttpRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{1}
}

func (x *HttpRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HttpRequest) GetHttpMethod() HttpMethod {
	if x != nil {
		return x.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (x *HttpRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpRequest) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

func (m *HttpRequest) GetAuthorizationHeader() isHttpRequest_AuthorizationHeader {
	if m != nil {
		return m.AuthorizationHeader
	}
	return nil
}

func (x *HttpRequest) GetOauthToken() *OAuthToken {
	if x, ok := x.GetAuthorizationHeader().(*HttpRequest_OauthToken); ok {
		return x.OauthToken
	}
	return nil
}

func (x *HttpRequest) GetOidcToken() *OidcToken {
	if x, ok := x.GetAuthorizationHeader().(*HttpRequest_OidcToken); ok {
		return x.OidcToken
	}
	return nil
}

type isHttpRequest_AuthorizationHeader interface {
	isHttpRequest_AuthorizationHeader()
}

type HttpRequest_OauthToken struct {
	// If specified, an
	// [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
	// will be generated and attached as an `Authorization` header in the HTTP
	// request.
	//
	// This type of authorization should generally only be used when calling
	// Google APIs hosted on *.googleapis.com.
	OauthToken *OAuthToken `protobuf:"bytes,5,opt,name=oauth_token,json=oauthToken,proto3,oneof"`
}

type HttpRequest_OidcToken struct {
	// If specified, an
	// [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
	// token will be generated and attached as an `Authorization` header in the
	// HTTP request.
	//
	// This type of authorization can be used for many scenarios, including
	// calling Cloud Run, or endpoints where you intend to validate the token
	// yourself.
	OidcToken *OidcToken `protobuf:"bytes,6,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*HttpRequest_OauthToken) isHttpRequest_AuthorizationHeader() {}

func (*HttpRequest_OidcToken) isHttpRequest_AuthorizationHeader() {}

// App Engine HTTP queue.
//
// The task will be delivered to the App Engine application hostname
// specified by its
// [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] and
// [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]. The
// documentation for
// [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
// explains how the task's host URL is constructed.
//
// Using [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue]
// requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
type AppEngineHttpQueue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Overrides for the
	// [task-level
	// app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
	//
	// If set, `app_engine_routing_override` is used for all tasks in
	// the queue, no matter what the setting is for the
	// [task-level
	// app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
	AppEngineRoutingOverride *AppEngineRouting `protobuf:"bytes,1,opt,name=app_engine_routing_override,json=appEngineRoutingOverride,proto3" json:"app_engine_routing_override,omitempty"`
}

func (x *AppEngineHttpQueue) Reset() {
	*x = AppEngineHttpQueue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEngineHttpQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineHttpQueue) ProtoMessage() {}

func (x *AppEngineHttpQueue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineHttpQueue.ProtoReflect.Descriptor instead.
func (*AppEngineHttpQueue) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{2}
}

func (x *AppEngineHttpQueue) GetAppEngineRoutingOverride() *AppEngineRouting {
	if x != nil {
		return x.AppEngineRoutingOverride
	}
	return nil
}

// App Engine HTTP request.
//
// The message defines the HTTP request that is sent to an App Engine app when
// the task is dispatched.
//
// Using [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
// requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
//
// The task will be delivered to the App Engine app which belongs to the same
// project as the queue. For more information, see
// [How Requests are
// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
// and how routing is affected by
// [dispatch
// files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
// Traffic is encrypted during transport and never leaves Google datacenters.
// Because this traffic is carried over a communication mechanism internal to
// Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
// The request to the handler, however, will appear to have used the HTTP
// protocol.
//
// The [AppEngineRouting][google.cloud.tasks.v2beta3.AppEngineRouting] used to
// construct the URL that the task is delivered to can be set at the queue-level
// or task-level:
//
//   - If set,
//     [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
//     is used for all tasks in the queue, no matter what the setting
//     is for the
//     [task-level
//     app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
//
// The `url` that the task will be sent to is:
//
//   - `url =` [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] `+`
//     [relative_uri][google.cloud.tasks.v2beta3.AppEngineHttpRequest.relative_uri]
//
// Tasks can be dispatched to secure app handlers, unsecure app handlers, and
// URIs restricted with
// [`login:
// admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
// Because tasks are not run as any user, they cannot be dispatched to URIs
// restricted with
// [`login:
// required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
// Task dispatches also do not follow redirects.
//
// The task attempt has succeeded if the app's request handler returns an HTTP
// response code in the range [`200` - `299`]. The task attempt has failed if
// the app's handler returns a non-2xx response code or Cloud Tasks does
// not receive response before the
// [deadline][google.cloud.tasks.v2beta3.Task.dispatch_deadline]. Failed tasks
// will be retried according to the [retry
// configuration][google.cloud.tasks.v2beta3.Queue.retry_config]. `503` (Service
// Unavailable) is considered an App Engine system error instead of an
// application error and will cause Cloud Tasks' traffic congestion control to
// temporarily throttle the queue's dispatches. Unlike other types of task
// targets, a `429` (Too Many Requests) response from an app handler does not
// cause traffic congestion control to throttle the queue.
type AppEngineHttpRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP method to use for the request. The default is POST.
	//
	// The app's request handler for the task's target URL must be able to handle
	// HTTP requests with this http_method, otherwise the task attempt fails with
	// error code 405 (Method Not Allowed). See [Writing a push task request
	// handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
	// and the App Engine documentation for your runtime on [How Requests are
	// Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
	HttpMethod HttpMethod `protobuf:"varint,1,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.tasks.v2beta3.HttpMethod" json:"http_method,omitempty"`
	// Task-level setting for App Engine routing.
	//
	// If set,
	// [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
	// is used for all tasks in the queue, no matter what the setting is for the
	// [task-level
	// app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
	AppEngineRouting *AppEngineRouting `protobuf:"bytes,2,opt,name=app_engine_routing,json=appEngineRouting,proto3" json:"app_engine_routing,omitempty"`
	// The relative URI.
	//
	// The relative URI must begin with "/" and must be a valid HTTP relative URI.
	// It can contain a path and query string arguments.
	// If the relative URI is empty, then the root path "/" will be used.
	// No spaces are allowed, and the maximum length allowed is 2083 characters.
	RelativeUri string `protobuf:"bytes,3,opt,name=relative_uri,json=relativeUri,proto3" json:"relative_uri,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values.
	// Headers can be set when the
	// [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	// Repeated headers are not supported but a header value can contain commas.
	//
	// Cloud Tasks sets some headers to default values:
	//
	// * `User-Agent`: By default, this header is
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
	//   This header can be modified, but Cloud Tasks will append
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
	//   modified `User-Agent`.
	//
	// If the task has a
	// [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
	// sets the following headers:
	//
	// * `Content-Type`: By default, the `Content-Type` header is set to
	//   `"application/octet-stream"`. The default can be overridden by explicitly
	//   setting `Content-Type` to a particular media type when the
	//   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	//   For example, `Content-Type` can be set to `"application/json"`.
	// * `Content-Length`: This is computed by Cloud Tasks. This value is
	//   output only.   It cannot be changed.
	//
	// The headers below cannot be set or overridden:
	//
	// * `Host`
	// * `X-Google-*`
	// * `X-AppEngine-*`
	//
	// In addition, Cloud Tasks sets some headers when the task is dispatched,
	// such as headers containing information about the task; see
	// [request
	// headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
	// These headers are set only when the task is dispatched, so they are not
	// visible when the task is returned in a Cloud Tasks response.
	//
	// Although there is no specific limit for the maximum number of headers or
	// the size, there is a limit on the maximum size of the
	// [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
	// [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
	// documentation.
	Headers map[string]string `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body.
	//
	// A request body is allowed only if the HTTP method is POST or PUT. It is
	// an error to set a body on a task with an incompatible
	// [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
	Body []byte `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *AppEngineHttpRequest) Reset() {
	*x = AppEngineHttpRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEngineHttpRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineHttpRequest) ProtoMessage() {}

func (x *AppEngineHttpRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineHttpRequest.ProtoReflect.Descriptor instead.
func (*AppEngineHttpRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{3}
}

func (x *AppEngineHttpRequest) GetHttpMethod() HttpMethod {
	if x != nil {
		return x.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (x *AppEngineHttpRequest) GetAppEngineRouting() *AppEngineRouting {
	if x != nil {
		return x.AppEngineRouting
	}
	return nil
}

func (x *AppEngineHttpRequest) GetRelativeUri() string {
	if x != nil {
		return x.RelativeUri
	}
	return ""
}

func (x *AppEngineHttpRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *AppEngineHttpRequest) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

// App Engine Routing.
//
// Defines routing characteristics specific to App Engine - service, version,
// and instance.
//
// For more information about services, versions, and instances see
// [An Overview of App
// Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
// [Microservices Architecture on Google App
// Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
// [App Engine Standard request
// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
// and [App Engine Flex request
// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
type AppEngineRouting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// App service.
	//
	// By default, the task is sent to the service which is the default
	// service when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is
	// not parsable into
	// [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For
	// example, some tasks which were created using the App Engine SDK use a
	// custom domain name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable,
	// then [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the
	// empty string.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// App version.
	//
	// By default, the task is sent to the version which is the default
	// version when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is
	// not parsable into
	// [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For
	// example, some tasks which were created using the App Engine SDK use a
	// custom domain name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable,
	// then [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the
	// empty string.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// App instance.
	//
	// By default, the task is sent to an instance which is available when
	// the task is attempted.
	//
	// Requests can only be sent to a specific instance if
	// [manual scaling is used in App Engine
	// Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
	// App Engine Flex does not support instances. For more information, see
	// [App Engine Standard request
	// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
	// and [App Engine Flex request
	// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Output only. The host that the task is sent to.
	//
	// The host is constructed from the domain name of the app associated with
	// the queue's project ID (for example <app-id>.appspot.com), and the
	// [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks
	// which were created using the App Engine SDK might have a custom domain
	// name.
	//
	// For more information, see
	// [How Requests are
	// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
	Host string `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
}

func (x *AppEngineRouting) Reset() {
	*x = AppEngineRouting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEngineRouting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEngineRouting) ProtoMessage() {}

func (x *AppEngineRouting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEngineRouting.ProtoReflect.Descriptor instead.
func (*AppEngineRouting) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{4}
}

func (x *AppEngineRouting) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *AppEngineRouting) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AppEngineRouting) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *AppEngineRouting) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

// Contains information needed for generating an
// [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
// This type of authorization should generally only be used when calling Google
// APIs hosted on *.googleapis.com.
type OAuthToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OAuth token.
	// The service account must be within the same project as the queue. The
	// caller must have iam.serviceAccounts.actAs permission for the service
	// account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// OAuth scope to be used for generating OAuth access token.
	// If not specified, "https://www.googleapis.com/auth/cloud-platform"
	// will be used.
	Scope string `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
}

func (x *OAuthToken) Reset() {
	*x = OAuthToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuthToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuthToken) ProtoMessage() {}

func (x *OAuthToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuthToken.ProtoReflect.Descriptor instead.
func (*OAuthToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{5}
}

func (x *OAuthToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *OAuthToken) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
// This type of authorization can be used for many scenarios, including
// calling Cloud Run, or endpoints where you intend to validate the token
// yourself.
type OidcToken struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OIDC token.
	// The service account must be within the same project as the queue. The
	// caller must have iam.serviceAccounts.actAs permission for the service
	// account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Audience to be used when generating OIDC token. If not specified, the URI
	// specified in target will be used.
	Audience string `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *OidcToken) Reset() {
	*x = OidcToken{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcToken) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcToken) ProtoMessage() {}

func (x *OidcToken) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2beta3_target_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcToken.ProtoReflect.Descriptor instead.
func (*OidcToken) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP(), []int{6}
}

func (x *OidcToken) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *OidcToken) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

var File_google_cloud_tasks_v2beta3_target_proto protoreflect.FileDescriptor

var file_google_cloud_tasks_v2beta3_target_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x22, 0x39, 0x0a, 0x0b, 0x50, 0x75, 0x6c, 0x6c, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x10,
	0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67,
	0x22, 0xb3, 0x03, 0x0a, 0x0b, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x12, 0x47, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52,
	0x0a, 0x68, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x62,
	0x6f, 0x64, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12,
	0x49, 0x0a, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x0a,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x46, 0x0a, 0x0a, 0x6f, 0x69,
	0x64, 0x63, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4f, 0x69, 0x64, 0x63,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x6f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x16,
	0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x81, 0x01, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x48, 0x74, 0x74, 0x70, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x6b, 0x0a,
	0x1b, 0x61, 0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x52, 0x18, 0x61, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x22, 0x87, 0x03, 0x0a, 0x14, 0x41,
	0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x5a, 0x0a, 0x12,
	0x61, 0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x61, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x12, 0x57, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x76, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x22, 0x56, 0x0a, 0x0a,
	0x4f, 0x41, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x22, 0x5b, 0x0a, 0x09, 0x4f, 0x69, 0x64, 0x63, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x2a, 0x73, 0x0a, 0x0a, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12,
	0x1b, 0x0a, 0x17, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x4f, 0x53, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x45, 0x54, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x48, 0x45, 0x41, 0x44, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x55, 0x54,
	0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12, 0x09,
	0x0a, 0x05, 0x50, 0x41, 0x54, 0x43, 0x48, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x53, 0x10, 0x07, 0x42, 0x74, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x0b, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x70, 0x62, 0x3b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_tasks_v2beta3_target_proto_rawDescOnce sync.Once
	file_google_cloud_tasks_v2beta3_target_proto_rawDescData = file_google_cloud_tasks_v2beta3_target_proto_rawDesc
)

func file_google_cloud_tasks_v2beta3_target_proto_rawDescGZIP() []byte {
	file_google_cloud_tasks_v2beta3_target_proto_rawDescOnce.Do(func() {
		file_google_cloud_tasks_v2beta3_target_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_tasks_v2beta3_target_proto_rawDescData)
	})
	return file_google_cloud_tasks_v2beta3_target_proto_rawDescData
}

var file_google_cloud_tasks_v2beta3_target_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_tasks_v2beta3_target_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_tasks_v2beta3_target_proto_goTypes = []interface{}{
	(HttpMethod)(0),              // 0: google.cloud.tasks.v2beta3.HttpMethod
	(*PullMessage)(nil),          // 1: google.cloud.tasks.v2beta3.PullMessage
	(*HttpRequest)(nil),          // 2: google.cloud.tasks.v2beta3.HttpRequest
	(*AppEngineHttpQueue)(nil),   // 3: google.cloud.tasks.v2beta3.AppEngineHttpQueue
	(*AppEngineHttpRequest)(nil), // 4: google.cloud.tasks.v2beta3.AppEngineHttpRequest
	(*AppEngineRouting)(nil),     // 5: google.cloud.tasks.v2beta3.AppEngineRouting
	(*OAuthToken)(nil),           // 6: google.cloud.tasks.v2beta3.OAuthToken
	(*OidcToken)(nil),            // 7: google.cloud.tasks.v2beta3.OidcToken
	nil,                          // 8: google.cloud.tasks.v2beta3.HttpRequest.HeadersEntry
	nil,                          // 9: google.cloud.tasks.v2beta3.AppEngineHttpRequest.HeadersEntry
}
var file_google_cloud_tasks_v2beta3_target_proto_depIdxs = []int32{
	0, // 0: google.cloud.tasks.v2beta3.HttpRequest.http_method:type_name -> google.cloud.tasks.v2beta3.HttpMethod
	8, // 1: google.cloud.tasks.v2beta3.HttpRequest.headers:type_name -> google.cloud.tasks.v2beta3.HttpRequest.HeadersEntry
	6, // 2: google.cloud.tasks.v2beta3.HttpRequest.oauth_token:type_name -> google.cloud.tasks.v2beta3.OAuthToken
	7, // 3: google.cloud.tasks.v2beta3.HttpRequest.oidc_token:type_name -> google.cloud.tasks.v2beta3.OidcToken
	5, // 4: google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override:type_name -> google.cloud.tasks.v2beta3.AppEngineRouting
	0, // 5: google.cloud.tasks.v2beta3.AppEngineHttpRequest.http_method:type_name -> google.cloud.tasks.v2beta3.HttpMethod
	5, // 6: google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing:type_name -> google.cloud.tasks.v2beta3.AppEngineRouting
	9, // 7: google.cloud.tasks.v2beta3.AppEngineHttpRequest.headers:type_name -> google.cloud.tasks.v2beta3.AppEngineHttpRequest.HeadersEntry
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_tasks_v2beta3_target_proto_init() }
func file_google_cloud_tasks_v2beta3_target_proto_init() {
	if File_google_cloud_tasks_v2beta3_target_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEngineHttpQueue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEngineHttpRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEngineRouting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuthToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2beta3_target_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OidcToken); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_tasks_v2beta3_target_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*HttpRequest_OauthToken)(nil),
		(*HttpRequest_OidcToken)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_tasks_v2beta3_target_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_tasks_v2beta3_target_proto_goTypes,
		DependencyIndexes: file_google_cloud_tasks_v2beta3_target_proto_depIdxs,
		EnumInfos:         file_google_cloud_tasks_v2beta3_target_proto_enumTypes,
		MessageInfos:      file_google_cloud_tasks_v2beta3_target_proto_msgTypes,
	}.Build()
	File_google_cloud_tasks_v2beta3_target_proto = out.File
	file_google_cloud_tasks_v2beta3_target_proto_rawDesc = nil
	file_google_cloud_tasks_v2beta3_target_proto_goTypes = nil
	file_google_cloud_tasks_v2beta3_target_proto_depIdxs = nil
}
