// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/datacatalog/v1/physical_schema.proto

package datacatalogpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Native schema used by a resource represented as an entry. Used by query
// engines for deserializing and parsing source data.
type PhysicalSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Schema:
	//	*PhysicalSchema_Avro
	//	*PhysicalSchema_Thrift
	//	*PhysicalSchema_Protobuf
	//	*PhysicalSchema_Parquet
	//	*PhysicalSchema_Orc
	//	*PhysicalSchema_Csv
	Schema isPhysicalSchema_Schema `protobuf_oneof:"schema"`
}

func (x *PhysicalSchema) Reset() {
	*x = PhysicalSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema) ProtoMessage() {}

func (x *PhysicalSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0}
}

func (m *PhysicalSchema) GetSchema() isPhysicalSchema_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *PhysicalSchema) GetAvro() *PhysicalSchema_AvroSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Avro); ok {
		return x.Avro
	}
	return nil
}

func (x *PhysicalSchema) GetThrift() *PhysicalSchema_ThriftSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Thrift); ok {
		return x.Thrift
	}
	return nil
}

func (x *PhysicalSchema) GetProtobuf() *PhysicalSchema_ProtobufSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Protobuf); ok {
		return x.Protobuf
	}
	return nil
}

func (x *PhysicalSchema) GetParquet() *PhysicalSchema_ParquetSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Parquet); ok {
		return x.Parquet
	}
	return nil
}

func (x *PhysicalSchema) GetOrc() *PhysicalSchema_OrcSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Orc); ok {
		return x.Orc
	}
	return nil
}

func (x *PhysicalSchema) GetCsv() *PhysicalSchema_CsvSchema {
	if x, ok := x.GetSchema().(*PhysicalSchema_Csv); ok {
		return x.Csv
	}
	return nil
}

type isPhysicalSchema_Schema interface {
	isPhysicalSchema_Schema()
}

type PhysicalSchema_Avro struct {
	// Schema in Avro JSON format.
	Avro *PhysicalSchema_AvroSchema `protobuf:"bytes,1,opt,name=avro,proto3,oneof"`
}

type PhysicalSchema_Thrift struct {
	// Schema in Thrift format.
	Thrift *PhysicalSchema_ThriftSchema `protobuf:"bytes,2,opt,name=thrift,proto3,oneof"`
}

type PhysicalSchema_Protobuf struct {
	// Schema in protocol buffer format.
	Protobuf *PhysicalSchema_ProtobufSchema `protobuf:"bytes,3,opt,name=protobuf,proto3,oneof"`
}

type PhysicalSchema_Parquet struct {
	// Marks a Parquet-encoded data source.
	Parquet *PhysicalSchema_ParquetSchema `protobuf:"bytes,4,opt,name=parquet,proto3,oneof"`
}

type PhysicalSchema_Orc struct {
	// Marks an ORC-encoded data source.
	Orc *PhysicalSchema_OrcSchema `protobuf:"bytes,5,opt,name=orc,proto3,oneof"`
}

type PhysicalSchema_Csv struct {
	// Marks a CSV-encoded data source.
	Csv *PhysicalSchema_CsvSchema `protobuf:"bytes,6,opt,name=csv,proto3,oneof"`
}

func (*PhysicalSchema_Avro) isPhysicalSchema_Schema() {}

func (*PhysicalSchema_Thrift) isPhysicalSchema_Schema() {}

func (*PhysicalSchema_Protobuf) isPhysicalSchema_Schema() {}

func (*PhysicalSchema_Parquet) isPhysicalSchema_Schema() {}

func (*PhysicalSchema_Orc) isPhysicalSchema_Schema() {}

func (*PhysicalSchema_Csv) isPhysicalSchema_Schema() {}

// Schema in Avro JSON format.
type PhysicalSchema_AvroSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// JSON source of the Avro schema.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *PhysicalSchema_AvroSchema) Reset() {
	*x = PhysicalSchema_AvroSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_AvroSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_AvroSchema) ProtoMessage() {}

func (x *PhysicalSchema_AvroSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_AvroSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_AvroSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PhysicalSchema_AvroSchema) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Schema in Thrift format.
type PhysicalSchema_ThriftSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Thrift IDL source of the schema.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *PhysicalSchema_ThriftSchema) Reset() {
	*x = PhysicalSchema_ThriftSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_ThriftSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_ThriftSchema) ProtoMessage() {}

func (x *PhysicalSchema_ThriftSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_ThriftSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_ThriftSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 1}
}

func (x *PhysicalSchema_ThriftSchema) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Schema in protocol buffer format.
type PhysicalSchema_ProtobufSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Protocol buffer source of the schema.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *PhysicalSchema_ProtobufSchema) Reset() {
	*x = PhysicalSchema_ProtobufSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_ProtobufSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_ProtobufSchema) ProtoMessage() {}

func (x *PhysicalSchema_ProtobufSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_ProtobufSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_ProtobufSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 2}
}

func (x *PhysicalSchema_ProtobufSchema) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Marks a Parquet-encoded data source.
type PhysicalSchema_ParquetSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PhysicalSchema_ParquetSchema) Reset() {
	*x = PhysicalSchema_ParquetSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_ParquetSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_ParquetSchema) ProtoMessage() {}

func (x *PhysicalSchema_ParquetSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_ParquetSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_ParquetSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 3}
}

// Marks an ORC-encoded data source.
type PhysicalSchema_OrcSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PhysicalSchema_OrcSchema) Reset() {
	*x = PhysicalSchema_OrcSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_OrcSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_OrcSchema) ProtoMessage() {}

func (x *PhysicalSchema_OrcSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_OrcSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_OrcSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 4}
}

// Marks a CSV-encoded data source.
type PhysicalSchema_CsvSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PhysicalSchema_CsvSchema) Reset() {
	*x = PhysicalSchema_CsvSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalSchema_CsvSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalSchema_CsvSchema) ProtoMessage() {}

func (x *PhysicalSchema_CsvSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalSchema_CsvSchema.ProtoReflect.Descriptor instead.
func (*PhysicalSchema_CsvSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP(), []int{0, 5}
}

var File_google_cloud_datacatalog_v1_physical_schema_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_physical_schema_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68,
	0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x22, 0x9a, 0x05, 0x0a, 0x0e, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x4c, 0x0a, 0x04, 0x61, 0x76, 0x72, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x41,
	0x76, 0x72, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x04, 0x61, 0x76, 0x72,
	0x6f, 0x12, 0x52, 0x0a, 0x06, 0x74, 0x68, 0x72, 0x69, 0x66, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x54,
	0x68, 0x72, 0x69, 0x66, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x06, 0x74,
	0x68, 0x72, 0x69, 0x66, 0x74, 0x12, 0x58, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x12,
	0x55, 0x0a, 0x07, 0x70, 0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x50, 0x61,
	0x72, 0x71, 0x75, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x07, 0x70,
	0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x12, 0x49, 0x0a, 0x03, 0x6f, 0x72, 0x63, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x4f, 0x72, 0x63, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x03, 0x6f, 0x72,
	0x63, 0x12, 0x49, 0x0a, 0x03, 0x63, 0x73, 0x76, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x79,
	0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x43, 0x73, 0x76, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x48, 0x00, 0x52, 0x03, 0x63, 0x73, 0x76, 0x1a, 0x20, 0x0a, 0x0a,
	0x41, 0x76, 0x72, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x22,
	0x0a, 0x0c, 0x54, 0x68, 0x72, 0x69, 0x66, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x1a, 0x24, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x0f, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x71,
	0x75, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x0b, 0x0a, 0x09, 0x4f, 0x72, 0x63,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x0b, 0x0a, 0x09, 0x43, 0x73, 0x76, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0xdb, 0x01,
	0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x42, 0x13, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02,
	0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescData = file_google_cloud_datacatalog_v1_physical_schema_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_physical_schema_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_datacatalog_v1_physical_schema_proto_goTypes = []interface{}{
	(*PhysicalSchema)(nil),                // 0: google.cloud.datacatalog.v1.PhysicalSchema
	(*PhysicalSchema_AvroSchema)(nil),     // 1: google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema
	(*PhysicalSchema_ThriftSchema)(nil),   // 2: google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema
	(*PhysicalSchema_ProtobufSchema)(nil), // 3: google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
	(*PhysicalSchema_ParquetSchema)(nil),  // 4: google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
	(*PhysicalSchema_OrcSchema)(nil),      // 5: google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema
	(*PhysicalSchema_CsvSchema)(nil),      // 6: google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema
}
var file_google_cloud_datacatalog_v1_physical_schema_proto_depIdxs = []int32{
	1, // 0: google.cloud.datacatalog.v1.PhysicalSchema.avro:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.AvroSchema
	2, // 1: google.cloud.datacatalog.v1.PhysicalSchema.thrift:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.ThriftSchema
	3, // 2: google.cloud.datacatalog.v1.PhysicalSchema.protobuf:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.ProtobufSchema
	4, // 3: google.cloud.datacatalog.v1.PhysicalSchema.parquet:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.ParquetSchema
	5, // 4: google.cloud.datacatalog.v1.PhysicalSchema.orc:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.OrcSchema
	6, // 5: google.cloud.datacatalog.v1.PhysicalSchema.csv:type_name -> google.cloud.datacatalog.v1.PhysicalSchema.CsvSchema
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_physical_schema_proto_init() }
func file_google_cloud_datacatalog_v1_physical_schema_proto_init() {
	if File_google_cloud_datacatalog_v1_physical_schema_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_AvroSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_ThriftSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_ProtobufSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_ParquetSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_OrcSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalSchema_CsvSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*PhysicalSchema_Avro)(nil),
		(*PhysicalSchema_Thrift)(nil),
		(*PhysicalSchema_Protobuf)(nil),
		(*PhysicalSchema_Parquet)(nil),
		(*PhysicalSchema_Orc)(nil),
		(*PhysicalSchema_Csv)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_physical_schema_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_physical_schema_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_physical_schema_proto_depIdxs,
		MessageInfos:      file_google_cloud_datacatalog_v1_physical_schema_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_physical_schema_proto = out.File
	file_google_cloud_datacatalog_v1_physical_schema_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_physical_schema_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_physical_schema_proto_depIdxs = nil
}
