// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/dataplex/v1/data_profile.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// DataProfileScan related setting.
type DataProfileSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataProfileSpec) Reset() {
	*x = DataProfileSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileSpec) ProtoMessage() {}

func (x *DataProfileSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileSpec.ProtoReflect.Descriptor instead.
func (*DataProfileSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{0}
}

// DataProfileResult defines the output of DataProfileScan. Each field of the
// table will have field type specific profile result.
type DataProfileResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of rows scanned.
	RowCount int64 `protobuf:"varint,3,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// The profile information per field.
	Profile *DataProfileResult_Profile `protobuf:"bytes,4,opt,name=profile,proto3" json:"profile,omitempty"`
	// The data scanned for this result.
	ScannedData *ScannedData `protobuf:"bytes,5,opt,name=scanned_data,json=scannedData,proto3" json:"scanned_data,omitempty"`
}

func (x *DataProfileResult) Reset() {
	*x = DataProfileResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult) ProtoMessage() {}

func (x *DataProfileResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult.ProtoReflect.Descriptor instead.
func (*DataProfileResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1}
}

func (x *DataProfileResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *DataProfileResult) GetProfile() *DataProfileResult_Profile {
	if x != nil {
		return x.Profile
	}
	return nil
}

func (x *DataProfileResult) GetScannedData() *ScannedData {
	if x != nil {
		return x.ScannedData
	}
	return nil
}

// Contains name, type, mode and field type specific profile information.
type DataProfileResult_Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of fields with structural and profile information for each field.
	Fields []*DataProfileResult_Profile_Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *DataProfileResult_Profile) Reset() {
	*x = DataProfileResult_Profile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile) ProtoMessage() {}

func (x *DataProfileResult_Profile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DataProfileResult_Profile) GetFields() []*DataProfileResult_Profile_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

// A field within a table.
type DataProfileResult_Profile_Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The data type retrieved from the schema of the data source. For
	// instance, for a BigQuery native table, it is the [BigQuery Table
	// Schema](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#tablefieldschema).
	// For a Dataplex Entity, it is the [Entity
	// Schema](https://cloud.google.com/dataplex/docs/reference/rpc/google.cloud.dataplex.v1#type_3).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The mode of the field. Possible values include:
	//
	// * REQUIRED, if it is a required field.
	// * NULLABLE, if it is an optional field.
	// * REPEATED, if it is a repeated field.
	Mode string `protobuf:"bytes,3,opt,name=mode,proto3" json:"mode,omitempty"`
	// Profile information for the corresponding field.
	Profile *DataProfileResult_Profile_Field_ProfileInfo `protobuf:"bytes,4,opt,name=profile,proto3" json:"profile,omitempty"`
}

func (x *DataProfileResult_Profile_Field) Reset() {
	*x = DataProfileResult_Profile_Field{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *DataProfileResult_Profile_Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetProfile() *DataProfileResult_Profile_Field_ProfileInfo {
	if x != nil {
		return x.Profile
	}
	return nil
}

// The profile information for each field type.
type DataProfileResult_Profile_Field_ProfileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ratio of rows with null value against total scanned rows.
	NullRatio float64 `protobuf:"fixed64,2,opt,name=null_ratio,json=nullRatio,proto3" json:"null_ratio,omitempty"`
	// Ratio of rows with distinct values against total scanned rows.
	// Not available for complex non-groupable field type RECORD and fields
	// with REPEATABLE mode.
	DistinctRatio float64 `protobuf:"fixed64,3,opt,name=distinct_ratio,json=distinctRatio,proto3" json:"distinct_ratio,omitempty"`
	// The list of top N non-null values and number of times they occur in
	// the scanned data. N is 10 or equal to the number of distinct values
	// in the field, whichever is smaller. Not available for complex
	// non-groupable field type RECORD and fields with REPEATABLE mode.
	TopNValues []*DataProfileResult_Profile_Field_ProfileInfo_TopNValue `protobuf:"bytes,4,rep,name=top_n_values,json=topNValues,proto3" json:"top_n_values,omitempty"`
	// Structural and profile information for specific field type. Not
	// available, if mode is REPEATABLE.
	//
	// Types that are assignable to FieldInfo:
	//	*DataProfileResult_Profile_Field_ProfileInfo_StringProfile
	//	*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile
	//	*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile
	FieldInfo isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo `protobuf_oneof:"field_info"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetNullRatio() float64 {
	if x != nil {
		return x.NullRatio
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetDistinctRatio() float64 {
	if x != nil {
		return x.DistinctRatio
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetTopNValues() []*DataProfileResult_Profile_Field_ProfileInfo_TopNValue {
	if x != nil {
		return x.TopNValues
	}
	return nil
}

func (m *DataProfileResult_Profile_Field_ProfileInfo) GetFieldInfo() isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo {
	if m != nil {
		return m.FieldInfo
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetStringProfile() *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_StringProfile); ok {
		return x.StringProfile
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetIntegerProfile() *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile); ok {
		return x.IntegerProfile
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetDoubleProfile() *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile); ok {
		return x.DoubleProfile
	}
	return nil
}

type isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo interface {
	isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo()
}

type DataProfileResult_Profile_Field_ProfileInfo_StringProfile struct {
	// String type field information.
	StringProfile *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo `protobuf:"bytes,101,opt,name=string_profile,json=stringProfile,proto3,oneof"`
}

type DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile struct {
	// Integer type field information.
	IntegerProfile *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo `protobuf:"bytes,102,opt,name=integer_profile,json=integerProfile,proto3,oneof"`
}

type DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile struct {
	// Double type field information.
	DoubleProfile *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo `protobuf:"bytes,103,opt,name=double_profile,json=doubleProfile,proto3,oneof"`
}

func (*DataProfileResult_Profile_Field_ProfileInfo_StringProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

// The profile information for a string type field.
type DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum length of non-null values in the scanned data.
	MinLength int64 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Maximum length of non-null values in the scanned data.
	MaxLength int64 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
	// Average length of non-null values in the scanned data.
	AverageLength float64 `protobuf:"fixed64,3,opt,name=average_length,json=averageLength,proto3" json:"average_length,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 0}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetMinLength() int64 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetMaxLength() int64 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetAverageLength() float64 {
	if x != nil {
		return x.AverageLength
	}
	return 0
}

// The profile information for an integer type field.
type DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Average float64 `protobuf:"fixed64,1,opt,name=average,proto3" json:"average,omitempty"`
	// Standard deviation of non-null values in the scanned data. NaN, if
	// the field has a NaN.
	StandardDeviation float64 `protobuf:"fixed64,3,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Minimum of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Min int64 `protobuf:"varint,4,opt,name=min,proto3" json:"min,omitempty"`
	// A quartile divides the number of data points into four parts, or
	// quarters, of more-or-less equal size. Three main quartiles used
	// are: The first quartile (Q1) splits off the lowest 25% of data from
	// the highest 75%. It is also known as the lower or 25th empirical
	// quartile, as 25% of the data is below this point. The second
	// quartile (Q2) is the median of a data set. So, 50% of the data lies
	// below this point. The third quartile (Q3) splits off the highest
	// 25% of data from the lowest 75%. It is known as the upper or 75th
	// empirical quartile, as 75% of the data lies below this point.
	// Here, the quartiles is provided as an ordered list of quartile
	// values for the scanned data, occurring in order Q1, median, Q3.
	Quartiles []int64 `protobuf:"varint,6,rep,packed,name=quartiles,proto3" json:"quartiles,omitempty"`
	// Maximum of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Max int64 `protobuf:"varint,5,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 1}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetAverage() float64 {
	if x != nil {
		return x.Average
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetStandardDeviation() float64 {
	if x != nil {
		return x.StandardDeviation
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetMin() int64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetQuartiles() []int64 {
	if x != nil {
		return x.Quartiles
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetMax() int64 {
	if x != nil {
		return x.Max
	}
	return 0
}

// The profile information for a double type field.
type DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Average float64 `protobuf:"fixed64,1,opt,name=average,proto3" json:"average,omitempty"`
	// Standard deviation of non-null values in the scanned data. NaN, if
	// the field has a NaN.
	StandardDeviation float64 `protobuf:"fixed64,3,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Minimum of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Min float64 `protobuf:"fixed64,4,opt,name=min,proto3" json:"min,omitempty"`
	// A quartile divides the number of data points into four parts, or
	// quarters, of more-or-less equal size. Three main quartiles used
	// are: The first quartile (Q1) splits off the lowest 25% of data from
	// the highest 75%. It is also known as the lower or 25th empirical
	// quartile, as 25% of the data is below this point. The second
	// quartile (Q2) is the median of a data set. So, 50% of the data lies
	// below this point. The third quartile (Q3) splits off the highest
	// 25% of data from the lowest 75%. It is known as the upper or 75th
	// empirical quartile, as 75% of the data lies below this point.
	// Here, the quartiles is provided as an ordered list of quartile
	// values for the scanned data, occurring in order Q1, median, Q3.
	Quartiles []float64 `protobuf:"fixed64,6,rep,packed,name=quartiles,proto3" json:"quartiles,omitempty"`
	// Maximum of non-null values in the scanned data. NaN, if the field
	// has a NaN.
	Max float64 `protobuf:"fixed64,5,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 2}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetAverage() float64 {
	if x != nil {
		return x.Average
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetStandardDeviation() float64 {
	if x != nil {
		return x.StandardDeviation
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetQuartiles() []float64 {
	if x != nil {
		return x.Quartiles
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

// Top N non-null values in the scanned data.
type DataProfileResult_Profile_Field_ProfileInfo_TopNValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String value of a top N non-null value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Count of the corresponding value in the scanned data.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_TopNValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_TopNValue) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_TopNValue.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_TopNValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 3}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

var File_google_cloud_dataplex_v1_data_profile_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_data_profile_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x11, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x22, 0x9a, 0x0c, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x1a, 0xce, 0x0a, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x51,
	0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x1a, 0xef, 0x09, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x5f, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0xc8, 0x08, 0x0a, 0x0b, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6e, 0x75,
	0x6c, 0x6c, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x63, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x71,
	0x0a, 0x0c, 0x74, 0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x6f, 0x70, 0x4e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x4e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x7e, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x0e, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0x76, 0x0a, 0x0f, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d, 0x69,
	0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x1a, 0x9d, 0x01,
	0x0a, 0x10, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x12,
	0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d,
	0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x1c, 0x0a,
	0x09, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x09, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6d,
	0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x1a, 0x9c, 0x01,
	0x0a, 0x0f, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x73,
	0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x01, 0x52,
	0x09, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61,
	0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x1a, 0x37, 0x0a, 0x09,
	0x54, 0x6f, 0x70, 0x4e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x42, 0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescData = file_google_cloud_dataplex_v1_data_profile_proto_rawDesc
)

func file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_data_profile_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_data_profile_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescData
}

var file_google_cloud_dataplex_v1_data_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_dataplex_v1_data_profile_proto_goTypes = []interface{}{
	(*DataProfileSpec)(nil),                                              // 0: google.cloud.dataplex.v1.DataProfileSpec
	(*DataProfileResult)(nil),                                            // 1: google.cloud.dataplex.v1.DataProfileResult
	(*DataProfileResult_Profile)(nil),                                    // 2: google.cloud.dataplex.v1.DataProfileResult.Profile
	(*DataProfileResult_Profile_Field)(nil),                              // 3: google.cloud.dataplex.v1.DataProfileResult.Profile.Field
	(*DataProfileResult_Profile_Field_ProfileInfo)(nil),                  // 4: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo)(nil),  // 5: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.StringFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo)(nil), // 6: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.IntegerFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo)(nil),  // 7: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.DoubleFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_TopNValue)(nil),        // 8: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.TopNValue
	(*ScannedData)(nil),                                                  // 9: google.cloud.dataplex.v1.ScannedData
}
var file_google_cloud_dataplex_v1_data_profile_proto_depIdxs = []int32{
	2, // 0: google.cloud.dataplex.v1.DataProfileResult.profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile
	9, // 1: google.cloud.dataplex.v1.DataProfileResult.scanned_data:type_name -> google.cloud.dataplex.v1.ScannedData
	3, // 2: google.cloud.dataplex.v1.DataProfileResult.Profile.fields:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field
	4, // 3: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo
	8, // 4: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.top_n_values:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.TopNValue
	5, // 5: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.string_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.StringFieldInfo
	6, // 6: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.integer_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.IntegerFieldInfo
	7, // 7: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.double_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.DoubleFieldInfo
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_data_profile_proto_init() }
func file_google_cloud_dataplex_v1_data_profile_proto_init() {
	if File_google_cloud_dataplex_v1_data_profile_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_processing_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field_ProfileInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataProfileResult_Profile_Field_ProfileInfo_TopNValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*DataProfileResult_Profile_Field_ProfileInfo_StringProfile)(nil),
		(*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile)(nil),
		(*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_data_profile_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_data_profile_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_data_profile_proto_depIdxs,
		MessageInfos:      file_google_cloud_dataplex_v1_data_profile_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_data_profile_proto = out.File
	file_google_cloud_dataplex_v1_data_profile_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_data_profile_proto_goTypes = nil
	file_google_cloud_dataplex_v1_data_profile_proto_depIdxs = nil
}
