// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/maps/places/v1/places_service.proto

package placespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// How results will be ranked in the response.
type SearchTextRequest_RankPreference int32

const (
	// RankPreference value not set. Will default to DISTANCE.
	SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED SearchTextRequest_RankPreference = 0
	// Ranks results by distance.
	SearchTextRequest_DISTANCE SearchTextRequest_RankPreference = 1
	// Ranks results by relevance. Sort order determined by normal ranking
	// stack. See SortRefinement::RELEVANCE.
	SearchTextRequest_RELEVANCE SearchTextRequest_RankPreference = 2
)

// Enum value maps for SearchTextRequest_RankPreference.
var (
	SearchTextRequest_RankPreference_name = map[int32]string{
		0: "RANK_PREFERENCE_UNSPECIFIED",
		1: "DISTANCE",
		2: "RELEVANCE",
	}
	SearchTextRequest_RankPreference_value = map[string]int32{
		"RANK_PREFERENCE_UNSPECIFIED": 0,
		"DISTANCE":                    1,
		"RELEVANCE":                   2,
	}
)

func (x SearchTextRequest_RankPreference) Enum() *SearchTextRequest_RankPreference {
	p := new(SearchTextRequest_RankPreference)
	*p = x
	return p
}

func (x SearchTextRequest_RankPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchTextRequest_RankPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_places_service_proto_enumTypes[0].Descriptor()
}

func (SearchTextRequest_RankPreference) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_places_service_proto_enumTypes[0]
}

func (x SearchTextRequest_RankPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchTextRequest_RankPreference.Descriptor instead.
func (SearchTextRequest_RankPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 0}
}

// int 32 range. Both min and max are optional. If only min is set, then the
// range only has a lower bound. If only max is set, then range only has an
// upper bound. At least one of min and max must be set. Values are inclusive.
type Int32Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound. If unset, behavior is documented on the range field.
	Min *int32 `protobuf:"varint,1,opt,name=min,proto3,oneof" json:"min,omitempty"`
	// Upper bound. If unset, behavior is documented on the range field.
	Max *int32 `protobuf:"varint,2,opt,name=max,proto3,oneof" json:"max,omitempty"`
}

func (x *Int32Range) Reset() {
	*x = Int32Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Int32Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int32Range) ProtoMessage() {}

func (x *Int32Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Int32Range.ProtoReflect.Descriptor instead.
func (*Int32Range) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{0}
}

func (x *Int32Range) GetMin() int32 {
	if x != nil && x.Min != nil {
		return *x.Min
	}
	return 0
}

func (x *Int32Range) GetMax() int32 {
	if x != nil && x.Max != nil {
		return *x.Max
	}
	return 0
}

// Request data structure for SearchText.
type SearchTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text query for textual search.
	TextQuery string `protobuf:"bytes,1,opt,name=text_query,json=textQuery,proto3" json:"text_query,omitempty"`
	// Place details will be displayed with the preferred language if available.
	// If the language code is unspecified or unrecognized, place details of any
	// language may be returned, with a preference for English if such details
	// exist.
	//
	// Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Unicode country/region code (CLDR) of the location where the
	// request is coming from. It is used to display the place details, like
	// region-specific place name, if available.
	//
	// For more information, see
	// http://www.unicode.org/reports/tr35/#unicode_region_subtag.
	//
	//
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// How results will be ranked in the response.
	RankPreference SearchTextRequest_RankPreference `protobuf:"varint,4,opt,name=rank_preference,json=rankPreference,proto3,enum=google.maps.places.v1.SearchTextRequest_RankPreference" json:"rank_preference,omitempty"`
	// The region to search. Setting location would usually yields
	// better results. Recommended to set. This location serves as a bias unless
	// strict_restriction is set to true, which turns the location to a strict
	// restriction.
	//
	// Deprecated.  Use LocationRestriction or LocationBias instead.
	//
	// Deprecated: Marked as deprecated in google/maps/places/v1/places_service.proto.
	Location *SearchTextRequest_Location `protobuf:"bytes,5,opt,name=location,proto3" json:"location,omitempty"`
	// The requested place type. Full list of types supported:
	// https://developers.google.com/places/supported_types. Only support one
	// included type.
	IncludedType string `protobuf:"bytes,6,opt,name=included_type,json=includedType,proto3" json:"included_type,omitempty"`
	// Used to restrict the search to places that are open at a specific time.
	// open_now marks if a business is currently open.
	OpenNow bool `protobuf:"varint,7,opt,name=open_now,json=openNow,proto3" json:"open_now,omitempty"`
	// [Deprecated!]Used to restrict the search to places that are within a
	// certain price range. This is on a scale of 0 to 4. Set a minimum of 0 or
	// set a maximum of 4 has no effect on the search results. Min price is
	// default to 0 and max price is default to 4. Default value will be used if
	// either min or max is unset.
	//
	// Deprecated: Marked as deprecated in google/maps/places/v1/places_service.proto.
	PriceRange *Int32Range `protobuf:"bytes,8,opt,name=price_range,json=priceRange,proto3" json:"price_range,omitempty"`
	// Filter out results whose average user rating is strictly less than this
	// limit. A valid value must be an float between 0 and 5 (inclusively) at a
	// 0.5 cadence i.e. `[0, 0.5, 1.0, ... , 5.0]` inclusively. This is to keep
	// parity with LocalRefinement_UserRating. The input rating will round up to
	// the nearest 0.5(ceiling). For instance, a rating of 0.6 will eliminate all
	// results with a less than 1.0 rating.
	MinRating float64 `protobuf:"fixed64,9,opt,name=min_rating,json=minRating,proto3" json:"min_rating,omitempty"`
	// Maximum number of results to return. It must be between 1 and 20,
	// inclusively. If the number is unset, it falls back to the upper limit. If
	// the number is set to negative or exceeds the upper limit, an
	// INVALID_ARGUMENT error is returned.
	MaxResultCount int32 `protobuf:"varint,10,opt,name=max_result_count,json=maxResultCount,proto3" json:"max_result_count,omitempty"`
	// Used to restrict the search to places that are marked as certain price
	// levels. Users can choose any combinations of price levels. Default to
	// select all price levels.
	PriceLevels []PriceLevel `protobuf:"varint,11,rep,packed,name=price_levels,json=priceLevels,proto3,enum=google.maps.places.v1.PriceLevel" json:"price_levels,omitempty"`
	// Used to set strict type filtering for included_type. If set to true, only
	// results of the same type will be returned. Default to false.
	StrictTypeFiltering bool `protobuf:"varint,12,opt,name=strict_type_filtering,json=strictTypeFiltering,proto3" json:"strict_type_filtering,omitempty"`
	// The region to search. This location serves as a bias which means results
	// around given location might be returned. Cannot be set along with
	// location_restriction.
	LocationBias *SearchTextRequest_LocationBias `protobuf:"bytes,13,opt,name=location_bias,json=locationBias,proto3" json:"location_bias,omitempty"`
	// The region to search. This location serves as a restriction which means
	// results outside given location will not be returned. Cannot be set along
	// with location_bias.
	LocationRestriction *SearchTextRequest_LocationRestriction `protobuf:"bytes,14,opt,name=location_restriction,json=locationRestriction,proto3" json:"location_restriction,omitempty"`
}

func (x *SearchTextRequest) Reset() {
	*x = SearchTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest) ProtoMessage() {}

func (x *SearchTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest.ProtoReflect.Descriptor instead.
func (*SearchTextRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchTextRequest) GetTextQuery() string {
	if x != nil {
		return x.TextQuery
	}
	return ""
}

func (x *SearchTextRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SearchTextRequest) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *SearchTextRequest) GetRankPreference() SearchTextRequest_RankPreference {
	if x != nil {
		return x.RankPreference
	}
	return SearchTextRequest_RANK_PREFERENCE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/maps/places/v1/places_service.proto.
func (x *SearchTextRequest) GetLocation() *SearchTextRequest_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *SearchTextRequest) GetIncludedType() string {
	if x != nil {
		return x.IncludedType
	}
	return ""
}

func (x *SearchTextRequest) GetOpenNow() bool {
	if x != nil {
		return x.OpenNow
	}
	return false
}

// Deprecated: Marked as deprecated in google/maps/places/v1/places_service.proto.
func (x *SearchTextRequest) GetPriceRange() *Int32Range {
	if x != nil {
		return x.PriceRange
	}
	return nil
}

func (x *SearchTextRequest) GetMinRating() float64 {
	if x != nil {
		return x.MinRating
	}
	return 0
}

func (x *SearchTextRequest) GetMaxResultCount() int32 {
	if x != nil {
		return x.MaxResultCount
	}
	return 0
}

func (x *SearchTextRequest) GetPriceLevels() []PriceLevel {
	if x != nil {
		return x.PriceLevels
	}
	return nil
}

func (x *SearchTextRequest) GetStrictTypeFiltering() bool {
	if x != nil {
		return x.StrictTypeFiltering
	}
	return false
}

func (x *SearchTextRequest) GetLocationBias() *SearchTextRequest_LocationBias {
	if x != nil {
		return x.LocationBias
	}
	return nil
}

func (x *SearchTextRequest) GetLocationRestriction() *SearchTextRequest_LocationRestriction {
	if x != nil {
		return x.LocationRestriction
	}
	return nil
}

// Response proto for SearchText.
type SearchTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of places that meet the user's text search criteria.
	Places []*Place `protobuf:"bytes,1,rep,name=places,proto3" json:"places,omitempty"`
}

func (x *SearchTextResponse) Reset() {
	*x = SearchTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextResponse) ProtoMessage() {}

func (x *SearchTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextResponse.ProtoReflect.Descriptor instead.
func (*SearchTextResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{2}
}

func (x *SearchTextResponse) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

// The region to search.
//
// Deprecated. Use LocationRestriction or LocationBias instead.
type SearchTextRequest_Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*SearchTextRequest_Location_Rectangle
	Type isSearchTextRequest_Location_Type `protobuf_oneof:"type"`
	// Make location field a strict restriction and filter out POIs outside of
	// the given location. If location type field is unset this field will have
	// no effect.
	StrictRestriction bool `protobuf:"varint,2,opt,name=strict_restriction,json=strictRestriction,proto3" json:"strict_restriction,omitempty"`
}

func (x *SearchTextRequest_Location) Reset() {
	*x = SearchTextRequest_Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest_Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_Location) ProtoMessage() {}

func (x *SearchTextRequest_Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_Location.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_Location) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 0}
}

func (m *SearchTextRequest_Location) GetType() isSearchTextRequest_Location_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_Location) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_Location_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *SearchTextRequest_Location) GetStrictRestriction() bool {
	if x != nil {
		return x.StrictRestriction
	}
	return false
}

type isSearchTextRequest_Location_Type interface {
	isSearchTextRequest_Location_Type()
}

type SearchTextRequest_Location_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

func (*SearchTextRequest_Location_Rectangle) isSearchTextRequest_Location_Type() {}

// The region to search. This location serves as a bias which means results
// around given location might be returned.
type SearchTextRequest_LocationBias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*SearchTextRequest_LocationBias_Rectangle
	//	*SearchTextRequest_LocationBias_Circle
	Type isSearchTextRequest_LocationBias_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationBias) Reset() {
	*x = SearchTextRequest_LocationBias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest_LocationBias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationBias) ProtoMessage() {}

func (x *SearchTextRequest_LocationBias) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationBias.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationBias) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 1}
}

func (m *SearchTextRequest_LocationBias) GetType() isSearchTextRequest_LocationBias_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

func (x *SearchTextRequest_LocationBias) GetCircle() *Circle {
	if x, ok := x.GetType().(*SearchTextRequest_LocationBias_Circle); ok {
		return x.Circle
	}
	return nil
}

type isSearchTextRequest_LocationBias_Type interface {
	isSearchTextRequest_LocationBias_Type()
}

type SearchTextRequest_LocationBias_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

type SearchTextRequest_LocationBias_Circle struct {
	// A circle defined by center point and radius.
	Circle *Circle `protobuf:"bytes,2,opt,name=circle,proto3,oneof"`
}

func (*SearchTextRequest_LocationBias_Rectangle) isSearchTextRequest_LocationBias_Type() {}

func (*SearchTextRequest_LocationBias_Circle) isSearchTextRequest_LocationBias_Type() {}

// The region to search. This location serves as a restriction which means
// results outside given location will not be returned.
type SearchTextRequest_LocationRestriction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*SearchTextRequest_LocationRestriction_Rectangle
	Type isSearchTextRequest_LocationRestriction_Type `protobuf_oneof:"type"`
}

func (x *SearchTextRequest_LocationRestriction) Reset() {
	*x = SearchTextRequest_LocationRestriction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchTextRequest_LocationRestriction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTextRequest_LocationRestriction) ProtoMessage() {}

func (x *SearchTextRequest_LocationRestriction) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_places_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTextRequest_LocationRestriction.ProtoReflect.Descriptor instead.
func (*SearchTextRequest_LocationRestriction) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_places_service_proto_rawDescGZIP(), []int{1, 2}
}

func (m *SearchTextRequest_LocationRestriction) GetType() isSearchTextRequest_LocationRestriction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *SearchTextRequest_LocationRestriction) GetRectangle() *viewport.Viewport {
	if x, ok := x.GetType().(*SearchTextRequest_LocationRestriction_Rectangle); ok {
		return x.Rectangle
	}
	return nil
}

type isSearchTextRequest_LocationRestriction_Type interface {
	isSearchTextRequest_LocationRestriction_Type()
}

type SearchTextRequest_LocationRestriction_Rectangle struct {
	// A rectangle box defined by northeast and southwest corner.
	Rectangle *viewport.Viewport `protobuf:"bytes,1,opt,name=rectangle,proto3,oneof"`
}

func (*SearchTextRequest_LocationRestriction_Rectangle) isSearchTextRequest_LocationRestriction_Type() {
}

var File_google_maps_places_v1_places_service_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_places_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65,
	0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4a, 0x0a, 0x0a, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x61, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x88, 0x01, 0x01,
	0x42, 0x06, 0x0a, 0x04, 0x5f, 0x6d, 0x69, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x6d, 0x61, 0x78,
	0x22, 0xff, 0x09, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x74, 0x65, 0x78, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x60, 0x0a, 0x0f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x51, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x70,
	0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6f, 0x70,
	0x65, 0x6e, 0x4e, 0x6f, 0x77, 0x12, 0x46, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x10,
	0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x12, 0x5a, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x69, 0x61,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x52, 0x0c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x6f, 0x0a, 0x14,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x7c, 0x0a,
	0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x63,
	0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x56,
	0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61,
	0x6e, 0x67, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x11, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x8a, 0x01, 0x0a, 0x0c,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x69, 0x61, 0x73, 0x12, 0x39, 0x0a, 0x09,
	0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x09, 0x72, 0x65,
	0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x58, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x39, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52,
	0x09, 0x72, 0x65, 0x63, 0x74, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x4e, 0x0a, 0x0e, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x4e, 0x4b, 0x5f, 0x50, 0x52, 0x45,
	0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45,
	0x10, 0x02, 0x22, 0x4a, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x32, 0xa1,
	0x01, 0x0a, 0x06, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x7d, 0x0a, 0x0a, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x14, 0x3a, 0x01, 0x2a, 0x22, 0x0f, 0x2f, 0x76, 0x31, 0x2f, 0x54, 0x65, 0x78,
	0x74, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x18, 0xca, 0x41, 0x15, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x42, 0xa6, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70,
	0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_places_service_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_places_service_proto_rawDescData = file_google_maps_places_v1_places_service_proto_rawDesc
)

func file_google_maps_places_v1_places_service_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_places_service_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_places_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_places_service_proto_rawDescData)
	})
	return file_google_maps_places_v1_places_service_proto_rawDescData
}

var file_google_maps_places_v1_places_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_maps_places_v1_places_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_maps_places_v1_places_service_proto_goTypes = []interface{}{
	(SearchTextRequest_RankPreference)(0),         // 0: google.maps.places.v1.SearchTextRequest.RankPreference
	(*Int32Range)(nil),                            // 1: google.maps.places.v1.Int32Range
	(*SearchTextRequest)(nil),                     // 2: google.maps.places.v1.SearchTextRequest
	(*SearchTextResponse)(nil),                    // 3: google.maps.places.v1.SearchTextResponse
	(*SearchTextRequest_Location)(nil),            // 4: google.maps.places.v1.SearchTextRequest.Location
	(*SearchTextRequest_LocationBias)(nil),        // 5: google.maps.places.v1.SearchTextRequest.LocationBias
	(*SearchTextRequest_LocationRestriction)(nil), // 6: google.maps.places.v1.SearchTextRequest.LocationRestriction
	(PriceLevel)(0),                               // 7: google.maps.places.v1.PriceLevel
	(*Place)(nil),                                 // 8: google.maps.places.v1.Place
	(*viewport.Viewport)(nil),                     // 9: google.geo.type.Viewport
	(*Circle)(nil),                                // 10: google.maps.places.v1.Circle
}
var file_google_maps_places_v1_places_service_proto_depIdxs = []int32{
	0,  // 0: google.maps.places.v1.SearchTextRequest.rank_preference:type_name -> google.maps.places.v1.SearchTextRequest.RankPreference
	4,  // 1: google.maps.places.v1.SearchTextRequest.location:type_name -> google.maps.places.v1.SearchTextRequest.Location
	1,  // 2: google.maps.places.v1.SearchTextRequest.price_range:type_name -> google.maps.places.v1.Int32Range
	7,  // 3: google.maps.places.v1.SearchTextRequest.price_levels:type_name -> google.maps.places.v1.PriceLevel
	5,  // 4: google.maps.places.v1.SearchTextRequest.location_bias:type_name -> google.maps.places.v1.SearchTextRequest.LocationBias
	6,  // 5: google.maps.places.v1.SearchTextRequest.location_restriction:type_name -> google.maps.places.v1.SearchTextRequest.LocationRestriction
	8,  // 6: google.maps.places.v1.SearchTextResponse.places:type_name -> google.maps.places.v1.Place
	9,  // 7: google.maps.places.v1.SearchTextRequest.Location.rectangle:type_name -> google.geo.type.Viewport
	9,  // 8: google.maps.places.v1.SearchTextRequest.LocationBias.rectangle:type_name -> google.geo.type.Viewport
	10, // 9: google.maps.places.v1.SearchTextRequest.LocationBias.circle:type_name -> google.maps.places.v1.Circle
	9,  // 10: google.maps.places.v1.SearchTextRequest.LocationRestriction.rectangle:type_name -> google.geo.type.Viewport
	2,  // 11: google.maps.places.v1.Places.SearchText:input_type -> google.maps.places.v1.SearchTextRequest
	3,  // 12: google.maps.places.v1.Places.SearchText:output_type -> google.maps.places.v1.SearchTextResponse
	12, // [12:13] is the sub-list for method output_type
	11, // [11:12] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_places_service_proto_init() }
func file_google_maps_places_v1_places_service_proto_init() {
	if File_google_maps_places_v1_places_service_proto != nil {
		return
	}
	file_google_maps_places_v1_geometry_proto_init()
	file_google_maps_places_v1_place_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_places_v1_places_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Int32Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest_Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest_LocationBias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_places_v1_places_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchTextRequest_LocationRestriction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_maps_places_v1_places_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*SearchTextRequest_Location_Rectangle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*SearchTextRequest_LocationBias_Rectangle)(nil),
		(*SearchTextRequest_LocationBias_Circle)(nil),
	}
	file_google_maps_places_v1_places_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*SearchTextRequest_LocationRestriction_Rectangle)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_places_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_places_v1_places_service_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_places_service_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_places_service_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_places_service_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_places_service_proto = out.File
	file_google_maps_places_v1_places_service_proto_rawDesc = nil
	file_google_maps_places_v1_places_service_proto_goTypes = nil
	file_google_maps_places_v1_places_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PlacesClient is the client API for Places service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlacesClient interface {
	// Text query based place search.
	SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error)
}

type placesClient struct {
	cc grpc.ClientConnInterface
}

func NewPlacesClient(cc grpc.ClientConnInterface) PlacesClient {
	return &placesClient{cc}
}

func (c *placesClient) SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error) {
	out := new(SearchTextResponse)
	err := c.cc.Invoke(ctx, "/google.maps.places.v1.Places/SearchText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlacesServer is the server API for Places service.
type PlacesServer interface {
	// Text query based place search.
	SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error)
}

// UnimplementedPlacesServer can be embedded to have forward compatible implementations.
type UnimplementedPlacesServer struct {
}

func (*UnimplementedPlacesServer) SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchText not implemented")
}

func RegisterPlacesServer(s *grpc.Server, srv PlacesServer) {
	s.RegisterService(&_Places_serviceDesc, srv)
}

func _Places_SearchText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.places.v1.Places/SearchText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchText(ctx, req.(*SearchTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Places_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.places.v1.Places",
	HandlerType: (*PlacesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchText",
			Handler:    _Places_SearchText_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/places/v1/places_service.proto",
}
