// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/networksecurity/v1beta1/authorization_policy.proto

package networksecuritypb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible values that define what action to take.
type AuthorizationPolicy_Action int32

const (
	// Default value.
	AuthorizationPolicy_ACTION_UNSPECIFIED AuthorizationPolicy_Action = 0
	// Grant access.
	AuthorizationPolicy_ALLOW AuthorizationPolicy_Action = 1
	// Deny access.
	// Deny rules should be avoided unless they are used to provide a default
	// "deny all" fallback.
	AuthorizationPolicy_DENY AuthorizationPolicy_Action = 2
)

// Enum value maps for AuthorizationPolicy_Action.
var (
	AuthorizationPolicy_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	AuthorizationPolicy_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"ALLOW":              1,
		"DENY":               2,
	}
)

func (x AuthorizationPolicy_Action) Enum() *AuthorizationPolicy_Action {
	p := new(AuthorizationPolicy_Action)
	*p = x
	return p
}

func (x AuthorizationPolicy_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationPolicy_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_enumTypes[0].Descriptor()
}

func (AuthorizationPolicy_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_enumTypes[0]
}

func (x AuthorizationPolicy_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationPolicy_Action.Descriptor instead.
func (AuthorizationPolicy_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0}
}

// AuthorizationPolicy is a resource that specifies how a server
// should authorize incoming connections. This resource in itself does
// not change the configuration unless it's attached to a target https
// proxy or endpoint config selector resource.
type AuthorizationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the AuthorizationPolicy resource. It matches pattern
	// `projects/{project}/locations/{location}/authorizationPolicies/<authorization_policy>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Free-text description of the resource.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Set of label tags associated with the AuthorizationPolicy
	// resource.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The action to take when a rule match is found. Possible values
	// are "ALLOW" or "DENY".
	Action AuthorizationPolicy_Action `protobuf:"varint,6,opt,name=action,proto3,enum=google.cloud.networksecurity.v1beta1.AuthorizationPolicy_Action" json:"action,omitempty"`
	// Optional. List of rules to match. Note that at least one of the rules must
	// match in order for the action specified in the 'action' field to be taken.
	// A rule is a match if there is a matching source and destination. If left
	// blank, the action specified in the `action` field will be applied on every
	// request.
	Rules []*AuthorizationPolicy_Rule `protobuf:"bytes,7,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *AuthorizationPolicy) Reset() {
	*x = AuthorizationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy) ProtoMessage() {}

func (x *AuthorizationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0}
}

func (x *AuthorizationPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuthorizationPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AuthorizationPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AuthorizationPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AuthorizationPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AuthorizationPolicy) GetAction() AuthorizationPolicy_Action {
	if x != nil {
		return x.Action
	}
	return AuthorizationPolicy_ACTION_UNSPECIFIED
}

func (x *AuthorizationPolicy) GetRules() []*AuthorizationPolicy_Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Request used with the ListAuthorizationPolicies method.
type ListAuthorizationPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the AuthorizationPolicies
	// should be listed, specified in the format
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of AuthorizationPolicies to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListAuthorizationPoliciesResponse` Indicates that this is a
	// continuation of a prior `ListAuthorizationPolicies` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAuthorizationPoliciesRequest) Reset() {
	*x = ListAuthorizationPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAuthorizationPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAuthorizationPoliciesRequest) ProtoMessage() {}

func (x *ListAuthorizationPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAuthorizationPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListAuthorizationPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{1}
}

func (x *ListAuthorizationPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAuthorizationPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAuthorizationPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListAuthorizationPolicies method.
type ListAuthorizationPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of AuthorizationPolicies resources.
	AuthorizationPolicies []*AuthorizationPolicy `protobuf:"bytes,1,rep,name=authorization_policies,json=authorizationPolicies,proto3" json:"authorization_policies,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAuthorizationPoliciesResponse) Reset() {
	*x = ListAuthorizationPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAuthorizationPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAuthorizationPoliciesResponse) ProtoMessage() {}

func (x *ListAuthorizationPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAuthorizationPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListAuthorizationPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{2}
}

func (x *ListAuthorizationPoliciesResponse) GetAuthorizationPolicies() []*AuthorizationPolicy {
	if x != nil {
		return x.AuthorizationPolicies
	}
	return nil
}

func (x *ListAuthorizationPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetAuthorizationPolicy method.
type GetAuthorizationPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the AuthorizationPolicy to get. Must be in the format
	// `projects/{project}/locations/{location}/authorizationPolicies/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAuthorizationPolicyRequest) Reset() {
	*x = GetAuthorizationPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAuthorizationPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAuthorizationPolicyRequest) ProtoMessage() {}

func (x *GetAuthorizationPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAuthorizationPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetAuthorizationPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{3}
}

func (x *GetAuthorizationPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the CreateAuthorizationPolicy method.
type CreateAuthorizationPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the AuthorizationPolicy. Must be in the
	// format `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the AuthorizationPolicy resource to be created.
	// This value should be 1-63 characters long, containing only
	// letters, numbers, hyphens, and underscores, and should not start
	// with a number. E.g. "authz_policy".
	AuthorizationPolicyId string `protobuf:"bytes,2,opt,name=authorization_policy_id,json=authorizationPolicyId,proto3" json:"authorization_policy_id,omitempty"`
	// Required. AuthorizationPolicy resource to be created.
	AuthorizationPolicy *AuthorizationPolicy `protobuf:"bytes,3,opt,name=authorization_policy,json=authorizationPolicy,proto3" json:"authorization_policy,omitempty"`
}

func (x *CreateAuthorizationPolicyRequest) Reset() {
	*x = CreateAuthorizationPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAuthorizationPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAuthorizationPolicyRequest) ProtoMessage() {}

func (x *CreateAuthorizationPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAuthorizationPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateAuthorizationPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{4}
}

func (x *CreateAuthorizationPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAuthorizationPolicyRequest) GetAuthorizationPolicyId() string {
	if x != nil {
		return x.AuthorizationPolicyId
	}
	return ""
}

func (x *CreateAuthorizationPolicyRequest) GetAuthorizationPolicy() *AuthorizationPolicy {
	if x != nil {
		return x.AuthorizationPolicy
	}
	return nil
}

// Request used by the UpdateAuthorizationPolicy method.
type UpdateAuthorizationPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// AuthorizationPolicy resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated AuthorizationPolicy resource.
	AuthorizationPolicy *AuthorizationPolicy `protobuf:"bytes,2,opt,name=authorization_policy,json=authorizationPolicy,proto3" json:"authorization_policy,omitempty"`
}

func (x *UpdateAuthorizationPolicyRequest) Reset() {
	*x = UpdateAuthorizationPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAuthorizationPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAuthorizationPolicyRequest) ProtoMessage() {}

func (x *UpdateAuthorizationPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAuthorizationPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateAuthorizationPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateAuthorizationPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAuthorizationPolicyRequest) GetAuthorizationPolicy() *AuthorizationPolicy {
	if x != nil {
		return x.AuthorizationPolicy
	}
	return nil
}

// Request used by the DeleteAuthorizationPolicy method.
type DeleteAuthorizationPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the AuthorizationPolicy to delete. Must be in the
	// format `projects/{project}/locations/{location}/authorizationPolicies/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAuthorizationPolicyRequest) Reset() {
	*x = DeleteAuthorizationPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAuthorizationPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAuthorizationPolicyRequest) ProtoMessage() {}

func (x *DeleteAuthorizationPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAuthorizationPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteAuthorizationPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteAuthorizationPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specification of rules.
type AuthorizationPolicy_Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of attributes for the traffic source. All of the sources
	// must match. A source is a match if both principals and ip_blocks match.
	// If not set, the action specified in the 'action' field will be applied
	// without any rule checks for the source.
	Sources []*AuthorizationPolicy_Rule_Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Optional. List of attributes for the traffic destination. All of the
	// destinations must match. A destination is a match if a request matches
	// all the specified hosts, ports, methods and headers. If not set, the
	// action specified in the 'action' field will be applied without any rule
	// checks for the destination.
	Destinations []*AuthorizationPolicy_Rule_Destination `protobuf:"bytes,2,rep,name=destinations,proto3" json:"destinations,omitempty"`
}

func (x *AuthorizationPolicy_Rule) Reset() {
	*x = AuthorizationPolicy_Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationPolicy_Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy_Rule) ProtoMessage() {}

func (x *AuthorizationPolicy_Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy_Rule.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy_Rule) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AuthorizationPolicy_Rule) GetSources() []*AuthorizationPolicy_Rule_Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *AuthorizationPolicy_Rule) GetDestinations() []*AuthorizationPolicy_Rule_Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

// Specification of traffic source attributes.
type AuthorizationPolicy_Rule_Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of peer identities to match for authorization. At least
	// one principal should match. Each peer can be an exact match, or a
	// prefix match (example, "namespace/*") or a suffix match (example,
	// "*/service-account") or a presence match "*". Authorization based on
	// the principal name without certificate validation (configured by
	// ServerTlsPolicy resource) is considered insecure.
	Principals []string `protobuf:"bytes,1,rep,name=principals,proto3" json:"principals,omitempty"`
	// Optional. List of CIDR ranges to match based on source IP address. At
	// least one IP block should match. Single IP (e.g., "1.2.3.4") and CIDR
	// (e.g., "1.2.3.0/24") are supported. Authorization based on source IP
	// alone should be avoided. The IP addresses of any load balancers or
	// proxies should be considered untrusted.
	IpBlocks []string `protobuf:"bytes,2,rep,name=ip_blocks,json=ipBlocks,proto3" json:"ip_blocks,omitempty"`
}

func (x *AuthorizationPolicy_Rule_Source) Reset() {
	*x = AuthorizationPolicy_Rule_Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationPolicy_Rule_Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy_Rule_Source) ProtoMessage() {}

func (x *AuthorizationPolicy_Rule_Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy_Rule_Source.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy_Rule_Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *AuthorizationPolicy_Rule_Source) GetPrincipals() []string {
	if x != nil {
		return x.Principals
	}
	return nil
}

func (x *AuthorizationPolicy_Rule_Source) GetIpBlocks() []string {
	if x != nil {
		return x.IpBlocks
	}
	return nil
}

// Specification of traffic destination attributes.
type AuthorizationPolicy_Rule_Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of host names to match. Matched against the ":authority"
	// header in http requests. At least one host should match. Each host can
	// be an exact match, or a prefix match (example "mydomain.*") or a suffix
	// match (example "*.myorg.com") or a presence (any) match "*".
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Required. List of destination ports to match. At least one port should
	// match.
	Ports []uint32 `protobuf:"varint,2,rep,packed,name=ports,proto3" json:"ports,omitempty"`
	// Optional. A list of HTTP methods to match. At least one method should
	// match. Should not be set for gRPC services.
	Methods []string `protobuf:"bytes,4,rep,name=methods,proto3" json:"methods,omitempty"`
	// Optional. Match against key:value pair in http header. Provides a
	// flexible match based on HTTP headers, for potentially advanced use
	// cases. At least one header should match. Avoid using header matches to
	// make authorization decisions unless there is a strong guarantee that
	// requests arrive through a trusted client or proxy.
	HttpHeaderMatch *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch `protobuf:"bytes,5,opt,name=http_header_match,json=httpHeaderMatch,proto3" json:"http_header_match,omitempty"`
}

func (x *AuthorizationPolicy_Rule_Destination) Reset() {
	*x = AuthorizationPolicy_Rule_Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationPolicy_Rule_Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy_Rule_Destination) ProtoMessage() {}

func (x *AuthorizationPolicy_Rule_Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy_Rule_Destination.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy_Rule_Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *AuthorizationPolicy_Rule_Destination) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *AuthorizationPolicy_Rule_Destination) GetPorts() []uint32 {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *AuthorizationPolicy_Rule_Destination) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *AuthorizationPolicy_Rule_Destination) GetHttpHeaderMatch() *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch {
	if x != nil {
		return x.HttpHeaderMatch
	}
	return nil
}

// Specification of HTTP header match attributes.
type AuthorizationPolicy_Rule_Destination_HttpHeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_RegexMatch
	Type isAuthorizationPolicy_Rule_Destination_HttpHeaderMatch_Type `protobuf_oneof:"type"`
	// Required. The name of the HTTP header to match. For matching
	// against the HTTP request's authority, use a headerMatch
	// with the header name ":authority". For matching a
	// request's method, use the headerName ":method".
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
}

func (x *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) Reset() {
	*x = AuthorizationPolicy_Rule_Destination_HttpHeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) ProtoMessage() {}

func (x *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationPolicy_Rule_Destination_HttpHeaderMatch.ProtoReflect.Descriptor instead.
func (*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP(), []int{0, 0, 1, 0}
}

func (m *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) GetType() isAuthorizationPolicy_Rule_Destination_HttpHeaderMatch_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) GetRegexMatch() string {
	if x, ok := x.GetType().(*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (x *AuthorizationPolicy_Rule_Destination_HttpHeaderMatch) GetHeaderName() string {
	if x != nil {
		return x.HeaderName
	}
	return ""
}

type isAuthorizationPolicy_Rule_Destination_HttpHeaderMatch_Type interface {
	isAuthorizationPolicy_Rule_Destination_HttpHeaderMatch_Type()
}

type AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_RegexMatch struct {
	// Required. The value of the header must match the regular expression
	// specified in regexMatch. For regular expression grammar,
	// please see: en.cppreference.com/w/cpp/regex/ecmascript
	// For matching against a port specified in the HTTP
	// request, use a headerMatch with headerName set to Host
	// and a regular expression that satisfies the RFC2616 Host
	// header's port specifier.
	RegexMatch string `protobuf:"bytes,2,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}

func (*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_RegexMatch) isAuthorizationPolicy_Rule_Destination_HttpHeaderMatch_Type() {
}

var File_google_cloud_networksecurity_v1beta1_authorization_policy_proto protoreflect.FileDescriptor

var file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b, 0x0b, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x62, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5d, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x1a, 0x8e, 0x05, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x07, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x73, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4f, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23,
	0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69, 0x70, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x1a, 0xd9, 0x02, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73,
	0x12, 0x19, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x11, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68, 0x74, 0x74, 0x70, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x67, 0x0a, 0x0f, 0x48, 0x74, 0x74, 0x70,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x26, 0x0a, 0x0b, 0x72,
	0x65, 0x67, 0x65, 0x78, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x65, 0x78, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x35, 0x0a, 0x06,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e,
	0x59, 0x10, 0x02, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x54,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x7d, 0x22, 0xa1, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70,
	0x0a, 0x16, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6f, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a,
	0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x02, 0x0a, 0x20, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12,
	0x71, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0xd7, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x71, 0x0a, 0x14, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x72, 0x0a, 0x20,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x92, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x62, 0xaa, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x27, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescOnce sync.Once
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescData = file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDesc
)

func file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescGZIP() []byte {
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescOnce.Do(func() {
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescData)
	})
	return file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDescData
}

var file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_goTypes = []interface{}{
	(AuthorizationPolicy_Action)(0),                              // 0: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action
	(*AuthorizationPolicy)(nil),                                  // 1: google.cloud.networksecurity.v1beta1.AuthorizationPolicy
	(*ListAuthorizationPoliciesRequest)(nil),                     // 2: google.cloud.networksecurity.v1beta1.ListAuthorizationPoliciesRequest
	(*ListAuthorizationPoliciesResponse)(nil),                    // 3: google.cloud.networksecurity.v1beta1.ListAuthorizationPoliciesResponse
	(*GetAuthorizationPolicyRequest)(nil),                        // 4: google.cloud.networksecurity.v1beta1.GetAuthorizationPolicyRequest
	(*CreateAuthorizationPolicyRequest)(nil),                     // 5: google.cloud.networksecurity.v1beta1.CreateAuthorizationPolicyRequest
	(*UpdateAuthorizationPolicyRequest)(nil),                     // 6: google.cloud.networksecurity.v1beta1.UpdateAuthorizationPolicyRequest
	(*DeleteAuthorizationPolicyRequest)(nil),                     // 7: google.cloud.networksecurity.v1beta1.DeleteAuthorizationPolicyRequest
	(*AuthorizationPolicy_Rule)(nil),                             // 8: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
	nil,                                                          // 9: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.LabelsEntry
	(*AuthorizationPolicy_Rule_Source)(nil),                      // 10: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
	(*AuthorizationPolicy_Rule_Destination)(nil),                 // 11: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
	(*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch)(nil), // 12: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch
	(*timestamppb.Timestamp)(nil),                                // 13: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                                // 14: google.protobuf.FieldMask
}
var file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_depIdxs = []int32{
	13, // 0: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.create_time:type_name -> google.protobuf.Timestamp
	13, // 1: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.update_time:type_name -> google.protobuf.Timestamp
	9,  // 2: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.labels:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.LabelsEntry
	0,  // 3: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.action:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Action
	8,  // 4: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.rules:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule
	1,  // 5: google.cloud.networksecurity.v1beta1.ListAuthorizationPoliciesResponse.authorization_policies:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy
	1,  // 6: google.cloud.networksecurity.v1beta1.CreateAuthorizationPolicyRequest.authorization_policy:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy
	14, // 7: google.cloud.networksecurity.v1beta1.UpdateAuthorizationPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 8: google.cloud.networksecurity.v1beta1.UpdateAuthorizationPolicyRequest.authorization_policy:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy
	10, // 9: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.sources:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Source
	11, // 10: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.destinations:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination
	12, // 11: google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.http_header_match:type_name -> google.cloud.networksecurity.v1beta1.AuthorizationPolicy.Rule.Destination.HttpHeaderMatch
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_init() }
func file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_init() {
	if File_google_cloud_networksecurity_v1beta1_authorization_policy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAuthorizationPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAuthorizationPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAuthorizationPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAuthorizationPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAuthorizationPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAuthorizationPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationPolicy_Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationPolicy_Rule_Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationPolicy_Rule_Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*AuthorizationPolicy_Rule_Destination_HttpHeaderMatch_RegexMatch)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_goTypes,
		DependencyIndexes: file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_depIdxs,
		EnumInfos:         file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_enumTypes,
		MessageInfos:      file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_msgTypes,
	}.Build()
	File_google_cloud_networksecurity_v1beta1_authorization_policy_proto = out.File
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_rawDesc = nil
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_goTypes = nil
	file_google_cloud_networksecurity_v1beta1_authorization_policy_proto_depIdxs = nil
}
