// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.23.2
// source: google/cloud/osconfig/agentendpoint/v1/os_policy.proto

package agentendpointpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Policy mode
type OSPolicy_Mode int32

const (
	// Invalid mode
	OSPolicy_MODE_UNSPECIFIED OSPolicy_Mode = 0
	// This mode checks if the configuration resources in the policy are in
	// their desired state. No actions are performed if they are not in the
	// desired state. This mode is used for reporting purposes.
	OSPolicy_VALIDATION OSPolicy_Mode = 1
	// This mode checks if the configuration resources in the policy are in
	// their desired state, and if not, enforces the desired state.
	OSPolicy_ENFORCEMENT OSPolicy_Mode = 2
)

// Enum value maps for OSPolicy_Mode.
var (
	OSPolicy_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "VALIDATION",
		2: "ENFORCEMENT",
	}
	OSPolicy_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"VALIDATION":       1,
		"ENFORCEMENT":      2,
	}
)

func (x OSPolicy_Mode) Enum() *OSPolicy_Mode {
	p := new(OSPolicy_Mode)
	*p = x
	return p
}

func (x OSPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[0].Descriptor()
}

func (OSPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[0]
}

func (x OSPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicy_Mode.Descriptor instead.
func (OSPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0}
}

// The desired state that the OS Config agent maintains on the VM.
type OSPolicy_Resource_PackageResource_DesiredState int32

const (
	// Unspecified is invalid.
	OSPolicy_Resource_PackageResource_DESIRED_STATE_UNSPECIFIED OSPolicy_Resource_PackageResource_DesiredState = 0
	// Ensure that the package is installed.
	OSPolicy_Resource_PackageResource_INSTALLED OSPolicy_Resource_PackageResource_DesiredState = 1
	// The agent ensures that the package is not installed and
	// uninstalls it if detected.
	OSPolicy_Resource_PackageResource_REMOVED OSPolicy_Resource_PackageResource_DesiredState = 2
)

// Enum value maps for OSPolicy_Resource_PackageResource_DesiredState.
var (
	OSPolicy_Resource_PackageResource_DesiredState_name = map[int32]string{
		0: "DESIRED_STATE_UNSPECIFIED",
		1: "INSTALLED",
		2: "REMOVED",
	}
	OSPolicy_Resource_PackageResource_DesiredState_value = map[string]int32{
		"DESIRED_STATE_UNSPECIFIED": 0,
		"INSTALLED":                 1,
		"REMOVED":                   2,
	}
)

func (x OSPolicy_Resource_PackageResource_DesiredState) Enum() *OSPolicy_Resource_PackageResource_DesiredState {
	p := new(OSPolicy_Resource_PackageResource_DesiredState)
	*p = x
	return p
}

func (x OSPolicy_Resource_PackageResource_DesiredState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicy_Resource_PackageResource_DesiredState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[1].Descriptor()
}

func (OSPolicy_Resource_PackageResource_DesiredState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[1]
}

func (x OSPolicy_Resource_PackageResource_DesiredState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_DesiredState.Descriptor instead.
func (OSPolicy_Resource_PackageResource_DesiredState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 0}
}

// Type of archive.
type OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType int32

const (
	// Unspecified is invalid.
	OSPolicy_Resource_RepositoryResource_AptRepository_ARCHIVE_TYPE_UNSPECIFIED OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType = 0
	// Deb indicates that the archive contains binary files.
	OSPolicy_Resource_RepositoryResource_AptRepository_DEB OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType = 1
	// Deb-src indicates that the archive contains source files.
	OSPolicy_Resource_RepositoryResource_AptRepository_DEB_SRC OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType = 2
)

// Enum value maps for OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType.
var (
	OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_name = map[int32]string{
		0: "ARCHIVE_TYPE_UNSPECIFIED",
		1: "DEB",
		2: "DEB_SRC",
	}
	OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType_value = map[string]int32{
		"ARCHIVE_TYPE_UNSPECIFIED": 0,
		"DEB":                      1,
		"DEB_SRC":                  2,
	}
)

func (x OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) Enum() *OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType {
	p := new(OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType)
	*p = x
	return p
}

func (x OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[2].Descriptor()
}

func (OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[2]
}

func (x OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType.Descriptor instead.
func (OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2, 0, 0}
}

// The interpreter to use.
type OSPolicy_Resource_ExecResource_Exec_Interpreter int32

const (
	// Invalid value, the request will return validation error.
	OSPolicy_Resource_ExecResource_Exec_INTERPRETER_UNSPECIFIED OSPolicy_Resource_ExecResource_Exec_Interpreter = 0
	// If no interpreter is specified the
	// source will be executed directly, which will likely only
	// succeed for executables and scripts with shebang lines.
	// [Wikipedia
	// shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	OSPolicy_Resource_ExecResource_Exec_NONE OSPolicy_Resource_ExecResource_Exec_Interpreter = 1
	// Indicates that the script will be run with /bin/sh on Linux and
	// cmd.exe on windows.
	OSPolicy_Resource_ExecResource_Exec_SHELL OSPolicy_Resource_ExecResource_Exec_Interpreter = 2
	// Indicates that the script will be run with powershell.
	OSPolicy_Resource_ExecResource_Exec_POWERSHELL OSPolicy_Resource_ExecResource_Exec_Interpreter = 3
)

// Enum value maps for OSPolicy_Resource_ExecResource_Exec_Interpreter.
var (
	OSPolicy_Resource_ExecResource_Exec_Interpreter_name = map[int32]string{
		0: "INTERPRETER_UNSPECIFIED",
		1: "NONE",
		2: "SHELL",
		3: "POWERSHELL",
	}
	OSPolicy_Resource_ExecResource_Exec_Interpreter_value = map[string]int32{
		"INTERPRETER_UNSPECIFIED": 0,
		"NONE":                    1,
		"SHELL":                   2,
		"POWERSHELL":              3,
	}
)

func (x OSPolicy_Resource_ExecResource_Exec_Interpreter) Enum() *OSPolicy_Resource_ExecResource_Exec_Interpreter {
	p := new(OSPolicy_Resource_ExecResource_Exec_Interpreter)
	*p = x
	return p
}

func (x OSPolicy_Resource_ExecResource_Exec_Interpreter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicy_Resource_ExecResource_Exec_Interpreter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[3].Descriptor()
}

func (OSPolicy_Resource_ExecResource_Exec_Interpreter) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[3]
}

func (x OSPolicy_Resource_ExecResource_Exec_Interpreter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicy_Resource_ExecResource_Exec_Interpreter.Descriptor instead.
func (OSPolicy_Resource_ExecResource_Exec_Interpreter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 3, 0, 0}
}

// Desired state of the file.
type OSPolicy_Resource_FileResource_DesiredState int32

const (
	// Unspecified is invalid.
	OSPolicy_Resource_FileResource_DESIRED_STATE_UNSPECIFIED OSPolicy_Resource_FileResource_DesiredState = 0
	// Ensure file at path is present.
	OSPolicy_Resource_FileResource_PRESENT OSPolicy_Resource_FileResource_DesiredState = 1
	// Ensure file at path is absent.
	OSPolicy_Resource_FileResource_ABSENT OSPolicy_Resource_FileResource_DesiredState = 2
	// Ensure the contents of the file at path matches. If the file does
	// not exist it will be created.
	OSPolicy_Resource_FileResource_CONTENTS_MATCH OSPolicy_Resource_FileResource_DesiredState = 3
)

// Enum value maps for OSPolicy_Resource_FileResource_DesiredState.
var (
	OSPolicy_Resource_FileResource_DesiredState_name = map[int32]string{
		0: "DESIRED_STATE_UNSPECIFIED",
		1: "PRESENT",
		2: "ABSENT",
		3: "CONTENTS_MATCH",
	}
	OSPolicy_Resource_FileResource_DesiredState_value = map[string]int32{
		"DESIRED_STATE_UNSPECIFIED": 0,
		"PRESENT":                   1,
		"ABSENT":                    2,
		"CONTENTS_MATCH":            3,
	}
)

func (x OSPolicy_Resource_FileResource_DesiredState) Enum() *OSPolicy_Resource_FileResource_DesiredState {
	p := new(OSPolicy_Resource_FileResource_DesiredState)
	*p = x
	return p
}

func (x OSPolicy_Resource_FileResource_DesiredState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicy_Resource_FileResource_DesiredState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[4].Descriptor()
}

func (OSPolicy_Resource_FileResource_DesiredState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes[4]
}

func (x OSPolicy_Resource_FileResource_DesiredState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicy_Resource_FileResource_DesiredState.Descriptor instead.
func (OSPolicy_Resource_FileResource_DesiredState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 4, 0}
}

// An OS policy defines the desired state configuration for an instance.
type OSPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *OSPolicy) Reset() {
	*x = OSPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy) ProtoMessage() {}

func (x *OSPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy.ProtoReflect.Descriptor instead.
func (*OSPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0}
}

// An OS policy resource is used to define the desired state configuration
// and provides a specific functionality like installing/removing packages,
// executing a script etc.
//
// The system ensures that resources are always in their desired state by
// taking necessary actions if they have drifted from their desired state.
type OSPolicy_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The id of the resource with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the OS policy.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Resource type.
	//
	// Types that are assignable to ResourceType:
	//	*OSPolicy_Resource_Pkg
	//	*OSPolicy_Resource_Repository
	//	*OSPolicy_Resource_Exec
	//	*OSPolicy_Resource_File_
	ResourceType isOSPolicy_Resource_ResourceType `protobuf_oneof:"resource_type"`
}

func (x *OSPolicy_Resource) Reset() {
	*x = OSPolicy_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource) ProtoMessage() {}

func (x *OSPolicy_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OSPolicy_Resource) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *OSPolicy_Resource) GetResourceType() isOSPolicy_Resource_ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return nil
}

func (x *OSPolicy_Resource) GetPkg() *OSPolicy_Resource_PackageResource {
	if x, ok := x.GetResourceType().(*OSPolicy_Resource_Pkg); ok {
		return x.Pkg
	}
	return nil
}

func (x *OSPolicy_Resource) GetRepository() *OSPolicy_Resource_RepositoryResource {
	if x, ok := x.GetResourceType().(*OSPolicy_Resource_Repository); ok {
		return x.Repository
	}
	return nil
}

func (x *OSPolicy_Resource) GetExec() *OSPolicy_Resource_ExecResource {
	if x, ok := x.GetResourceType().(*OSPolicy_Resource_Exec); ok {
		return x.Exec
	}
	return nil
}

func (x *OSPolicy_Resource) GetFile() *OSPolicy_Resource_FileResource {
	if x, ok := x.GetResourceType().(*OSPolicy_Resource_File_); ok {
		return x.File
	}
	return nil
}

type isOSPolicy_Resource_ResourceType interface {
	isOSPolicy_Resource_ResourceType()
}

type OSPolicy_Resource_Pkg struct {
	// Package resource
	Pkg *OSPolicy_Resource_PackageResource `protobuf:"bytes,2,opt,name=pkg,proto3,oneof"`
}

type OSPolicy_Resource_Repository struct {
	// Package repository resource
	Repository *OSPolicy_Resource_RepositoryResource `protobuf:"bytes,3,opt,name=repository,proto3,oneof"`
}

type OSPolicy_Resource_Exec struct {
	// Exec resource
	Exec *OSPolicy_Resource_ExecResource `protobuf:"bytes,4,opt,name=exec,proto3,oneof"`
}

type OSPolicy_Resource_File_ struct {
	// File resource
	File *OSPolicy_Resource_FileResource `protobuf:"bytes,5,opt,name=file,proto3,oneof"`
}

func (*OSPolicy_Resource_Pkg) isOSPolicy_Resource_ResourceType() {}

func (*OSPolicy_Resource_Repository) isOSPolicy_Resource_ResourceType() {}

func (*OSPolicy_Resource_Exec) isOSPolicy_Resource_ResourceType() {}

func (*OSPolicy_Resource_File_) isOSPolicy_Resource_ResourceType() {}

// A remote or local file.
type OSPolicy_Resource_File struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A specific type of file.
	//
	// Types that are assignable to Type:
	//	*OSPolicy_Resource_File_Remote_
	//	*OSPolicy_Resource_File_Gcs_
	//	*OSPolicy_Resource_File_LocalPath
	Type isOSPolicy_Resource_File_Type `protobuf_oneof:"type"`
	// Defaults to false. When false, files are subject to validations
	// based on the file type:
	//
	// Remote: A checksum must be specified.
	// Cloud Storage: An object generation number must be specified.
	AllowInsecure bool `protobuf:"varint,4,opt,name=allow_insecure,json=allowInsecure,proto3" json:"allow_insecure,omitempty"`
}

func (x *OSPolicy_Resource_File) Reset() {
	*x = OSPolicy_Resource_File{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_File) ProtoMessage() {}

func (x *OSPolicy_Resource_File) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_File.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_File) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (m *OSPolicy_Resource_File) GetType() isOSPolicy_Resource_File_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *OSPolicy_Resource_File) GetRemote() *OSPolicy_Resource_File_Remote {
	if x, ok := x.GetType().(*OSPolicy_Resource_File_Remote_); ok {
		return x.Remote
	}
	return nil
}

func (x *OSPolicy_Resource_File) GetGcs() *OSPolicy_Resource_File_Gcs {
	if x, ok := x.GetType().(*OSPolicy_Resource_File_Gcs_); ok {
		return x.Gcs
	}
	return nil
}

func (x *OSPolicy_Resource_File) GetLocalPath() string {
	if x, ok := x.GetType().(*OSPolicy_Resource_File_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (x *OSPolicy_Resource_File) GetAllowInsecure() bool {
	if x != nil {
		return x.AllowInsecure
	}
	return false
}

type isOSPolicy_Resource_File_Type interface {
	isOSPolicy_Resource_File_Type()
}

type OSPolicy_Resource_File_Remote_ struct {
	// A generic remote file.
	Remote *OSPolicy_Resource_File_Remote `protobuf:"bytes,1,opt,name=remote,proto3,oneof"`
}

type OSPolicy_Resource_File_Gcs_ struct {
	// A Cloud Storage object.
	Gcs *OSPolicy_Resource_File_Gcs `protobuf:"bytes,2,opt,name=gcs,proto3,oneof"`
}

type OSPolicy_Resource_File_LocalPath struct {
	// A local path to use.
	LocalPath string `protobuf:"bytes,3,opt,name=local_path,json=localPath,proto3,oneof"`
}

func (*OSPolicy_Resource_File_Remote_) isOSPolicy_Resource_File_Type() {}

func (*OSPolicy_Resource_File_Gcs_) isOSPolicy_Resource_File_Type() {}

func (*OSPolicy_Resource_File_LocalPath) isOSPolicy_Resource_File_Type() {}

// A resource that manages a system package.
type OSPolicy_Resource_PackageResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The desired state the agent should maintain for this package. The
	// default is to ensure the package is installed.
	DesiredState OSPolicy_Resource_PackageResource_DesiredState `protobuf:"varint,1,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.agentendpoint.v1.OSPolicy_Resource_PackageResource_DesiredState" json:"desired_state,omitempty"`
	// A system package.
	//
	// Types that are assignable to SystemPackage:
	//	*OSPolicy_Resource_PackageResource_Apt
	//	*OSPolicy_Resource_PackageResource_Deb_
	//	*OSPolicy_Resource_PackageResource_Yum
	//	*OSPolicy_Resource_PackageResource_Zypper_
	//	*OSPolicy_Resource_PackageResource_Rpm
	//	*OSPolicy_Resource_PackageResource_Googet
	//	*OSPolicy_Resource_PackageResource_Msi
	SystemPackage isOSPolicy_Resource_PackageResource_SystemPackage `protobuf_oneof:"system_package"`
}

func (x *OSPolicy_Resource_PackageResource) Reset() {
	*x = OSPolicy_Resource_PackageResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *OSPolicy_Resource_PackageResource) GetDesiredState() OSPolicy_Resource_PackageResource_DesiredState {
	if x != nil {
		return x.DesiredState
	}
	return OSPolicy_Resource_PackageResource_DESIRED_STATE_UNSPECIFIED
}

func (m *OSPolicy_Resource_PackageResource) GetSystemPackage() isOSPolicy_Resource_PackageResource_SystemPackage {
	if m != nil {
		return m.SystemPackage
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetApt() *OSPolicy_Resource_PackageResource_APT {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Apt); ok {
		return x.Apt
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetDeb() *OSPolicy_Resource_PackageResource_Deb {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Deb_); ok {
		return x.Deb
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetYum() *OSPolicy_Resource_PackageResource_YUM {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Yum); ok {
		return x.Yum
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetZypper() *OSPolicy_Resource_PackageResource_Zypper {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Zypper_); ok {
		return x.Zypper
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetRpm() *OSPolicy_Resource_PackageResource_RPM {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Rpm); ok {
		return x.Rpm
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetGooget() *OSPolicy_Resource_PackageResource_GooGet {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Googet); ok {
		return x.Googet
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource) GetMsi() *OSPolicy_Resource_PackageResource_MSI {
	if x, ok := x.GetSystemPackage().(*OSPolicy_Resource_PackageResource_Msi); ok {
		return x.Msi
	}
	return nil
}

type isOSPolicy_Resource_PackageResource_SystemPackage interface {
	isOSPolicy_Resource_PackageResource_SystemPackage()
}

type OSPolicy_Resource_PackageResource_Apt struct {
	// A package managed by Apt.
	Apt *OSPolicy_Resource_PackageResource_APT `protobuf:"bytes,2,opt,name=apt,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Deb_ struct {
	// A deb package file.
	Deb *OSPolicy_Resource_PackageResource_Deb `protobuf:"bytes,3,opt,name=deb,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Yum struct {
	// A package managed by YUM.
	Yum *OSPolicy_Resource_PackageResource_YUM `protobuf:"bytes,4,opt,name=yum,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Zypper_ struct {
	// A package managed by Zypper.
	Zypper *OSPolicy_Resource_PackageResource_Zypper `protobuf:"bytes,5,opt,name=zypper,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Rpm struct {
	// An rpm package file.
	Rpm *OSPolicy_Resource_PackageResource_RPM `protobuf:"bytes,6,opt,name=rpm,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Googet struct {
	// A package managed by GooGet.
	Googet *OSPolicy_Resource_PackageResource_GooGet `protobuf:"bytes,7,opt,name=googet,proto3,oneof"`
}

type OSPolicy_Resource_PackageResource_Msi struct {
	// An MSI package.
	Msi *OSPolicy_Resource_PackageResource_MSI `protobuf:"bytes,8,opt,name=msi,proto3,oneof"`
}

func (*OSPolicy_Resource_PackageResource_Apt) isOSPolicy_Resource_PackageResource_SystemPackage() {}

func (*OSPolicy_Resource_PackageResource_Deb_) isOSPolicy_Resource_PackageResource_SystemPackage() {}

func (*OSPolicy_Resource_PackageResource_Yum) isOSPolicy_Resource_PackageResource_SystemPackage() {}

func (*OSPolicy_Resource_PackageResource_Zypper_) isOSPolicy_Resource_PackageResource_SystemPackage() {
}

func (*OSPolicy_Resource_PackageResource_Rpm) isOSPolicy_Resource_PackageResource_SystemPackage() {}

func (*OSPolicy_Resource_PackageResource_Googet) isOSPolicy_Resource_PackageResource_SystemPackage() {
}

func (*OSPolicy_Resource_PackageResource_Msi) isOSPolicy_Resource_PackageResource_SystemPackage() {}

// A resource that manages a package repository.
type OSPolicy_Resource_RepositoryResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A specific type of repository.
	//
	// Types that are assignable to Repository:
	//	*OSPolicy_Resource_RepositoryResource_Apt
	//	*OSPolicy_Resource_RepositoryResource_Yum
	//	*OSPolicy_Resource_RepositoryResource_Zypper
	//	*OSPolicy_Resource_RepositoryResource_Goo
	Repository isOSPolicy_Resource_RepositoryResource_Repository `protobuf_oneof:"repository"`
}

func (x *OSPolicy_Resource_RepositoryResource) Reset() {
	*x = OSPolicy_Resource_RepositoryResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_RepositoryResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_RepositoryResource) ProtoMessage() {}

func (x *OSPolicy_Resource_RepositoryResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_RepositoryResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (m *OSPolicy_Resource_RepositoryResource) GetRepository() isOSPolicy_Resource_RepositoryResource_Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (x *OSPolicy_Resource_RepositoryResource) GetApt() *OSPolicy_Resource_RepositoryResource_AptRepository {
	if x, ok := x.GetRepository().(*OSPolicy_Resource_RepositoryResource_Apt); ok {
		return x.Apt
	}
	return nil
}

func (x *OSPolicy_Resource_RepositoryResource) GetYum() *OSPolicy_Resource_RepositoryResource_YumRepository {
	if x, ok := x.GetRepository().(*OSPolicy_Resource_RepositoryResource_Yum); ok {
		return x.Yum
	}
	return nil
}

func (x *OSPolicy_Resource_RepositoryResource) GetZypper() *OSPolicy_Resource_RepositoryResource_ZypperRepository {
	if x, ok := x.GetRepository().(*OSPolicy_Resource_RepositoryResource_Zypper); ok {
		return x.Zypper
	}
	return nil
}

func (x *OSPolicy_Resource_RepositoryResource) GetGoo() *OSPolicy_Resource_RepositoryResource_GooRepository {
	if x, ok := x.GetRepository().(*OSPolicy_Resource_RepositoryResource_Goo); ok {
		return x.Goo
	}
	return nil
}

type isOSPolicy_Resource_RepositoryResource_Repository interface {
	isOSPolicy_Resource_RepositoryResource_Repository()
}

type OSPolicy_Resource_RepositoryResource_Apt struct {
	// An Apt Repository.
	Apt *OSPolicy_Resource_RepositoryResource_AptRepository `protobuf:"bytes,1,opt,name=apt,proto3,oneof"`
}

type OSPolicy_Resource_RepositoryResource_Yum struct {
	// A Yum Repository.
	Yum *OSPolicy_Resource_RepositoryResource_YumRepository `protobuf:"bytes,2,opt,name=yum,proto3,oneof"`
}

type OSPolicy_Resource_RepositoryResource_Zypper struct {
	// A Zypper Repository.
	Zypper *OSPolicy_Resource_RepositoryResource_ZypperRepository `protobuf:"bytes,3,opt,name=zypper,proto3,oneof"`
}

type OSPolicy_Resource_RepositoryResource_Goo struct {
	// A Goo Repository.
	Goo *OSPolicy_Resource_RepositoryResource_GooRepository `protobuf:"bytes,4,opt,name=goo,proto3,oneof"`
}

func (*OSPolicy_Resource_RepositoryResource_Apt) isOSPolicy_Resource_RepositoryResource_Repository() {
}

func (*OSPolicy_Resource_RepositoryResource_Yum) isOSPolicy_Resource_RepositoryResource_Repository() {
}

func (*OSPolicy_Resource_RepositoryResource_Zypper) isOSPolicy_Resource_RepositoryResource_Repository() {
}

func (*OSPolicy_Resource_RepositoryResource_Goo) isOSPolicy_Resource_RepositoryResource_Repository() {
}

// A resource that contains custom validation and enforcement steps.
type OSPolicy_Resource_ExecResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. What to run to validate this resource is in the desired state.
	// An exit code of 100 indicates "in desired state", and exit code of 101
	// indicates "not in desired state". Any other exit code indicates a
	// failure running validate.
	Validate *OSPolicy_Resource_ExecResource_Exec `protobuf:"bytes,1,opt,name=validate,proto3" json:"validate,omitempty"`
	// What to run to bring this resource into the desired state.
	// A exit code of 100 indicates "success", any other exit code idicates a
	// failure running enforce.
	Enforce *OSPolicy_Resource_ExecResource_Exec `protobuf:"bytes,2,opt,name=enforce,proto3" json:"enforce,omitempty"`
}

func (x *OSPolicy_Resource_ExecResource) Reset() {
	*x = OSPolicy_Resource_ExecResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_ExecResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_ExecResource) ProtoMessage() {}

func (x *OSPolicy_Resource_ExecResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_ExecResource.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_ExecResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 3}
}

func (x *OSPolicy_Resource_ExecResource) GetValidate() *OSPolicy_Resource_ExecResource_Exec {
	if x != nil {
		return x.Validate
	}
	return nil
}

func (x *OSPolicy_Resource_ExecResource) GetEnforce() *OSPolicy_Resource_ExecResource_Exec {
	if x != nil {
		return x.Enforce
	}
	return nil
}

// A resource that manages the state of a file.
type OSPolicy_Resource_FileResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source for the contents of the file.
	//
	// Types that are assignable to Source:
	//	*OSPolicy_Resource_FileResource_File
	//	*OSPolicy_Resource_FileResource_Content
	Source isOSPolicy_Resource_FileResource_Source `protobuf_oneof:"source"`
	// Required. The absolute path of the file.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Required. Desired state of the file.
	State OSPolicy_Resource_FileResource_DesiredState `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.OSPolicy_Resource_FileResource_DesiredState" json:"state,omitempty"`
	// Consists of three octal digits which represent, in
	// order, the permissions of the owner, group, and other users for the
	// file (similarly to the numeric mode used in the linux chmod
	// utility). Each digit represents a three bit number with the 4 bit
	// corresponding to the read permissions, the 2 bit corresponds to the
	// write bit, and the one bit corresponds to the execute permission.
	// Default behavior is 755.
	//
	// Below are some examples of permissions and their associated values:
	// read, write, and execute: 7
	// read and execute: 5
	// read and write: 6
	// read only: 4
	Permissions string `protobuf:"bytes,5,opt,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *OSPolicy_Resource_FileResource) Reset() {
	*x = OSPolicy_Resource_FileResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_FileResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_FileResource) ProtoMessage() {}

func (x *OSPolicy_Resource_FileResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_FileResource.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_FileResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 4}
}

func (m *OSPolicy_Resource_FileResource) GetSource() isOSPolicy_Resource_FileResource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *OSPolicy_Resource_FileResource) GetFile() *OSPolicy_Resource_File {
	if x, ok := x.GetSource().(*OSPolicy_Resource_FileResource_File); ok {
		return x.File
	}
	return nil
}

func (x *OSPolicy_Resource_FileResource) GetContent() string {
	if x, ok := x.GetSource().(*OSPolicy_Resource_FileResource_Content); ok {
		return x.Content
	}
	return ""
}

func (x *OSPolicy_Resource_FileResource) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *OSPolicy_Resource_FileResource) GetState() OSPolicy_Resource_FileResource_DesiredState {
	if x != nil {
		return x.State
	}
	return OSPolicy_Resource_FileResource_DESIRED_STATE_UNSPECIFIED
}

func (x *OSPolicy_Resource_FileResource) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

type isOSPolicy_Resource_FileResource_Source interface {
	isOSPolicy_Resource_FileResource_Source()
}

type OSPolicy_Resource_FileResource_File struct {
	// A remote or local source.
	File *OSPolicy_Resource_File `protobuf:"bytes,1,opt,name=file,proto3,oneof"`
}

type OSPolicy_Resource_FileResource_Content struct {
	// A a file with this content.
	Content string `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*OSPolicy_Resource_FileResource_File) isOSPolicy_Resource_FileResource_Source() {}

func (*OSPolicy_Resource_FileResource_Content) isOSPolicy_Resource_FileResource_Source() {}

// Specifies a file available via some URI.
type OSPolicy_Resource_File_Remote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI from which to fetch the object. It should contain both the
	// protocol and path following the format `{protocol}://{location}`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// SHA256 checksum of the remote file.
	Sha256Checksum string `protobuf:"bytes,2,opt,name=sha256_checksum,json=sha256Checksum,proto3" json:"sha256_checksum,omitempty"`
}

func (x *OSPolicy_Resource_File_Remote) Reset() {
	*x = OSPolicy_Resource_File_Remote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_File_Remote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_File_Remote) ProtoMessage() {}

func (x *OSPolicy_Resource_File_Remote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_File_Remote.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_File_Remote) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

func (x *OSPolicy_Resource_File_Remote) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *OSPolicy_Resource_File_Remote) GetSha256Checksum() string {
	if x != nil {
		return x.Sha256Checksum
	}
	return ""
}

// Specifies a file available as a Cloud Storage Object.
type OSPolicy_Resource_File_Gcs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Bucket of the Cloud Storage object.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the Cloud Storage object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Generation number of the Cloud Storage object.
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *OSPolicy_Resource_File_Gcs) Reset() {
	*x = OSPolicy_Resource_File_Gcs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_File_Gcs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_File_Gcs) ProtoMessage() {}

func (x *OSPolicy_Resource_File_Gcs) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_File_Gcs.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_File_Gcs) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 0, 1}
}

func (x *OSPolicy_Resource_File_Gcs) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *OSPolicy_Resource_File_Gcs) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *OSPolicy_Resource_File_Gcs) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

// A deb package file. dpkg packages only support INSTALLED state.
type OSPolicy_Resource_PackageResource_Deb struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A deb package.
	Source *OSPolicy_Resource_File `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Whether dependencies should also be installed.
	// install when false: `dpkg -i package`
	// install when true: `apt-get update && apt-get -y install
	// package.deb`
	PullDeps bool `protobuf:"varint,2,opt,name=pull_deps,json=pullDeps,proto3" json:"pull_deps,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_Deb) Reset() {
	*x = OSPolicy_Resource_PackageResource_Deb{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_Deb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_Deb) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_Deb) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_Deb.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_Deb) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 0}
}

func (x *OSPolicy_Resource_PackageResource_Deb) GetSource() *OSPolicy_Resource_File {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource_Deb) GetPullDeps() bool {
	if x != nil {
		return x.PullDeps
	}
	return false
}

// A package managed by APT.
// install: `apt-get update && apt-get -y install [name]`
// remove: `apt-get -y remove [name]`
type OSPolicy_Resource_PackageResource_APT struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Package name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_APT) Reset() {
	*x = OSPolicy_Resource_PackageResource_APT{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_APT) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_APT) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_APT) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_APT.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_APT) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 1}
}

func (x *OSPolicy_Resource_PackageResource_APT) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An RPM package file. RPM packages only support INSTALLED state.
type OSPolicy_Resource_PackageResource_RPM struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An rpm package.
	Source *OSPolicy_Resource_File `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Whether dependencies should also be installed.
	// install when false: `rpm --upgrade --replacepkgs package.rpm`
	// install when true: `yum -y install package.rpm` or
	// `zypper -y install package.rpm`
	PullDeps bool `protobuf:"varint,2,opt,name=pull_deps,json=pullDeps,proto3" json:"pull_deps,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_RPM) Reset() {
	*x = OSPolicy_Resource_PackageResource_RPM{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_RPM) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_RPM) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_RPM) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_RPM.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_RPM) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 2}
}

func (x *OSPolicy_Resource_PackageResource_RPM) GetSource() *OSPolicy_Resource_File {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource_RPM) GetPullDeps() bool {
	if x != nil {
		return x.PullDeps
	}
	return false
}

// A package managed by YUM.
// install: `yum -y install package`
// remove: `yum -y remove package`
type OSPolicy_Resource_PackageResource_YUM struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Package name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_YUM) Reset() {
	*x = OSPolicy_Resource_PackageResource_YUM{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_YUM) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_YUM) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_YUM) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_YUM.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_YUM) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 3}
}

func (x *OSPolicy_Resource_PackageResource_YUM) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A package managed by Zypper.
// install: `zypper -y install package`
// remove: `zypper -y rm package`
type OSPolicy_Resource_PackageResource_Zypper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Package name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_Zypper) Reset() {
	*x = OSPolicy_Resource_PackageResource_Zypper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_Zypper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_Zypper) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_Zypper) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_Zypper.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_Zypper) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 4}
}

func (x *OSPolicy_Resource_PackageResource_Zypper) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A package managed by GooGet.
// install: `googet -noconfirm install package`
// remove: `googet -noconfirm remove package`
type OSPolicy_Resource_PackageResource_GooGet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Package name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_GooGet) Reset() {
	*x = OSPolicy_Resource_PackageResource_GooGet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_GooGet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_GooGet) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_GooGet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_GooGet.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_GooGet) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 5}
}

func (x *OSPolicy_Resource_PackageResource_GooGet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An MSI package. MSI packages only support INSTALLED state.
type OSPolicy_Resource_PackageResource_MSI struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MSI package.
	Source *OSPolicy_Resource_File `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Additional properties to use during installation.
	// This should be in the format of Property=Setting.
	// Appended to the defaults of "ACTION=INSTALL
	// REBOOT=ReallySuppress".
	Properties []string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *OSPolicy_Resource_PackageResource_MSI) Reset() {
	*x = OSPolicy_Resource_PackageResource_MSI{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_PackageResource_MSI) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_PackageResource_MSI) ProtoMessage() {}

func (x *OSPolicy_Resource_PackageResource_MSI) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_PackageResource_MSI.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_PackageResource_MSI) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 1, 6}
}

func (x *OSPolicy_Resource_PackageResource_MSI) GetSource() *OSPolicy_Resource_File {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *OSPolicy_Resource_PackageResource_MSI) GetProperties() []string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Represents a single apt package repository. These will be added to
// a repo file that will be managed at
// /etc/apt/sources.list.d/google_osconfig.list.
type OSPolicy_Resource_RepositoryResource_AptRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of archive files in this repository. The default behavior is
	// DEB.
	ArchiveType OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType `protobuf:"varint,1,opt,name=archive_type,json=archiveType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType" json:"archive_type,omitempty"`
	// Required. URI for this repository.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. Distribution of this repository.
	Distribution string `protobuf:"bytes,3,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Required. List of components for this repository. Must contain at least one
	// item.
	Components []string `protobuf:"bytes,4,rep,name=components,proto3" json:"components,omitempty"`
	// URI of the key file for this repository. The agent maintains a
	// keyring at /etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg.
	GpgKey string `protobuf:"bytes,5,opt,name=gpg_key,json=gpgKey,proto3" json:"gpg_key,omitempty"`
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) Reset() {
	*x = OSPolicy_Resource_RepositoryResource_AptRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_RepositoryResource_AptRepository) ProtoMessage() {}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource_AptRepository.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_RepositoryResource_AptRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2, 0}
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) GetArchiveType() OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType {
	if x != nil {
		return x.ArchiveType
	}
	return OSPolicy_Resource_RepositoryResource_AptRepository_ARCHIVE_TYPE_UNSPECIFIED
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) GetDistribution() string {
	if x != nil {
		return x.Distribution
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) GetComponents() []string {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *OSPolicy_Resource_RepositoryResource_AptRepository) GetGpgKey() string {
	if x != nil {
		return x.GpgKey
	}
	return ""
}

// Represents a single yum package repository. These are added to a
// repo file that is managed at
// `/etc/yum.repos.d/google_osconfig.repo`.
type OSPolicy_Resource_RepositoryResource_YumRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A one word, unique name for this repository. This is  the `repo
	// id` in the yum config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique
	// identifier when checking for resource conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) Reset() {
	*x = OSPolicy_Resource_RepositoryResource_YumRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_RepositoryResource_YumRepository) ProtoMessage() {}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource_YumRepository.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_RepositoryResource_YumRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2, 1}
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_YumRepository) GetGpgKeys() []string {
	if x != nil {
		return x.GpgKeys
	}
	return nil
}

// Represents a single zypper package repository. These are added to a
// repo file that is managed at
// `/etc/zypp/repos.d/google_osconfig.repo`.
type OSPolicy_Resource_RepositoryResource_ZypperRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A one word, unique name for this repository. This is the `repo
	// id` in the zypper config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique
	// identifier when checking for GuestPolicy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) Reset() {
	*x = OSPolicy_Resource_RepositoryResource_ZypperRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_RepositoryResource_ZypperRepository) ProtoMessage() {}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource_ZypperRepository.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_RepositoryResource_ZypperRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2, 2}
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) GetBaseUrl() string {
	if x != nil {
		return x.BaseUrl
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_ZypperRepository) GetGpgKeys() []string {
	if x != nil {
		return x.GpgKeys
	}
	return nil
}

// Represents a Goo package repository. These are added to a repo file
// that is managed at
// `C:/ProgramData/GooGet/repos/google_osconfig.repo`.
type OSPolicy_Resource_RepositoryResource_GooRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the repository.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The url of the repository.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *OSPolicy_Resource_RepositoryResource_GooRepository) Reset() {
	*x = OSPolicy_Resource_RepositoryResource_GooRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_RepositoryResource_GooRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_RepositoryResource_GooRepository) ProtoMessage() {}

func (x *OSPolicy_Resource_RepositoryResource_GooRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_RepositoryResource_GooRepository.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_RepositoryResource_GooRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 2, 3}
}

func (x *OSPolicy_Resource_RepositoryResource_GooRepository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OSPolicy_Resource_RepositoryResource_GooRepository) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A file or script to execute.
type OSPolicy_Resource_ExecResource_Exec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What to execute.
	//
	// Types that are assignable to Source:
	//	*OSPolicy_Resource_ExecResource_Exec_File
	//	*OSPolicy_Resource_ExecResource_Exec_Script
	Source isOSPolicy_Resource_ExecResource_Exec_Source `protobuf_oneof:"source"`
	// Optional arguments to pass to the source during execution.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Required. The script interpreter to use.
	Interpreter OSPolicy_Resource_ExecResource_Exec_Interpreter `protobuf:"varint,4,opt,name=interpreter,proto3,enum=google.cloud.osconfig.agentendpoint.v1.OSPolicy_Resource_ExecResource_Exec_Interpreter" json:"interpreter,omitempty"`
	// Only recorded for enforce Exec.
	// Path to an output file (that is created by this Exec) whose
	// content will be recorded in OSPolicyResourceCompliance after a
	// successful run. Absence or failure to read this file will result in
	// this ExecResource being non-compliant. Output file size is limited to
	// 100K bytes.
	OutputFilePath string `protobuf:"bytes,5,opt,name=output_file_path,json=outputFilePath,proto3" json:"output_file_path,omitempty"`
}

func (x *OSPolicy_Resource_ExecResource_Exec) Reset() {
	*x = OSPolicy_Resource_ExecResource_Exec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicy_Resource_ExecResource_Exec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicy_Resource_ExecResource_Exec) ProtoMessage() {}

func (x *OSPolicy_Resource_ExecResource_Exec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicy_Resource_ExecResource_Exec.ProtoReflect.Descriptor instead.
func (*OSPolicy_Resource_ExecResource_Exec) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP(), []int{0, 0, 3, 0}
}

func (m *OSPolicy_Resource_ExecResource_Exec) GetSource() isOSPolicy_Resource_ExecResource_Exec_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *OSPolicy_Resource_ExecResource_Exec) GetFile() *OSPolicy_Resource_File {
	if x, ok := x.GetSource().(*OSPolicy_Resource_ExecResource_Exec_File); ok {
		return x.File
	}
	return nil
}

func (x *OSPolicy_Resource_ExecResource_Exec) GetScript() string {
	if x, ok := x.GetSource().(*OSPolicy_Resource_ExecResource_Exec_Script); ok {
		return x.Script
	}
	return ""
}

func (x *OSPolicy_Resource_ExecResource_Exec) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *OSPolicy_Resource_ExecResource_Exec) GetInterpreter() OSPolicy_Resource_ExecResource_Exec_Interpreter {
	if x != nil {
		return x.Interpreter
	}
	return OSPolicy_Resource_ExecResource_Exec_INTERPRETER_UNSPECIFIED
}

func (x *OSPolicy_Resource_ExecResource_Exec) GetOutputFilePath() string {
	if x != nil {
		return x.OutputFilePath
	}
	return ""
}

type isOSPolicy_Resource_ExecResource_Exec_Source interface {
	isOSPolicy_Resource_ExecResource_Exec_Source()
}

type OSPolicy_Resource_ExecResource_Exec_File struct {
	// A remote or local file.
	File *OSPolicy_Resource_File `protobuf:"bytes,1,opt,name=file,proto3,oneof"`
}

type OSPolicy_Resource_ExecResource_Exec_Script struct {
	// An inline script.
	Script string `protobuf:"bytes,2,opt,name=script,proto3,oneof"`
}

func (*OSPolicy_Resource_ExecResource_Exec_File) isOSPolicy_Resource_ExecResource_Exec_Source() {}

func (*OSPolicy_Resource_ExecResource_Exec_Script) isOSPolicy_Resource_ExecResource_Exec_Source() {}

var File_google_cloud_osconfig_agentendpoint_v1_os_policy_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb8, 0x24, 0x0a, 0x08, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0xec,
	0x23, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x13, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x5d, 0x0a, 0x03, 0x70, 0x6b, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x03, 0x70, 0x6b, 0x67, 0x12,
	0x6e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x5c, 0x0a, 0x04, 0x65, 0x78, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x04, 0x65, 0x78, 0x65, 0x63, 0x12, 0x5c, 0x0a,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0xba, 0x03, 0x0a, 0x04,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x5f, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x03, 0x67, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x2e, 0x47, 0x63, 0x73, 0x48, 0x00, 0x52, 0x03, 0x67, 0x63, 0x73, 0x12, 0x1f, 0x0a,
	0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x25,
	0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x1a, 0x48, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x1a,
	0x5f, 0x0a, 0x03, 0x47, 0x63, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xc5, 0x0b, 0x0a, 0x0f, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x80, 0x01, 0x0a,
	0x0d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x61, 0x0a, 0x03, 0x61, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x50, 0x54, 0x48, 0x00, 0x52, 0x03, 0x61,
	0x70, 0x74, 0x12, 0x61, 0x0a, 0x03, 0x64, 0x65, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x62, 0x48, 0x00,
	0x52, 0x03, 0x64, 0x65, 0x62, 0x12, 0x61, 0x0a, 0x03, 0x79, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x59, 0x55,
	0x4d, 0x48, 0x00, 0x52, 0x03, 0x79, 0x75, 0x6d, 0x12, 0x6a, 0x0a, 0x06, 0x7a, 0x79, 0x70, 0x70,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x48, 0x00, 0x52, 0x06, 0x7a, 0x79,
	0x70, 0x70, 0x65, 0x72, 0x12, 0x61, 0x0a, 0x03, 0x72, 0x70, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x50, 0x4d,
	0x48, 0x00, 0x52, 0x03, 0x72, 0x70, 0x6d, 0x12, 0x6a, 0x0a, 0x06, 0x67, 0x6f, 0x6f, 0x67, 0x65,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x47, 0x6f, 0x6f, 0x47, 0x65, 0x74, 0x48, 0x00, 0x52, 0x06, 0x67, 0x6f, 0x6f,
	0x67, 0x65, 0x74, 0x12, 0x61, 0x0a, 0x03, 0x6d, 0x73, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4d, 0x53, 0x49, 0x48,
	0x00, 0x52, 0x03, 0x6d, 0x73, 0x69, 0x1a, 0x7f, 0x0a, 0x03, 0x44, 0x65, 0x62, 0x12, 0x5b, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75,
	0x6c, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x70,
	0x75, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x73, 0x1a, 0x1e, 0x0a, 0x03, 0x41, 0x50, 0x54, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x7f, 0x0a, 0x03, 0x52, 0x50, 0x4d, 0x12, 0x5b,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x75, 0x6c, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x70, 0x75, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x73, 0x1a, 0x1e, 0x0a, 0x03, 0x59, 0x55, 0x4d, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x21, 0x0a, 0x06, 0x5a, 0x79, 0x70, 0x70,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x21, 0x0a, 0x06, 0x47,
	0x6f, 0x6f, 0x47, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x82,
	0x01, 0x0a, 0x03, 0x4d, 0x53, 0x49, 0x12, 0x5b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x22, 0x49, 0x0a, 0x0c, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x45, 0x53, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x02, 0x42, 0x10,
	0x0a, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x1a, 0x9d, 0x09, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6e, 0x0a, 0x03, 0x61, 0x70, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x03, 0x61, 0x70, 0x74, 0x12, 0x6e, 0x0a, 0x03, 0x79, 0x75, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x03, 0x79, 0x75, 0x6d, 0x12, 0x77, 0x0a, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x06, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72,
	0x12, 0x6e, 0x0a, 0x03, 0x67, 0x6f, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x47, 0x6f, 0x6f, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x03, 0x67, 0x6f, 0x6f,
	0x1a, 0xe1, 0x02, 0x0a, 0x0d, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x8e, 0x01, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x70, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x27, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x70, 0x67, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x67, 0x70, 0x67, 0x4b, 0x65,
	0x79, 0x22, 0x41, 0x0a, 0x0b, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1c, 0x0a, 0x18, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x44, 0x45, 0x42, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x42, 0x5f, 0x53,
	0x52, 0x43, 0x10, 0x02, 0x1a, 0x82, 0x01, 0x0a, 0x0d, 0x59, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e,
	0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x62, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x19,
	0x0a, 0x08, 0x67, 0x70, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x67, 0x70, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x1a, 0x85, 0x01, 0x0a, 0x10, 0x5a, 0x79,
	0x70, 0x70, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x13,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75,
	0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x62,
	0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x70, 0x67, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x67, 0x70, 0x67, 0x4b, 0x65, 0x79,
	0x73, 0x1a, 0x3f, 0x0a, 0x0d, 0x47, 0x6f, 0x6f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75,
	0x72, 0x6c, 0x42, 0x0c, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x1a, 0xf5, 0x04, 0x0a, 0x0c, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x6c, 0x0a, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x65, 0x0a, 0x07, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x07, 0x65,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x1a, 0x8f, 0x03, 0x0a, 0x04, 0x45, 0x78, 0x65, 0x63, 0x12,
	0x54, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x12, 0x7e, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
	0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x22, 0x4f, 0x0a,
	0x0b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x17,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x03, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x91, 0x03, 0x0a, 0x0c, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x04, 0x66, 0x69, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x12, 0x6e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x5a, 0x0a, 0x0c, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x45, 0x53, 0x49, 0x52, 0x45,
	0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x42, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x10, 0x03, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0f, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3d, 0x0a,
	0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56,
	0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x45,
	0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x8f, 0x01, 0x0a,
	0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_goTypes = []interface{}{
	(OSPolicy_Mode)(0), // 0: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Mode
	(OSPolicy_Resource_PackageResource_DesiredState)(0),                 // 1: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.DesiredState
	(OSPolicy_Resource_RepositoryResource_AptRepository_ArchiveType)(0), // 2: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType
	(OSPolicy_Resource_ExecResource_Exec_Interpreter)(0),                // 3: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
	(OSPolicy_Resource_FileResource_DesiredState)(0),                    // 4: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource.DesiredState
	(*OSPolicy)(nil),                                              // 5: google.cloud.osconfig.agentendpoint.v1.OSPolicy
	(*OSPolicy_Resource)(nil),                                     // 6: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource
	(*OSPolicy_Resource_File)(nil),                                // 7: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	(*OSPolicy_Resource_PackageResource)(nil),                     // 8: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource
	(*OSPolicy_Resource_RepositoryResource)(nil),                  // 9: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource
	(*OSPolicy_Resource_ExecResource)(nil),                        // 10: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource
	(*OSPolicy_Resource_FileResource)(nil),                        // 11: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource
	(*OSPolicy_Resource_File_Remote)(nil),                         // 12: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.Remote
	(*OSPolicy_Resource_File_Gcs)(nil),                            // 13: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.Gcs
	(*OSPolicy_Resource_PackageResource_Deb)(nil),                 // 14: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.Deb
	(*OSPolicy_Resource_PackageResource_APT)(nil),                 // 15: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.APT
	(*OSPolicy_Resource_PackageResource_RPM)(nil),                 // 16: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.RPM
	(*OSPolicy_Resource_PackageResource_YUM)(nil),                 // 17: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.YUM
	(*OSPolicy_Resource_PackageResource_Zypper)(nil),              // 18: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.Zypper
	(*OSPolicy_Resource_PackageResource_GooGet)(nil),              // 19: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.GooGet
	(*OSPolicy_Resource_PackageResource_MSI)(nil),                 // 20: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.MSI
	(*OSPolicy_Resource_RepositoryResource_AptRepository)(nil),    // 21: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.AptRepository
	(*OSPolicy_Resource_RepositoryResource_YumRepository)(nil),    // 22: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.YumRepository
	(*OSPolicy_Resource_RepositoryResource_ZypperRepository)(nil), // 23: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
	(*OSPolicy_Resource_RepositoryResource_GooRepository)(nil),    // 24: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.GooRepository
	(*OSPolicy_Resource_ExecResource_Exec)(nil),                   // 25: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec
}
var file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_depIdxs = []int32{
	8,  // 0: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.pkg:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource
	9,  // 1: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.repository:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource
	10, // 2: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.exec:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource
	11, // 3: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.file:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource
	12, // 4: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.remote:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.Remote
	13, // 5: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.gcs:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File.Gcs
	1,  // 6: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.desired_state:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.DesiredState
	15, // 7: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.apt:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.APT
	14, // 8: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.deb:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.Deb
	17, // 9: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.yum:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.YUM
	18, // 10: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.zypper:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.Zypper
	16, // 11: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.rpm:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.RPM
	19, // 12: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.googet:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.GooGet
	20, // 13: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.msi:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.MSI
	21, // 14: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.apt:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.AptRepository
	22, // 15: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.yum:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.YumRepository
	23, // 16: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.zypper:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.ZypperRepository
	24, // 17: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.goo:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.GooRepository
	25, // 18: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.validate:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec
	25, // 19: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.enforce:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec
	7,  // 20: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource.file:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	4,  // 21: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource.state:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.FileResource.DesiredState
	7,  // 22: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.Deb.source:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	7,  // 23: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.RPM.source:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	7,  // 24: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.PackageResource.MSI.source:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	2,  // 25: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.AptRepository.archive_type:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.RepositoryResource.AptRepository.ArchiveType
	7,  // 26: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec.file:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.File
	3,  // 27: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec.interpreter:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource.ExecResource.Exec.Interpreter
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1_os_policy_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_File); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_RepositoryResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_ExecResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_FileResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_File_Remote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_File_Gcs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_Deb); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_APT); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_RPM); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_YUM); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_Zypper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_GooGet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_PackageResource_MSI); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_RepositoryResource_AptRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_RepositoryResource_YumRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_RepositoryResource_ZypperRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_RepositoryResource_GooRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OSPolicy_Resource_ExecResource_Exec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_Pkg)(nil),
		(*OSPolicy_Resource_Repository)(nil),
		(*OSPolicy_Resource_Exec)(nil),
		(*OSPolicy_Resource_File_)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_File_Remote_)(nil),
		(*OSPolicy_Resource_File_Gcs_)(nil),
		(*OSPolicy_Resource_File_LocalPath)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_PackageResource_Apt)(nil),
		(*OSPolicy_Resource_PackageResource_Deb_)(nil),
		(*OSPolicy_Resource_PackageResource_Yum)(nil),
		(*OSPolicy_Resource_PackageResource_Zypper_)(nil),
		(*OSPolicy_Resource_PackageResource_Rpm)(nil),
		(*OSPolicy_Resource_PackageResource_Googet)(nil),
		(*OSPolicy_Resource_PackageResource_Msi)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_RepositoryResource_Apt)(nil),
		(*OSPolicy_Resource_RepositoryResource_Yum)(nil),
		(*OSPolicy_Resource_RepositoryResource_Zypper)(nil),
		(*OSPolicy_Resource_RepositoryResource_Goo)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_FileResource_File)(nil),
		(*OSPolicy_Resource_FileResource_Content)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*OSPolicy_Resource_ExecResource_Exec_File)(nil),
		(*OSPolicy_Resource_ExecResource_Exec_Script)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1_os_policy_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_depIdxs = nil
}
