// Code generated by go-bindata. (@generated) DO NOT EDIT.

 //Package devices generated by go-bindata.// sources:
// devices/data/smc.tsv
package devices

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// ModTime return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _smcTsv = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x74\x95\xc1\x72\xab\x3a\x0f\xc7\xd7\x3d\x4f\xc1\xf0\x00\x1d\x4c\x92\x36\x67\x09\xa6\x05\x66\x42\xa2\x09\x29\x5f\x77\xdf\x10\xca\x6d\x99\x43\x02\x03\xf4\x9e\xe6\xed\xef\x58\xc6\xc6\x36\x64\xe9\x9f\x24\xdb\x92\xfe\xb2\xed\x13\x7d\xa7\xf6\x83\x0d\x2f\x34\xb6\x28\xbc\xd9\xbf\x18\x29\x4c\xe2\x80\xfd\x60\x53\x78\xb3\x88\x05\x5d\xf3\x53\x5d\xaa\xe1\xc6\x0d\x91\x34\x44\x65\x3e\xf4\xd5\xf5\x0f\xe7\xc1\x14\x90\x17\x7f\xf2\xcf\x92\xe3\x17\x81\xf9\xf2\x55\x5b\x12\x3a\x2e\x69\xd3\x95\x23\x73\x35\xe6\x22\x5b\x69\x6c\x85\x6c\xad\xb1\x35\xb2\x8d\xc6\x36\xc8\x9e\x34\xf6\x84\xec\x59\x63\xcf\xc8\xb6\x1a\xdb\x22\xf3\xe6\xc9\x5a\x5e\x3d\x3c\x72\xe3\x2c\xe3\xc9\x46\x44\xf9\x5c\xa3\x7c\x24\x92\x06\xad\x7c\x24\x98\x02\x94\xf2\x11\x51\x3e\x5e\x07\xf2\xaa\x2d\xfd\xf9\x66\xd3\x15\xfc\xd9\x8e\x93\x2d\x95\x0a\x48\x3d\x0e\x0a\x13\x78\x06\x08\x65\x48\x38\x4a\x24\x2c\x0c\x12\xa2\x68\x42\x78\xd3\x73\x0e\x51\x1a\x0c\x07\x15\x66\x15\x12\x13\xa0\xa8\x18\x50\x6b\x12\x92\x25\xda\x3b\xa9\xfd\x60\x27\xe5\xa5\xe9\x6e\xfa\x39\x09\x1e\x9f\x94\x17\xcb\xcf\x59\x21\x50\x4e\x09\xd1\x21\x16\x2e\xd9\x6a\xd0\xe7\x9e\xbf\x75\xc8\x3d\xc5\x69\x56\xd2\x7c\x7c\xd7\xa5\xdc\xd5\xc4\xe3\xbe\x06\x16\x3b\x9b\x18\xbd\xf7\x58\x97\x7d\xd3\x0d\x5f\xe7\xae\xfa\xf8\x2c\x45\x39\xf6\x98\x88\x6a\x90\x79\xf2\x19\xd9\x93\xfb\x0e\xe3\xd6\xac\x5b\x09\x8d\xa6\x2d\xa3\x11\xa8\xb5\x04\xbc\x01\x4c\x6e\x40\x4d\x80\x57\x61\x40\x2b\xb5\x87\xd8\xab\xba\x7f\xea\xe6\x2f\xbf\x93\x47\x54\x84\xb7\xf8\xc2\x43\xd9\x81\x6d\xd5\x8e\xe3\xfd\x45\x34\xc6\xfd\x5c\x8d\xe1\x78\x5f\x78\x33\xf3\xea\x7a\x6e\xf2\xee\x43\x3f\xbe\xe5\xb7\x6a\xfe\x96\xdd\x82\xb5\xe7\xd6\xbc\xbe\x58\xc7\xb2\x1f\x18\x3a\x23\xf2\x77\x54\xf7\xdc\x21\xde\xd1\x40\xc7\xff\x13\xd9\xb5\x4d\x37\xe8\xa6\x08\x4d\x51\x10\x58\x7e\x3e\x36\x23\x22\x2a\xc2\x84\x22\x57\x45\x98\x4f\xb4\x52\x11\xbe\x56\x07\xdc\xeb\xd0\x0e\x55\x91\xd7\x56\xd0\x55\xff\x62\xc9\x7d\xe7\xc4\xee\x9a\x0f\x43\xd9\xdd\xac\x53\xfa\xff\xc4\x7b\x47\x4e\x54\x8e\x47\xfb\xae\x8a\xf0\x68\x7f\xa5\x20\xa3\x56\x56\xfa\xdd\xb6\xf5\x18\xdb\xa2\x44\x74\x2e\x1f\x88\x96\xcc\x82\x5c\xce\x67\x41\xee\x14\xe4\xce\x82\x30\xf5\x76\x35\xe3\x98\x7f\xbb\x9e\x71\x7c\xb1\xdb\xcd\x8c\xe3\xab\x9d\xe2\x8d\x5f\x7e\xda\xfc\xda\x57\xcd\xd5\x4a\xeb\x66\xe8\xb9\x1a\x53\x14\x69\x8c\x88\x3d\xc7\x4d\x2f\x44\xb9\x60\xc1\x4c\x3c\x57\xb3\xb8\x4a\xcc\x6a\xc1\xc2\x62\x32\xea\xcc\xbe\xab\xcc\xf8\xc2\xb8\x9f\x3b\xfb\xae\x32\xe3\x0b\x5b\x23\x5b\xcf\xbe\xab\xcc\xf8\xc2\x9e\x90\x3d\xcd\xbe\xab\xcc\xf8\xc2\xd8\x77\x95\x65\xe4\x38\xb2\xec\x74\x62\x20\xc4\x0b\x87\xa3\x13\x23\x89\x73\x94\xaf\x27\x5b\xef\x31\x04\x68\x84\x0b\xf1\x6a\xb0\x45\xc0\x3d\xe5\x00\xa6\x8e\x75\xcc\xab\x1a\x4d\x1b\xc3\xb4\x91\x26\xc0\x28\xe2\x66\x92\x70\x9d\x31\x92\x15\x05\xde\x12\x2b\xcf\xa2\xad\x55\xc6\xc0\x71\x75\x94\xe0\x91\xa3\x8c\x48\x9f\x0d\x82\xc8\xd9\xe8\x20\xfb\x2d\x3d\x88\x8b\x24\x70\x8f\x06\xc9\x9e\x99\x8f\xf7\xfd\x53\xd5\x55\xde\xdd\xc6\xe3\x32\xec\x6f\x3a\xe4\xd7\x8f\xb3\x64\x5b\x95\xf1\x13\xca\x97\x51\x07\xa5\xd8\xcf\xf7\xf4\xd9\xca\xce\x98\x2d\x4d\x0e\xa9\x35\xd1\x58\x97\x09\x12\x29\x92\xac\x28\xe2\x03\x22\x57\x41\xf8\xc5\xc6\xd4\x11\xed\x1b\x6b\x17\xd3\x8d\x20\xc1\xd1\x4b\x90\x6c\x05\x81\xdd\x8e\x07\x85\x23\x08\x5f\xdf\x39\x48\x46\x20\xbb\x1c\x4f\x3a\x10\x3b\x27\xbc\xd5\xfc\x17\xa5\xcd\x75\xe8\x9a\xba\x2e\x3b\x6e\x9a\x24\x22\xfd\x55\x69\xc4\xf7\xa5\x11\xdf\x97\x46\x7c\xe0\x51\x55\x5f\x3c\x4a\xe6\x23\x13\x0f\x98\xa0\xe0\x63\x92\x5f\x79\xf7\x59\x76\x96\x9f\x1c\xf6\xf6\x2f\x1b\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x16\xa6\x0f\x28\xa8\xac\xe7\x48\x6f\x0e\x50\x08\xf4\x86\x02\x3d\x89\x86\x9e\x9a\x21\xaf\xb9\xd3\x6e\x86\x88\x21\x0d\x98\xa4\x31\x55\x1f\x42\xdc\x2c\x54\x23\x43\xe7\xa8\xb7\x1e\x96\xfa\x0b\x6a\x7f\x41\x3e\x0a\xd3\x69\x77\x3b\x0e\xf7\xc5\x00\xf7\xc5\x00\x91\xe3\xaa\x33\xaf\x70\x65\xce\x25\x6d\xcd\x57\x05\xf4\x61\x97\x78\x41\x63\xe0\xef\xe8\x5c\x63\xb0\xa8\x3c\x08\xb0\x80\x01\xb5\xe2\xeb\x54\xc2\x14\x61\x7a\xeb\x87\xf2\x22\xe8\x7f\x01\x00\x00\xff\xff\x1d\x32\xff\xb6\x46\x0d\x00\x00")

func smcTsvBytes() ([]byte, error) {
	return bindataRead(
		_smcTsv,
		"smc.tsv",
	)
}

func smcTsv() (*asset, error) {
	bytes, err := smcTsvBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "smc.tsv", size: 3398, mode: os.FileMode(420), modTime: time.Unix(1592914957, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"smc.tsv": smcTsv,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"smc.tsv": &bintree{smcTsv, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
